/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PW2UTI.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** DESCRIPTION: OS/2 dependant functions for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include <string.h>                         /* for str*() */
#include <process.h>                        /* for system() */
#include "pwinc.h"                         /* OS2 main include file */

HKBD        pw_hkbd = 0;
HVIO        pw_hvio = 0;
#ifdef MOUSE
HMOU        pw_hmou = 0;

#define PWL_MOU_LEFT    0
#define PWL_MOU_RIGHT   1
#define PWL_MOU_UP      2
#define PWL_MOU_DOWN    3
#define PWL_MOU_LBUT    4
#define PWL_MOU_MBUT    5
#define PWL_MOU_RBUT    6
static int mou_present = 0;
static int mou_hcnt = 0;
static int mou_vcnt = 0;
static PTRLOC PtrLoc;
static int mou_speed = 230;
#define MOUSE_STEP  (256-mou_speed)
#endif

void pws_mon()
{
    VIOCONFIGINFO vioinConfig;

    if (_pwcf_mon == PWCF_CGACOLOR)
    {
        vioinConfig.cb = sizeof(vioinConfig);   /* structure length   */
        VioGetConfig(0,                         /* must be zero       */
            &vioinConfig,                       /* configuration data */
            pw_hvio);                           /* video handle       */
    	if ((vioinConfig.display == 0) || (vioinConfig.display == 3))
            _pwcf_mon = PWCF_MDAMONO;           /* MDA+monchrome monitor */
    }
}

int pws_shell(void)
{
    int ret;
    int r, c;
    
    pws_GetCursor(&r, &c);
    putchar('\f');
    if ((ret = system("cls")) == 0)
    {
        printf("POWER %s - %s - %s\n", _pw_version, _pw_date, _pw_ltsp);
        puts("To return to the POWER application, type \"exit\".");
        ret = system("cmd");
    }
    pws_cursor(r, c);
    return ret;
}

void pws_GetCursor(pRow, pCol)
int *pRow;
int *pCol;
{
    VioGetCurPos((PUSHORT)pRow, (PUSHORT)pCol, pw_hvio);
}

void pws_cursor(row, col)
int row, col;
{
    VIOCURSORINFO viociCursor;

    VioSetCurPos(row,                     /* cursor row    */
        col,                              /* cursor column */
        pw_hvio);                         /* video handle  */
    VioGetCurType(&viociCursor, pw_hvio);
    viociCursor.attr = (row == _pwv_scrnrow) ? -1 : 0;
    VioSetCurType(&viociCursor, pw_hvio);
}

PWKEY pws_getkey()
{
    KBDKEYINFO kbciKeyInfo;
    PWKEY key;

    KbdCharIn(&kbciKeyInfo,                  /* buffer for data */
        0,                                   /* wait for a key  */
        pw_hkbd);                            /* keyboard handle */
    if (kbciKeyInfo.chChar == 0x00 ||
        kbciKeyInfo.chChar == 0xe0)
        key = (kbciKeyInfo.chScan<<8);
    else
        key = kbciKeyInfo.chChar;
    return key;
}

#ifdef MOUSE
void pws_MouInit()
{
    mou_present = !MouOpen(0L, &pw_hmou);      /* open standard mou device */
    if (mou_present)
        MouGetPtrPos(&PtrLoc, pw_hmou);
}

void pws_MouReset()
{
    if (mou_present)
    {
    }
}

void pws_MouScan(pKey, pw_mou_key)
PWKEY *pKey;
PWKEY *pw_mou_key;
{
    if (mou_present)
    {
        if (mou_hcnt < -MOUSE_STEP/2)
        {
            *pKey = pw_mou_key[PWL_MOU_LEFT];
            mou_hcnt += MOUSE_STEP/2;
        }
        if (mou_hcnt > MOUSE_STEP/2)
        {
            *pKey = pw_mou_key[PWL_MOU_RIGHT];
            mou_hcnt -= MOUSE_STEP/2;
        }
        if (mou_vcnt < -MOUSE_STEP)
        {
            *pKey = pw_mou_key[PWL_MOU_UP];
            mou_vcnt += MOUSE_STEP;
        }
        if (mou_vcnt > MOUSE_STEP)
        {
            *pKey = pw_mou_key[PWL_MOU_DOWN];
            mou_vcnt -= MOUSE_STEP;
        }
    }
}
#endif



