/*
 * File: rwindow.r
 *  non window-system-specific window support routines
 */

#ifdef XIcon
/*
 * An obvious library function that never was (exported to fsys.c)
 */
char *strnchr(s,ci,len)
char *s;
int ci;
long len;
   {
   register long i;
   char c = (char)ci;
   for(i=0;i<len;i++,s++) if (*s == c) return s;
   return NULL;
   }

/*
 * subscript the already-processed-events "queue" to index i.
 * used in "cooked mode" I/O to determine, e.g. how far to backspace.
 */
char *evquesub(w,i)
wbp w;
int i;
   {
   wsp ws = w->window;
   int j = ws->eQback+i;

   if (i < 0) {
      if (j < 0) j+= EQUEUELEN;
      else if (j > EQUEUELEN) j -= EQUEUELEN;
      return &(ws->eventQueue[j]);
      }
   else {
      /* "this isn't getting called in the forwards direction!\n" */
      return NULL;
      }
   }

#ifdef PresentationManager

/* -----------------------------------------------------------------------
   Name - ObtainEvents
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */

/* #%#% need to add event interval and modifier keys to x and y values  */

#define EvQueChar(ws,c) { \
  struct descrip d;\
  StrLen(d) = 1; \
  StrLoc(d) = (char *)&allchars[FromAscii(c) & 0xFF]; \
  c_put(&((ws)->listp), &d); \
}

#define EvQueInt(ws,i) { \
  struct descrip d;\
  MakeInt((i),&d); \
  c_put(&((ws)->listp), &d); \
}

int ObtainEvents(wstate *ws, SHORT blockflag)
{
  QMSG msg;
  wstate *msg_ws;

  /* if block flag set, go for the block */
  while (WinPeekMsg(HInterpAnchorBlock, &msg, NULLHANDLE, INTERP_EVENT_START,
                    INTERP_EVENT_END, PM_REMOVE) || 
         (blockflag && WinGetMsg(HInterpAnchorBlock, &msg, NULLHANDLE, 
                                 INTERP_EVENT_START, INTERP_EVENT_END))) {
    /* decifer the window state pointer */
    msg_ws = (wstate *)msg.mp1;
    /* update pointerx, and pointery in window state */
    /* map the point to our window */
    WinMapWindowPoints(HWND_DESKTOP, msg_ws->hwnd, &(msg.ptl), 1);
    msg_ws->pointerx = (SHORT)msg.ptl.x;
    msg_ws->pointery = msg_ws->height - (SHORT)msg.ptl.y;
    /* take the event and shove it onto the window's icon list */
    if (msg.msg == ASCII_CHAR) { EvQueChar(msg_ws, ((char)msg.mp2)); }
    else
      EvQueInt(msg_ws, (int)msg.mp2);
    EvQueInt(msg_ws, msg_ws->pointerx);
    EvQueInt(msg_ws, msg_ws->pointery);
    if (blockflag && (!ws || ws == msg_ws)) return 1;
    } /* End of while - get an event */
  return 1;
} /* End of ObtainEvents */
#endif					/* PresentationManager */

/*
 * poll for available events on all opened displays.
 * this is where the interpreter calls into the X interface.
 */
int pollevent()
   {
#ifndef PresentationManager
   wdp wd;
   int hm;
   for (wd = wdsplys; wd; wd = wd->next) {
      if ((hm = handle_misc(wd, NULL)) < 1) {
	 if (hm == -1) return -1;
         }
      }
#else					/* PresentationManager */
   ObtainEvents(NULL, NO_WAIT_EVT);
#endif					/* PresentationManager */
   return 400;
   }

/*
 * get event from window, assigning to &x, &y, and &interval
 *
 * returns 0 for success, -1 if window died, -2 for malformed queue
 */
int wgetevent(w,res)
wbp w;
dptr res;
   {
   struct descrip xdesc, ydesc;
   uword i;

   if (wgetq(w,res) == -1)
      return -1;					/* window died */
   if (BlkLoc(w->window->listp)->list.size < 2)
      return -2;					/* malformed queue */

   wgetq(w,&xdesc);
   wgetq(w,&ydesc);

   if (xdesc.dword != D_Integer || ydesc.dword != D_Integer)
      return -2;			/* bad values on queue */

   IntVal(amperX) = IntVal(xdesc) & 0xFFFF;		/* &x */
   if (IntVal(amperX) >= 0x8000)
      IntVal(amperX) -= 0x10000;
   IntVal(amperY) = IntVal(ydesc) & 0xFFFF;		/* &y */
   if (IntVal(amperY) >= 0x8000)
      IntVal(amperY) -= 0x10000;
   MakeInt(1 + XTOCOL(w,IntVal(amperX)), &(amperCol));	/* &col */
   MakeInt(YTOROW(w,IntVal(amperY)) , &(amperRow));	/* &row */

   xmod_control = IntVal(xdesc) & MOD_CONTROL;		/* &control */
   xmod_meta = IntVal(xdesc) & MOD_META;		/* &meta */
   xmod_shift = IntVal(xdesc) & MOD_SHIFT;		/* &shift */

   i = (((uword) IntVal(ydesc)) >> 16) & 0xFFF;		/* mantissa */
   i <<= 4 * ((((uword) IntVal(ydesc)) >> 28) & 0x7);	/* scale it */
   IntVal(amperInterval) = i;				/* &interval */
   return 0;
   }

/*
 * get event from window (drop mouse events), no echo
 *
 * returns 1 for success, -1 if window died, -2 for malformed queue
 */
int wgetchne(w,res)
wbp w;
dptr res;
   {
   int i;

   while (1) {
      i = wgetevent(w,res);
      if (i != 0)
	 return i;
      if (is:string(*res))
         return 1;
      }
   }

/*
 * get event from window (drop mouse events), with echo
 *
 * returns 1 for success, -1 if window died, -2 for malformed queue
 */
int wgetche(w,res)
wbp w;
dptr res;
   {
   int i;
   i = wgetchne(w,res);
   if (i != 1)
      return i;
   i = *StrLoc(*res);
   if ((0 <= i) && (i <= 127) && (ISECHOON(w))) {
#ifndef PresentationManager
      wputc(i, w);
      if (i == '\r') wputc((int)'\n', w); /* CR -> CR/LF */
#else					/* PresentationManager */
     wputc(((i == '\r') ? '\n' : i), w);
#endif					/* PresentationManager */
      }
   return 1;
   }

/*
 * go to row,col within window w.  updates state variables only.
 * A cursor, if any, is drawn by event-reading code.
 */
wgoto(w,row,col)
wbp w;
int row, col;
   {
   w->window->x = COLTOX(w, col);
   w->window->y = ROWTOY(w, row);
   }


/*
 * strncpy with guaranteed NUL termination
 */
novalue mystrncpy(dest,src,n)
char *dest, *src;
int n;
   {
   strncpy(dest,src,n);
   dest[n] = '\0';
   }

/*
 * wlongread(s,elsize,nelem,f) -- read string from window for reads(w)
 *
 * returns length(>=0) for success, -1 if window died, -2 for malformed queue
 */
wlongread(s, elsize, nelem, f)
char *s;
int elsize, nelem;
FILE *f;
   {
   int c;
   tended char *ts = s;
   struct descrip foo;
   long l = 0, bytes = elsize * nelem;

   while (l < bytes) {
     c = wgetche((wbp)f, &foo);
     if (c < 0)
	return c;
     c = *StrLoc(foo);
     switch(c) {
       case '\177':
       case '\010':
         if (l > 0) { ts--; l--; }
         break;
       default:
         *ts++ = c; l++;
         break;
       } /* End of switch - type of character */
     } /* End of while - go until full */
   return l;
   } /* End of wlongread */

/*
 * wgetstrg(s,maxlen,f) -- get string from window for read(w) or !w
 *
 * returns length(>=0) for success, -1 if window died, -2 for malformed queue
 */
int wgetstrg(s, maxlen, f)
char *s;
long  maxlen;
FILE *f;
   {
   int c;
   tended char *ts = s;
   long l = 0;
   struct descrip foo;

   while (l < maxlen) {
      c = wgetche((wbp)f,&foo);
      if (c < 0)
	 return c;
      c = *StrLoc(foo);
      switch(c) {
        case '\177':
        case '\010':
          if (l > 0) { ts--; l--; }
          break;
        case '\r':
        case '\n':
          return l;
        default:
          *ts++ = c; l++;
          break;
        } /* End of switch - type of character */
      } /* End of while - not full */
   return l;
   }


/*
 * Assignment side-effects for &x,&y,&row,&col
 */
int xyrowcol(dx)
dptr dx;
{
   if (VarLoc(*dx) == &amperX) { /* update &col too */
      wbp w;
      if (!is:file(kywd_xwin[XKey_Window]))
	 return -1;
      w = (wbp)BlkLoc(kywd_xwin[XKey_Window])->file.fd;
      MakeInt(1 + XTOCOL(w, IntVal(amperX)), &amperCol);
      }
   else if (VarLoc(*dx) == &amperY) { /* update &row too */
      wbp w;
      if (!is:file(kywd_xwin[XKey_Window]))
	 return -1;
      w = (wbp)BlkLoc(kywd_xwin[XKey_Window])->file.fd;
      MakeInt(YTOROW(w, IntVal(amperY)), &amperRow);
      }
   else if (VarLoc(*dx) == &amperCol) { /* update &x too */
      wbp w;
      if (!is:file(kywd_xwin[XKey_Window]))
	 return -1;
      w = (wbp)BlkLoc(kywd_xwin[XKey_Window])->file.fd;
      MakeInt(COLTOX(w, IntVal(amperCol)), &amperX);
      }
   else if (VarLoc(*dx) == &amperRow) { /* update &y too */
      wbp w;
      if (!is:file(kywd_xwin[XKey_Window]))
	 return -1;
      w = (wbp)BlkLoc(kywd_xwin[XKey_Window])->file.fd;
      MakeInt(ROWTOY(w, IntVal(amperRow)), &amperY);
      }
   }

#else					/* XIcon */
static char junk;		/* avoid empty module */
#endif					/* XIcon */
