PROGRAM mousdemo;     { Demo of the mouse unit }

USES dos, crt, mouse;

CONST hardware = 1;                                  { cursor types }
      software = 0;
      left     = 0;                                 { mouse buttons }
      right    = 1;

VAR  theMouse : resetRec;                         { for mouse fcn 0 }
     its      : locRec;                       { for mouse inquiries }
     col, row : integer;
     input    : string [80];


BEGIN
  CLRSCR;                                        { clear the screen }
  mReset (theMouse);                         { initialize the mouse }
  IF theMouse.exists THEN               { and make sure we have one }

{ Do the software mouse demo first }
    BEGIN
      WRITELN ('Software cursor:');
      WRITELN ('Demo of a mouse with ',
                theMouse.nButtons, ' buttons');
      WRITELN ('Move the mouse around and click the left button');
      WRITELN ('Click the right button for hardware mouse demo');
      WRITELN;
      mTextCursor (software, $0000, $0718);        { set s/w cursor }
      mShow;                                       { turn cursor on }
      REPEAT
        mReleased (left, its);                  { check left button }
        IF its.opCount > 0 THEN BEGIN
          mHide;                           { in case screen scrolls }
          WRITELN ('Mouse is at column ', its.column,
                   ', row ', its.row);
          mShow;                                   { cursor back on }
        END;
        mReleased (right, its);                { check right button }
      UNTIL its.opCount > 0;                 { loop if not released }

{ Now do the hardware mouse demo }
      CLRSCR;
      WRITELN ('Hardware cursor:');
      WRITELN
        ('Move the mouse, click left button');
      WRITELN ('Type something and press Enter');
      WRITELN ('Click right button to end demo');
      mReset (theMouse);                   { clear old mouse status }
      mTextCursor (hardware, 2, 5); { set h/w cursor as small block }
      mShow;                                       { and turn it on }
      REPEAT
        mReleased (left, its);                  { check left button }
        IF its.opCount > 0 THEN BEGIN
          col := its.column DIV 8;          { compute text position }
          row := its.row DIV 8;
          GOTOXY (col, row);                    { move text pointer }
          WRITE ('?');                                     { prompt }
          READLN (input);                           { get the input }
          mMoveto (its.column, its.row);         { restore position }
        END;
        mReleased (right, its);                { check right button }
      UNTIL its.opCount > 0;                 { loop if not released }

{ Clean up afterwards }
      mTextCursor (hardware, 6, 7); { if graphics board, else 11,12 }
      mReset (theMouse);                       { reinitialize mouse }
      CLRSCR;
    END
  ELSE
    WRITELN ('Mouse not present in system');
END.