// Global definitions header file (GLOBALS.H)
//
// Written 1996, 1997 by Roland Acton - public domain.
//
// This file is part of the Game Music System 1.1 distribution.

// Standard definitions needed by all files.

#ifndef INCLUDED_GLOBALS
#define INCLUDED_GLOBALS

/* NOTE: If you are using one of the supported compilers, you should not
   need to modify this file. The autodetect code below will select the
   appropriate TARGET and USING defines. */

/* TARGET_LINUX is for my use only. The play routine may or may not work
   under Linux at some point in the future. At the moment, it doesn't.
   TARGET_WIN95 is experimental at this point. */
//#define TARGET_MSDOS   // Compiling for MS-DOS
//#define TARGET_LINUX   // Compiling for Linux 2.0.27
//#define TARGET_WIN95   // Compiling for Windows 95

// ONLY ONE of these should be defined.
//#define USING_GCC   // Compiling with GCC 2.7.2 (DJGPP 2.0)
//#define USING_BORLAND   // Compiling with Borland 3.1
//#define USING_WATCOM   // Compiling with Watcom 10.5a

// Some compiler auto-detection to make life easier.
#ifdef __GNUC__
  #define USING_GCC
  #ifdef __DJGPP__
    #ifdef __WIN32__
      #define TARGET_WIN95
    #else
      #define TARGET_MSDOS
    #endif
  #else
    #define TARGET_LINUX
  #endif
#endif

#ifdef __BORLANDC__
  #define USING_BORLAND
  #define TARGET_MSDOS
#endif

#ifdef __WATCOMC__
  #define USING_WATCOM
  #define TARGET_MSDOS
#endif

//#define EDITOR_HOOKS
/* Things the editor needs to manage the song and player, not necessary if
   just the player is being compiled. */

//#define NDEBUG   // Turn off assert() system.
//#define DEBUG_DISPLAYS   // Some things for debugging the editor.

#define YES 1
#define NO 0
/* Note: The code interprets any nonzero value as YES. But when calling the
   subroutines which deal with bit-mapped values it is important that 1 (and
   no more) is passed. */

enum gms_function_return_codes {gms_function_success, gms_function_failure};

#define MAX_BLOCKS 100
#define MAX_PATTERNS 100
#define MAX_INSTRUMENTS 36
#define MAX_TRACKS 20

#endif   // #ifndef INCLUDED_GLOBALS
