// Instrument header file (INST.H)
//
// Written 1996, 1997 by Roland Acton - public domain.
//
// This file is part of the Game Music System 1.1 distribution.

// Things relating to the instrument class.

#ifndef INCLUDED_INST
#define INCLUDED_INST

#ifdef TARGET_WIN95
#else
  #ifdef USING_GCC
    #ifdef TARGET_MSDOS
      #include <dpmi.h>
    #else
      #include "msonly.h"
    #endif
  #endif
#endif

union am_vib_union {
  unsigned char byte;
  struct {
    unsigned frequency_multiple: 4;
    unsigned keyboard_scaling_rate: 1;
    unsigned hold_at_sustain: 1;
    unsigned apply_vibrato: 1;
    unsigned apply_amplitude_modulation: 1;
  } bitmap;
};

union scaling_volume_union {
  unsigned char byte;
  struct {
    unsigned volume: 6;
    unsigned scaling_level: 2;
  } bitmap;
};

union a_d_union {
  unsigned char byte;
  struct {
    unsigned decay: 4;
    unsigned attack: 4;
  } bitmap;
};

union s_r_union {
  unsigned char byte;
  struct {
    unsigned release: 4;
    unsigned sustain: 4;
  } bitmap;
};

union op1mod_feedback_union {
  unsigned char byte;
  struct {
    unsigned additive_synthesis: 1;
    unsigned feedback_strength: 3;
  } bitmap;
};

union wave_union {
  unsigned char byte;
  struct {
    unsigned waveform: 3;
  } bitmap;
};

class instrument {
public:
  unsigned int has_synth_component;
  unsigned int has_sample_component;
  am_vib_union am_vib1, am_vib2;
  scaling_volume_union scaling_volume1, scaling_volume2;
  a_d_union a_d1, a_d2;
  s_r_union s_r1, s_r2;
  op1mod_feedback_union op1mod_feedback;
  wave_union wave1, wave2;
  char name[30 + 1];
  enum resolution_types {type_8_bit, type_16_bit} resolution;
  enum presence_types {mono, stereo} presence;
#ifdef USING_BORLAND
  signed char huge *sample_address_RM;
#else
  signed char *sample_address_RM;
  signed char *sample_address_PM;
#endif
#ifdef TARGET_WIN95
#else
  #ifdef USING_GCC
  _go32_dpmi_seginfo dos_buffer_info;
  #endif
#endif
  unsigned long int sample_length;
  unsigned long int repeat_start;
  unsigned long int repeat_length;
  unsigned int sample_freq;
  unsigned long int sample_linear_address;
// The address to pass to the DMA hardware.
  unsigned int in_signed_form;

  instrument();
  ~instrument();
  void delete_synth_component();
  void delete_sample_component();
  gms_function_return_codes prepare_sample();
  void unprepare_sample();
  void convert_to_signed();
  void convert_to_unsigned();
  void invert_samples();
};

#endif   // #ifndef INCLUDED_INST
