/*
                          PS_CONV
  Function: take the verb from the transaction program, then
  select the appropriate subroutine and pass to it the control
  in order to process that verb.

  Input: The verb code and the pointer to the verb srtucture.
  Output: Return codes which will be placed into the verb structure.

  CopyRight 1995. Nicholas Poljakov all rights reserved.

 */

 #include <state1.h>
 #include <common.h>
 #include <string.h>
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int proterr(void *, unsigned long);
int preptrcv(void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);
int confirm(void *);
int confirmd(void *);

ps_conv(code, sptr)
unsigned int code;
char *sptr;
 {
    struct com *p_com;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "psconv");
pnum = 1;
drec = &code;
lenr = 2;
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

    p_com = (struct com *)sptr;
    p_com -> prim_rc = OK;
    p_com -> sec_rc = OK;

      switch(code)
            {
              case Allocate :
                              { allocate(sptr);
                                break; }
              case Confirm  :
                              { confirm(sptr);
                                break; }
              case COnfirmed :
                              { confirmd(sptr);
                                break; }
              case Deallocate :
                              { dealloc(sptr);
                                break; }
              case Get_attributes :
                              { get_attr(sptr);
                                break; }
              case Flush :
                              { flush(sptr);
                                break; }
              case Prepare_to_receive :
                              { preptrcv(sptr);
                                break; }
              case Receive_immediate :
              case Receive_and_wait :
                              { recwait(sptr);
                                break; }
              case Request_to_send :
                              { rtsend(sptr);
                                break; }
              case Send_data :
                              { sendat(sptr);
                                break; }
              case Send_error :
                              { senderr(sptr);
                                break; }
              case Test :
                              { test(sptr);
                                break; }

          default:        { return(-1);}
            }
 }
