/****************************************************************************
*   Function:    int sockrx(int fd, char *bufptr, int toread)               *
*   Operation:   to read n bytes from socket fd into bufptr                 *
*                BUT FAST -- WITHOUT PAUSING...                             *
*   Returns:     number of bytes read or -1 for error                       *
*   Parameters:  fd, socket file descriptor                                 *
*                bufptr, address of character array to read into            *
*                toread, the actual number of bytes to read into bufptr     *
****************************************************************************/

#include "socko.h"

#include <stdio.h>

#ifdef UNIX
# include <sys/types.h>
#else
# include <tklib.h>
#endif

#include <sys/socket.h>

#ifdef UNIX
# include <sys/time.h>
# include <errno.h>
extern int errno;
#else
# include <io.h>
# include <sys/nfs_time.h>
# include <tk_errno.h>
#endif

struct timeval wait_time;
fd_set rwfds;

int sockrx(fd, bufptr, toread)
  register int fd;
  register char *bufptr;
  register int toread;
{
  int togo = 0;
  int nread = 0;
  int total = 0;

  for(;;) {
    togo = recv(fd,bufptr,toread,MSG_PEEK);
    if (togo >= 0) 
      break;
    else {
#ifndef SYSV
      if (errno == EWOULDBLOCK) {
#endif

#ifdef SEQ
      if (errno == EWOULDBLOCK) {
#endif
        FD_ZERO(&rwfds);
        FD_SET(fd, &rwfds); 
        wait_time.tv_sec = 25;
        wait_time.tv_usec = 0;
        if ((select(32, &rwfds, (fd_set*) 0, (fd_set *) 0, &wait_time)) < 1)        
          return(-1);
#ifndef SYSV
      } 
      else 
        return(-1);
#endif

#ifdef SEQ
      } 
      else 
        return(-1);
#endif

    }
  }
  while(togo > 0) {
    nread = recv(fd, bufptr, togo, 0);
    if (nread > 0) {
      bufptr += nread;
      togo -= nread;
      total += nread;
    }
    else if (nread < 0) {
#ifndef SYSV
      if (errno == EWOULDBLOCK) {
#endif

#ifdef SEQ
      if (errno == EWOULDBLOCK) {
#endif
        FD_ZERO(&rwfds);
        FD_SET(fd, &rwfds); 
        wait_time.tv_sec = 25;
        wait_time.tv_usec = 0;
        if ((select(32, &rwfds, (fd_set*) 0, (fd_set *) 0, &wait_time)) < 1)        
          return(-1);
#ifndef SYSV
      }
      else 
        return(-1);
#endif

#ifdef SEQ
      }
      else 
        return(-1);
#endif
    } else {
      *bufptr = 0;
      return(-1);
    }
  }
  *bufptr = 0;
  return (total);
}
