/* DPMI.H */

#pragma pack(1)

typedef struct {
    unsigned long edi, esi, ebp, reserved, ebx, edx, ecx, eax;
    unsigned flags, es, ds, fs, gs, ip, cs, sp, ss;
    } RMODE_CALL;

/* structure of a protected-mode descriptor */
typedef struct {
    unsigned limit, addr_lo;
    unsigned char addr_hi, access, reserved, addr_xhi;
    } DESCRIPTOR;   

/* low-level DPMI functions */  
BOOL dpmi_present(void);
void dpmi_version(unsigned *pmaj, unsigned *pmin, 
    unsigned *pflags, unsigned *pproc);
BOOL dpmi_rmode_intr(unsigned intno, unsigned flags, 
    unsigned copywords, RMODE_CALL far *rmode_call);
unsigned dpmi_sel(void);
BOOL dpmi_set_descriptor(unsigned pmodesel, DESCRIPTOR far *d);
BOOL dpmi_get_descriptor(unsigned pmodesel, DESCRIPTOR far *d);
BOOL dpmi_sel_free(unsigned pmodesel);

/* higher layer on top of DPMI */
unsigned DosAllocRealSeg(DWORD bytes, unsigned *ppara, unsigned *psel);
unsigned DosFreeRealSeg(unsigned sel);
unsigned DosMapRealSeg(unsigned rmpara, DWORD size, unsigned far *psel);
unsigned DosFreeSeg(unsigned sel);
void far *DosProtToReal(void far *prot);

void far *map_real(void far *rptr, unsigned long size);
void free_mapped_seg(void far *fp);
unsigned get_mapped(void);
unsigned verw(unsigned sel);

/* undocumented Windows functions */
extern DWORD FAR PASCAL GetSelectorBase(unsigned sel);
extern DWORD FAR PASCAL GetSelectorLimit(unsigned sel);
extern void FAR PASCAL SetSelectorBase(unsigned sel, DWORD base);
extern void FAR PASCAL SetSelectorLimit(unsigned sel, DWORD limit);
