#include<stdio.h>
#include<string.h>
#include"stdwin.h"
#include"csapi.h"

        char message[50];

class myApp : public WinAppStdWindow
    {
    HWND hWndClipStac;
    BOOL ClipStacActive;
public:
    myApp(char *name) : WinAppStdWindow(name)
        {
        ClipStacActive = FALSE;
        DelWinStyle(WS_VISIBLE);
        WM_CLIPSTACREGISTER = RegisterWindowMessage(szWM_CLIPSTACREGISTER);
        WM_CLIPSTACPUSH = RegisterWindowMessage(szWM_CLIPSTACPUSH);
        WM_CLIPSTACPOP = RegisterWindowMessage(szWM_CLIPSTACPOP);    
        WM_CLIPSTACFIND = RegisterWindowMessage(szWM_CLIPSTACFIND);
        WM_CLIPSTACGET = RegisterWindowMessage(szWM_CLIPSTACGET);
        WM_CLIPSTACEXIT = RegisterWindowMessage(szWM_CLIPSTACEXIT);
        WM_CLIPSTACDEREGISTER = RegisterWindowMessage(szWM_CLIPSTACREGISTER);
        WM_CLIPSTACNUMITEMS = RegisterWindowMessage(szWM_CLIPSTACNUMITEMS);
        }
    void WMCREATE(WinAppMsg&)
        {
        SendMessage(0xffff,WM_CLIPSTACREGISTER,hWnd,0L);
        SetTimer(hWnd,1,5000,NULL);     // wait for 5 seconds for ClipStac to respond
        }
    void WMTIMER(WinAppMsg& m)
        {
        if(m.wParam == 1)
            {
            KillTimer(hWnd,1);              // ClipStac too slow or not running...
            MessageBox(hWnd,"ClipStac not found!","CSTEST",MB_OK);
            PostMessage(hWnd,WM_CLOSE,0,0L);
            }
        if(m.wParam == 2)
            {
            KillTimer(hWnd,2);
            MessageBox(hWnd,"CSTest exiting.","CSTEST",MB_OK);
            PostMessage(hWnd,WM_CLOSE,0,0L);
            }
        }
        
    void WMCLOSE(WinAppMsg&)
        {
        if(ClipStacActive)              // if ClipStac active, let it know we're history
            SendMessage(hWndClipStac,WM_CLIPSTACDEREGISTER,hWnd,0L);
        DestroyWindow(hWnd);
        }
    void WMDESTROY(WinAppMsg&)
        {
        PostQuitMessage(0);
        }
        
    void WMUSER(WinAppMsg &m)
        {
        if(m.msg == WM_CLIPSTACREGISTER)
            {
            if(HIWORD(m.lParam) == hWnd)
                {
                KillTimer(hWnd,1);
                ClipStacActive = TRUE;
                hWndClipStac = LOWORD(m.lParam);

                if(hWndClipStac)                // if ClipStac handle retrieved
                    {
                    int numItems = SendMessage(hWndClipStac,WM_CLIPSTACNUMITEMS,0,0L);
                        // have it push the Clipboard contents onto the stack
                    if(SendMessage(hWndClipStac,WM_CLIPSTACPUSH,0,0L))
                        {
                        MessageBox(hWnd,"Stack pushed!","CSTEST",MB_OK);
                            // now pop the stack
                        if(SendMessage(hWndClipStac,WM_CLIPSTACPOP,0,0L))
                            MessageBox(hWnd,"Stack popped!","CSTEST",MB_OK);
                        }
                    else
                        MessageBox(hWnd,"0 return from PUSH","CSTEST",MB_OK);
                    
                        // now get the identifying info on item 0
                    LPSTR stuff = (LPSTR)SendMessage(hWndClipStac,WM_CLIPSTACGET,0,0L);
                    if(stuff)
                        {
                        char buf[200];
                        sprintf(buf,"Info on item[%d] (of %d): %Fs",0,numItems,(LPSTR)stuff);
                        MessageBox(hWnd,buf,"CSTEST",MB_OK);

                            // now find the item # that contains all this
                        char *p = strstr(buf,":\\");
                        if(!p)
                            p = strstr(buf,"(Own");
                        if(p)
                            {
                            p--;
                            LPSTR lpstr = p;
                            int index = SendMessage(hWndClipStac,WM_CLIPSTACFIND,0,(LONG)lpstr);
                            if(index != -1)
                                {
                                sprintf(buf,"index = %d",index);
                                MessageBox(hWnd,buf,"CSTEST",MB_OK);
                                }
                            }
                        SetTimer(hWnd,2,5000,NULL);     // wait for 5 seconds for ClipStac to terminate
                        }
                    }
                }
            return;
            }
        if(m.msg == WM_CLIPSTACEXIT)
            {
            ClipStacActive = FALSE;
            MessageBox(hWnd,"ClipStac has terminated","CSTEST",MB_OK);
            }
        }
    };


int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int)
    {
    myApp MyWin("CSTest");
    if(MyWin.GetPrevInstance())
        {
        MessageBox(NULL,"CSTest already running!","CSTest",MB_OK);
        return 0;
        }
    MyWin.Display(SW_HIDE);                    // open the window
    return MyWin.Run();                 // process any messages
    }





