//***********************************************************************
//
//  Circle.cpp
//
//***********************************************************************

#include <afxwin.h>
#include "Circle.h"

IMPLEMENT_SERIAL (CCircle, CObject, 2 | VERSIONABLE_SCHEMA)

CCircle::CCircle (LPRECT pRect, COLORREF crColor)
{
    m_rect.left = pRect->left;
    m_rect.top = pRect->top;
    m_rect.right = pRect->right;
    m_rect.bottom = pRect->bottom;
    m_crColor = crColor;
}

void CCircle::Serialize (CArchive& ar)
{
    if (ar.IsStoring ())
        ar << m_rect << (DWORD) m_crColor;
    else {
        UINT nSchema = ar.GetObjectSchema ();
        switch (nSchema) {

        case 1: // Version 1
            ar >> m_rect;
            m_crColor = RGB (255, 0, 0);
            break;

        case 2: // Version 2
            DWORD dwColor;
            ar >> m_rect >> dwColor;
            m_crColor = (COLORREF) dwColor;
            break;

        default: // Unknown version
            AfxThrowArchiveException (CArchiveException::badSchema);
            break;
        }
    }
}

void CCircle::Draw (CDC* pDC)
{
    CPen pen (PS_SOLID, 10, m_crColor);
    CPen* pOldPen = pDC->SelectObject (&pen);
    pDC->SelectStockObject (NULL_BRUSH);
    pDC->Ellipse (m_rect);
    pDC->SelectObject (pOldPen);
}
