//***********************************************************************
//
//  DrawView.cpp
//
//***********************************************************************

#include <afxwin.h>
#include "Circle.h"
#include "DrawDoc.h"
#include "DrawView.h"

IMPLEMENT_DYNCREATE (CDrawView, CView)

BEGIN_MESSAGE_MAP (CDrawView, CView)
    ON_WM_LBUTTONDOWN ()
    ON_WM_MOUSEMOVE ()
    ON_WM_LBUTTONUP ()
END_MESSAGE_MAP ()

void CDrawView::OnDraw (CDC* pDC)
{
    CDrawDoc* pDoc = GetDocument ();
    POSITION pos = pDoc->GetFirstCirclePosition ();

    while (pos != NULL) {
        CCircle* pCircle = pDoc->GetNextCircle (pos);
        pCircle->Draw (pDC);
    }
}

void CDrawView::OnLButtonDown (UINT nFlags, CPoint point)
{
    CClientDC dc (this);
    m_point1 = point;
    m_point2 = point;
    SetCapture ();
}

void CDrawView::OnMouseMove (UINT nFlags, CPoint point)
{
    if (GetCapture () == this) {
        CClientDC dc (this);
        RubberBandCircle (&dc, m_point1, m_point2);
        RubberBandCircle (&dc, m_point1, point);
        m_point2 = point;
    }
}

void CDrawView::OnLButtonUp (UINT nFlags, CPoint point)
{
    if (GetCapture () == this) {
        ReleaseCapture ();
        CClientDC dc (this);
        RubberBandCircle (&dc, m_point1, m_point2);

        CCircle* pCircle = GetDocument ()->AddCircle (m_point1, m_point2);
        if (pCircle != NULL)
            pCircle->Draw (&dc);
    }
}

void CDrawView::RubberBandCircle (CDC* pDC, CPoint point1, CPoint point2)
{
    int nOldMode = pDC->SetROP2 (R2_NOT);
    pDC->SelectStockObject (NULL_BRUSH);
    pDC->Ellipse (point1.x, point1.y, point2.x, point2.y);
    pDC->SetROP2 (nOldMode);
}
