/* MCI REXX Sample #4 */
/* this script shows you how to determine the total playing time of   */
/* a CD.  In addition, it has the ability to figure out the number of */
/* tracks on a CD, and the total playing time of each track.          */

rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/* Open the CD */

rc = mciRxSendString("open cdaudio alias supercd wait", 'Retst', '0', '0')
rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')
If Retst <> 'TRUE' then
     do
     say 'Must have CD inserted to run this command file'
     say 'Please insert'
     rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')

       do while Retst <> 'TRUE'
         rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')
       End
     End

rc = mciRxSendString("status supercd number of tracks wait", 'NumTracks', '0', '0')

/* Initialize some variables */

loop = 1
trackstring = 'status supercd length track'

/* The command below sets the current time format to milliseconds (or ms) */
/* By default, OS/2 records time in MMTIME units (or 1/300 seconds).      */
/* Milliseconds are a little easier to keep track of for most people so   */
/* we will use this instead.                                              */

rc = mciRxSendString("set supercd time format ms wait", 'Retst', '0', '0')

rc = mciRxSendString("status supercd number of tracks wait", 'Retst', '0', '0')
say 'The total number of tracks on the CD is: ' Retst ' seconds'


rc = mciRxSendString("status supercd length wait", 'Retst', '0', '0')
say 'The total playing time for the CD is: ' Retst ' seconds'



  /* we are going to loop through each track and query the device */
  /* to determine how long each track (or song) will play         */

  do while loop <= NumTracks
      
      trackcommand = trackstring loop ' wait '
      rc = mciRxSendString(trackcommand, 'Retst', '0', '0')

      /* Remember that the time format that OS/2 sends us is in ms. */
      /* We will convert this number of seconds for the user.       */

      TimeInSecs = Retst / 100
      say 'Track ' loop ' is: ' TimeInSecs ' seconds'
      loop = loop + 1
  End

rc = mciRxSendString("close supercd wait", 'Retst', '0', '0')
say 'Finished SuperCD artist setup'
exit


error:
   say 'Error' ErrRC 'at line' sigl ', sourceline:' sourceline(sigl)
   say 'Terminating'
   mciRxSendString("close supercd wait", 'Retst', '0', '0')
   mciRxExit()               /* Tell the DLL we're going away */
   exit ErrRC                /* exit, tell caller things went poorly */

halt:
/*
 * Close all device alias's, in case we previously killed
 * this batch file in the same process.
 */
   say 'Terminating'
   mciRxSendString("close supercd wait", 'Retst', '0', '0')
   mciRxExit()               /* Tell the DLL we're going away */

exit


