/* MCI REXX Audio Sample */
/* Sample REXX Script */
/* this script shows you how to use the clipboard functions to edit   */
/* an audio file.                                                     */
/* It also illustrates how to use the clipboard to communicate with   */
/* other apps.                                                        */


rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

createfile = 0

/* the default is the microphone */

microphone = 1


parse arg arg1 arg2 arg3

If (arg1 = '/?' | arg1 = '/h' | arg1 = '/?' | arg1 = '') THEN
   do
     DisplayHelpOptions()
   End

else If (arg1 = '/n' | arg1 = '/N' ) THEN
   do
     createfile = 1
     rc = mciRxSendString("open new type waveaudio alias rexxtracks wait", 'Retst', '0', '0')

   End
else 
   do
    say 'no new file'
   rc = mciRxSendString("open waveaudio alias rexxtracks wait", 'Retst', '0', '0')
   rc = LoadFile( arg1 )
   End

If (arg2 = '' | arg2 = '/M' | arg2 = '/m') THEN
   do
     say 'from mic'
     microphone = 1
     rc = mciRxSendString("connector rexxtracks enable type microphone wait", 'Retst', '0', '0')

   End
else 
   do
   microphone = 1
   say 'from line'
   rc = mciRxSendString("connector rexxtracks enable type line in wait", 'Retst', '0', '0')
   End


If (arg3 = '/S' | arg3 = '/s') THEN
   do
     savefile = 1
     say 'saving audio....'
   End
else 
   do
   savefile = 0
   End


/* Do we need to record audio */
if (createfile = 1) then
  do
  rc = RecordAudio()
  END


rc = LeaveInClipBoard()

/* If the save option is turned, then save the audio file */
if (savefile = 1) then
  do
  rc = SaveAudio()
  END


rc = mciRxSendString("close rexxtracks wait", 'Retst', '0', '0')
exit


DisplayHelpOptions:

   say 'REXXTracks is a FREEWARE REXX-based audio effects player'
   say ''
   say 'It supports the following  parameters (case insensitive)'
   say ''
   say 'The first parameter must be file name to edit OR'
   say '  /n to create a new file'
   say ''
   say 'The second parameter is where to record from '
   say ''
   say '  /M for a microphone'
   say '  /L for line input or CD'

   say ''
   say '/S instructs REXXTracks to save the file when it is done'

   exit 0


LoadFile:
   arg audiofile


    command = "load rexxtracks " audiofile "  wait"
    say "command :" command
    rc = mciRxSendString(command, 'Retst', '0', '0')



return 0


/* REXXTracks always modifies the wave file in memory and copies the */
/* final result into the clipboard unless otherwise specified by the */
/* user.                                                             */
/* The routine simply copies the first part of the wave file         */
/* into the clipboard and then pastes it three times into file.      */
/* The final result is left in the clipboard for other applications  */
/* to use.                                                           */

LeaveInClipBoard:


rc = mciRxSendString("copy rexxtracks from 0 to 3000 wait", 'Retst', '0', '0')
if ( rc > 0 ) then
  do
  say "Make sure to run REXXTracks from an application with a message queue"
  say "such as PMRExx.  See the help for more information on this topic."
  End

rc = mciRxSendString("seek rexxtracks to 0 wait", 'Retst', '0', '0')
rc = mciRxSendString("paste rexxtracks wait", 'Retst', '0', '0')
if ( rc > 0 ) then
  do
  say ""
  say "Clipboard operations failed!!!!"
  say "Make sure to run REXXTracks from an application with a message queue"
  say "such as PMRExx.  See the help for more information"
  End



rc = mciRxSendString("seek rexxtracks to 0 wait", 'Retst', '0', '0')
rc = mciRxSendString("paste rexxtracks wait", 'Retst', '0', '0')

rc = mciRxSendString("seek rexxtracks to 0 wait", 'Retst', '0', '0')
rc = mciRxSendString("paste rexxtracks wait", 'Retst', '0', '0')


rc = mciRxSendString("copy rexxtracks from 0 wait", 'Retst', '0', '0')

return 0

/* RecordAudio is used to place digital audio data into an empty     */
/* .WAV file.  It records audio from the microphone (the default     */
/* input source.                                                     */
/* This REXX file uses MMTIME (each MMTIME unit is 1/3000th of a     */
/* second.                                                           */

RecordAudio:


say "Recording 6 seconds of normal audio..."
rc = mciRxSendString("record rexxtracks to 18000 wait", 'Retst', '0', '0')


say "Recording 4 seconds of audio in the middle of the file..."
rc = mciRxSendString("record rexxtracks from 3000 to 15000 insert wait", 'Retst', '0', '0')

say "Recording over the first 4 seconds of normal audio..."

rc = mciRxSendString("record rexxtracks from 0 to 12000 wait", 'Retst', '0', '0')

say "This is what it sounds like after recording is done."

rc = mciRxSendString("play rexxtracks from 0 wait", 'Retst', '0', '0')


return 0


/* SaveAudio is save the changes we've made to the audio file.       */
/* Without this, all modifications will be lost.                     */
/*                                                                   */
/* This routine always saves to the REXXTRKS.WAV filename.           */

SaveAudio:

rc = mciRxSendString("save rexxtracks rexxtrks.wav wait", 'Retst', '0', '0')

return rc



