

/* EGADEMO.C -- Compile with Microsoft C Version 3 with /Ze parameter
		to enable "far" keyword.  Programmed by Charles Petzold. */
#include <dos.h>
#define MAXROWS 350
#define MAXCOLS 640
#define COLBYTES MAXCOLS/8
#define GRAFOUT(index,value) { outp(0x3CE,index) ; outp(0x3CF,value) ; }
#define SWAP(a,b,temp) { temp = a ; a = b ; b = temp ; }

main()	{
	setvideomode(16) ;
	randomrect(0) ;				/* Draw colored rectangles */
	setvideomode(16) ;
	randomrect(0x18) ;			/* Rectangles with XORing */
	setvideomode(3) ;
	}

setvideomode(mode)				/* Sets video mode */
	int mode ;
	{
	union REGS regs ;

	regs.x.ax = mode ;
	int86(0x10, &regs, &regs) ;
	}

randomrect(fnct)				/* Draws 100 rectangles */
	int fnct ;
	{
	unsigned int i, r1, c1, r2, c2, temp ;

	GRAFOUT(3, fnct) ;			/* Function Register */
	for (i = 0 ; i < 100 ; i++) {
		r1 = rand() % MAXROWS ; r2 = rand() % MAXROWS ;
		c1 = rand() % MAXCOLS ; c2 = rand() % MAXCOLS ;
		if (r1 > r2) SWAP (r1, r2, temp) ;
		if (c1 > c2) SWAP (c1, c2, temp) ;
		rect(r1, c1, r2, c2, rand()%16);
		}
	}

rect(r1, c1, r2, c2, color)			/* r1 <= r2 and c1 <= c2 */
	unsigned int r1, c1, r2, c2, color ;
	{
	char far *addr = (char far *) (0xA0000000L + COLBYTES*r1 + (c1>>3)) ;
	int numrows    = r2 - r1 ;			/* Number of rows */
	int numcols    = (c2 >> 3) - (c1 >> 3) - 1 ;	/* Number of columns */
	char lmask     =   0xFF >> (c1 & 7) ;		/* Mask for left */
	char rmask     = ~(0xFF >> (c2 & 7)) ;		/* Mask for right */
	register row, col ;

	if (numcols < 0) {			/* Adjustment for small rows */
		lmask &= rmask ; 
		rmask = numcols = 0 ; 
		}
	GRAFOUT(0, color) ;			/* Set/Reset Register */
	GRAFOUT(1, 0x0F) ;  			/* Enable Set/Reset Register */
	for (row = 0 ; row < numrows ; row++) {
		GRAFOUT(8, lmask) ;			/* Bit Mask Register */
		*(addr++) &= 1 ;			/* Left side */
		GRAFOUT(8, 0xFF) ;
		for (col = 0 ; col < numcols ; col++) 
			*(addr++) &= 1 ;		/* Middle part */
		GRAFOUT(8, rmask) ;
		*(addr++) &= 1 ;			/* Right side */
		addr += COLBYTES - 2 - numcols ;	/* Next row */
		}
	GRAFOUT(0, 0) ;				/* Set/Reset to normal */
	GRAFOUT(1, 0) ;				/* S/R Enable to normal */  
	GRAFOUT(8, 0xFF) ;			/* Bit mask to normal */
	}



Figure 16:  An EGA graphics demonstration program written in C that draws random rectangles on the screen.