PROGRAM TPoker;
USES Crt, Cards, poker;
TYPE
  TextPoker = OBJECT (PokerGame)
    CONSTRUCTOR Init(iTC : Byte);
    DESTRUCTOR Done; virtual;
    PROCEDURE Display; virtual;
    PROCEDURE ClearBottom; virtual;
    PROCEDURE ShowStake; virtual;
    PROCEDURE HoldButton(B : Byte); virtual;
    PROCEDURE Tell(M1, M2 : Message); virtual;
  END;

  CONSTRUCTOR TextPoker.Init(iTC : Byte);
  BEGIN
    PokerGame.Init(iTC);
    Randomize;
    D := New(DeckP, Init(0, 0, iTC));
    D^.shuffle;
    stake := 40;
    margin := 20; tab := 10; topmargin := 10;
  END;

  PROCEDURE TextPoker.Display;
  BEGIN
    TextAttr := TableColor;
    ClrScr;
    TextAttr := $70;
    GotoXY(28, 2); Write('Ŀ');
    GotoXY(28, 3); Write(' V*I*D*E*O   P*O*K*E*R ');
    GotoXY(28, 4); Write('');
    TextAttr := TableColor;
    Frame(30, 5, 50, 7, 1, true, ' ');
    Frame(41, 19, 79, 25, 2, true, ' ');
    GotoXY(42, 20); Write('One pair    1-1| Full house       9-1');
    GotoXY(42, 21); Write('Two pair    2-1| 4 of a kind     25-1');
    GotoXY(42, 22); Write('3 of a kind 3-1| Straight flush  50-1');
    GotoXY(42, 23); Write('Straight    4-1| Royal flush    250-1');
    GotoXY(42, 24); Write('Flush       6-1|');
  END;

  DESTRUCTOR TextPoker.Done; BEGIN PokerGame.Done; END;

  PROCEDURE TextPoker.ClearBottom;
  BEGIN frame(1, 20, 40, 25, 0, true, ' '); END;

  PROCEDURE TextPoker.ShowStake;
  VAR S : String[20];
  BEGIN
    Str(0.25*stake:1:2, S); {19 blanks on next line}
    GotoXY(31, 6); Write('                   ');
    GotoXY(47-length(S), 6);
    Write('$'+S);
  END;

  PROCEDURE TextPoker.HoldButton(B : Byte);
  BEGIN
    GotoXY(20+B*10, 16);
    IF hold[B] THEN
      BEGIN
        TextAttr := ((TableColor SHL 4)+(TableColor SHR 4)) AND $7F;
        Write('HOLD');
        TextAttr := TableColor;
      END
    ELSE Write('    ');
  END;

  PROCEDURE TextPoker.Tell(M1, M2 : Message);
  BEGIN GotoXY(2, 20); Write(M1); GotoXY(2,21); Write(M2); END;

VAR
  V       : TextPoker;
  doagain : boolean;
BEGIN
  V.Init($F);
  V.Display;
  REPEAT
    V.Play(doagain);
  UNTIL NOT doagain;
  V.Done;
END.