/*
    EDITDEMO.C      Simple test program demonstrating use of
                    DosEditName and DosCopy APIs in OS/2 1.2

    Copyright (C) 1989 Ziff-Davis Communications
    PC Magazine * Ray Duncan

    Compile:    cl /Zi /F 2000 editdemo.c
                markexe lfns testedit.exe
*/
 
#include <stdio.h>
#include <string.h>
 
#define MAXPATHNAME  260
 
#define API unsigned extern far pascal  // OS/2 API function prototypes 
 
API DosCopy(char far *, char far *, unsigned, unsigned long);
API DosEditName(unsigned, char far *, char far *, char far *, unsigned);
 
FILE *datafile;
 
main(int argc, char *argv[])
{
    char filename[MAXPATHNAME];             // name of original file
    char tempname[MAXPATHNAME];             // name of temporary file
    char backname[MAXPATHNAME];             // name of backup file

    strcpy(filename, "arbitrary.file.dat"); // the actual test name

    DosEditName(1,                          // edit type (always 1)
                filename,                   // original file name
                "*.*.$$$",                  // editing string
                tempname,                   // receives temporary file name
                sizeof(tempname));          // max size of edited name

    DosEditName(1,                          // edit type (always 1)
                filename,                   // original file name
                "*.*.bak",                  // editing string
                backname,                   // receives backup file name
                sizeof(backname));          // max size of edited name

    DosCopy(filename,                       // name of existing file
            tempname,                       // name of new file
            1,                              // mode (create or replace)
            0L);                            // reserved parameter

    datafile = fopen(tempname, "r+");       // open temporary file 

                                            // perform modifications
                                            // to temporary file here...

    fclose(datafile);                       // close temporary file

    unlink(backname);                       // get rid of previous backup
    rename(filename, backname);             // rename original file to .BAK
    rename(tempname, filename);             // assign original file name
}                                           // to temporary file
