{
 
                                                                          
         TITLE :      DGDEC.TPU                                           
       PURPOSE :      Common declarations.                                
        AUTHOR :      David Gerrold, CompuServe ID:  70307,544            
   _____________________________________________________________________  
                                                                          
    Written in Turbo Pascal, Version 5.5,                                 
    with routines from TurboPower, Object Professional.                   
                                                                          
    Turbo Pascal is a product of Borland International.                   
    Object Professional is a product of TurboPower Software.              
   _____________________________________________________________________  
                                                                          
    This is not public domain software.                                   
    This software is copyright 1990, by David Gerrold.                    
    Permission is hereby granted for personal use.                        
                                                                          
         The Brass Cannon Corporation                                     
         9420 Reseda Blvd., #804                                          
         Northridge, CA  91324-2932.                                      
                                                                          
 
                                                                            }
{ Compiler Directives ===================================================== }

{$A-}    {Switch word alignment off, necessary for cloning}
{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$I-}    {I/O checking off}
{$N+,E+} {Simulate numeric coprocessor}
{$M 16384,0,327680} {stack and heap}
{$V-}    {Variable range checking off}

{ Name ==================================================================== }

UNIT DgDec;
{
  The purpose of this code is to provide a template for beginning a new
  unit.  Replace these lines with a general description of the unit's
  abilities.
}

{ ========================================================================= }
{ Interface =============================================================== }

INTERFACE

{ ========================================================================= }
{ Type declarations ======================================================= }

TYPE
  Proc = Procedure;

TYPE
  CapsFlagType =
    (NoCaps,
     MixedCaps,
     SentenceCaps,
     NameCaps,
     AllCaps);

{ Shift key declarations -------------------------------------------------- }

VAR
  KeyStateByte : byte absolute $40:$17;          { shift key status }

CONST
{ Bit values of KeyStateByte at $40:$17 }
  RightShiftKey =   1;
  LeftShiftKey  =   2;
  ShiftKey      =   3;
  ControlKey    =   4;
  AltKey        =   8;
  ScrlLock      =  16;
  NumLock       =  32;
  CapsLock      =  64;
  InsLock       = 128;

{ Boolean declarations ---------------------------------------------------- }

CONST
  Flag         : boolean = false;                { trash variable }
  FlagArray    : array [false..true] of string [3] = ('Off', ' On');

{ Key declarations -------------------------------------------------------- }

CONST
  SpaceChar       : char = #32;

CONST
  Null            = #0;
  BackSpace       = #8;
  Tab             = #9;
  Enter           = #13;
  Esc             = #27;
  CtrlBackSpace   = #127;
  ShiftTab        = #143;

  ShiftDownArrow  = #50;                         { '2' }
  ShiftLeftArrow  = #52;                         { '4' }
  ShiftRightArrow = #54;                         { '6' }
  ShiftUpArrow    = #56;                         { '8' }

{ Alt-characters 144-178. }
  AltA = #158;
  AltB = #176;
  AltC = #174;
  AltD = #160;
  AltE = #146;
  AltF = #161;
  AltG = #162;
  AltH = #163;
  AltI = #151;
  AltJ = #164;
  AltK = #165;
  AltL = #166;
  AltM = #178;
  AltN = #177;
  AltO = #152;
  AltP = #153;
  AltQ = #144;
  AltR = #147;
  AltS = #159;
  AltT = #148;
  AltU = #150;
  AltV = #175;
  AltW = #145;
  AltX = #173;
  AltY = #149;
  AltZ = #172;
{
  Here are the same declarations in numerical order.
  Notice that you get the ordering of keys as they
  appear on the keyboard.  This is because the function
  is generating the values by adding 128 to the scancode
  of the character.

  AltQ = #144;
  AltW = #145;
  AltE = #146;
  AltR = #147;
  AltT = #148;
  AltY = #149;
  AltU = #150;
  AltI = #151;
  AltO = #152;
  AltP = #153;
  AltA = #158;
  AltS = #159;
  AltD = #160;
  AltF = #161;
  AltG = #162;
  AltH = #163;
  AltJ = #164;
  AltK = #165;
  AltL = #166;
  AltZ = #172;
  AltX = #173;
  AltC = #174;
  AltV = #175;
  AltB = #176;
  AltN = #177;
  AltM = #178;
}

{ Normal function keys }
  F1         = #187;
  F2         = #188;
  F3         = #189;
  F4         = #190;
  F5         = #191;
  F6         = #192;
  F7         = #193;
  F8         = #194;
  F9         = #195;
  F10        = #196;

  HomeKey    = #199;
  UpArrow    = #200;
  PgUp       = #201;
  LeftArrow  = #203;
  RightArrow = #205;
  EndKey     = #207;
  DownArrow  = #208;
  PgDn       = #209;
  InsertKey  = #210;
  DeleteKey  = #211;

{ Shifted function keys }
  ShiftF1    = #212;
  ShiftF2    = #213;
  ShiftF3    = #214;
  ShiftF4    = #215;
  ShiftF5    = #216;
  ShiftF6    = #217;
  ShiftF7    = #218;
  ShiftF8    = #219;
  ShiftF9    = #220;
  ShiftF10   = #221;

{ Control function keys }
  CtrlF1     = #222;
  CtrlF2     = #223;
  CtrlF3     = #224;
  CtrlF4     = #225;
  CtrlF5     = #226;
  CtrlF6     = #227;
  CtrlF7     = #228;
  CtrlF8     = #229;
  CtrlF9     = #230;
  CtrlF10    = #231;

{ Alt function keys }
  AltF1      = #232;
  AltF2      = #233;
  AltF3      = #234;
  AltF4      = #235;
  AltF5      = #236;
  AltF6      = #237;
  AltF7      = #238;
  AltF8      = #239;
  AltF9      = #240;
  AltF10     = #241;

{ Control keypad keys }
  CtrlLeftArrow   = #243;
  CtrlRightArrow  = #244;
  CtrlEndKey      = #245;
  CtrlPageDown    = #246;
  CtrlHomeKey     = #247;
  CtrlPageUp      = #248;        { Scancode-shift sees CtrlPageUp as ^D }
                                 { ReadChar translates it to #248 }

{ Control shift keypad keys }
  CtrlShiftLeftArrow   = #249;
  CtrlShiftRightArrow  = #250;
  CtrlShiftEndKey      = #251;
  CtrlShiftPageDown    = #252;
  CtrlShiftHomeKey     = #253;
  CtrlShiftPageUp      = #254;

{ KeyCode declarations ---------------------------------------------------- }

CONST
  KcEnter   = $1C0D;
  KcEsc     = $011B;

{ KeyCode values of alphabet keys }
{ add as needed }
  KcUpD     = $2044;
  KcUpN     = $314E;
  KcUpR     = $1352;
  KcUpS     = $1F53;
  KcUpU     = $1655;

  KcLoD     = $2064;
  KcLoN     = $316E;
  KcLoR     = $1372;
  KcLoS     = $1F73;
  KcLoU     = $1675;

  KcCtrlD   = $2004;
  KcCtrlN   = $310E;
  KcCtrlR   = $1312;
  KcCtrlS   = $1F13;
  KcCtrlU   = $1615;

{ KeyCode values of Number pad }
  KcNumPadDot = $532E;
  KcNumPad0 = $5230;
  KcNumPad1 = $4F31;
  KcNumPad2 = $5032;
  KcNumPad3 = $5133;
  KcNumPad4 = $4B34;
  KcNumPad5 = $4C35;
  KcNumPad6 = $4D36;
  KcNumPad7 = $4737;
  KcNumPad8 = $4838;
  KcNumPad9 = $4939;

  KcNumPadMinus = $4A2D;
  KcNumPadPlus  = $4E2B;

{ KeyCode values of function keys }
  KcF1         = $3B00;
  KcF2         = $3C00;
  KcF3         = $3D00;
  KcF4         = $3E00;
  KcF5         = $3F00;
  KcF6         = $4000;
  KcF7         = $4100;
  KcF8         = $4200;
  KcF9         = $4300;
  KcF10        = $4400;

{ KeyCode values of cursor keys }
  KcHomeKey    = $4700;
  KcUpArrow    = $4800;
  KcPgUp       = $4900;
  KcLeftArrow  = $4B00;
  KcRightArrow = $4D00;
  KcEndKey     = $4F00;
  KcDownArrow  = $5000;
  KcPgDn       = $5100;
  KcInsertKey  = $5200;
  KcDeleteKey  = $5300;

  KcCtrlHomeKey    = $7700;
  KcCtrlPgUp       = $8400;
  KcCtrlLeftArrow  = $7300;
  KcCtrlRightArrow = $7400;
  KcCtrlEndKey     = $7500;
  KcCtrlPgDn       = $7600;

{ KeyCode values of Alt chars }
  KcAltA = $1E00;
  KcAltB = $3000;
  KcAltC = $2E00;
  KcAltD = $2000;
  KcAltE = $1200;
  KcAltF = $2100;
  KcAltG = $2200;
  KcAltH = $2300;
  KcAltI = $1700;
  KcAltJ = $2400;
  KcAltK = $2500;
  KcAltL = $2600;
  KcAltM = $3200;
  KcAltN = $3100;
  KcAltO = $1800;
  KcAltP = $1900;
  KcAltQ = $1000;
  KcAltR = $1300;
  KcAltS = $1F00;
  KcAltT = $1400;
  KcAltU = $1600;
  KcAltV = $2F00;
  KcAltW = $1100;
  KcAltX = $2D00;
  KcAltY = $1500;
  KcAltZ = $2C00;

{ Procedure declarations -------------------------------------------------- }

PROCEDURE Zen;
{ Empty procedure to pass to procedure variables. }

FUNCTION ShiftKeyOn : boolean;
{ returns true if either shift key is pressed }

FUNCTION AltKeyReleased : boolean;
{ returns true if alt-key is not pressed }

{ ========================================================================= }
{ Implementation ========================================================== }

IMPLEMENTATION

{ ========================================================================= }
{ Zen ===================================================================== }

{$F+} PROCEDURE Zen; {$F-}
{ Empty procedure to pass to procedure variables. }
BEGIN
{ ... do nothing ... }
END;

{ ShiftKeyOn ============================================================== }

FUNCTION ShiftKeyOn : boolean;
{ returns true if either shift key is pressed }
BEGIN
  ShiftKeyOn := KeyStateByte and ShiftKey > 0;
END;

{ AltKeyReleased ========================================================== }

FUNCTION AltKeyReleased : boolean;
{ returns true if alt-key is not pressed }
BEGIN
  AltKeyReleased := KeyStateByte and AltKey <> AltKey;
END;

{ ========================================================================= }
{ Initialization ========================================================== }

{ No initialization needed. }
END.

{ ========================================================================= }
{ ========================================================================= }

NOTES:


{ ========================================================================= }
{ ========================================================================= }
