{
 
                                                                          
         TITLE :      DGMATH.TPU                                          
       PURPOSE :      Number crunching routines.                          
        AUTHOR :      David Gerrold, CompuServe ID:  70307,544            
  ______________________________________________________________________  
                                                                          
    Written in Turbo Pascal, Version 5.5,                                 
    with routines from TurboPower, Object Professional.                   
                                                                          
    Turbo Pascal is a product of Borland International.                   
    Object Professional is a product of TurboPower Software.              
  ______________________________________________________________________  
                                                                          
    This is not public domain software.                                   
    This software is copyright 1990, by David Gerrold.                    
    Permission is hereby granted for personal use.                        
                                                                          
         The Brass Cannon Corporation                                     
         9420 Reseda Blvd., #804                                          
         Northridge, CA  91324-2932.                                      
                                                                          
 
                                                                            }
{ Compiler Directives ===================================================== }

{$A-}    {Switch word alignment off, necessary for cloning}
{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$I-}    {I/O checking off}
{$N+,E+} {Simulate numeric coprocessor}
{$M 16384,0,327680} {stack and heap}
{$V-}    {Variable range checking off}

{ Name ==================================================================== }

UNIT DgMath;
{
  The purpose of DgMath is to provide useful number-crunching routines.
}

{ Interface =============================================================== }

INTERFACE

{ Functions and Procedures ================================================ }

PROCEDURE UpCycle (VAR Num : integer;  Bottom, Top : word);
{ Increases Num through cycle, bounded by Bottom and Top. }

PROCEDURE DownCycle (VAR Num : integer;  Bottom, Top : word);
{ Decreases Num through cycle, bounded by Bottom and Top. }

FUNCTION Max (Num1, Num2 : integer) : integer;
{ Returns greater value. }

FUNCTION Min (Num1, Num2 : integer) : integer;
{ Returns lesser value. }

FUNCTION MaxReal (Num1, Num2 : real) : real;
{ Returns greater value. }

FUNCTION MinReal (Num1, Num2 : real) : real;
{ Returns lesser value. }

FUNCTION Dec2Hex (Num : word) : string;
{ Returns decimal value as hex string }

FUNCTION Hex2Dec (S : string) : longint;
{ returns hexadecimal string as decimal value }

{ ========================================================================= }
{ Implementation ========================================================== }

IMPLEMENTATION

CONST
  HexString : array [0..15] of char = '0123456789ABCDEF';

{ ========================================================================= }
{ UpCycle ================================================================= }

PROCEDURE UpCycle (VAR Num : integer;  Bottom, Top : word);
{ Increases Num through cycle, bounded by Bottom and Top. }

BEGIN
  inc (Num);
  if Num > Top then Num := Bottom;
END;

{ DownCycle =============================================================== }

PROCEDURE DownCycle (VAR Num : integer;  Bottom, Top : word);
{ Decreases Num through cycle, bounded by Bottom and Top. }

BEGIN
  dec (Num);
  if Num < Bottom then Num := Top;
END;

{ Max ===================================================================== }

FUNCTION Max (Num1, Num2 : integer) : integer;
BEGIN
  if Num1 > Num2 Then Max := Num1 Else Max := Num2;
END;

{ Min ===================================================================== }

FUNCTION Min (Num1, Num2 : integer) : integer;
BEGIN
  if Num1 < Num2 Then Min := Num1 Else Min := Num2;
END;

{ MaxReal ================================================================= }

FUNCTION MaxReal (Num1, Num2 : real) : real;
BEGIN
  if Num1 > Num2 Then MaxReal := Num1 Else MaxReal := Num2;
END;

{ MinReal ================================================================= }

FUNCTION MinReal (Num1, Num2 : real) : real;
BEGIN
  if Num1 < Num2 Then MinReal := Num1 Else MinReal := Num2;
END;

{ Dec2Hex ================================================================= }

FUNCTION Dec2Hex (Num : word) : string;
{ Returns decimal value as hex string }
VAR
  Loop,
  Bits  : byte;
  S     : string [10];

BEGIN
  S := '';
  for Loop := 1 to 4 do begin
    S := HexString [Lo (Num) and $F] + S;
    Num := Num shr 4;
    end;
  Dec2Hex := '$' + S;
END;

{ Hex2Dec ================================================================= }

FUNCTION Hex2Dec (S : string) : longint;
{ returns hexadecimal string as decimal value }
VAR
  Len   : byte absolute S;
  Loop  : byte;
  Li    : longint;
  Num   : longint;

BEGIN
  if S [1] = '$' then delete (S, 1, 1);
  if upcase (S [Len]) = 'H' then dec (S [0]);
  Num := 0;
  for Loop := 1 to Len do begin                            { get end letter }
    Li := 0;
    while
      (HexString [Li] <> S [Loop])                         { compare letter }
        and
      (Li < 16)
    do
      inc (Li);                                            { inc counter }
    if Li = 16 then begin
      Num := -1;                                           { if invalid }
      exit;
      end;
    Num := Num + Li shl ((Len - Loop) * 4);
    end;
  Hex2Dec := Num;                                          { return }
END;

{ Initialization ========================================================== }

{ no initialization needed }
END.

{ ========================================================================= }
{ DgMath History ========================================================== }

VERSION HISTORY:
  9005.05
    Totally restructured for consistency with Object Professional.

{ DgMath Needs ============================================================ }

NEED TO ADD:
  Nothing right now.

{ Bug Reports ============================================================= }

BUGS:
  Don't be silly.

{ ========================================================================= }
