
#include <stdio.h>

#include "luthor.h"

#include "basicdef.h"
#include "basictab.h"
#include "incldef.h"
#include "incltab.h"

int main(int argc,char **argv)
{
	int mainlextable,incllextable;
	int lexstream,t;
	int old;
	LEXINFO *it;

	if(argv[1]==NULL){
    	fprintf(stderr,"No input file name supplied\n");
        exit(1);
	}
    
    LexInit(0);		/* initialize the lex processor */

    mainlextable=LexSetObject(&BASICObject);
    incllextable=LexSetObject(&INCLObject);
	
    lexstream=LexInputFile(mainlextable,argv[1]);
    if(lexstream==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
    
    while(1){
    	t=ThisToken(lexstream);
    	if(!t){
        	printf("token error!\n");
            exit(1);
		}
        if(t==EOF){
        	record("token=EOF\n");
			if(LexLineInfo(lexstream)->CurFileDepth <= 1){
        		break;
			} else {
        		AdvanceToken(lexstream);
        	    continue;
			}
		}
        it=LexLineInfo(lexstream);
    	printf("\nFilename=%s\n",it->CurFileName);
        printf("LineNbr=%ld\n",it->CurLineNumber);
        printf("LineText=%s\n",it->CurLineText);
        printf("TokenPos=%d\n",it->CurTokenPos);
        printf("FileDepth=%d\n",it->CurFileDepth);
        printf("LexStreamType=%d\n",it->LexStreamType);
    	record("\nFilename=%s\n",it->CurFileName);
        record("LineNbr=%ld\n",it->CurLineNumber);
        record("LineText=%s\n",it->CurLineText);
        record("TokenPos=%d\n",it->CurTokenPos);
        record("FileDepth=%d\n",it->CurFileDepth);
        record("LexStreamType=%d\n",it->LexStreamType);
        record("Token=%d",t);
    	if(t==TK_EOL){
        	record("->\\n\n");
        	printf("->\\n\n");
		} else {
        	record("->%s\n",ThisTokenText(lexstream));
        	printf("->%s\n",ThisTokenText(lexstream));
		}
        if(t==TK_INCLUDE){
        	/*
            ** need to parse the include file defs
            */
            if(!(old=LexChangeTable(lexstream,incllextable))){
            	printf("LexChangeTable error!\n");
                exit(1);
			}
            while(AdvanceToken(lexstream)==IN_WHITESPACE);
            if(ThisToken(lexstream) != IN_FILENAME){
            	printf("Unexpected token\n");
                exit(1);
			}
            LexPushFile(lexstream,ThisTokenText(lexstream));
            AdvanceToken(lexstream);
            LexChangeTable(lexstream,old);
            continue;
		}
        if(!AdvanceToken(lexstream)){
        	printf("token error!\n");
            exit(1);
		}
	}
    printf("EOF\n");
    exit(0);
}

