//******************************************************************************
// ERROR HANDLER: MAIN                                                        **
//                                                                            **
// Copyright 1997 Adept Software, All Rights Reserved                         **
// The information in this file may be used freely, if due credit is given    **
//******************************************************************************

#ifndef ERR_MAIN_H
	#define ERR_MAIN_H

	#include "Adept.H"

//**************************************
// GLOBAL CONSTANTS

	#define ERR_MAX			8

	enum ERR_ERROR_VALUES
	{
		ERR_NONE,
		ERR_QUIET,
		ERR_FATAL,
		ERR_UNKNOWN,
		ERR_MISC,
		ERR_BLOCK,
		ERR_MEMMISC,ERR_BADDATA,ERR_CANTALLOC,
			ERR_MEMALLOCZERO,ERR_MEMREALLOCNULL,ERR_MEMFREENULL,
		ERR_RESMISC,ERR_RESBADDATA,ERR_RESFIND,
		ERR_FILEMISC,ERR_FILEFIND,ERR_FILEOPEN,ERR_FILECLOSE,
			ERR_FILEREAD,ERR_FILEWRITE,ERR_FILEBADDATA,
		ERR_TIMERMISC,
		ERR_MATHMISC,
		ERR_VIDEOMISC,
		ERR_SOUNDMISC,
	};

	#define errbreak				break
	#define ERR_RESET()				(ERR_Count=ERR_Base,ERR_SubCode=0)
	#define ERR_CHECK()				(ERR_Count>ERR_Base)
	#define ERR_CHECKBREAK(Func)	if(ERR_CHECK()) {Func;errbreak;}
	#define ERR_CHECKABORT(Func)	if(ERR_CHECK()) {Func;ERR_Abort();}

	#define ERR_START				{flag ERR_Success=FALSE;byte ERR_OldBase=ERR_Base;ERR_Base=ERR_Count;do{
	#define ERR_END					ERR_Success=!ERR_CHECK();}while(FALSE);if(!ERR_Success && !ERR_CHECK()) ERR_Report(ERR_BLOCK,"File: \"%s\" Line: %i",__FILE__,__LINE__);ERR_Base=ERR_OldBase;}
	#define ERR_ENDIGNORE			}while(FALSE);ERR_RESET();ERR_Base=ERR_OldBase;}
	#define ERR_ENDREPLACE(Report)	ERR_Success=!ERR_CHECK();}while(FALSE);if(!ERR_Success) {ERR_Count=ERR_Base;Report;};ERR_Base=ERR_OldBase;}

	#define ERR_REPLACE(Report)		if(ERR_CHECK()) {ERR_Count=ERR_Base;Report;}
	#define ERR_WATCHBREAK(ValOK,Func)	{if((ERR_SubCode=Func)!=(ValOK)) errbreak;}
// use GetLastError & FormatMessage in windows?

	#ifdef  ERR_DEBUG
		#define ERR_KILL()			if(ERR_CHECK()) {ERR_Report(ERR_FATAL,"ERR_KILL() File: \"%s\" Line: %i",__FILE__,__LINE__);ERR_Abort();}
		#define ERR_Pal(R,G,B) 		{dword CliPrev=_cli();outp(0x3C8,0);outp(0x3C9,R);outp(0x3C9,G);outp(0x3C9,B);_cliprev(CliPrev);}
		#define ERR_Overscan(Color)	{dword CliPrev=_cli();inp(0x3DA);outp(0x3C0,17);outp(0x3C0,Color);outp(0x3C0,0x20);_cliprev(CliPrev);}
	#else
		#define ERR_KILL()
		#define ERR_Pal(R,G,B)
		#define ERR_Overscan(Color)
	#endif

//**************************************
// GLOBAL VARIABLES

	#undef GLOBAL
	#ifdef ERR_MAIN_C
		#define GLOBAL
		GLOBAL	byte	ERR_Count=0,ERR_Base=0;
	#else
		#define GLOBAL	extern
		GLOBAL	byte	ERR_Count,ERR_Base;
	#endif

	GLOBAL	dword	ERR_SubCode;
	GLOBAL	dword	ERR_Codes[ERR_MAX],ERR_SubCodes[ERR_MAX];
	GLOBAL	byte	ERR_Strings[ERR_MAX][121];

	#ifdef  ERR_DEBUG
	GLOBAL	sdword		ERR_X,ERR_Y,ERR_Z,
						ERR_1,ERR_2,ERR_3,ERR_4;
	#endif

//**************************************
// GLOBAL ROUTINES

	flag	ERR_Startup			(void);
	void	ERR_Shutdown		(void);

	byte	*ERR_DefaultString	(dword Code);
	void	ERR_Report			(dword Code,byte *String,...);
	void	ERR_Display			(flag All);
	void	ERR_Abort			(void);

	#ifdef  ERR_DEBUG
		void	ERR_LogWrite		(byte *String,...);
		void	ERR_LogWriteRaw		(byte *Buffer,dword Size);
	#else
		#define ERR_LogWrite()
		#define ERR_LogWriteRaw()
	#endif

#endif
/*
--------------------------------------------------------------------------------
Global Error Handler: Main  Copyright 1997 Adept Software, All Rights Reserved
--------------------------------------------------------------------------------

DESCRIPTION
-----------

The error handler should be used in EVERY file that may create an error
condition.  This library is extremely helpful for program stability,
debugging, and beta testing.

ADVANTAGES TO THE ERROR HANDLER LIBRARY:

* Programs have a consistent and useful error handling interface.
* You don't have to use the return value of routines to report error
  conditions.
* Error reporting is handled automatically
* Includes built-in file logging, and other debugging tools.

NOTES
-----

Always manually report fatal errors caused by routines that do not
	report errors (routines not from the Adept Library).
Report will abort the program if the code is FATAL, but you should still
	always assume that it returns (in Windows, aborting doesn't immediately
	stop program execution.

Define "ERR_DEBUG" to compile with full debugging on, including the log.

CONSTANTS
---------

	"errbreak"
	Break out of an error block (setting an error condition).
	This command uses the C command "break", so if this is used in a loop or
	switch, it will only break out of that block.  Place a CHECKBREAK() at the
	end of such a block.

	"RESET()"
	Reset current error condition.  If inside a "START".."END" block, only
	resets errors that occurred inside that block.

	"CHECK()"
	Check for an error condition.

	"CHECKBREAK(Func)"
	If an error condtion exists: execute Func, then errbreak.

	"CHECKABORT(Func)"
	If an error condtion exists: execute Func, then Abort().

	"START"
	Start an error-checking block.  Previous errors are IGNORED within a
	block.

	"END"
	End the error-checking block.  If any errors occured or "errbreak" was
	executed, an error condition exists.  

	"ENDIGNORE"
	End the error-checking block, ignoring any errors that occured in the
	block.

	"ENDREPLACE(Report)"
	End the error-checking block.  Use in conjuction with ERR_Report() to
	replace any current error messages with a new one.

	"REPLACE(Report)"
	Use in conjuction with ERR_Report() to replace any current error messages
	with a new one.

	"WATCHBREAK(ValOK,Func)"
	Execute Func, and errbreak if the return value doesn't match ValOK.
	If there is an error, the return value will be used as the SubCode
	for the next error reported.

DEBUGGING TOOLS
---------------

	"Kill()"
	Report the file and line of the Kill statement, then call Abort().

	"Pal()"
	Change color 0 of the palette.

	"Overscan()"
	Change the overscan color (screen border).

	"X","Y".."1","2"..
	Variables that may be used globally for debugging.

ROUTINES
--------

	"Startup()"
	Initializes the library.  MUST be called before reporting errors,
	and before using most other routines in the Adept library.

	"Shutdown()"
	Shut down the library.  Must be called before the program terminates.
	Displays any errors.

	"DefaultString()"
	Return the default error string for an error type.

	"Report()"
	Report an error, setting an error condition.

	"Display()"
	Display all errors, or the last error reported.
	DOS - uses text, ensure that the video is in text mode.
	WINDOWS - uses a message box, ensure that video is in an acceptable state.

	"Abort()"
	Abort the program asap.
	DOS - uses exit() to abort after all atexit() routines.
	WINDOWS - sends a WM_CLOSE message to the application.

	"LogWrite()"
	Write a string to the debugging log file.

	"LogWriteRaw()"
	Write raw data to the debugging log file.

--------------------------------------------------------------------------------
*/
