//******************************************************************************
// PLC: DATA TYPES                                                            **
//                                                                            **
// Copyright 1997 Adept Software, All Rights Reserved                         **
//******************************************************************************

#ifndef PLC_DT_H
	#define PLC_DT_H

	#include "Adept.H"

//**************************************
// GLOBAL CONSTANTS

	#define PLC_DT_DEFAULTRADIX	10

	// DATATYPE
	#define PLC_DT_STRMAX		80
	typedef struct
	{
		LNK_LINK	Link;
		enum
		{
			PLC_DT_NONE,
			PLC_DT_INT,
			PLC_DT_FLOAT,
			PLC_DT_STRING,
		} Type;
		// FUTURE (distant): store actual values elsewhere
		byte		Extra[PLC_DT_STRMAX+1];
			#define PLC_DT__String(Value)	((byte*)((Value)->Extra))
	} PLC_DATATYPE;

//**************************************
// GLOBAL	ROUTINE PROTOTYPES

	void	PLC_DT_Assign		(PLC_DATATYPE *Dest,PLC_DATATYPE *Source);
	sbyte	PLC_DT_Compare		(PLC_DATATYPE *Value1,PLC_DATATYPE *Value2);
	flag	PLC_DT_GetBool		(PLC_DATATYPE *Value);
	flag	PLC_DT_SetBool		(PLC_DATATYPE *Value,flag Data);
	sdword	PLC_DT_GetInt		(PLC_DATATYPE *Value);
	sdword	PLC_DT_SetInt		(PLC_DATATYPE *Value,sdword Data);
	float	PLC_DT_GetFloat		(PLC_DATATYPE *Value);
	float	PLC_DT_SetFloat		(PLC_DATATYPE *Value,float Data);
	byte	*PLC_DT_GetString	(PLC_DATATYPE *Value);
	byte	*PLC_DT_SetString	(PLC_DATATYPE *Value,byte *Data);

#endif
