//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCHECK.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Check-boxes & radio-buttons          |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_string
#define uses_check
#define uses_dc
#define uses_dialog
#define uses_icons
#define uses_system

#include "PVuses.h"

static int *old_data = NULL;
static short *old_short_data = NULL;

//Tcluster publics:

Tcluster::Tcluster( char *_prompt ):
  Titem( i_cluster_len + 1 + smart_len( _prompt ), 1 )
{
  prompt = STRDUP( _prompt );
  shortcut = get_shortcut( _prompt );
}

Tcluster::~Tcluster( void )
{
  FREE( prompt );
}

void Tcluster::set_prompt( char *_prompt )
{
  FREE( prompt );
  prompt = STRDUP( _prompt );
  redraw();
}

//Tcluster protected

void Tcluster::event_handler( Tevent &ev )
{
  if(
      (
        ( ev.code != evKEY_PRESS ) || ( ev.ASCII != shortcut )
      ) &&
      (
        !state( isFOCUSED ) ||
          (
            ( ( ev.code != evKEY_PRESS ) || ( ev.ASCII != kSPACE ) )
#ifndef NOMOUSE
         && ( ( ev.code != evMOUSE_UP ) || !ev.INSIDE )
#endif
          )
      )
    )
    Titem::event_handler( ev );
  else
  {
    focus();
    if( state(isFOCUSED) ) press();
    redraw();
    handled( ev );
  }
}

void Tcluster::draw_cluster( char *box )
{
  char s;

  s = 't';
  if( state( isDISABLED ) )
  {
    s = 'd';
    shortcut_attr = disabled_attr;
  }
  else
    if( state( isSELECTED ) ) s = 'b';
  txtf( "|%c%s %s", s, box, prompt );
}

//Tcheck publics:

Tcheck::Tcheck( char *_prompt, boolean &_data ):
  Tcluster( _prompt )
{
  data_ptr = &_data;
  data = _data;
}

//Tcheck protected:

void Tcheck::draw( void )
{
  if( data ) draw_cluster( i_check_on ); else draw_cluster( i_check_off );
}

void Tcheck::press( void )
{
  data = !data;
  item_acted = this;
}

void Tcheck::press( boolean state )
{
  data = state;
  item_acted = this;
}

boolean Tcheck::pressed( void )
{
  return data != 0;
}

void Tcheck::ok_item( void )
{
  *data_ptr = data;
}

//Tcheckb publics:

Tcheckb::Tcheckb( char *_prompt, uint &_data, uint _bit ):
  Tcheck( _prompt, tmp_data )
{
  _data_ptr = &_data;
  bit = _bit;
  tmp_data =  ( ( _data & _bit ) != 0 );
  data_ptr = &tmp_data;
  data = tmp_data;
}

//Tcheckb protected:

void Tcheckb::ok_item( void )
{
  Tcheck::ok_item();
  if( tmp_data )
    *_data_ptr |= bit;
  else
    *_data_ptr &= ~bit;
}

//Tcheckw publics:

Tcheckw::Tcheckw( char *_prompt, word &_data, uint _bit ):
  Tcheck( _prompt, tmp_data )
{
  _data_ptr = &_data;
  bit = _bit;
  tmp_data =  ( ( _data & _bit ) != 0 );
  data_ptr = &tmp_data;
  data = tmp_data;
}

//Tcheckb protected:

void Tcheckw::ok_item( void )
{
  Tcheck::ok_item();
  if( tmp_data )
    *_data_ptr |= bit;
  else
    *_data_ptr &= ~bit;
}

//Tradio publics:

Tradio::Tradio( char *_prompt, int &_data, int _value ):
  Tcluster( _prompt )
{
  data_ptr = &_data; value = _value;
  data = _data;
  if( data_ptr == old_data )
    set_flags( ifTAB_STOP, 0 );
  else
    old_data = data_ptr;
}

void Tradio::press( void )
{
  _command_info( data_ptr, 0 ); broadcast( cmRADIO_DEPRESS );
  data = value;
  item_acted = this;
}

#pragma off( unreferenced )
void Tradio::press( boolean state )
{
  press();
}
#pragma on( unreferenced )

boolean Tradio::pressed( void )
{
  return data == value;
}

//Tradio protected:

void Tradio::draw( void )
{
  if( data == value ) draw_cluster( i_radio_on ); else draw_cluster( i_radio_off );
}

void Tradio::event_handler( Tevent &ev )
{
  if( ( ev.code != evCOMMAND ) || ( ev.CMD_CODE != cmRADIO_DEPRESS ) ||
     ( ev.CMD_INFO != data_ptr ) || ( value != data ) )
    Tcluster::event_handler( ev );
  else
  {
    data = 0;
    redraw();
    handled( ev );
  }
  old_data = NULL;
}

void Tradio::ok_item( void )
{
  if( data == value ) *data_ptr = data;
}

//Tshort_radio publics:

Tshort_radio::Tshort_radio( char *_prompt, short &_data, short _value ):
  Tcluster( _prompt )
{
  data_ptr = &_data; value = _value;
  data = _data;
  if( data_ptr == old_short_data )
    set_flags( ifTAB_STOP, 0 );
  else
    old_short_data = data_ptr;
}

void Tshort_radio::press( void )
{
  _command_info( data_ptr, 0 ); broadcast( cmRADIO_DEPRESS );
  data = value;
  item_acted = this;
}

#pragma off( unreferenced )
void Tshort_radio::press( boolean state )
{
  press();
}
#pragma on( unreferenced )

boolean Tshort_radio::pressed( void )
{
  return data == value;
}

//Tradio protected:

void Tshort_radio::draw( void )
{
  if( data == value ) draw_cluster( i_radio_on ); else draw_cluster( i_radio_off );
}

void Tshort_radio::event_handler( Tevent &ev )
{
  if( ( ev.code != evCOMMAND ) || ( ev.CMD_CODE != cmRADIO_DEPRESS ) ||
     ( ev.CMD_INFO != data_ptr ) || ( value != data ) )
    Tcluster::event_handler( ev );
  else
  {
    data = 0;
    redraw();
    handled( ev );
  }
  old_short_data = NULL;
}

void Tshort_radio::ok_item( void )
{
  if( data == value ) *data_ptr = data;
}

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

/*
  Description:
    Construct a check item and insert it in the dialog box.
  Entry:
    t    - title of the check item, shortcut prefix '|~';
    data - boolean that holds current check state.
  Exit:
    Return pointer to the check item.
*/
Tcheck *check( char *t, boolean &data )
{
  Tcheck *c;

  c = NEW( Tcheck( t, data ) );
  put_item( c, c->xl + 1, 1 );
  return c;
}

/*
  Description:
    Construct a bit-check item and insert it in the dialog box.
  Entry:
    t    - title of the bit-check item, shortcut prefix '|~';
    data - uint that holds current check state bits.
    bit  - bitmask for the bits to be affected.
  Exit:
    Return pointer to the check item.
*/
Tcheckb *check( char *t, uint &data, uint bit )
{
  Tcheckb *c;

  c = NEW( Tcheckb( t, data, bit ) );
  put_item( c, c->xl + 1, 1 );
  return c;
}

/*
  Description:
    Construct a bit-check word item and insert it in the dialog box.
  Entry:
    t    - title of the bit-check item, shortcut prefix '|~';
    data - word that holds current check state bits.
    bit  - bitmask for the bits to be affected.
  Exit:
    Return pointer to the check item.
*/
Tcheckw *check( char *t, word &data, uint bit )
{
  Tcheckw *c;

  c = NEW( Tcheckw( t, data, bit ) );
  put_item( c, c->xl + 1, 1 );
  return c;
}

/*
  Description:
    Construct a radio button and insert it in the dialog box.
  Entry:
    t     - title of the radio button, shortcut prefix '|~';
    data  - address of the integer that holds current radio buttons state;
    value - the value responding to this radio button. All radio buttons
            attached to one 'data' must have different values.
  Exit:
    Return pointer to the radio button.
*/
Tradio *radio( char *t, int &data, int value )
{
  Tradio *r;

  r = NEW( Tradio( t, data, value ) );
  put_item( r, r->xl + 1, 1 );
  return r;
}

/*
  Description:
    Construct a radio button and insert it in the dialog box.
  Entry:
    t     - title of the radio button, shortcut prefix '|~';
    data  - address of the short that holds current radio buttons state;
    value - the value responding to this radio button. All radio buttons
            attached to one 'data' must have different values.
  Exit:
    Return pointer to the radio button.
*/
Tshort_radio *radio( char *t, short &data, int value )
{
  Tshort_radio *r;

  r = NEW( Tshort_radio( t, data, value ) );
  put_item( r, r->xl + 1, 1 );
  return r;
}
