//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCMD.CPP                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Commands manager                     |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_app

#include "PVuses.h"

static Tcommands default_commands;
static Tcommands *commands = &default_commands;

//Tcommands

Tset Tcommands::global;

Tcommands::Tcommands( void )
{
  !global;
  local = NULL;
}

Tcommands::Tcommands( Tset &_local )
{
  local = &_local;
  if( local == NULL ) return;
  ~*local;
  *local << 0;
}

void Tcommands::operator ~ ( void )
{
  if( local != NULL )
  {
    ~*local;
    *local << 0;
  }
  if( this == commands ) commands_changed();
}

void Tcommands::operator ! ( void )
{
  if( local != NULL ) !*local;
  if( this == commands ) commands_changed();
}

Tcommands& operator << ( Tcommands &set, uint member )
{
  if( member > 255 )
    set.global << ( member & 0x00FF );
  else
    if( set.local != NULL ) *set.local << member;
  if( commands == &set ) commands_changed();
  return set;
}

Tcommands& operator >> ( Tcommands &set, uint member )
{
  if( member > 255 )
    set.global >> ( member & 0x00FF );
  else
    if( set.local != NULL ) *set.local >> member;
  if( commands == &set ) commands_changed();
  return set;
}

Tcommands& operator << ( Tcommands &set, Tcommands &set1 )
{
  set.global << set1.global;
  if( ( set.local != NULL ) && ( set1.local != NULL ) ) *set.local << *set1.local;
  if( commands == &set ) commands_changed();
  return set;
}

Tcommands& operator >> ( Tcommands &set, Tcommands &set1 )
{
  set.global >> set1.global;
  if( ( set.local != NULL ) && ( set1.local != NULL ) ) *set.local >> *set1.local;
  if( commands == &set ) commands_changed();
  return set;
}

int operator & ( Tcommands &set, uint member )
{
  if( member > 255 )
    if( set.global & 0 )
      return set.global & ( member & 0x00FF );
    else
      return 0;
  if( ( set.local != NULL ) &&
      ( ( *set.local & 0 ) || ( member < cmUSER00 ) ) )
    return *set.local & member;
  return 0;
}

boolean cenabled( uint cmd )
{
  return ( *commands & cmd ) != 0;
}

boolean cdisabled( uint cmd )
{
  return ( *commands & cmd ) == 0;
}

void cenable( uint cmd )
{
  if( *commands & cmd ) return;
  *commands << cmd;
}

void cdisable( uint cmd )
{
  if( !( *commands & cmd ) ) return;
  *commands >> cmd;
}

void cstate( uint cmd, boolean enable )
{
  if( enable ) cenable( cmd ); else cdisable( cmd );
}

void set_cmd( Tcommands *cmd )
{
  if( cmd != NULL )
    commands = cmd;
  else
    commands = &default_commands;
  commands_changed();
}

Tcommands *get_cmd( void )
{
  return commands;
}
