//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCMDGEN.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Command generators                   |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_ctype
#define uses_string
#define uses_app
#define uses_cmdgen
#define uses_colors
#define uses_config
#define uses_dc
#define uses_desk
#define uses_help
#define uses_ini
#define uses_system

#define DECLARE_PVCMDGEN
#include "PVuses.h"
#undef DECLARE_PVCMDGEN

#define SUSPEND_DELAY 10

#ifndef NOMAINMENU

class Tmain_menu: public Tmenu_bar
{
  public:
    Tmain_menu( void );

  protected:
    virtual void calc_bounds( int delta_xl, int delta_yl );
};

#endif

#ifndef NOLOCALMENU

class Tlocal_menu: public Tmenu_box
{
  public:
    Tlocal_menu( Tmenu *_menu );
    virtual void drag( int _x, int _y );
    virtual boolean valid( uint command );
    virtual uint exec( void );

#ifndef NOMOUSE
  protected:
    virtual boolean isit_4u( Tevent &ev );
    virtual void event_handler( Tevent &ev );
#endif
};

static Tlocal_menu *local_menu = NULL;

#endif

static int timer_handle = -1;

//INTERFACE

static inline boolean is_submenu( Tmenu_item *i )
{
  return ( i != NULL ) && ( i->kind == 1 );
}

static inline boolean is_valid( Tmenu_item *i )
{
  return ( i != NULL ) && ( i->name != NULL );
}

void dispose_menu( Tmenu *p )
{
  Tmenu_item *i, *t;

  if( p != NULL )
  {
    i = p->items;
    while( i != NULL )
    {
      if( is_submenu( i ) )
      {
        dispose_menu( i->what.submenu );
        i->what.submenu = NULL;
      }
      t = i;
      i = i->next;
      DELETE( t );
    }
    DELETE( p );
  }
}

Tmenu *current_menu = NULL;
Tmenu_item *current_item = NULL;

void update_menu( Tmenu *cm, Tmenu_item *ci )
{
  Tmenu_item *i, *t;

  current_menu = cm;
  current_item = ci;
  if( cm==NULL || ci==NULL ) return;
  i = ci->next;
  ci->next = NULL;
  while( i != NULL )
  {
    if( is_submenu( i ) )
    {
      dispose_menu( i->what.submenu );
      i->what.submenu = NULL;
    }
    t = i;
    i = i->next;
    DELETE( t );
  }
}

void menu( void )
{
  Tmenu *p;

  p = NEW( Tmenu );
  p->items=NULL;
  p->old_menu = current_menu;
  p->old_item = current_item;
  p->current = NULL;
  current_menu = p;
  if( current_item != NULL ) current_item->what.submenu = p;
  current_item = NULL;
}

Tmenu *endm( void )
{
  Tmenu *p;

  p = current_menu;
  current_item = current_menu->old_item;
  current_menu = current_menu->old_menu;
  return p;
}

Tmenu_bar *construct_main_menu( Tmenu *m )
{
  dispose_menu( main_menu->menu );
  main_menu->menu = m;
  return main_menu;
}

#ifndef NOLOCALMENU
Tmenu_box *construct_local_menu( Tmenu *m )
{
  if( local_menu != NULL ) DELETE( local_menu );
  local_menu = NEW( Tlocal_menu( m ) );
  return local_menu;
}
#endif

Tmenu_box *construct_menu_box( Tmenu *m )
{
  return NEW( Tmenu_box( m, NULL ) );
}

Tmenu_bar *construct_menu_bar( Tmenu *m, int _xl )
{
  return NEW( Tmenu_bar( m, _xl ) );
}

static Tmenu_item *new_item( void )
{
  Tmenu_item *p;

  p = NEW( Tmenu_item );
  if( current_item != NULL )
    current_item->next = p;
  else
    current_menu->items = p;
#ifndef NOHELP
  p->help_ctx = __help();
#endif
  p->next = NULL;
  current_item = p;
  return p;
}

Tmenu_item *mitem( char *name, uint command )
{
  Tmenu_item *p;

  p = mitem( name, "", command );
  p->kind = 0;
  return p;
}

Tmenu_item *mitem( char *name, char *param, uint command )
{
  Tmenu_item *p;

  p = new_item();
  if( *name == 0 ) p->name = NULL; else p->name = name;
  p->kind = 2;
  p->command = command;
  if( *param == 0 ) p->what.param = NULL; else p->what.param = param;
  return p;
}

Tmenu_item *mitem( char *name, uint &_check, uint command )
{
  Tmenu_item *p;

  p = mitem( name, "", command );
  p->kind = 3;
  p->what.check = &_check;
  return p;
}

Tmenu_item *mitem( void )
{
  Tmenu_item *p;

  p = new_item();
  p->name = NULL;
  p->command = 0;
  p->what.param = NULL;
  p->kind = 1;
  return p;
}

Tmenu_item *submenu( char *name )
{
  Tmenu_item *p;

  p = new_item();
  if( *name == 0 ) p->name = NULL; else p->name = name;
  p->kind = 1;
  p->command = 0;
  menu();
  return p;
}

void show_menu_cursor( Tmenu *p )
{
  if( p == NULL ) return;
  p->current = p->items;
  while( !is_valid( p->current ) && ( p->current != NULL ) )
    p->current = p->current->next;
}

void show_submenu_cursor( Tmenu_item *p )
{
  if( p == NULL ) return;
  if( is_submenu( p ) ) show_menu_cursor( p->what.submenu );
}

static Tmenu_item *get_menu_item_ptr( Tmenu *p, uint command )
{
  Tmenu_item *i;

  if( p != NULL )
  {
    i = p->items;
    while( i != NULL )
    {
      if( i->command == command ) return i;
      if( is_submenu( i ) )
      {
        p = (Tmenu *) get_menu_item_ptr( i->what.submenu, command );
        if( p != NULL ) return (Tmenu_item *) p;
      }
      i = i->next;
    }
  }
  return NULL;
}

//Tmenu_base publics:

Tmenu_base::Tmenu_base( int _xl, int _yl ):
  Titem( _xl, _yl )
{
  set_flags( mfSUSPEND_SELECTION, 1 );
  set_flags( ifSELECTABLE, 0 );
  set_state( isON_TOP, 1 );
  pulled_down = 0;
  shortcut = 0;
  client = NULL;
}

Tmenu_base::~Tmenu_base( void )
{
  if( ( menu != NULL ) && ( parent == NULL ) ) dispose_menu( menu );
}

uint Tmenu_base::exec( void )
{
  if( owner != NULL ) owner->focus();
  update_commands( menu );
  return Titem::exec();
}

//Tmenu_base protected:

void Tmenu_base::set_palette( void )
{
  selected_attr = pal_menus.selected;
  disabled_attr = pal_menus.disabled;
  bold_attr = pal_menus.frame;
  text_attr = pal_menus.normal;
  attr[0] = pal_menus.disabled_selected;
  shortcut_attr = pal_menus.shortcut;
}

void Tmenu_base::event_handler( Tevent &ev )
{
#ifndef NOHELP
  uint hctx;
  Tmenu_base *pm;
#endif
  Tmenu_item *p;

  if( menu != NULL )
  {
    switch( ev.code )
    {
      case evCOMMAND:
        switch( ev.CMD_CODE )
        {
          case cmMENU_CLOSE_SUBMENU:
            if( parent == ev.CMD_INFO )
            {
              handled( ev );
              close_menu();
            }
            break;
          case cmMENU_SELECTION:
            handled( ev );
            if( menu->current == NULL )
              cancelled();
            else
              if( is_submenu( menu->current ) )
                open_submenu();
              else
                selection_made();
            break;
          case cmMENU_SELECTION_MADE:
            if( ( menu->current != NULL ) && !is_submenu( menu->current ) )
            {
              if( !menu->current->enabled )
              {
                handled( ev );
                break;
              }
              put_command( client, menu->current->command );
            }
          case cmMENU_CANCELLED:
            if( state( isMODAL ) ) stop( ev.CMD_CODE );
            menu->current = NULL;
            close_menu();
            redraw();
            pulled_down = 0;
        }
        break;
#ifndef NOMOUSE
      case evMOUSE_DOWN:
        p = pointed_ptr( ev.LOCAL_X, ev.LOCAL_Y );
        cancel_request( timer_handle );
        close_submenu();
        menu->current = p;
        if( is_submenu( menu->current ) )
        {
          menu->current->what.submenu->current = NULL;
          make_selection();
        }
        if( ev.INSIDE )
        {
          redraw();
          handled( ev );
          if( ( parent == NULL ) && !state( isMODAL ) ) exec();
        }
        else
          if( state( isMODAL ) )
          {
            cancelled();
            put_event( ev );
          }
        break;
      case evMOUSE_REP:
      case evMOUSE_DRAG:
        if( ( parent == NULL ) && !state( isMODAL ) ) return;
        p = pointed_ptr( ev.LOCAL_X, ev.LOCAL_Y );
        if( p != menu->current )
        {
          if( ( p != NULL ) || !pulled_down || ev.INSIDE )
          {
            redraw();
            menu->current = p;
          }
          if( ev.INSIDE )
          {
            cancel_request( timer_handle );
            close_submenu();
            if( is_submenu( menu->current ) )
            {
              menu->current->what.submenu->current = NULL;
              if( flags( mfSUSPEND_SELECTION ) )
                suspend_selection();
              else
                make_selection();
            }
          }
        }
        if( ev.INSIDE ) handled( ev );
        break;
      case evMOUSE_UP:
        if( ( parent == NULL ) && !state( isMODAL ) ) return;
        if( ev.INSIDE )
        {
          if( pointed_ptr( ev.LOCAL_X, ev.LOCAL_Y ) == NULL )
          {
            show_menu_cursor( menu );
            redraw();
          }
          else
          {
            if( is_submenu( menu->current ) )
            {
              close_submenu();
              show_submenu_cursor( menu->current );
              cancel_request( timer_handle );
            }
            make_selection();
          }
          handled( ev );
        }
        else
          if( parent == NULL )
          {
            cancelled();
            handled( ev );
          }
        break;
#endif
      case evKEY_PRESS:
        if( !pulled_down )
        {
          if( ( parent != NULL ) || state( isMODAL ) || ( ev.ASCII > 255 ) )
          {
            if( ( ev.ASCII == shortcut ) && !state( isMODAL ) )
            {
              redraw();
              menu->current = menu->items;
              show_menu_cursor( menu );
              handled( ev );
              set_state( isHIDDEN, 0 );
              exec();
            }
            else
            {
              if( !state( isALIVE ) ) return;
              if( ev.ASCII == kESC )
              {
                handled( ev );
                if( parent == NULL )
                  cancelled();
                else
                  close_menu();
              }
              else
              {
                if( menu->current != NULL )
                {
                  switch( ev.ASCII )
                  {
#ifndef NOHELP
                    case kF1:
                      pm = this;
                      hctx = 0;
                      do
                      {
                        p = pm->menu->current;
                        if( p == NULL ) continue;
                        hctx = p->help_ctx;
                        pm = pm->parent;
                      }
                      while( ( pm != NULL ) && !hctx );
                      online_help( hctx );
                      break;
#endif
                    case kPG_UP:
                    case kHOME:
                      menu->current = menu->items;
                      show_menu_cursor( menu );
                      redraw();
                      break;
                    case kPG_DN:
                    case kEND:
                      menu->current = menu->items;
                      show_menu_cursor( menu );
                      previous_line();
                      break;
                    case kENTER:
                      make_selection();
                      show_submenu_cursor( menu->current );
                      break;
                    default:
                      goto hot;
                  }
                  handled( ev );
                }
                hot:
                if( ev.code != evNOTHING )
                {
                  p = shortcut_ptr( ev.ASCII );
                  if( p != NULL )
                  {
                    redraw();
                    menu->current = p;
                    show_submenu_cursor( p );
                    make_selection();
                    if( ( parent == NULL ) && !state( isMODAL ) ) exec();
                    handled( ev );
                  }
                }
              }
            }
          }
        }
    }
  }
  Titem::event_handler( ev );
}

void Tmenu_base::update_commands( Tmenu *m )
{
  Tmenu_item *i;

  if( m == NULL ) return;
  i = m->items;
  while( i != NULL )
  {
    i->enabled = cenabled( i->command );
    if( is_submenu( i ) )
      update_commands( i->what.submenu );
    i = i->next;
  }
}

Tmenu_item *Tmenu_base::next_line( void )
{
  Tmenu_item *p, *c;

  c = menu->current;
  if( c == NULL ) return NULL;
  do
  {
    p = menu->current;
    if( p->next == NULL )
      menu->current = menu->items;
    else
      menu->current = p->next;
  }
  while( !is_valid( menu->current ) && ( menu->current != c ) );
  if( !is_valid( menu->current ) ) menu->current = NULL;
  if( c != menu->current ) redraw();
  return menu->current;
}

Tmenu_item *Tmenu_base::previous_line( void )
{
  Tmenu_item *p, *p1, *p2;

  p = menu->current;
  if( p == NULL ) return NULL;
  p1 = p;
  do
  {
    p2 = menu->current;
  }
  while( next_line() != p1 );
  menu->current = p2;
  if( p != menu->current ) redraw();
  return p2;
}

Tmenu_item *Tmenu_base::shortcut_ptr( uint ascii )
{
  char *p, c1, c2;
  Tmenu_item *i;

  if( ( ( parent == NULL ) && !state( isMODAL ) && ( ascii <= 255 ) ) ||
      pulled_down ) return NULL;
  if( ascii>255 )
  {
#ifdef CYR
    ascii = alt2cyr( ascii );
#endif
    ascii = alt2lat( ascii );
  }
  if( ascii )
  {
    i = menu->items;
    while( i != NULL )
    {
      if( i->name != NULL )
      {
        p = i->name;
        do
        {
          if( ( p = strchr( p, '|' ) ) == NULL ) break;
        }
        while( *(++p) != '~' );
        if( ( p != NULL ) && is_valid( i ) )
        {
          c1 = toupper( *(++p) ); c2 = toupper( (char)ascii );
#ifdef CYR
          c1 = cyr_toupper( c1 ); c2 = cyr_toupper( c2 );
#endif
          if( c1 == c2 ) return i;
        }
      }
      i = i->next;
    }
  }
  return NULL;
}

void Tmenu_base::suspend_selection( void )
{
  Tevent ev;

  ev.code = evCOMMAND;
  ev.CMD_CODE = cmMENU_SELECTION;
  ev.priority = 0;
  ev.destination = this;
  event_request( timer_handle, ev, SUSPEND_DELAY );
}

void Tmenu_base::open_submenu( void )
{
  if( pulled_down ) return;
  pulled_down = 1;
  message( this, cmMENU_OPEN_SUBMENU );
}

void Tmenu_base::close_submenu( void )
{
  _command_info( this, 0 );
    modal_broadcast( cmMENU_CLOSE_SUBMENU );
  pulled_down = 0;
}

void Tmenu_base::close_menu( void )
{
  close_submenu();
  if( parent != NULL ) parent->pulled_down = 0;
  if( flags( ifCLOSEABLE ) ) message( this, cmDONE );
}


//Tmenu_box publics:

static int get_xl( Tmenu *menu )
{
  Tmenu_item *i;
  int xl, l;

  xl = 0;
  i = menu->items;
  while( i != NULL )
  {
    if( i->name != NULL )
    {
      l = smart_len( i->name ) + (char) ( ( i->kind == 1 ) << 1 );
      if( i->kind == 2 ) l += ( 2 + smart_len( i->what.param ) );
      if( l > xl ) xl = l;
    }
    i = i->next;
  }
  return xl + 4;
}

static int get_yl( Tmenu *menu )
{
  Tmenu_item *i;
  int yl;

  yl = 0;
  i = menu->items;
  while( i != NULL )
  {
    yl++;
    i = i->next;
  }
  return yl + 2;
}

Tmenu_box::Tmenu_box( Tmenu *_menu, Tmenu_base *_parent ):
  Tmenu_base( get_xl( _menu ), get_yl( _menu ) )
{
  menu = _menu;
  parent = _parent;
  if( parent != NULL ) client = parent->client;
}

void Tmenu_box::initialize( void )
{
  int xx, yy;

  if( owner != NULL )
  {
    owner->make_global( x, y, xx, yy );
    if( xx < 0 ) xx = 0;
    if( ( xx + xl ) > (int) scr_columns ) xx = scr_columns - xl;
    if( ( yy + yl ) > (int) scr_rows ) yy = scr_rows - yl;
    owner->make_local( xx, yy, xx, yy );
  }
  if( ( xx != x ) || ( yy != y ) ) drag( xx, yy );
}

//Tmenu_box protected:

void Tmenu_box::draw( void )
{
  char m[3] = " \020";
  Tmenu_item *i;
  char sa;
  char c, s, b;
  char *p;
  boolean f;

  if( menu == NULL ) return;
  sa = shortcut_attr;
  i = menu->items;
  c = char( xl-2 );
  txtf( "|b%c|r%c%c%c|n", frame_normal[0], c, frame_normal[1], frame_normal[2] );
  while( i != NULL )
  {
    shortcut_attr = sa;
    if( i->name != NULL )
    {
      f = ( i == menu->current );
      if( !i->command || i->enabled )
      {
        s = 't';
        if( f ) s = 's';
      }
      else
      {
        shortcut_attr = 0;
        s = 'd';
        if( f ) s = '0';
      }
      c = ' '; p = "";
      switch( i->kind )
      {
        case 1:
          p = m; break;
        case 2:
          p = i->what.param; break;
        case 3:
          if( *i->what.check == i->command ) c = '';
      }
      b = (char) ( xl - smart_len( i->name ) - smart_len( p ) - 4 );
      txtf( "|b%c|%c%c%s|r%c %s |b%c|n", frame_normal[3], s, c, i->name, b, p, frame_normal[5] );
    }
    else
    {
      c = (char) ( xl - 4 );
      txtf( "|b%c |r%c%c |b%c|n", frame_normal[3], c, frame_standard[1], frame_normal[5] );
    }
    i = i->next;
  }
  c = (char) ( xl - 2 );
  txtf( "|b%c|r%c%c%c", frame_normal[6], c, frame_normal[7], frame_normal[8] );
}

void Tmenu_box::event_handler( Tevent &ev )
{
  Tmenu_box *b;
  int px, py;

  if( menu == NULL ) return;
  if( state( isALIVE ) )
    switch( ev.code )
    {
      case evCOMMAND:
        switch( ev.CMD_CODE )
        {
          case cmMENU_OPEN_SUBMENU:
            if( is_submenu( menu->current ) )
            {
              b = NEW( Tmenu_box( menu->current->what.submenu, this ) );
              px = xl - 2; py = item_y( menu->current ) - 1;
              make_global( px, py, px, py );
              if( ( px + b->xl ) > (int) scr_columns ) px -= xl + b->xl - 4;
              if( ( py + b->yl ) > (int) scr_rows ) py = scr_rows -  b->yl;
              make_local( px, py, px, py );
              put_in( b, px, py );
              handled( ev );
            }
        }
        break;
      case evKEY_PRESS:
        switch( ev.ASCII )
        {
          case kUP:
            previous_line(); break;
          case kDOWN:
            next_line(); break;
          default:
            goto hot;
        }
        handled( ev );
    }
hot:
  Tmenu_base::event_handler( ev );
}

#pragma off( unreferenced )
int Tmenu_box::item_x( Tmenu_item *p )
{
  return 1;
}
#pragma on( unreferenced )

int Tmenu_box::item_y( Tmenu_item *p )
{
  Tmenu_item *i;
  int iy;

  iy = 1;
  i = menu->items;
  while( i != NULL )
  {
    if( i == p ) return iy;
    iy++;
    i = i->next;
  }
  return -1;
}

Tmenu_item *Tmenu_box::pointed_ptr( int mx, int my )
{
  Tmenu_item *i;
  int iy;

  iy = 0;
  i = menu->items;
  while( i != NULL )
  {
    iy++;
    if( is_valid( i ) && ( mx >= 1 ) && ( mx <= ( xl - 2 ) ) && ( my == iy ) )
      return i;
    i = i->next;
  }
  return NULL;
}


#ifndef NOLOCALMENU

//Tlocal_menu publics:

Tlocal_menu::Tlocal_menu( Tmenu *_menu ):
  Tmenu_box( _menu, NULL )
{
  int _x, _y;

  set_state( isHIDDEN, 1 );
  set_flags( ifCLOSEABLE, 0 );
  shortcut = kALT_F10;
  application->make_local( desktop_x, desktop_y, _x, _y );
  application->put_in( this, _x, _y );
}

void Tlocal_menu::drag( int _x, int _y )
{
  Tmenu_box::drag( _x, _y );
  initialize();
}

boolean Tlocal_menu::valid( uint command )
{
  if( command == cmDONE )
  {
    set_state( isHIDDEN, 1 );
    return 0;
  }
  return Tmenu_box::valid( command );
}

uint Tlocal_menu::exec( void )
{
  set_state( isHIDDEN, 0 );
  uint result = Tmenu_box::exec();
  set_state( isHIDDEN, 1 );
  return result;
}

//Tlocal_menu protected:

#ifndef NOMOUSE
boolean Tlocal_menu::isit_4u( Tevent &ev )
{
  if( Tmenu_box::isit_4u( ev ) ) return 1;
  if( state( isHIDDEN ) && ev.code==evMOUSE_DOWN && ev.BUTTON==1 &&
      ev.GLOBAL_Y>=desktop_y && menu!=NULL && menu->items!=NULL ) return 1;
  return 0;
}

void Tlocal_menu::event_handler( Tevent &ev )
{
  int xx, yy;

  if( state( isHIDDEN ) && ( ev.code == evMOUSE_DOWN ) && ( ev.BUTTON == 1 ) )
  {
    xx = ev.GLOBAL_X; yy = ev.GLOBAL_Y;
    if( ev.GLOBAL_X > ( desktop_x + ( desktop_xl >> 1 ) ) ) xx -= xl - 1;
    if( ev.GLOBAL_Y > ( desktop_y + ( desktop_yl >> 1 ) ) ) yy -= yl - 1;
    if( yy < desktop_y ) yy = desktop_y;
    if( ( xx + xl ) > (int) scr_columns ) xx = scr_columns - xl;
    if( ( yy + yl ) > (int) scr_rows ) yy = scr_rows - yl;
    owner->make_local( xx, yy, xx, yy );
    drag( xx, yy );
    owner->make_global( xx, yy, xx, yy );
    make_local( xx, yy, xx, yy );
    menu->current = pointed_ptr( xx, yy );
    if( is_submenu( menu->current ) )
    {
      menu->current->what.submenu->current = NULL;
      suspend_selection();
    }
    exec();
    handled( ev );
  }
  Tmenu_box::event_handler( ev );
}

#endif //NOMOUSE

#endif //NOLOCALMENU


//Tmenu_bar publics:

Tmenu_bar::Tmenu_bar( Tmenu *_menu, int _xl ):
  Tmenu_base( _xl, 1 )
{
  set_flags( ifPRE_PROCESS, 1 );
  set_flags( mfSUSPEND_SELECTION+ifCLOSEABLE, 0 );
  parent = NULL;
  menu = _menu;
}

//Tmenu_bar protected:

void Tmenu_bar::draw( void )
{
  Tmenu_item *i;
  char n, ta, s;
  boolean f;

  if( menu == NULL ) return;
  i = menu->items;
  n = 0;
  while( i != NULL )
  {
    ta = shortcut_attr;
    f = ( i == menu->current );
    if( !i->command || i->enabled )
    {
      s = 't';
      if( f ) s = 's';
    }
    else
    {
      shortcut_attr = 0;
      s = 'd';
      if( f ) s = '0';
    }
    txtf( "|%c%s", s, i->name );
    shortcut_attr = ta;
    n += smart_len( i->name );
    i = i->next;
  }
  txtf( "|r%c ", (char) ( xl - n ) );
}

void Tmenu_bar::event_handler( Tevent &ev )
{
  Tmenu_box *b;
  int px, py;
  boolean fl;

  if( menu == NULL ) return;
  if( state( isALIVE ) )
    switch( ev.code )
    {
      case evCOMMAND:
        if( ( ev.CMD_CODE == cmMENU_OPEN_SUBMENU ) &&
            is_submenu( menu->current ) )
        {
          b = NEW( Tmenu_box( menu->current->what.submenu, this ) );
          px = item_x( menu->current ); py = 1;
          make_global( px, py, px, py );
          if( ( py + b->yl ) > scr_rows ) py -= b->yl + 1;
          make_local( px, py, px, py );
          put_in( b, px, py );
          handled( ev );
        }
        break;
      case evKEY_PRESS:
        if( menu->current != NULL )
        {
          if( ( ev.ASCII == kLEFT ) || ( ev.ASCII == kRIGHT ) )
          {
            if( fl = pulled_down ) close_submenu();
            if( ev.ASCII == kLEFT )
              previous_line();
            else
              next_line();
            if( fl )
            {
              open_submenu();
              show_submenu_cursor( menu->current );
            }
            handled( ev );
          }
        }
    }
  Tmenu_base::event_handler( ev );
}

int Tmenu_bar::item_x( Tmenu_item *p )
{
  Tmenu_item *i;
  int ix;

  ix = 0;
  i = menu->items;
  while( i != NULL )
  {
    if( i==p ) return ix;
    ix += smart_len( i->name );
    i = i->next;
  }
  return -1;
}

#pragma off( unreferenced )
int Tmenu_bar::item_y( Tmenu_item *p )
{
  return 0;
}
#pragma on( unreferenced )

Tmenu_item *Tmenu_bar::pointed_ptr( int mx, int my )
{
  Tmenu_item *i;
  int ix;

  i = menu->items;
  while( i != NULL )
  {
    ix = item_x( i );
    if( ( i->name != NULL ) &&
        ( mx >= ix ) &&
        ( mx < ( ix + smart_len( i->name ) ) ) &&
        ( my == item_y( i ) ) &&
        is_valid( i ) ) return i;
    i = i->next;
  }
  return NULL;
}


#if !defined( NOMAINMENU ) || !defined( NOLOCALMENU )

//Tmain_menu publics:

Tmain_menu::Tmain_menu( void ):
  Tmenu_bar( NULL, 1 )
{
  shortcut = kF10;
  grow_mode = gmGROW_HOR;
}

//Tmain_menu protected:

#pragma off( unreferenced )
void Tmain_menu::calc_bounds( int delta_xl, int delta_yl )
{
  drag( desktop_x, desktop_y );
  desktop_y++;
  desktop_yl--;
  resize( application->xl, 1 );
}
#pragma on( unreferenced )

#endif //!defined( NOMAINMENU ) || !defined( NOLOCALMENU )


#ifndef NOTOOLBAR

class Ttoolbar: public Titem
{
  public:
    Ttoolbar( void );
    void reset( void );
    Tbutton *addtool( char *t, uint cmd );
    void addkey( uint k, uint cmd );

  protected:
    int tool_x;
    virtual void set_palette( void );
    virtual void calc_bounds( int delta_xl, int delta_yl );
    virtual void event_handler( Tevent &ev );
};

#endif

#ifndef NOTOOLBAR

class Ttool: public Tbutton
{
  public:
    Ttool( char *t, uint cmd );
};

//Ttool publics:

Ttool::Ttool( char *t, uint cmd ):
  Tbutton( t, cmd )
{
  set_flags( bfBROADCAST, 1 ); set_flags( ifSELECTABLE, 0 );
}

#endif //NOTOOLBAR

#ifndef NOTOOLBAR

//Ttoolbar publics:

Ttoolbar::Ttoolbar( void ):
  Titem( 1, 1 )
{
  set_flags( ifSELECTABLE, 0 ); set_flags( ifPRE_PROCESS, 1 );
  backgrnd_attr = pal_windows.tool_normal;
  set_state( isHIDDEN, toolbar_enabled != cmWINDOW_TOOLBAR );
  reset();
}

void Ttoolbar::reset( void )
{
  while( last != NULL ) DELETE( last );
  redraw();
  tool_x = 1;
}

Tbutton *Ttoolbar::addtool( char *t, uint cmd )
{
  Ttool *p;

  p = NEW( Ttool( t, cmd ) );
  put_in( p, tool_x, 0 );
  tool_x += smart_len( p->title ) + 2;
  set_state( isDISABLED, 0 );
  if( toolbar_enabled == cmWINDOW_TOOLBAR ) set_state( isHIDDEN, 0 );
  return p;
}

void Ttoolbar::addkey( uint k, uint cmd )
{
  Tkey *p;

  p = NEW( Tkey( k, cmd ) );
  p->set_flags( ifPRE_PROCESS, 1 );
  put_in( p, 0, 0 );
  set_state( isDISABLED, 0 );
}

//Ttoolbar protected:

void Ttoolbar::set_palette( void )
{
  text_attr = backgrnd_attr;
  shortcut_attr = pal_windows.shortcut;
}

#pragma off( unreferenced )
void Ttoolbar::calc_bounds( int delta_xl, int delta_yl )
{
  resize( owner->xl, 1 );
  drag( 0, desktop_y );
  if( state( isHIDDEN ) ) return;
  desktop_y++;
  desktop_yl--;
}
#pragma on( unreferenced )


void Ttoolbar::event_handler( Tevent &ev )
{
  boolean h;

  Titem::event_handler( ev );
  switch( ev.code )
  {
    case evCOMMAND:
      if( ev.CMD_CODE == cmWINDOW_TOOLBAR )
      {
        h = !state( isHIDDEN );
        set_state( isHIDDEN, h );
        if( h )
        {
          desktop_y--; desktop_yl++;
          toolbar_enabled = 0;
        }
        else
        {
          desktop_yl--; desktop_y++;
          toolbar_enabled = cmWINDOW_TOOLBAR;
        }
        desktop->drag( desktop_x, desktop_y );
        desktop->resize( desktop_xl, desktop_yl );
        handled( ev );
      }
  }
}

#endif //NOTOOLBAR

//INTERFACE

static Tcontext_handler current_context_handler = NULL;
static int current_context = 0;

#ifndef NOTOOLBAR

void construct_toolbar( void )
{
  ( (Ttoolbar *) toolbar )->reset();
}

#endif

#ifndef NOTOOLBAR

Tbutton *add_tool( char *t, uint cmd, uint key )
{
  Tbutton *b;

  b = add_tool( t, cmd );
  b->shortcut = key;
  return b;
}

Tbutton *add_tool( char *t, uint cmd )
{
  return ( (Ttoolbar *) toolbar )->addtool( t, cmd );
}

void add_tool( uint cmd, uint key )
{
  ( (Ttoolbar *) toolbar )->addkey( key, cmd );
}

#endif //NOTOOLBAR

void install_context_handler( Tcontext_handler ctxhnd )
{
  current_context_handler = ctxhnd;
}

void set_context( int context )
{
  if( ( current_context_handler != NULL ) && context && ( context != current_context ) )
  {
#ifndef NOLOCALMENU
    DELETE( local_menu );
    local_menu = NULL;
#endif
    current_context_handler( context );
    current_context = context;
  }
}

void update_context( void )
{
  if( ( current_context_handler != NULL ) && current_context )
  {
#ifndef NOLOCALMENU
    DELETE( local_menu );
    local_menu = NULL;
#endif
    current_context_handler( current_context );
  }
}

#if !defined( NOCONFIG ) && !defined( NOTOOLBAR )
static void read_params( void )
{
  boolean x;

  seek_section( 0, SECTION_DESKTOP );
#ifndef NOTOOLBAR
  ini( VAR_TOOLBAR, x, 1 );
    if( x ) toolbar_enabled = cmWINDOW_TOOLBAR; else toolbar_enabled = 0;
#endif
}
#endif

void global_key( uint cmd, uint key )
{
  local_key( application, cmd, key );
}

void local_key( Titem *p, uint cmd, uint key )
{
  Tkey *k;

  k = NEW( Tkey( key, cmd ) );
  k->set_flags( ifPRE_PROCESS, 1 );
  p->put_in( k, 0, 0 );
}

void __init_cmdgen( void )
{

//init tools
#if !defined( NOTOOLBAR ) && !defined( NOCONFIG )
  read_params();
#endif

#ifndef NOTOOLBAR
  toolbar = NEW( Ttoolbar );
  application->put_in( toolbar, 0, 0 );
#endif

//init menu
  timer_handle = alloc_timer();
#if !defined( NOMAINMENU ) || !defined( NOLOCALMENU )
  main_menu = NEW( Tmain_menu );
  application->put_in( main_menu, 0, 0 );
#endif
}
