//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCOMLIN.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Command line processor               |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef NOPARAM

#define uses_ctype
#define uses_dos
#define uses_fcntl
#define uses_malloc
#define uses_process
#define uses_stdio
#define uses_stdlib
#define uses_string
#define uses_basics
#define uses_comlin
#define uses_system

#define DECLARE_PVCOMLIN
#include "PVuses.h"
#undef DECLARE_PVCOMLIN

#define PARAMS_BUFFER 0x1000
#define ecUNKNOWN_PARAMS 222
#define ecREAD_PARAMS 223

static char *params;
static Tset used_params;

char *param_str( uint index )
{
  char *p;

  if( index >= param_count ) return NULL;
  p = params;
  index++;
  while( --index ) p = strchr( p, 0 ) + 1;
  return p;
}

boolean param_opt( char *cmd )
{
  uint i;

  strupr( cmd );
  for( i = 0; i < param_count; i++ )
    if( ( strchr( param_str(i), ':' ) == NULL ) && !strncmp( param_str(i), cmd, strlen( cmd ) ) )
    {
      used_params >> i;
      return 1;
    }
  return 0;
}

boolean param_spec( char *cmd, char *r )
{
  uint i;

  strupr( cmd );
  for( i = 0; i < param_count; i++ )
    if( !strncmp( param_str(i), cmd, strlen( cmd ) ) )
    {
      strcpy(r, &param_str(i)[ strlen( cmd ) ] );
      used_params >> i;
      return 1;
    }
  return 0;
}

boolean param_cmd( char *cmd )
{
  uint i;

  for( i = 0; i < param_count; i++ )
    if( ( used_params & i ) && ( param_str(i)[0] != '/' ) )
    {
      used_params >> i;
      strcpy( cmd, param_str(i) );
      return 1;
    }
  return 0;
}

boolean param_filename( char *name, char *ext )
{
  if( !param_cmd( name ) ) return 0;
  add_ext( name, ext );
  return 1;
}

boolean param_filenames( char *name, char *ext )
{
  static char wildcard = 0;
  static struct find_t ffblk;
  static char drive[_MAX_DRIVE];
  static char dir[_MAX_DIR];
  char s[80];

  if( wildcard )
  {
    wildcard = !_dos_findnext( &ffblk );
    if( wildcard )
    {
      strcpy( name, drive );
      strcat( name, dir );
      strcat( name, ffblk.name );
      add_ext( name, ext );
      return 1;
    }
  }
  if( !wildcard && param_cmd( s ) )
  {
    if( ( strchr( s, '*' ) != NULL ) || ( strchr( s, '?' ) != NULL ) )
    {
      wildcard = !_dos_findfirst( s, _A_NORMAL, &ffblk );
      if( wildcard )
      {
        _splitpath( s, drive, dir, NULL, NULL );
        strcpy( name, drive );
        strcat( name, dir );
        strcat( name, ffblk.name );
        add_ext( name, ext );
        return 1;
      }
    }
    else
    {
      add_ext( strcpy( name, s ), ext );
      return 1;
    }
  }
  return 0;
}

static char *(*cmd_line)[1];
static int arg_index;
static char *cur_ptr;
static uint cmd_count;
static int handle = 0;

static char get_cmd_byte( void )
{
  char name[80], buf;
  uint j;
  unsigned num_read;

  buf = 0;
  loop:
    if( handle )
    {
      if( _dos_read( handle, &buf, 1, &num_read ) )
      {
#ifdef CYR
        printf( ":      ." );
#else
        printf( "Error: Unable to read command line options file." );
#endif
        exit( ecREAD_PARAMS );
      }
      if( num_read )
      {
        if( buf < ' ' ) buf = ' ';
        return toupper( buf );
      }
      else
      {
        _dos_close( handle );
        handle = 0;
      }
    }
    else
    {
      buf = *cur_ptr++;
      if( !buf )
      {
        if( ++arg_index >= cmd_count ) return 0;
        cur_ptr = *cmd_line[arg_index];
        return ' ';
      }
      if( buf == '@' )
      {
        j = 0;
        while( ( *cur_ptr != ' ' ) && ( *cur_ptr != '/' ) && ( *cur_ptr != 0 ) )
          name[j++] = *(cur_ptr++);
        name[j] = 0;
        if( _dos_open( name, O_RDONLY, &handle) )
        {
#ifdef CYR
          printf( ":      ." );
#else
          printf( "Error: Unable to read command line options file." );
#endif
          exit( ecREAD_PARAMS );
        }
      }
      else
        if( buf ) return toupper( buf );
    }
  goto loop;
}

void __tini_comlin( void )
{
  uint i;

  if( !used_params.is_empty() )
  {
    restore_dos_screen();
#ifdef CYR
    printf( ":     : " );
#else
    printf( "Error: Unknown command line parameter(s):" );
#endif
    for( i = 0; i < param_count; i++ )
      if( used_params & i )
        printf( " %s", param_str( i ) );
    printf( "\n" );
    exit( ecUNKNOWN_PARAMS );
  }
  FREE( params );
  param_count = 0;
}

void __init_comlin( int argc, char *argv[] )
{
  char *p, b;
  uint i;

  cmd_count = argc; cmd_line = (char *(*)[1]) argv;
  params = (char *) MALLOC( PARAMS_BUFFER );
  p = params;
  arg_index = 0; cur_ptr = argv[arg_index];
  param_count = cmd_count > 0;
  while( ( b = get_cmd_byte() ) != 0 )
  {
    if( ( b == '/' ) || ( b == ' ') )
    {
      while( b == ' ' ) b = get_cmd_byte();
      if( !b ) break;
      if( p != params )
      {
        *(p++) = 0;
        param_count++;
      }
    }
    *(p++) = b;
  }
  *p = 0;
  if( handle ) _dos_close( handle );
  ~used_params;
  for( i = 1; i < param_count; i++ )
    used_params << i;
}

#endif //NOPARAM
