//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVHIST.CPP                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     History box implementation           |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef NOHIST

#define uses_string
#define uses_cmd
#define uses_hist
#define uses_icons

#include "PVuses.h"

#define MAX_HISTORY_ENTRIES 32

struct Thistory_list
{
  void *id;
  Tlb_list *list;
  Thistory_list *next;
};

static Thistory_list *first_history = NULL;

Tlb_list *registrate_history( void *id )
{
  Thistory_list *p;

  p = first_history;
  while( p != NULL )
  {
    if( p->id == id ) return p->list;
    p = p->next;
  }
  p = NEW( Thistory_list );
  p->id = id;
  p->list = NEW( Tlb_list );
  p->next = first_history;
  first_history = p;
  return p->list;
}

//Thistory publics:

Thistory::Thistory( void *_id ):
  Tcombo()
{
  list = registrate_history( _id );
}

Thistory::Thistory( Tlb_list *_list ):
  Tcombo()
{
  list = _list;
}

void Thistory::record_history( void )
{
  char s[256], t[256];
  uint n;

  ( ( Tcombo_item * ) owner )->get_data( s );
  if( !( *s ) ) return;
  for( n = 0; n < list->vcount; n++ )
  {
    list->gettxt( n, t );
    if( strcmp( t, s ) == 0 )
    {
      list->del( n );
      break;
    }
  }
  if( list->vcount == MAX_HISTORY_ENTRIES ) list->del( list->vcount );
  list->ins( 0, s );
}

//Thistory protected:

void Thistory::initialize( void )
{
  Tcombo::initialize();
  ( (Tcombo_item *) owner )->options |= loASSOCIATED;
  ( (Tcombo_item *) owner )->vcount = list->vcount;
  ( (Tcombo_item *) owner )->hsize = list->hsize;
  ( (Tcombo_item *) owner )->hmax_size = list->hmax_size;
  ( (Tcombo_item *) owner )->overflow = list->overflow;
  ( (Tcombo_item *) owner )->changed = list->changed;
}

void Thistory::event_handler( Tevent &ev )
{
  if( ( ev.code != evCOMMAND ) || ( ev.CMD_CODE != cmDLG_RECORD_HISTORY ) )
    Tcombo::event_handler( ev );
  else
    record_history();
}

Tcombo_list * Thistory::init_combo_list( void )
{
  return NEW( Tcombo_list(
    list->vcurrent,
    open_xl - i_sb_up_len,
    open_yl,
    list )
  );
}

void Thistory::open_combo( void )
{
  Tcombo::open_combo();
  list->top();
}

#endif
