//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVMEMMON.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Memory monitor implementation        |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_app
#define uses_colors
#define uses_dc
#define uses_desk
#define uses_system

#include "PVuses.h"

#ifdef MEMMON

class Tmem_monitor: public Titem
{
  public:
    Tmem_monitor( void );
    virtual void set_palette( void );
    virtual void draw( void );
};

static Tmem_monitor *mem_monitor;
static Tidle old_idle;

void mem_refresh( unsigned long time_passed )
{
  static unsigned long old_mem = 0;

  old_idle( time_passed );
  if( old_mem == mem_avail ) return;
  old_mem = mem_avail;
  mem_monitor->redraw();
}

Tmem_monitor::Tmem_monitor( void ):
  Titem( 8, 1 )
{
  set_events_mask( (uint)-1, 0 );
  set_flags( (uint)-1, 0 ); set_flags( ifVISIBLE, 1 );
  drag_mode = dmDRAG_BOTH;
  old_idle = hook_idle( mem_refresh );
}

void Tmem_monitor::set_palette( void )
{
  text_attr = pal_desktop.bold;
}

void Tmem_monitor::draw( void )
{
  txtf( "%8lu", mem_avail );
}

void __init_mem( void )
{
  mem_monitor = NEW( Tmem_monitor );
  desktop->put_in( mem_monitor, desktop->xl - 8, desktop->yl - 1 );
}

#endif //MEMMON
