//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCOLORS.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Colors management interface          |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_colors( void );

#ifndef _PVCOLORS_H
#define _PVCOLORS_H

#define atBLACK         0x00
#define atBLUE          0x01
#define atGREEN         0x02
#define atCYAN          0x03
#define atRED           0x04
#define atMAGENTA       0x05
#define atBROWN         0x06
#define atLGRAY         0x07
#define atDGRAY         0x08
#define atLBLUE         0x09
#define atLGREEN        0x0A
#define atLCYAN         0x0B
#define atLRED          0x0C
#define atLMAGENTA      0x0D
#define atYELLOW        0x0E
#define atWHITE         0x0F

#define atBLACK_ON_BLACK        (atBLACK   |(atBLACK   <<4))
#define atBLACK_ON_BLUE         (atBLACK   |(atBLUE    <<4))
#define atBLACK_ON_GREEN        (atBLACK   |(atGREEN   <<4))
#define atBLACK_ON_CYAN         (atBLACK   |(atCYAN    <<4))
#define atBLACK_ON_RED          (atBLACK   |(atRED     <<4))
#define atBLACK_ON_MAGENTA      (atBLACK   |(atMAGENTA <<4))
#define atBLACK_ON_BROWN        (atBLACK   |(atBROWN   <<4))
#define atBLACK_ON_LGRAY        (atBLACK   |(atLGRAY   <<4))
#define atBLACK_ON_DGRAY        (atBLACK   |(atDGRAY   <<4))
#define atBLACK_ON_LBLUE        (atBLACK   |(atLBLUE   <<4))
#define atBLACK_ON_LGREEN       (atBLACK   |(atLGREEN  <<4))
#define atBLACK_ON_LCYAN        (atBLACK   |(atLCYAN   <<4))
#define atBLACK_ON_LRED         (atBLACK   |(atLRED    <<4))
#define atBLACK_ON_LMAGENTA     (atBLACK   |(atLMAGENTA<<4))
#define atBLACK_ON_YELLOW       (atBLACK   |(atYELLOW  <<4))
#define atBLACK_ON_WHITE        (atBLACK   |(atWHITE   <<4))

#define atBLUE_ON_BLACK         (atBLUE    |(atBLACK   <<4))
#define atBLUE_ON_BLUE          (atBLUE    |(atBLUE    <<4))
#define atBLUE_ON_GREEN         (atBLUE    |(atGREEN   <<4))
#define atBLUE_ON_CYAN          (atBLUE    |(atCYAN    <<4))
#define atBLUE_ON_RED           (atBLUE    |(atRED     <<4))
#define atBLUE_ON_MAGENTA       (atBLUE    |(atMAGENTA <<4))
#define atBLUE_ON_BROWN         (atBLUE    |(atBROWN   <<4))
#define atBLUE_ON_LGRAY         (atBLUE    |(atLGRAY   <<4))
#define atBLUE_ON_DGRAY         (atBLUE    |(atDGRAY   <<4))
#define atBLUE_ON_LBLUE         (atBLUE    |(atLBLUE   <<4))
#define atBLUE_ON_LGREEN        (atBLUE    |(atLGREEN  <<4))
#define atBLUE_ON_LCYAN         (atBLUE    |(atLCYAN   <<4))
#define atBLUE_ON_LRED          (atBLUE    |(atLRED    <<4))
#define atBLUE_ON_LMAGENTA      (atBLUE    |(atLMAGENTA<<4))
#define atBLUE_ON_YELLOW        (atBLUE    |(atYELLOW  <<4))
#define atBLUE_ON_WHITE         (atBLUE    |(atWHITE   <<4))

#define atGREEN_ON_BLACK        (atGREEN   |(atBLACK   <<4))
#define atGREEN_ON_BLUE         (atGREEN   |(atBLUE    <<4))
#define atGREEN_ON_GREEN        (atGREEN   |(atGREEN   <<4))
#define atGREEN_ON_CYAN         (atGREEN   |(atCYAN    <<4))
#define atGREEN_ON_RED          (atGREEN   |(atRED     <<4))
#define atGREEN_ON_MAGENTA      (atGREEN   |(atMAGENTA <<4))
#define atGREEN_ON_BROWN        (atGREEN   |(atBROWN   <<4))
#define atGREEN_ON_LGRAY        (atGREEN   |(atLGRAY   <<4))
#define atGREEN_ON_DGRAY        (atGREEN   |(atDGRAY   <<4))
#define atGREEN_ON_LBLUE        (atGREEN   |(atLBLUE   <<4))
#define atGREEN_ON_LGREEN       (atGREEN   |(atLGREEN  <<4))
#define atGREEN_ON_LCYAN        (atGREEN   |(atLCYAN   <<4))
#define atGREEN_ON_LRED         (atGREEN   |(atLRED    <<4))
#define atGREEN_ON_LMAGENTA     (atGREEN   |(atLMAGENTA<<4))
#define atGREEN_ON_YELLOW       (atGREEN   |(atYELLOW  <<4))
#define atGREEN_ON_WHITE        (atGREEN   |(atWHITE   <<4))

#define atCYAN_ON_BLACK         (atCYAN    |(atBLACK   <<4))
#define atCYAN_ON_BLUE          (atCYAN    |(atBLUE    <<4))
#define atCYAN_ON_GREEN         (atCYAN    |(atGREEN   <<4))
#define atCYAN_ON_CYAN          (atCYAN    |(atCYAN    <<4))
#define atCYAN_ON_RED           (atCYAN    |(atRED     <<4))
#define atCYAN_ON_MAGENTA       (atCYAN    |(atMAGENTA <<4))
#define atCYAN_ON_BROWN         (atCYAN    |(atBROWN   <<4))
#define atCYAN_ON_LGRAY         (atCYAN    |(atLGRAY   <<4))
#define atCYAN_ON_DGRAY         (atCYAN    |(atDGRAY   <<4))
#define atCYAN_ON_LBLUE         (atCYAN    |(atLBLUE   <<4))
#define atCYAN_ON_LGREEN        (atCYAN    |(atLGREEN  <<4))
#define atCYAN_ON_LCYAN         (atCYAN    |(atLCYAN   <<4))
#define atCYAN_ON_LRED          (atCYAN    |(atLRED    <<4))
#define atCYAN_ON_LMAGENTA      (atCYAN    |(atLMAGENTA<<4))
#define atCYAN_ON_YELLOW        (atCYAN    |(atYELLOW  <<4))
#define atCYAN_ON_WHITE         (atCYAN    |(atWHITE   <<4))

#define atRED_ON_BLACK          (atRED     |(atBLACK   <<4))
#define atRED_ON_BLUE           (atRED     |(atBLUE    <<4))
#define atRED_ON_GREEN          (atRED     |(atGREEN   <<4))
#define atRED_ON_CYAN           (atRED     |(atCYAN    <<4))
#define atRED_ON_RED            (atRED     |(atRED     <<4))
#define atRED_ON_MAGENTA        (atRED     |(atMAGENTA <<4))
#define atRED_ON_BROWN          (atRED     |(atBROWN   <<4))
#define atRED_ON_LGRAY          (atRED     |(atLGRAY   <<4))
#define atRED_ON_DGRAY          (atRED     |(atDGRAY   <<4))
#define atRED_ON_LBLUE          (atRED     |(atLBLUE   <<4))
#define atRED_ON_LGREEN         (atRED     |(atLGREEN  <<4))
#define atRED_ON_LCYAN          (atRED     |(atLCYAN   <<4))
#define atRED_ON_LRED           (atRED     |(atLRED    <<4))
#define atRED_ON_LMAGENTA       (atRED     |(atLMAGENTA<<4))
#define atRED_ON_YELLOW         (atRED     |(atYELLOW  <<4))
#define atRED_ON_WHITE          (atRED     |(atWHITE   <<4))

#define atMAGENTA_ON_BLACK      (atMAGENTA |(atBLACK   <<4))
#define atMAGENTA_ON_BLUE       (atMAGENTA |(atBLUE    <<4))
#define atMAGENTA_ON_GREEN      (atMAGENTA |(atGREEN   <<4))
#define atMAGENTA_ON_CYAN       (atMAGENTA |(atCYAN    <<4))
#define atMAGENTA_ON_RED        (atMAGENTA |(atRED     <<4))
#define atMAGENTA_ON_MAGENTA    (atMAGENTA |(atMAGENTA <<4))
#define atMAGENTA_ON_BROWN      (atMAGENTA |(atBROWN   <<4))
#define atMAGENTA_ON_LGRAY      (atMAGENTA |(atLGRAY   <<4))
#define atMAGENTA_ON_DGRAY      (atMAGENTA |(atDGRAY   <<4))
#define atMAGENTA_ON_LBLUE      (atMAGENTA |(atLBLUE   <<4))
#define atMAGENTA_ON_LGREEN     (atMAGENTA |(atLGREEN  <<4))
#define atMAGENTA_ON_LCYAN      (atMAGENTA |(atLCYAN   <<4))
#define atMAGENTA_ON_LRED       (atMAGENTA |(atLRED    <<4))
#define atMAGENTA_ON_LMAGENTA   (atMAGENTA |(atLMAGENTA<<4))
#define atMAGENTA_ON_YELLOW     (atMAGENTA |(atYELLOW  <<4))
#define atMAGENTA_ON_WHITE      (atMAGENTA |(atWHITE   <<4))

#define atBROWN_ON_BLACK        (atBROWN   |(atBLACK   <<4))
#define atBROWN_ON_BLUE         (atBROWN   |(atBLUE    <<4))
#define atBROWN_ON_GREEN        (atBROWN   |(atGREEN   <<4))
#define atBROWN_ON_CYAN         (atBROWN   |(atCYAN    <<4))
#define atBROWN_ON_RED          (atBROWN   |(atRED     <<4))
#define atBROWN_ON_MAGENTA      (atBROWN   |(atMAGENTA <<4))
#define atBROWN_ON_BROWN        (atBROWN   |(atBROWN   <<4))
#define atBROWN_ON_LGRAY        (atBROWN   |(atLGRAY   <<4))
#define atBROWN_ON_DGRAY        (atBROWN   |(atDGRAY   <<4))
#define atBROWN_ON_LBLUE        (atBROWN   |(atLBLUE   <<4))
#define atBROWN_ON_LGREEN       (atBROWN   |(atLGREEN  <<4))
#define atBROWN_ON_LCYAN        (atBROWN   |(atLCYAN   <<4))
#define atBROWN_ON_LRED         (atBROWN   |(atLRED    <<4))
#define atBROWN_ON_LMAGENTA     (atBROWN   |(atLMAGENTA<<4))
#define atBROWN_ON_YELLOW       (atBROWN   |(atYELLOW  <<4))
#define atBROWN_ON_WHITE        (atBROWN   |(atWHITE   <<4))

#define atLGRAY_ON_BLACK        (atLGRAY   |(atBLACK   <<4))
#define atLGRAY_ON_BLUE         (atLGRAY   |(atBLUE    <<4))
#define atLGRAY_ON_GREEN        (atLGRAY   |(atGREEN   <<4))
#define atLGRAY_ON_CYAN         (atLGRAY   |(atCYAN    <<4))
#define atLGRAY_ON_RED          (atLGRAY   |(atRED     <<4))
#define atLGRAY_ON_MAGENTA      (atLGRAY   |(atMAGENTA <<4))
#define atLGRAY_ON_BROWN        (atLGRAY   |(atBROWN   <<4))
#define atLGRAY_ON_LGRAY        (atLGRAY   |(atLGRAY   <<4))
#define atLGRAY_ON_DGRAY        (atLGRAY   |(atDGRAY   <<4))
#define atLGRAY_ON_LBLUE        (atLGRAY   |(atLBLUE   <<4))
#define atLGRAY_ON_LGREEN       (atLGRAY   |(atLGREEN  <<4))
#define atLGRAY_ON_LCYAN        (atLGRAY   |(atLCYAN   <<4))
#define atLGRAY_ON_LRED         (atLGRAY   |(atLRED    <<4))
#define atLGRAY_ON_LMAGENTA     (atLGRAY   |(atLMAGENTA<<4))
#define atLGRAY_ON_YELLOW       (atLGRAY   |(atYELLOW  <<4))
#define atLGRAY_ON_WHITE        (atLGRAY   |(atWHITE   <<4))

#define atDGRAY_ON_BLACK        (atDGRAY   |(atBLACK   <<4))
#define atDGRAY_ON_BLUE         (atDGRAY   |(atBLUE    <<4))
#define atDGRAY_ON_GREEN        (atDGRAY   |(atGREEN   <<4))
#define atDGRAY_ON_CYAN         (atDGRAY   |(atCYAN    <<4))
#define atDGRAY_ON_RED          (atDGRAY   |(atRED     <<4))
#define atDGRAY_ON_MAGENTA      (atDGRAY   |(atMAGENTA <<4))
#define atDGRAY_ON_BROWN        (atDGRAY   |(atBROWN   <<4))
#define atDGRAY_ON_LGRAY        (atDGRAY   |(atLGRAY   <<4))
#define atDGRAY_ON_DGRAY        (atDGRAY   |(atDGRAY   <<4))
#define atDGRAY_ON_LBLUE        (atDGRAY   |(atLBLUE   <<4))
#define atDGRAY_ON_LGREEN       (atDGRAY   |(atLGREEN  <<4))
#define atDGRAY_ON_LCYAN        (atDGRAY   |(atLCYAN   <<4))
#define atDGRAY_ON_LRED         (atDGRAY   |(atLRED    <<4))
#define atDGRAY_ON_LMAGENTA     (atDGRAY   |(atLMAGENTA<<4))
#define atDGRAY_ON_YELLOW       (atDGRAY   |(atYELLOW  <<4))
#define atDGRAY_ON_WHITE        (atDGRAY   |(atWHITE   <<4))

#define atLBLUE_ON_BLACK        (atLBLUE   |(atBLACK   <<4))
#define atLBLUE_ON_BLUE         (atLBLUE   |(atBLUE    <<4))
#define atLBLUE_ON_GREEN        (atLBLUE   |(atGREEN   <<4))
#define atLBLUE_ON_CYAN         (atLBLUE   |(atCYAN    <<4))
#define atLBLUE_ON_RED          (atLBLUE   |(atRED     <<4))
#define atLBLUE_ON_MAGENTA      (atLBLUE   |(atMAGENTA <<4))
#define atLBLUE_ON_BROWN        (atLBLUE   |(atBROWN   <<4))
#define atLBLUE_ON_LGRAY        (atLBLUE   |(atLGRAY   <<4))
#define atLBLUE_ON_DGRAY        (atLBLUE   |(atDGRAY   <<4))
#define atLBLUE_ON_LBLUE        (atLBLUE   |(atLBLUE   <<4))
#define atLBLUE_ON_LGREEN       (atLBLUE   |(atLGREEN  <<4))
#define atLBLUE_ON_LCYAN        (atLBLUE   |(atLCYAN   <<4))
#define atLBLUE_ON_LRED         (atLBLUE   |(atLRED    <<4))
#define atLBLUE_ON_LMAGENTA     (atLBLUE   |(atLMAGENTA<<4))
#define atLBLUE_ON_YELLOW       (atLBLUE   |(atYELLOW  <<4))
#define atLBLUE_ON_WHITE        (atLBLUE   |(atWHITE   <<4))

#define atLGREEN_ON_BLACK       (atLGREEN  |(atBLACK   <<4))
#define atLGREEN_ON_BLUE        (atLGREEN  |(atBLUE    <<4))
#define atLGREEN_ON_GREEN       (atLGREEN  |(atGREEN   <<4))
#define atLGREEN_ON_CYAN        (atLGREEN  |(atCYAN    <<4))
#define atLGREEN_ON_RED         (atLGREEN  |(atRED     <<4))
#define atLGREEN_ON_MAGENTA     (atLGREEN  |(atMAGENTA <<4))
#define atLGREEN_ON_BROWN       (atLGREEN  |(atBROWN   <<4))
#define atLGREEN_ON_LGRAY       (atLGREEN  |(atLGRAY   <<4))
#define atLGREEN_ON_DGRAY       (atLGREEN  |(atDGRAY   <<4))
#define atLGREEN_ON_LBLUE       (atLGREEN  |(atLBLUE   <<4))
#define atLGREEN_ON_LGREEN      (atLGREEN  |(atLGREEN  <<4))
#define atLGREEN_ON_LCYAN       (atLGREEN  |(atLCYAN   <<4))
#define atLGREEN_ON_LRED        (atLGREEN  |(atLRED    <<4))
#define atLGREEN_ON_LMAGENTA    (atLGREEN  |(atLMAGENTA<<4))
#define atLGREEN_ON_YELLOW      (atLGREEN  |(atYELLOW  <<4))
#define atLGREEN_ON_WHITE       (atLGREEN  |(atWHITE   <<4))

#define atLCYAN_ON_BLACK        (atLCYAN   |(atBLACK   <<4))
#define atLCYAN_ON_BLUE         (atLCYAN   |(atBLUE    <<4))
#define atLCYAN_ON_GREEN        (atLCYAN   |(atGREEN   <<4))
#define atLCYAN_ON_CYAN         (atLCYAN   |(atCYAN    <<4))
#define atLCYAN_ON_RED          (atLCYAN   |(atRED     <<4))
#define atLCYAN_ON_MAGENTA      (atLCYAN   |(atMAGENTA <<4))
#define atLCYAN_ON_BROWN        (atLCYAN   |(atBROWN   <<4))
#define atLCYAN_ON_LGRAY        (atLCYAN   |(atLGRAY   <<4))
#define atLCYAN_ON_DGRAY        (atLCYAN   |(atDGRAY   <<4))
#define atLCYAN_ON_LBLUE        (atLCYAN   |(atLBLUE   <<4))
#define atLCYAN_ON_LGREEN       (atLCYAN   |(atLGREEN  <<4))
#define atLCYAN_ON_LCYAN        (atLCYAN   |(atLCYAN   <<4))
#define atLCYAN_ON_LRED         (atLCYAN   |(atLRED    <<4))
#define atLCYAN_ON_LMAGENTA     (atLCYAN   |(atLMAGENTA<<4))
#define atLCYAN_ON_YELLOW       (atLCYAN   |(atYELLOW  <<4))
#define atLCYAN_ON_WHITE        (atLCYAN   |(atWHITE   <<4))

#define atLRED_ON_BLACK         (atLRED    |(atBLACK   <<4))
#define atLRED_ON_BLUE          (atLRED    |(atBLUE    <<4))
#define atLRED_ON_GREEN         (atLRED    |(atGREEN   <<4))
#define atLRED_ON_CYAN          (atLRED    |(atCYAN    <<4))
#define atLRED_ON_RED           (atLRED    |(atRED     <<4))
#define atLRED_ON_MAGENTA       (atLRED    |(atMAGENTA <<4))
#define atLRED_ON_BROWN         (atLRED    |(atBROWN   <<4))
#define atLRED_ON_LGRAY         (atLRED    |(atLGRAY   <<4))
#define atLRED_ON_DGRAY         (atLRED    |(atDGRAY   <<4))
#define atLRED_ON_LBLUE         (atLRED    |(atLBLUE   <<4))
#define atLRED_ON_LGREEN        (atLRED    |(atLGREEN  <<4))
#define atLRED_ON_LCYAN         (atLRED    |(atLCYAN   <<4))
#define atLRED_ON_LRED          (atLRED    |(atLRED    <<4))
#define atLRED_ON_LMAGENTA      (atLRED    |(atLMAGENTA<<4))
#define atLRED_ON_YELLOW        (atLRED    |(atYELLOW  <<4))
#define atLRED_ON_WHITE         (atLRED    |(atWHITE   <<4))

#define atLMAGENTA_ON_BLACK     (atLMAGENTA|(atBLACK   <<4))
#define atLMAGENTA_ON_BLUE      (atLMAGENTA|(atBLUE    <<4))
#define atLMAGENTA_ON_GREEN     (atLMAGENTA|(atGREEN   <<4))
#define atLMAGENTA_ON_CYAN      (atLMAGENTA|(atCYAN    <<4))
#define atLMAGENTA_ON_RED       (atLMAGENTA|(atRED     <<4))
#define atLMAGENTA_ON_MAGENTA   (atLMAGENTA|(atMAGENTA <<4))
#define atLMAGENTA_ON_BROWN     (atLMAGENTA|(atBROWN   <<4))
#define atLMAGENTA_ON_LGRAY     (atLMAGENTA|(atLGRAY   <<4))
#define atLMAGENTA_ON_DGRAY     (atLMAGENTA|(atDGRAY   <<4))
#define atLMAGENTA_ON_LBLUE     (atLMAGENTA|(atLBLUE   <<4))
#define atLMAGENTA_ON_LGREEN    (atLMAGENTA|(atLGREEN  <<4))
#define atLMAGENTA_ON_LCYAN     (atLMAGENTA|(atLCYAN   <<4))
#define atLMAGENTA_ON_LRED      (atLMAGENTA|(atLRED    <<4))
#define atLMAGENTA_ON_LMAGENTA  (atLMAGENTA|(atLMAGENTA<<4))
#define atLMAGENTA_ON_YELLOW    (atLMAGENTA|(atYELLOW  <<4))
#define atLMAGENTA_ON_WHITE     (atLMAGENTA|(atWHITE   <<4))

#define atYELLOW_ON_BLACK       (atYELLOW  |(atBLACK   <<4))
#define atYELLOW_ON_BLUE        (atYELLOW  |(atBLUE    <<4))
#define atYELLOW_ON_GREEN       (atYELLOW  |(atGREEN   <<4))
#define atYELLOW_ON_CYAN        (atYELLOW  |(atCYAN    <<4))
#define atYELLOW_ON_RED         (atYELLOW  |(atRED     <<4))
#define atYELLOW_ON_MAGENTA     (atYELLOW  |(atMAGENTA <<4))
#define atYELLOW_ON_BROWN       (atYELLOW  |(atBROWN   <<4))
#define atYELLOW_ON_LGRAY       (atYELLOW  |(atLGRAY   <<4))
#define atYELLOW_ON_DGRAY       (atYELLOW  |(atDGRAY   <<4))
#define atYELLOW_ON_LBLUE       (atYELLOW  |(atLBLUE   <<4))
#define atYELLOW_ON_LGREEN      (atYELLOW  |(atLGREEN  <<4))
#define atYELLOW_ON_LCYAN       (atYELLOW  |(atLCYAN   <<4))
#define atYELLOW_ON_LRED        (atYELLOW  |(atLRED    <<4))
#define atYELLOW_ON_LMAGENTA    (atYELLOW  |(atLMAGENTA<<4))
#define atYELLOW_ON_YELLOW      (atYELLOW  |(atYELLOW  <<4))
#define atYELLOW_ON_WHITE       (atYELLOW  |(atWHITE   <<4))

#define atWHITE_ON_BLACK        (atWHITE   |(atBLACK   <<4))
#define atWHITE_ON_BLUE         (atWHITE   |(atBLUE    <<4))
#define atWHITE_ON_GREEN        (atWHITE   |(atGREEN   <<4))
#define atWHITE_ON_CYAN         (atWHITE   |(atCYAN    <<4))
#define atWHITE_ON_RED          (atWHITE   |(atRED     <<4))
#define atWHITE_ON_MAGENTA      (atWHITE   |(atMAGENTA <<4))
#define atWHITE_ON_BROWN        (atWHITE   |(atBROWN   <<4))
#define atWHITE_ON_LGRAY        (atWHITE   |(atLGRAY   <<4))
#define atWHITE_ON_DGRAY        (atWHITE   |(atDGRAY   <<4))
#define atWHITE_ON_LBLUE        (atWHITE   |(atLBLUE   <<4))
#define atWHITE_ON_LGREEN       (atWHITE   |(atLGREEN  <<4))
#define atWHITE_ON_LCYAN        (atWHITE   |(atLCYAN   <<4))
#define atWHITE_ON_LRED         (atWHITE   |(atLRED    <<4))
#define atWHITE_ON_LMAGENTA     (atWHITE   |(atLMAGENTA<<4))
#define atWHITE_ON_YELLOW       (atWHITE   |(atYELLOW  <<4))
#define atWHITE_ON_WHITE        (atWHITE   |(atWHITE   <<4))

//DESKTOP

struct Tdesktop_colors
{
  boolean solid;
  char normal;
  char bold;
};

//MENUS

struct Tmenus_colors
{
  char frame;
  char normal;
  char selected;
  char disabled;
  char disabled_selected;
  char shortcut;
};

//WINDOWS

struct Twindows_colors
{
  char frame_normal;
  char frame_selected;
  char icon_normal;
  char icon_selected;
  char icon_pressed;
  char title_normal;
  char title_selected;
  char shortcut;
  char standard_normal;
  char standard_bold;
  char standard_selected;
  char standard_disabled;
  char editor_normal;
  char editor_bold;
  char editor_selected;
  char editor_disabled;
  char tool_normal;
  char tool_bold;
  char tool_selected;
  char tool_disabled;
  char help_normal;
  char help_bold;
  char help_selected;
  char help_disabled;
  char alert_normal;
  char alert_bold;
  char alert_selected;
  char alert_disabled;
};

//BUTTONS

struct Tbuttons_colors
{
  char normal;
  char selected;
  char disabled;
  char _default;
  char pressed;
};

//DRAG & DROP

struct Tdrag_drop_colors
{
  char normal;
  char disabled;
};
#endif

#ifdef DECLARE_PVCOLORS

Tdesktop_colors pal_desktop;
Tmenus_colors pal_menus;
Twindows_colors pal_windows;
Tbuttons_colors pal_buttons;
Tdrag_drop_colors pal_drag_drop;

//DEFINITIONS FOR COLOR DISPLAY

Tdesktop_colors color_desktop =
{
/* solid      */ 0,
/* normal     */ atLGRAY_ON_DGRAY,
/* bold       */ atWHITE_ON_DGRAY
};

Tmenus_colors color_menus =
{
/* frame             */ atBLACK_ON_WHITE,
/* normal            */ atBLACK_ON_WHITE,
/* selected          */ atWHITE_ON_BLACK,
/* disabled          */ atLGRAY_ON_WHITE,
/* disabled_selected */ atLGRAY_ON_BLACK,
/* shortcut          */ atLRED
};

Twindows_colors color_windows =
{
/* frame_normal      */ atLGRAY,          //|0
/* frame_selected    */ atWHITE,          //|1
/* icon_normal       */ atLGRAY_ON_BLACK, //|2
/* icon_selected     */ atWHITE_ON_BLACK, //|3
/* icon_pressed      */ atWHITE_ON_LRED,  //|4
/* title_normal      */ atDGRAY_ON_LGRAY, //|5
/* title_selected    */ atBLACK_ON_WHITE, //|6
/* shortcut          */ atYELLOW,
/* standard_normal   */ atBLACK_ON_LGRAY,
/* standard_bold     */ atWHITE_ON_LGRAY,
/* standard_selected */ atWHITE_ON_BLACK,
/* standard_disabled */ atBLUE_ON_LGRAY,
/* editor_normal     */ atWHITE_ON_BLUE,
/* editor_bold       */ atYELLOW_ON_BLUE,
/* editor_selected   */ atWHITE_ON_LBLUE,
/* editor_disabled   */ atLGRAY_ON_BLUE,
/* tool_normal       */ atBLACK_ON_CYAN,
/* tool_bold         */ atWHITE_ON_CYAN,
/* tool_selected     */ atWHITE_ON_BLACK,
/* tool_disabled     */ atRED_ON_CYAN,
/* help_normal       */ atWHITE_ON_LBLUE,
/* help_bold         */ atYELLOW_ON_LBLUE,
/* help_selected     */ atYELLOW_ON_BLACK,
/* help_disabled     */ atRED_ON_LBLUE,
/* alert_normal      */ atWHITE_ON_RED,
/* alert_bold        */ atYELLOW_ON_RED,
/* alert_selected    */ atWHITE_ON_BLACK,
/* alert_disabled    */ atLGRAY_ON_RED
};

Tbuttons_colors color_buttons =
{
/* normal   */ atWHITE_ON_BLACK,
/* selected */ atYELLOW_ON_BLACK,
/* disabled */ atLGRAY_ON_BLACK,
/* default  */ atLCYAN_ON_BLACK,
/* pressed  */ atWHITE_ON_LRED
};

Tdrag_drop_colors color_drag_drop =
{
/* normal   */ atWHITE_ON_LBLUE,
/* disabled */ atWHITE_ON_LRED
};

//DEFINITIONS FOR BW DISPLAY

Tdesktop_colors bw_desktop =
{
/* solid      */ 0,
/* normal     */ atLGRAY_ON_DGRAY,
/* bold       */ atWHITE_ON_DGRAY
};

Tmenus_colors bw_menus =
{
/* frame             */ atBLACK_ON_WHITE,
/* normal            */ atBLACK_ON_WHITE,
/* selected          */ atWHITE_ON_BLACK,
/* disabled          */ atLGRAY_ON_WHITE,
/* disabled_selected */ atLGRAY_ON_BLACK,
/* shortcut          */ atLGRAY
};

Twindows_colors bw_windows =
{
/* frame_normal      */ atLGRAY, //|0
/* frame_selected    */ atWHITE, //|1
/* icon_normal       */ atLGRAY_ON_BLACK, //|2
/* icon_selected     */ atWHITE_ON_BLACK, //|3
/* icon_pressed      */ atWHITE_ON_LGRAY, //|4
/* title_normal      */ atBLACK_ON_LGRAY, //|5
/* title_selected    */ atBLACK_ON_WHITE, //|6
/* shortcut          */ atWHITE,
/* standard_normal   */ atBLACK_ON_LGRAY,
/* standard_bold     */ atWHITE_ON_LGRAY,
/* standard_selected */ atWHITE_ON_BLACK,
/* standard_disabled */ atDGRAY_ON_LGRAY,
/* editor_normal     */ atLGRAY_ON_BLACK,
/* editor_bold       */ atWHITE_ON_BLACK,
/* editor_selected   */ atLGRAY_ON_DGRAY,
/* editor_disabled   */ atDGRAY_ON_BLACK,
/* tool_normal       */ atBLACK_ON_LGRAY,
/* tool_bold         */ atWHITE_ON_LGRAY,
/* tool_selected     */ atWHITE_ON_BLACK,
/* tool_disabled     */ atDGRAY_ON_LGRAY,
/* help_normal       */ atBLACK_ON_LGRAY,
/* help_bold         */ atWHITE_ON_LGRAY,
/* help_selected     */ atWHITE_ON_BLACK,
/* help_disabled     */ atDGRAY_ON_LGRAY,
/* alert_normal      */ atBLACK_ON_LGRAY,
/* alert_bold        */ atWHITE_ON_LGRAY,
/* alert_selected    */ atWHITE_ON_BLACK,
/* alert_disabled    */ atDGRAY_ON_LGRAY
};

Tbuttons_colors bw_buttons =
{
/* normal   */ atLGRAY_ON_BLACK,
/* selected */ atWHITE_ON_BLACK,
/* disabled */ atDGRAY_ON_BLACK,
/* default  */ atWHITE_ON_BLACK,
/* pressed  */ atBLACK_ON_WHITE
};

Tdrag_drop_colors bw_drag_drop =
{
/* normal   */ atWHITE_ON_LGRAY,
/* disabled */ atBLACK_ON_LGRAY
};

#else

extern Tdesktop_colors pal_desktop;
extern Tmenus_colors pal_menus;
extern Twindows_colors pal_windows;
extern Tbuttons_colors pal_buttons;
extern Tdrag_drop_colors pal_drag_drop;

extern Tdesktop_colors bw_desktop;
extern Tmenus_colors bw_menus;
extern Twindows_colors bw_windows;
extern Tbuttons_colors bw_buttons;
extern Tdrag_drop_colors bw_drag_drop;

extern Tdesktop_colors color_desktop;
extern Tmenus_colors color_menus;
extern Twindows_colors color_windows;
extern Tbuttons_colors color_buttons;
extern Tdrag_drop_colors color_drag_drop;

#endif
