//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        TERRMON.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Terror_monitor class implementation  |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_string

#define uses_colors
#define uses_dc
#define uses_editor

#include "PVUSES.H"

#define _DECLARE_TERRMON_H
  #include "TERRMON.H"
#undef  _DECLARE_TERRMON_H


/*
public
*/
  Terror_monitor::Terror_monitor( char *error_msg, Titem *_editor ):
    Titem( _editor->xl, 1 )
  {
    grow_mode = gmGROW_HOR;
    set_flags( ifPRE_PROCESS, 1 );
    set_flags( ifSELECTABLE, 0 );
    msg = STRDUP( error_msg );
    _editor->put_in( this, 0, 0 );
    editor = (Tfile_editor *) _editor;
  }

  Terror_monitor::~Terror_monitor( void )
  {
    err_mon = NULL;
    FREE( msg );
  }

/*
protected
*/
  void Terror_monitor::draw( void )
  {
    int d, l;
    char *s;

    d = editor->delta_x;
    l = strlen( msg );
    if( d > l - xl ) d = max( 0, l - xl );
    s = msg+d;
    text_attr = pal_windows.alert_normal;
    direct_txt( s ); txtf( "|r%c ", xl - strlen( s ) );
  }

  void Terror_monitor::event_handler( Tevent &ev )
  {
    Titem::event_handler( ev );
    if( ev.code == evKEY_PRESS ) put_command( this, cmDONE );
  }
