//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        TLOG.CPP                             |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Tlog class implementation            |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdarg
#define uses_stdio
#define uses_string

#define uses_app
#define uses_desk
#define uses_editor
#define uses_ht
#define uses_system
#define uses_table

#include "PVUSES.H"
#include "TERRMON.H"

#define _DECLARE_TLOG_H
  #include "TLOG.H"
#undef  _DECLARE_TLOG_H


/*
LOG ENTRY
*/
  struct Tlog_entry
  {
    uint x;
    uint y;
    uint offset;
    char *message;
    char filename[_MAX_PATH];
  };
  #define TLOG_ENTRY_SIZE ( sizeof( Tlog_entry ) - _MAX_PATH )

  static void free_log_entry( void *p )
  {
    FREE( ( (Tlog_entry *) p)->message );
  }


/*
public
*/
  Tlog::Tlog( int _xl, int _yl ):
    Thide_on_close( _xl, _yl )
  {
    data_size = TLOG_ENTRY_SIZE;
    lb_item_killer = free_log_entry;
    local_key( this, cmLOG_GOTO, kENTER );
    scroll_ahead = 1;
  }

  #pragma off( unreferenced )
  void Tlog::editors_supervisor( char *file_name, uint where, int bytes, int lines )
  {
    Tlog_entry *me;
    uint i;

    for( i = 0; i < vcount; i++ )
    {
      me = (Tlog_entry *) getptr( i );
      if( ( *me->filename ) &&
          ( me->offset != (uint) -1 ) &&
          ( strcmp( file_name, me->filename ) == 0 ) &&
          ( me->offset >= where ) )
        me->offset = max( where, me->offset + bytes );
    }
  }
  #pragma on( unreferenced )

  void Tlog::clip_copy( void )
  {
    Tlog_entry *me;
    uint pos, i;

    clipboard->delete_select();
    pos = clipboard->cur_ptr;
    for( i = 0; i < vcount; i++ )
    {
      me = (Tlog_entry *) getptr( i );
      if( !clipboard->insert_string(me->message,0) ) break;
      clipboard->new_line();
    }
    clipboard->set_select( pos, clipboard->cur_ptr, 1 );
  }

  void Tlog::logout( char *text, ... )
  {
    Tlog_entry me;
    char buf[256];
    va_list argptr;
    va_start( argptr, text );
    vsprintf( buf, text, argptr );
    va_end( argptr );
    me.x = me.y = 0;
    me.offset = 0;
    me.message = STRDUP( buf );
    *me.filename = 0;
    add( &me );
    update_commands();
  }

  void Tlog::load( char *filename )
  {
    FILE *f;
    char buf[256], *s0, *s1, *s2, *s3, *p;
    Tlog_entry me;

    f = fopen( filename, "rt" );
    if( f == NULL ) return;
    while( !feof( f ) && ( fgets( buf, 255, f ) != NULL ) )
    {
      if( ( p = strchr( buf, '\n' ) ) != NULL ) *p = 0;
      s0 = buf;                          while( *s0 && ( *s0 == ' ' ) ) s0++;
      s1 = strchr( s0, ',' ); *s1++ = 0; while( *s1 && ( *s1 == ' ' ) ) s1++;
      s2 = strchr( s1, ',' ); *s2++ = 0; while( *s2 && ( *s2 == ' ' ) ) s2++;
      s3 = strchr( s2, ',' ); *s3++ = 0; while( *s3 && ( *s3 == ' ' ) ) s3++;
      me.x = atol( s2 ) - 1; me.y = atol( s1 ) - 1;
      me.offset = (uint) -1;
      me.message = STRDUP( s3 );
      strcpy( me.filename, s0 );
      if( *s0 ) fexpand( me.filename );
      add( &me );
    }
    fclose( f );
    Tlb_list::bottom();
    owner->resize( owner->xl, owner->yl );
    update_commands();
  }

  void Tlog::show_first_error( void )
  {
    Tlog_entry *me;
    uint i;

    if( !vcount ) return;
    win_log();
    Tlb_list::bottom();
    for( i = 0; i < vcount; i++ )
    {
      me = (Tlog_entry *) getptr( i );
      if( *me->filename != 0 )
      {
        Tlb_list::at( i );
        break;
      }
    }
    show_error( 1 );
  }

  #pragma off( unreferenced )
  void Tlog::fetch( char *buffer, uint row, uint column, uint width )
  {
    Tlog_entry *me = (Tlog_entry *) getptr( row );
    switch( column )
    {
      case 0:
        *buffer = 0;
        if( *me->filename==0 ) return;
        strcpy( buffer, me->filename );
        min_path( buffer );
        short_path( buffer, width );
        break;
      case 1:
        if( row==vcurrent ) text_attr = selected_attr;
        strncpy( buffer, me->message, 255 );
    }
  }
  #pragma on( unreferenced )

  void Tlog::show_error( boolean focused )
  {
    Tlog_entry *me, *me1;
    char *editor_name;
    int i;

    set_state( isHIDDEN, 0 );
    if( err_mon != NULL ) DELETE( err_mon );
    err_mon = NULL;
    if( vcurrent >= vcount ) return;
    me = (Tlog_entry *) getptr( vcurrent );
    if( *me->filename==0 )
    {
      focus();
      return;
    }
    for( Tfile_editor *f=open_editors; f!=NULL; f=f->next_editor )
      if( strcmp( me->filename, f->text_editor->file_name ) == 0 ) break;
    if( f==NULL && focused )
    {
      focus();
      return;
    }
    _help( htW_EDITOR );
    edit_file( me->filename );
    if( ( current_editor == NULL ) ||
        ( strcmp( editor_name = ((Tfile_editor *) current_editor->editor)->text_editor->file_name,
                  me->filename ) != 0 ) ) return;
    for( i = 0; i < vcount; i++ )
    {
      me1 = (Tlog_entry *) getptr( i );
      if( ( me1->offset == (uint) -1 ) && !strcmp( editor_name, me1->filename ) )
      {
        current_editor->set_cur_xy( me1->x, me1->y, 0 );
        me1->offset = current_editor->cur_ptr;
      }
    }
    current_editor->set_cur_ptr( me->offset, 0 );
    current_editor->editor->track_cursor( 1 );
    if( focused )
    {
      current_editor->set_select(
        current_editor->line_start( current_editor->cur_ptr ),
        current_editor->next_line( current_editor->cur_ptr ), 0 );
      focus();
    }
    else
      err_mon = NEW( Terror_monitor( me->message, current_editor->editor ) );
  }

  void Tlog::nexterr( boolean focused )
  {
    if( vcurrent + 1 >= vcount ) return;
    Tlb_list::down();
    redraw();
    show_error( focused );
  }

  void Tlog::preverr( boolean focused )
  {
    if( vcurrent == 0 ) return;
    Tlb_list::up();
    redraw();
    show_error( focused );
  }


/*
protected
*/
  void Tlog::event_handler( Tevent &ev )
  {
    uint v;

    v = vcurrent;
    Thide_on_close::event_handler( ev );
    if( v != vcurrent ) show_error( state( isFOCUSED ) );
    if( ev.code==evCOMMAND )
    {
      switch( ev.CMD_CODE )
      {
        case cmLOG_CLEAR:
          clear();
          break;
        case cmLOG_CLIP_COPY:
          clip_copy();
          break;
        case cmLOG_GOTO:
          if( state(isFOCUSED) )
          {
            show_error( 0 );
            break;
          }
        default:
          return;
      }
      redraw();
      handled( ev );
    }
  }

  void Tlog::update_commands( void )
  {
    cstate( cmLOG_GOTO, vcount );
    cstate( cmLOG_CLEAR, vcount );
    cstate( cmLOG_CLIP_COPY, vcount );
  }


/*
INTERFACE
*/
  void construct_log( void )
  {
    Ttable *tbl;

    if( log != NULL ) DELETE( log->owner->owner );
    _help( htW_LOGOUT );
    construct_table( "Log", log = NEW( Tlog( desktop_xl, desktop_yl / 3 ) ) );
      tdata( "Destination", 12, 12 );
      tdata( "Message", 255, 255 );
    _context( cxLOG );
    tbl = endt();
    tbl->set_title_vtab( -1 );
    ( (Twindow *) tbl->owner )->palette = wpTOOL;
    local_key( tbl->owner, cmOK, kENTER );
    tbl->owner->set_flags( ifTILEABLE, 0 );
    insert_window( tbl->owner, 0, desktop_yl - tbl->owner->yl );
  }

  void win_log( void )
  {
    log->set_state( isHIDDEN, 0 );
    log->owner->owner->set_state( isICONIZED, 0 );
    log->focus();
  }

  void log_nexterr( void )
  //show next compiler's error
  {
    log->nexterr( 0 );
  }

  void log_preverr( void )
  //show previous compiler's error
  {
    log->preverr( 0 );
  }
