 REM Help.bas v7.1a r1.0 - Symbolic Instruction Code; help module.
 REM The public domain DOS programming interpreter utility.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 ' backwards compatible for bc 7.1
 REM $INCLUDE: 'bc7.inc'

 ' declare global error routine
 ON ERROR GOTO Error.Routine

 ' initialize variables
 PageLength = 23
 Var$ = ENVIRON$("SICPAGELENGTH")
 IF LEN(Var$) THEN
    Temp# = INT(VAL(Var$))
    IF Temp# > 0# AND Temp# <= 32767# THEN
       PageLength = CINT(Temp#)
    END IF
 END IF

 ' run program from command line
 CALL List.Help
Error.Resume:
 COLOR Plain, Black
 WHILE INKEY$ <> Nul
 WEND
 PRINT "Exiting to system.."
 END

 ' standard error trap for all Sic functions.
Error.Routine:
 IF POS(0) > 1 THEN
    PRINT
 END IF
 COLOR White, Black
 PRINT "Help utility error";Err
 RESUME Error.Resume

' display help menu
SUB List.Help
 DO
    COLOR White, Black
    PRINT "Help utility SIC v" + Version + " r" + Release + " list:"
    COLOR Yellow, Black
    PRINT "[1]command list"
    PRINT "[2]general documentation"
    PRINT "[3]formatting information"
    PRINT "[4]screen mode tables"
    PRINT "[5]error code values"
    PRINT "[6]syntax documentation"
    PRINT "[7]boolean syntax/charts"
    PRINT "[8]troolean syntax/charts"
    PRINT "[9]disclaimer notice"
    PRINT "[A]shareware information"
    CALL More.Prompt("Enter(1-A, Q to quit)?", "123456789aq", Output.Char$)
    SELECT CASE Output.Char$
    CASE "1"
       COLOR White, Black
       PRINT "SIC created: " + PublishDate
       COLOR Yellow, Black
       PRINT "ANALYZE  --  checks program structure."
       PRINT "CONTINUE --  continue halted program."
       PRINT "DEBUG    --  immediate debug mode."
       PRINT "FILES    --  display programs."
       PRINT "HELP     --  lists help topics."
       PRINT "INDENT   --  formats current program."
       PRINT "KILL     --  delete program."
       PRINT "LIST     --  display current program."
       PRINT "LOAD     --  read program from disk."
       PRINT "NEW      --  erase current program."
       PRINT "PRINT    --  print current program."
       PRINT "QUIT     --  exit SIC interpreter."
       PRINT "RENUMBER --  renumber program."
       PRINT "RUN      --  start current program."
       PRINT "SAVE     --  store current program."
       PRINT "SEARCH   --  search program for keyword."
       PRINT "SHELL    --  exit to dos shell."
       PRINT "WHATIS   --  enter immediate mode."
       CALL Key.Prompt
    CASE "2"
       Filename = "sic.doc"
       CALL List.Help.File
    CASE "3"
       Filename = "sicform.doc"
       CALL List.Help.File
    CASE "4"
       Filename = "sicscrn.doc"
       CALL List.Help.File
    CASE "5"
       Filename = "error.doc"
       CALL List.Help.File
    CASE "6"
       Filename = "syntax.doc"
       CALL List.Help.File
    CASE "7"
       Filename = "boolean.doc"
       CALL List.Help.File
    CASE "8"
       Filename = "troolean.doc"
       CALL List.Help.File
    CASE "9"
       Filename = "disclaim.doc"
       CALL List.Help.File
    CASE "a"
       Filename = "disclam2.doc"
       CALL List.Help.File
    CASE "q"
       EXIT DO
    END SELECT
 LOOP
END SUB

' displays a help file
SUB List.Help.File
 CLOSE
 IF DIR$(Filename) = Nul THEN
    PRINT "Helpfile "; CHR$(34); Filename; CHR$(34); " not found."
    EXIT SUB
 END IF
 OPEN Filename FOR INPUT AS #1
 Continuous = False
 Line.Count = False
 DO WHILE NOT EOF(1)
    COLOR Yellow, Black
    LINE INPUT #1, Input.Line$
    PRINT Input.Line$
    IF Continuous = False THEN
       Line.Count = Line.Count + 1
       IF Line.Count = PageLength THEN
	  Line.Count = False
	  CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	  SELECT CASE Output.Char$
	  CASE "n"
	     EXIT DO
	  CASE "c"
	     Continuous = True
	  END SELECT
       END IF
    END IF
 LOOP
 CALL Key.Prompt
END SUB

' prompts for multiple input characters
SUB More.Prompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$; " ";
 Input.Char$ = Nul
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' prompts for a keystroke
SUB Key.Prompt
 COLOR White, Black
 LOCATE , , 1
 PRINT "Press any key to continue:";
 Input.Char$ = Nul
 DO
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       EXIT DO
    END IF
 LOOP
 PRINT
END SUB
