 REM Sicsub2.bas v7.2a r1.0 - Symbolic Instruction Code; module 3 of 3.
 REM The public domain DOS programming interpreter.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 REM Include file for BC 7.1 compiler:
 REM Remove remark from following lines:

Rem Declare Function FormatD$(byval a#, b$)
Rem Declare Function Now#()
Rem Declare Function Format$(x#, x$)

' accepts an operation and performs on two values, string or numeric
SUB Arith (Token.Parsed$, Temp#, Temp2#)
 IF Last.Token THEN
    SELECT CASE Token.Parsed$
    CASE "-"
       Temp# = Temp# - Temp2#
    CASE "+"
       Temp# = Temp# + Temp2#
    CASE "/"
       Temp# = Temp# / Temp2#
    CASE "\"
       Temp# = Temp# \ Temp2#
    CASE "*"
       Temp# = Temp# * Temp2#
    CASE "^"
       Temp# = Temp# ^ Temp2#
    CASE "<"
       Temp# = (Temp# < Temp2#)
    CASE ">"
       Temp# = (Temp# > Temp2#)
    CASE "="
       Temp# = (Temp# = Temp2#)
    CASE "<="
       Temp# = (Temp# <= Temp2#)
    CASE ">="
       Temp# = (Temp# >= Temp2#)
    CASE "<>"
       Temp# = (Temp# <> Temp2#)
    CASE "=="
       CaseValue1 = Temp#
       CaseValue2 = Temp2#
       Last.Token = 2
    CASE "|"
       Temp# = Temp# OR Temp2#
    CASE "&"
       Temp# = Temp# AND Temp2#
    CASE "%"
       Temp# = Temp# MOD Temp2#
    CASE "~"
       Temp# = Temp# XOR Temp2#
    CASE "?"
       Temp# = Temp# IMP Temp2#
    CASE ":"
       Temp# = Temp# EQV Temp2#
    CASE "#"
       Temp# = NOT (Temp# OR Temp2#)
    CASE "@"
       Temp# = NOT (Temp# IMP Temp2#)
    CASE "`"
       Temp# = NOT (Temp# AND Temp2#)
    END SELECT
    EXIT SUB
 END IF
 SELECT CASE Token.Parsed$
 CASE "-"
    IF RIGHT$(Out3, LEN(Out4)) = Out4 THEN
       Out3 = LEFT$(Out3, LEN(Out3) - LEN(Out4))
    END IF
 CASE "+"
    Out3 = Out3 + Out4
 CASE "/", "\"
    IF LEN(Out3) > False AND LEN(Out4) > False THEN
       Imbedded = INSTR(Out3, Out4)
       WHILE Imbedded
	  Out3 = LEFT$(Out3, Imbedded - 1) + MID$(Out3, Imbedded + LEN(Out4))
	  Imbedded = INSTR(Out3, Out4)
       WEND
    END IF
 CASE "<"
    Last.Token = True
    Temp# = Out3 < Out4
 CASE ">"
    Last.Token = True
    Temp# = Out3 > Out4
 CASE "="
    Last.Token = True
    Temp# = Out3 = Out4
 CASE "<="
    Last.Token = True
    Temp# = Out3 <= Out4
 CASE ">="
    Last.Token = True
    Temp# = Out3 >= Out4
 CASE "<>"
    Last.Token = True
    Temp# = Out3 <> Out4
 CASE "=="
    CaseValueS1 = Out3
    CaseValueS2 = Out4
    Last.Token = 2
 END SELECT
END SUB

' accepts an operation and performs on one numeric variable
SUB Assignment1 (TempS$, TempS3%)
 IF LEFT$(TempS$, 2) = "--" THEN
    Assign = True
    Variables(TempS3%) = Variables(TempS3%) - 1#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "++" THEN
    Assign = True
    Variables(TempS3%) = Variables(TempS3%) + 1#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "**" THEN
    Assign = True
    Variables(TempS3%) = Variables(TempS3%) ^ 2#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "//" THEN
    Assign = True
    Variables(TempS3%) = SQR(Variables(TempS3%))
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "-=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) - Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "+=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) + Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "/=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) / Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "\=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) \ Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "*=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) * Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "^=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) ^ Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 3) = "^-=" THEN
    Out2 = MID$(TempS$, 4)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) ^ (-Temp4#)
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "%=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) MOD Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "|=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) OR Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "&=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) AND Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "~=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) XOR Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "?=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) IMP Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = ":=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Variables(TempS3%) EQV Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "#=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = NOT (Variables(TempS3%) OR Temp4#)
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "@=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = NOT (Variables(TempS3%) IMP Temp4#)
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "`=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = NOT (Variables(TempS3%) AND Temp4#)
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 1) = "=" THEN
    Out2 = MID$(TempS$, 2)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Variables(TempS3%) = Temp4#
    END IF
    EXIT SUB
 END IF
END SUB

' accepts an operation and performs on one numeric array element
SUB Assignment2 (TempS$, TempS1%, TempS2%)
 IF LEFT$(TempS$, 2) = "--" THEN
    Assign = True
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) - 1#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "++" THEN
    Assign = True
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + 1#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "**" THEN
    Assign = True
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ 2#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "//" THEN
    Assign = True
    Arrays(TempS1%, TempS2%) = SQR(Arrays(TempS1%, TempS2%))
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "-=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) - Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "+=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "/=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) / Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "\=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) \ Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "*=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) * Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "^=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 3) = "^-=" THEN
    Out2 = MID$(TempS$, 4)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ (-Temp4#)
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "%=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) MOD Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "|=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) OR Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "&=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) AND Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "~=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) XOR Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "?=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) IMP Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = ":=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) EQV Temp4#
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "#=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = NOT (Arrays(TempS1%, TempS2%) OR Temp4#)
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "@=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = NOT (Arrays(TempS1%, TempS2%) IMP Temp4#)
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "`=" THEN
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = NOT (Arrays(TempS1%, TempS2%) AND Temp4#)
    END IF
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 1) = "=" THEN
    Out2 = MID$(TempS$, 2)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       Arrays(TempS1%, TempS2%) = Temp4#
    END IF
 END IF
END SUB

' gets a value and assigns to one register variable
SUB Assignment3 (TempS1$, TempS2$)
 SELECT CASE TempS2$
 CASE "AX"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       AX = Temp4#
    END IF
    EXIT SUB
 CASE "BX"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       BX = Temp4#
    END IF
    EXIT SUB
 CASE "CX"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       CX = Temp4#
    END IF
    EXIT SUB
 CASE "DX"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       DX = Temp4#
    END IF
    EXIT SUB
 CASE "BP"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       BP = Temp4#
    END IF
    EXIT SUB
 CASE "SI"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       SI = Temp4#
    END IF
    EXIT SUB
 CASE "DI"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       DI = Temp4#
    END IF
    EXIT SUB
 CASE "FL"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       FL = Temp4#
    END IF
    EXIT SUB
 CASE "DS"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       DS = Temp4#
    END IF
    EXIT SUB
 CASE "ES"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       ES = Temp4#
    END IF
    EXIT SUB
 END SELECT
END SUB

' gets a value and assigns to one error variable
SUB Assignment4 (TempS1$, TempS2$)
 SELECT CASE TempS2$
 CASE "ERR"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       ErrorValue = CINT(Temp4#)
    END IF
    EXIT SUB
 CASE "ERL"
    Out2 = TempS1$
    CALL Equate(Temp4#)
    IF Last.Token = True THEN
       Assign = True
       ErrorLine = CINT(Temp4#)
    END IF
    EXIT SUB
  END SELECT
END SUB

' entry to expression parser,
' each following parser is higher precedence,
' this routine called by higher precedence routines recursively.

REM precedence of operators (from highest to lowest):
REM   !, +, - Not, Unary plus, Unary Minus
REM   ^       Power
REM   *, /    Multiplication, Division
REM   \       Integer division
REM   %       Modulo
REM   +, -    Addition, Subtraction
REM   =, <, >, <>, >=, <= Relational
REM   |, &, ~, ?, :, #, @, ` Logical (or, and, xor, imp, eqv, nor, non, xan)

SUB Equate (Temp#)
 Last.Token = False
 Out3 = Nul ' reset string storage
 Out4 = Nul ' reset string concatenate storage
 Temp# = DFalse ' reset result
 Token.Index = 1 ' reset pointer to expression token
 CALL Get.Token ' read next token
 CALL Parse1(Temp#) ' entry to parse the expression
 ' parse leftover tokens
 WHILE LEN(Strng)
    CALL Parse1(X#)
    ' toss away any unwanted tokens
    IF Last.Token = 3 THEN
       IF Allow.Extra = False THEN
          Strng = "<extra token>"
          ERROR 92
       END IF
    END IF
 WEND
END SUB

' verifies next token is opening parenthesis.
SUB Get.Token3
 Strng = Nul
 Token = False
 IF MID$(Out2, Token.Index, 1) = " " THEN
    Token.Index = Token.Index + 1
 END IF
 IF Token.Index > LEN(Out2) THEN
    ERROR 138
 END IF
 ' locate parenthesis symbol
 Token.Element$ = MID$(Out2, Token.Index, 1)
 IF Token.Element$ = "(" THEN
    Token = 1 ' store token type
    Strng = Token.Element$ ' store token
    Token.Index = Token.Index + 1 ' increment pointer
    EXIT SUB
 END IF
 ERROR 138
END SUB

' verifies last token is closing parenthesis.
SUB Get.Token4
 ' locate parenthesis symbol
 IF Strng = ")" THEN
    EXIT SUB
 END IF
 ERROR 139
END SUB

' returns next token in string form,
' increments pointer to next token,
' determines token type.
SUB Get.Token
 Strng = Nul
 Token = False
 IF MID$(Out2, Token.Index, 1) = " " THEN
    Token.Index = Token.Index + 1
 END IF
 CALL Get.Token2(Token.Exists)
 IF Token.Exists THEN
    EXIT SUB
 END IF
 IF Token.Index > LEN(Out2) THEN
    Strng = Nul
    Token = False
    Token.Index = Token.Index + 1
    EXIT SUB
 END IF
 ' locate expression symbol
 Token.Element$ = MID$(Out2, Token.Index, 1)
 IF INSTR(Token.List, Token.Element$) THEN
    Token = 1 ' store token type
    Strng = Token.Element$ ' store token
    Token.Index = Token.Index + 1 ' increment pointer
    EXIT SUB
 END IF
 ' locate expression is number
 Token.Element$ = MID$(Out2, Token.Index, 1)
 IF Token.Element$ >= "0" AND Token.Element$ <= "9" THEN
    ' increment token until token is other than number
    DO
       IF LEN(Token.Element$) = False THEN
	  EXIT DO
       END IF
       IF INSTR(Token.List, Token.Element$) THEN
	  EXIT DO
       END IF
       Strng = Strng + Token.Element$
       Token.Index = Token.Index + 1
       Token.Element$ = MID$(Out2, Token.Index, 1)
    LOOP
    Token = 2 ' store token type
    EXIT SUB
 END IF
 ' locate expression is number beginning with decimal
 Token.Element$ = MID$(Out2, Token.Index, 1)
 IF Token.Element$ = "." THEN
    ' increment token until token is other than number
    DO
       IF LEN(Token.Element$) = False THEN
	  EXIT DO
       END IF
       IF INSTR(Token.List, Token.Element$) THEN
	  EXIT DO
       END IF
       Strng = Strng + Token.Element$
       Token.Index = Token.Index + 1
       Token.Element$ = MID$(Out2, Token.Index, 1)
    LOOP
    Token = 2 ' store token type
    EXIT SUB
 END IF
 ' locate expression is alphabetic
 Token.Element$ = UCASE$(MID$(Out2, Token.Index, 1))
 IF Token.Element$ >= "A" AND Token.Element$ <= "Z" THEN
    ' increment token until token is other than alphabetic
    DO
       IF LEN(Token.Element$) = False THEN
	  EXIT DO
       END IF
       IF INSTR(Token.List, Token.Element$) THEN
	  EXIT DO
       END IF
       Strng = Strng + Token.Element$
       Token.Index = Token.Index + 1
       Token.Element$ = UCASE$(MID$(Out2, Token.Index, 1))
    LOOP
    Token = 3 ' store token type
    EXIT SUB
 END IF
 ' store unknown token
 Token = False
 Strng = Token.Element$
 Token.Index = Token.Index + 1
END SUB

' returns next two-character token in string form,
' increments pointer to next token,
' determines token type.
SUB Get.Token2 (Token.Exists)
 Token.Exists = False
 Stored.Token$ = Out2
 IF MID$(Stored.Token$, Token.Index + 1, 1) = " " THEN
    Stored.Token$ = LEFT$(Stored.Token$, Token.Index) + MID$(Stored.Token$, Token.Index + 2)
 END IF
 ' locate expression symbols
 Next.Token$ = MID$(Stored.Token$, Token.Index, 2)
 SELECT CASE Next.Token$
 CASE ">=", "=>"
    GOSUB Remove.Spaces
    Token = 1 ' store token type
    Strng = ">=" ' store token
    Token.Index = Token.Index + 2 ' increment pointer
    Token.Exists = True
 CASE "<=", "=<"
    GOSUB Remove.Spaces
    Token = 1 ' store token type
    Strng = "<=" ' store token
    Token.Index = Token.Index + 2 ' increment pointer
    Token.Exists = True
 CASE "<>", "><"
    GOSUB Remove.Spaces
    Token = 1 ' store token type
    Strng = "<>" ' store token
    Token.Index = Token.Index + 2 ' increment pointer
    Token.Exists = True
 CASE "=="
    GOSUB Remove.Spaces
    Token = 1 ' store token type
    Strng = "==" ' store token
    Token.Index = Token.Index + 2 ' increment pointer
    Token.Exists = True
 END SELECT
 EXIT SUB
Remove.Spaces:
 ' locate space
 IF MID$(Out2, Token.Index + 1, 1) = " " THEN
    Out2 = LEFT$(Out2, Token.Index) + MID$(Out2, Token.Index + 2)
 END IF
 RETURN
END SUB

' parses out single variable tokens
SUB Parse.Alphabetic1 (Temp#)
 SELECT CASE UCASE$(Strng) ' test variable symbol
 CASE "A" TO "Z"
    Element = ASC(UCASE$(Strng)) - 64
    Element.Type$ = MID$(Out2, Token.Index, 1)
    SELECT CASE Element.Type$
    CASE "("
       CALL Get.Token
       CALL Get.Token
       CALL Parse1(Temp#)
       IF Strng = ")" THEN
          Temp# = Arrays(Element, CINT(Temp#))
          Last.Token = True
       ELSE
          Strng = "<missing closing token>"
          ERROR 92
       END IF
    CASE "["
       CALL Get.Token
       CALL Get.Token
       CALL Parse1(Temp#)
       IF Strng = "]" THEN
          Temp# = Arrays(Element, CINT(Temp#))
          Last.Token = True
       ELSE
          Strng = "<missing closing token>"
          ERROR 92
       END IF
    CASE "{"
       CALL Get.Token
       CALL Get.Token
       CALL Parse1(Temp#)
       IF Strng = "}" THEN
          Temp# = Arrays(Element, CINT(Temp#))
          Last.Token = True
       ELSE
          Strng = "<missing closing token>"
          ERROR 92
       END IF
    CASE ELSE
       Temp# = Variables(Element)
       Last.Token = True
    END SELECT
 CASE ELSE
    IF Allow.Alpha THEN
       Out3 = Strng
    ELSE
       Strng = "(" + Strng + ")"
       ERROR 92
    END IF
 END SELECT
END SUB

' parses out two-letter variable tokens
SUB Parse.Alphabetic2 (Temp#)
 SELECT CASE UCASE$(Strng)
 ' user defined functions
 CASE "FN"
    CALL ParseFN (Temp#)
 CASE "FZ"
    CALL ParseFZ (Temp#)
 ' interrupt functions
 CASE "AX"
    Temp# = AX
    Last.Token = True
 CASE "BX"
    Temp# = BX
    Last.Token = True
 CASE "CX"
    Temp# = CX
    Last.Token = True
 CASE "DX"
    Temp# = DX
    Last.Token = True
 CASE "BP"
    Temp# = BP
    Last.Token = True
 CASE "SI"
    Temp# = SI
    Last.Token = True
 CASE "DI"
    Temp# = DI
    Last.Token = True
 CASE "FL"
    Temp# = FL
    Last.Token = True
 CASE "DS"
    Temp# = DS
    Last.Token = True
 CASE "ES"
    Temp# = ES
    Last.Token = True
 ' functions w/o parameters
 CASE "PI" ' calculate PI
    Temp# = ATN(1#) * 4#
    Last.Token = True
 CASE "EX" ' calculate E
    Temp# = EXP(1#)
    Last.Token = True
 ' special case functions
 CASE "IS"
    CALL Get.Token
    Strng2$ = Strng
    CALL Get.Token
    CALL Parse1(Temp4#)
    Out4 = Out3
    Temp3# = CaseValue
    Out3 = CaseStrng
    Strng = Strng2$
    CALL Arith(Strng, Temp3#, Temp4#)
    ValueIs = Temp3#
    Last.Token = 1
 CASE "OR"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# OR Temp#
    Last.Token = True
 CASE ELSE
    IF MID$(Strng, 2, 1) = "$" THEN
       SELECT CASE UCASE$(LEFT$(Strng, 1))
       CASE "A" TO "Z"
	  Element = ASC(UCASE$(LEFT$(Strng, 1))) - 64
	  Out3 = Strngs(Element)
	  Last.Token = False
       END SELECT
    ELSE
       IF Allow.Alpha THEN
	  Out3 = Strng
       ELSE
          Strng = "[" + Strng + "]"
	  ERROR 92
       END IF
    END IF
 END SELECT
END SUB

' parses FN(<x>)
SUB ParseFN (Temp#)
 Var$ = LEFT$(Out2, Token.Index - 3)
 CALL Get.Token3
 CALL Get.Token
 CALL Parse1(Temp4#)
 CALL Get.Token4
 Func% = CINT(Temp4#)
 IF Func% >= 1 AND Func% <= Max.Functions THEN
    Var2$ = MID$(Out2, Token.Index)
    Out2 = Definitions(Func%)
    Out2 = STRIM$(Out2)
    ' test for nul token
    IF Out2 = Nul THEN
       Strng = "<bad FN token>"
       ERROR 148
    END IF
    ' count recursing calls
    Recurse = Recurse + 1
    IF Recurse > Max.Recurse THEN
       Strng = "<bad FN recurse>"
       ERROR 148
    END IF
    ' recursively call functions
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp#)
    ' test huge recursed FN
    IF LEN(Var$) + LEN(Var2$) >= 1024 THEN
       Var$ = Nul
       Var2$ = Nul
       Strng = "<bad FN string>
       ERROR 148
    END IF
    ' re-concatenate equation
    Out2 = Var$ + Var2$
    Token.Index = LEN(Var$) + 1
    EXIT SUB
 END IF
 Strng = "<bad FN range>"
 ERROR 148
END SUB

' parses FZ(<x>)
SUB ParseFZ (Temp#)
 CALL Get.Token3
 CALL Get.Token
 CALL Parse1(Temp4#)
 CALL Get.Token4
 Func% = CINT(Temp4#)
 IF Func% >= 1 AND Func% <= Max.Functions THEN
    Out3 = Definitions(Func%)
    Out3 = STRIM$(Out3)
    IF Out3 = Nul THEN
       Strng = "<bad FN token>"
       ERROR 149
    END IF
    Last.Token = False
    EXIT SUB
 END IF
 Strng = "<bad FN range>"
 ERROR 149
END SUB

' parses out three-letter and greater variable tokens
SUB Parse.Alphabetic3 (Temp#)
 SELECT CASE UCASE$(Strng)
 ' special purpose functions
 CASE "ISNT"
    CALL Get.Token
    Strng2$ = Strng
    CALL Get.Token
    CALL Parse1(Temp4#)
    Out4 = Out3
    Temp3# = CaseValue
    Out3 = CaseStrng
    Strng = Strng2$
    CALL Arith(Strng, Temp3#, Temp4#)
    ValueIs = NOT Temp3#
    Last.Token = 1
 CASE "SCREEN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Xcoor# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Ycoor# = Temp#
    Temp# = SCREEN(Xcoor#, Ycoor#)
    CALL Get.Token4
    Last.Token = True
 CASE "POINT"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Xcoor# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Ycoor# = Temp#
    Temp# = POINT(Xcoor#, Ycoor#)
    CALL Get.Token4
    Last.Token = True
 ' functions w/o parameters
 CASE "FALSE"
    Temp# = DFalse
    Last.Token = True
 CASE "TRUE"
    Temp# = DTrue
    Last.Token = True
 CASE "TIMER"
    Temp# = TIMER
    Last.Token = True
 CASE "FREEFILE"
    File.Num% = FREEFILE
    IF File.Num% >= 1 AND File.Num% <= 255 THEN
       Temp# = CDBL(File.Num%)
    ELSE
       Temp# = DFalse
    END IF
    Last.Token = True
 CASE "RND"
    Temp# = RND
    Last.Token = True
 CASE "POS"
    Temp# = POS(0)
    Last.Token = True
 CASE "CSRLIN"
    Temp# = CSRLIN
    Last.Token = True
 CASE "ERR"
    Temp# = CLNG(ErrorValue)
    Last.Token = True
 CASE "ERL"
    Temp# = CLNG(ErrorLine)
    Last.Token = True
 CASE "ARRAYSIZE"
    Temp# = CDBL(Array.Size)
    Last.Token = True
 ' boolean functions
 CASE "AND"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# AND Temp#
    CALL Get.Token4
    Last.Token = True
 CASE "MOD"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# MOD Temp#
    CALL Get.Token4
    Last.Token = True
 CASE "NOR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = NOT (Number# OR Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "NON"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = NOT (Number# IMP Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "XAN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = NOT (Number# AND Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "XOR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# XOR Temp#
    CALL Get.Token4
    Last.Token = True
 CASE "IMP"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# IMP Temp#
    CALL Get.Token4
    Last.Token = True
 CASE "EQV"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# EQV Temp#
    CALL Get.Token4
    Last.Token = True
 CASE "NOT"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = NOT Temp#
    CALL Get.Token4
    Last.Token = True
 ' third-order boolean
 CASE "TAND"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number1# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Number2# = Temp#
    CALL Get.Token4
    SELECT CASE Number1#
    CASE -1,0,1
       SELECT CASE Number2#
       CASE -1,0,1
          Temp# = Number1# AND Number2#
          Last.Token = True
          EXIT SUB
       END SELECT
    END SELECT
    ERROR 2
 CASE "TOR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number1# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Number2# = Temp#
    CALL Get.Token4
    SELECT CASE Number1#
    CASE -1,0,1
       SELECT CASE Number2#
       CASE -1,0,1
          Temp# = Number1# OR Number2#
          Last.Token = True
          EXIT SUB
       END SELECT
    END SELECT
    ERROR 2
 CASE "TXOR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number1# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Number2# = Temp#
    CALL Get.Token4
    SELECT CASE Number1#
    CASE -1,0,1
       SELECT CASE Number2#
       CASE -1,0,1
          Temp# = Number1# XOR Number2#
          Last.Token = True
          EXIT SUB
       END SELECT
    END SELECT
    ERROR 2
 ' date/time functions
 CASE "CLOCK"
    Temp# = NOW
    Last.Token = True
 CASE "DATE$"
    Out3 = DATE$
    Last.Token = False
 CASE "TIME$"
    Out3 = TIME$
    Last.Token = False
 ' input functions
 CASE "INKEY$"
    ' check if program is redirected
    IF Program.Resume = 1 THEN
       ' store environment input character
       IF StdinInput1 THEN
          Out3 = CHR$(StdinInput1)
          EXIT SUB
       END IF
    END IF
    ' read keyboard directly
    LOCATE , , Visible
    IF KeyIS THEN
       Out3 = KeyboardChar$
    ELSE
       Out3 = Nul
    END IF
    Last.Token = False
 CASE "INPUT$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Temp# <= 0# OR Temp# > 32767# THEN
       ERROR 2 ' syntax error
    END IF
    Chars% = CINT(Temp#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp#)
       File.Num% = CINT(Temp#)
       Out3 = INPUT$(Chars%, File.Num%)
    ELSE
       ' check if program is redirected
       IF Program.Resume = 1 THEN
          ' store environment input character
          IF LEN(StdinInput2) THEN
             Out3 = StdinInput2
             EXIT SUB
          END IF
       END IF
       ' read keyboard directly
       LOCATE , , Visible
       Out3 = Nul
       DO
          IF KeyIS THEN ' test keyboard
             Out3 = Out3 + KeyboardChar$ ' get character
             IF LEN(Out3) = Chars% THEN ' check length
                EXIT DO
             END IF
          END IF

          ' release time slice in tight loop
          CALL Release.Time(1)

          ' exit input loop for control-break
          IF ControlBreak THEN
             EXIT DO
          END IF
       LOOP
    END IF
    CALL Get.Token4
    Last.Token = False
 ' special input loop time slice releaser
 CASE "SLICE$"
    Out3 = Nul
    Last.Token = False
    CALL Release.Time(1)
 ' conversion/calculation functions
 CASE "BIN$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = Nul
    IF Temp# >= False THEN
       Digits = False
       DO
	  IF 2 ^ (Digits + 1) > Temp# THEN
	     EXIT DO
	  END IF
	  Digits = Digits + 1
       LOOP
       FOR Power = Digits TO 0 STEP -1
	  IF Temp# - 2 ^ Power >= False THEN
	     Temp# = Temp# - 2 ^ Power
	     Out3 = Out3 + "1"
	  ELSE
	     Out3 = Out3 + "0"
	  END IF
       NEXT
    END IF
    CALL Get.Token4
    Last.Token = False
 CASE "CHR$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = CHR$(Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "HEX$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = HEX$(Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "OCT$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = OCT$(Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "STR$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = STR$(Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "LCASE$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LCASE$(Out3)
    CALL Get.Token4
    Last.Token = False
 CASE "UCASE$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = UCASE$(Out3)
    CALL Get.Token4
    Last.Token = False
 CASE "LTRIM$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LTRIM$(Out3)
    CALL Get.Token4
    Last.Token = False
 CASE "RTRIM$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = RTRIM$(Out3)
    CALL Get.Token4
    Last.Token = False
 CASE "TRIM$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LTRIM$(Out3)
    Out3 = RTRIM$(Out3)
    CALL Get.Token4
    Last.Token = False
 CASE "TTRIM$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LTRIM$(Out3)
    Out3 = RTRIM$(Out3)
    Out3 = TTRIM$(Out3, True)
    CALL Get.Token4
    Last.Token = False
 CASE "UTRIM$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LTRIM$(Out3)
    Out3 = RTRIM$(Out3)
    Out3 = TTRIM$(Out3, False)
    CALL Get.Token4
    Last.Token = False
 CASE "STRIP$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LTRIM$(Out3)
    Out3 = RTRIM$(Out3)
    WHILE INSTR(Out3, " ")
       Variable = INSTR(Out3, " ")
       Out3 = LEFT$(Out3, Variable - 1) + MID$(Out3, Variable + 1)
    WEND
    CALL Get.Token4
    Last.Token = False
 CASE "SPACE$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = SPACE$(CINT(Temp#))
    CALL Get.Token4
    Last.Token = False
 CASE "FORMAT$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Value# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = FORMAT$(Value#, Out3)
    CALL Get.Token4
    Last.Token = False
 CASE "MID$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp4# = Temp#
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp#)
       Length# = Temp#
       Out3 = MID$(Out3, Temp4#, Length#)
    ELSE
       Out3 = MID$(Out3, Temp4#)
    END IF
    CALL Get.Token4
    Last.Token = False
 CASE "REMID$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp4# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Length# = Temp#
    Out3 = LEFT$(Out3, Temp4# - 1) + MID$(Out3, Temp4# + Length#)
    CALL Get.Token4
    Last.Token = False
 CASE "DEMID$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    String1$ = Out3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF LEN(String1$) > False AND LEN(Out3) > False THEN
       Imbedded = INSTR(String1$, Out3)
       WHILE Imbedded
          String1$ = LEFT$(String1$, Imbedded - 1) + MID$(String1$, Imbedded + LEN(Out3))
	  Imbedded = INSTR(String1$, Out3)
       WEND
    END IF
    Out3 = String1$
    CALL Get.Token4
    Last.Token = False
 CASE "REPLACE$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    String1$ = Out3
    CALL Get.Token
    CALL Parse1(Temp#)
    String2$ = Out3
    CALL Get.Token
    CALL Parse1(Temp#)
    String3$ = Out3
    IF String1$ = Nul OR String2$ = Nul OR String2$ = String3$ THEN
       Out3 = String1$
       EXIT SUB
    END IF
    Temp1 = 1
    DO
       IF String1$ = Nul THEN
	  EXIT DO
       END IF
       Var1 = INSTR(Temp1, String1$, String2$)
       IF Var1 = False THEN
	  EXIT DO
       END IF
       String1$ = LEFT$(String1$, Var1 - 1) + String3$ + MID$(String1$, Var1 + LEN(String2$))
       Temp1 = Temp1 + LEN(String3$)
    LOOP
    Out3 = String1$
    CALL Get.Token4
    Last.Token = False
 CASE "LEFT$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LEFT$(Out3, Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "RIGHT$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = RIGHT$(Out3, Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "STRING$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Out3 = STRING$(Number#, Temp#)
    ELSE
       Out3 = STRING$(Number#, Out3)
    END IF
    CALL Get.Token4
    Last.Token = False
 ' constant functions
 CASE "AUTHOR$"
    Out3 = Statements(139)
    Last.Token = False
 CASE "EMAIL$"
    Out3 = Statements(140)
    Last.Token = False
 CASE "URL$"
    Out3 = Statements(141)
    Last.Token = False
 CASE "VERSION$"
    Out3 = Version
    Last.Token = False
 CASE "RELEASE$"
    Out3 = Release
    Last.Token = False
 CASE "COMMAND$"
    Out3 = CommandLine
    Last.Token = False
 CASE "PROGRAM$"
    Out3 = Program.Name
    Last.Token = False
 CASE "PUBLISH$"
    Out3 = PublishDate
    Last.Token = False
 CASE "COOKIE$"
    Out3 = "You owe me a sugar cookie for writing this program and I want it now!!"
    Last.Token = False
 CASE "OS$"
    Out3 = OperatingSystem
    Last.Token = False
 ' numeric constant functions
 CASE "MAXARRAYS"
    Temp#=Max.Arrays
    Last.Token = True
 CASE "MAXFUNCTIONS"
    Temp#=Max.Functions
    Last.Token = True
 CASE "MAXLINES"
    Temp#=Max.Lines
    Last.Token = True
 ' keyboard shift state
 CASE "FLAGS"
    DEF SEG = 0
    Temp# = PEEK(&H417)
    Last.Token = True
    IF InDEFSEG THEN
       DEF SEG = DEFSEGvalue
    ELSE
       DEF SEG
    END IF
 ' other functions
 CASE "PMAP"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number% = CINT(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Map.Type% = CINT(Temp#)
    Temp# = PMAP(Number%, Map.Type%)
    CALL Get.Token4
    Last.Token = True
 CASE "VARSEG"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Var.Seg2 = Temp#
       Temp# = VARSEG(Var.Seg2)
    ELSE
       Length = LEN(Out3)
       REDIM Var.Seg3(1 TO Length) AS INTEGER
       FOR Count = 1 TO Length
	  Var.Seg3(Count) = ASC(MID$(Out3, Count, 1))
       NEXT
       Temp# = VARSEG(Var.Seg3(1))
    END IF
    CALL Get.Token4
    Last.Token = True
 CASE "VARPTR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Var.Seg2 = Temp#
       Temp# = VARPTR(Var.Seg2)
    ELSE
       Length = LEN(Out3)
       REDIM Var.Seg3(1 TO Length) AS INTEGER
       FOR Count = 1 TO Length
	  Var.Seg3(Count) = ASC(MID$(Out3, Count, 1))
       NEXT
       Temp# = VARPTR(Var.Seg3(1))
    END IF
    CALL Get.Token4
    Last.Token = True
 CASE "VARPTR$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Var.Seg1 = Out3
    Out3 = VARPTR$(Var.Seg1)
    CALL Get.Token4
    Last.Token = False
 CASE "BUFFER"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Case.Value = Temp#
    SELECT CASE Case.Value
    CASE 1
       Temp# = Var.Seg2
       Last.Token = True
    CASE 2
       Out3 = Nul
       Length = UBOUND(Var.Seg3)
       FOR Count = 1 TO Length
	  Out3 = Out3 + CHR$(Var.Seg3(Count))
       NEXT
       Last.Token = False
    CASE 3
       Elements = INT((Array.Size + 1) / 2)
       FOR Count = 1 TO Elements
	  Graphics.Screen(Count) = Var.Seg3(Count)
       NEXT
       Last.Token = True
    END SELECT
    CALL Get.Token4
 CASE "GRPHSEG"
    Elements = INT((Array.Size + 1) / 2)
    REDIM Var.Seg3(1 TO Elements) AS INTEGER
    FOR Count = 1 TO Elements
       Var.Seg3(Count) = Graphics.Screen(Count)
    NEXT
    Temp# = VARSEG(Var.Seg3(1))
    Last.Token = True
 CASE "GRPHPTR"
    Elements = INT((Array.Size + 1) / 2)
    REDIM Var.Seg3(1 TO Elements) AS INTEGER
    FOR Count = 1 TO Elements
       Var.Seg3(Count) = Graphics.Screen(Count)
    NEXT
    Temp# = VARPTR(Var.Seg3(1))
    Last.Token = True
 CASE "PLAY"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = PLAY(Temp#)
    CALL Get.Token4
    Last.Token = True
 ' more numeric functions
 CASE "ABS"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ABS(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "ASC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ASC(Out3)
    CALL Get.Token4
    Last.Token = True
 CASE "ATN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ATN(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "COS"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = COS(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "COT"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = COS(Temp#) / SIN(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "CSC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 1# / SIN(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "EXP"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = EXP(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "FBN" ' calculate xth fibonachi value
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Fibo.A# = 1
    Fibo.B# = 1
    IF Temp# >= 1 THEN
       FOR Fibo.Number# = 1 TO Temp# - 1
          Fibo.Temp# = Fibo.B#
          Fibo.B# = Fibo.A# + Fibo.B#
          Fibo.A# = Fibo.Temp#
       NEXT
    END IF
    Temp# = Fibo.B#
    CALL Get.Token4
    Last.Token = True
 CASE "FCT"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Factorial# = 1
    Factorial.Count# = INT(Temp#)
    IF Factorial.Count# >= 1 THEN
       FOR Factorial.Count# = 1 TO Temp#
	  Factorial# = Factorial# * Factorial.Count#
       NEXT
    END IF
    Temp# = Factorial#
    CALL Get.Token4
    Last.Token = True
 CASE "FIX"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = FIX(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "INP"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = INP(CINT(Temp#))
    CALL Get.Token4
    Last.Token = True
 CASE "INSTR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Temp4# = Temp#
       CALL Get.Token
       CALL Parse1(Temp#)
       Stored.String$ = Out3
       CALL Get.Token
       CALL Parse1(Temp#)
    ELSE
       Temp4# = 1#
       Stored.String$ = Out3
       CALL Get.Token
       CALL Parse1(Temp#)
    END IF
    Temp# = INSTR(Temp4#, Stored.String$, Out3)
    CALL Get.Token4
    Last.Token = True
 CASE "FRE"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       value# = Temp#
       Temp# = FRE(value#)
    ELSE
       Temp# = FRE(Out3)
    END IF
    CALL Get.Token4
    Last.Token = True
 CASE "INT"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = INT(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "LEN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = CDBL(LEN(Out3))
    CALL Get.Token4
    Last.Token = True
 CASE "LOG"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LOG(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "PRM" ' calculate xth prime
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Prime.Number# = INT(Temp#)
    Prime# = 1
    IF Prime.Number# > False THEN
       Prime.Counter# = False
       DO
	  Prime# = Prime# + 1
	  Prime.Flag = False
          FOR Factor# = 2 TO INT(SQR(Prime#))
             IF Prime# / Factor# = INT(Prime# / Factor#) THEN
		Prime.Flag = True
		EXIT FOR
	     END IF
	  NEXT
	  IF Prime.Flag = False THEN
	     Prime.Counter# = Prime.Counter# + 1
	  END IF
	  IF Prime.Counter# = Prime.Number# THEN
	     EXIT DO
	  END IF
       LOOP
    END IF
    Temp# = Prime#
    CALL Get.Token4
    Last.Token = True
 CASE "SEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 1# / COS(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "SGN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = SGN(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "SIN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = SIN(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "SQR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = SQR(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "CBR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Temp# ^ (1# / 3#)
    CALL Get.Token4
    Last.Token = True
 CASE "NTH"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# ^ (1# / Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "PWR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# ^ Temp#
    CALL Get.Token4
    Last.Token = True
 CASE "TAN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = TAN(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "VAL"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = VAL(Out3)
    CALL Get.Token4
    Last.Token = True
 CASE "PEEK"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = PEEK(Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE "MKI$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = MKI$(Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "MKS$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = MKS$(Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "MKD$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = MKD$(Temp#)
    CALL Get.Token4
    Last.Token = False
 CASE "CVI"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = CVI(Out3)
    CALL Get.Token4
    Last.Token = True
 CASE "CVS"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = CVS(Out3)
    CALL Get.Token4
    Last.Token = True
 CASE "CVD"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = CVD(Out3)
    CALL Get.Token4
    Last.Token = True
 CASE "EOF"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp3#)
    Temp# = EOF(CINT(Temp3#))
    CALL Get.Token4
    Last.Token = True
 CASE "LOC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp3#)
    Temp# = LOC(CINT(Temp3#))
    CALL Get.Token4
    Last.Token = True
 CASE "LOF"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp3#)
    Temp# = LOF(CINT(Temp3#))
    CALL Get.Token4
    Last.Token = True
 CASE "EOD" ' end-of-data
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp3#)
    CALL Get.Token4
    CALL Read.Data.Element(More.Data)
    IF More.Data = False THEN
       DataNumber = DataNumber - 1
    END IF
    Temp# = CLNG(More.Data)
    Last.Token = True
 CASE "TOD" ' type-of-data
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp3#)
    CALL Get.Token4
    CALL Read.Data.Element(More.Data)
    IF More.Data = False THEN
       DataNumber = DataNumber - 1
       IF Last.Token THEN
	  Temp# = 1#
       ELSE
	  Temp# = 2#
       END IF
    ELSE
       Temp# = DFalse
    END IF
    Last.Token = True
 ' disk functions
 CASE "DIR$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Out3 = Nul THEN
       Out3 = DIR$
    ELSE
       Out3 = DIR$(Out3)
    END IF
    CALL Get.Token4
    Last.Token = False
 CASE "CURDIR$"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Out3 = Nul THEN
       Out3 = CURDIR$("")
    ELSE
       Out3 = CURDIR$(Out3)
    END IF
    CALL Get.Token4
    Last.Token = False
 CASE "DRV"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Drive.Number% = CINT(Temp#)
    ELSE
       Drive.Number% = CINT(ASC(UCASE$(Out3)) - 64)
    END IF
    CALL Get.Token4
    Last.Token = True
    InregsX.AX = &H3600
    InregsX.DX = Drive.Number%
    CALL InterruptX(&H21, InregsX, OutregsX)
    Temp# = DFalse
    IF OutregsX.AX = &HFFFF THEN
       EXIT SUB
    END IF
    ASCIZ = CHR$(Drive.Number% + 64) + ":\" + CHR$(0)
    InregsX.AX = &H7303
    InregsX.DS = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    InregsX.ES = VARSEG(FAT32Struc)
    InregsX.DI = VARPTR(FAT32Struc)
    InregsX.CX = LEN(FAT32Struc)
    CALL InterruptX(&H21, InregsX, OutregsX)
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       IF (OutregsX.AX AND &HFF) <> 0 THEN
          Bytes# = CLNG(ASC(MID$(FAT32Struc.BytesPerSector, 1, 1)))
          Bytes# = Bytes# + CLNG(ASC(MID$(FAT32Struc.BytesPerSector, 2, 1))) * 256#
          Bytes# = Bytes# + CLNG(ASC(MID$(FAT32Struc.BytesPerSector, 3, 1))) * 65536#
          Bytes# = Bytes# + CLNG(ASC(MID$(FAT32Struc.BytesPerSector, 4, 1))) * 16777216#
          Sectors# = CLNG(ASC(MID$(FAT32Struc.FreeSectors, 1, 1)))
          Sectors# = Sectors# + CLNG(ASC(MID$(FAT32Struc.FreeSectors, 2, 1))) * 256#
          Sectors# = Sectors# + CLNG(ASC(MID$(FAT32Struc.FreeSectors, 3, 1))) * 65536#
          Sectors# = Sectors# + CLNG(ASC(MID$(FAT32Struc.FreeSectors, 4, 1))) * 16777216#
          Temp# = Bytes# * Sectors#
          EXIT SUB
       END IF
    END IF
    InregsX.AX = &H3600
    InregsX.DX = Drive.Number%
    CALL InterruptX(&H21, InregsX, OutregsX)
    IF OutregsX.AX < False THEN
       Sectors# = CDBL(OutregsX.AX + 65536)
    ELSE
       Sectors# = CDBL(OutregsX.AX)
    END IF
    IF OutregsX.BX < False THEN
       Clusters# = CDBL(OutregsX.BX + 65536)
    ELSE
       Clusters# = CDBL(OutregsX.BX)
    END IF
    IF OutregsX.CX < False THEN
       Bytes# = CDBL(OutregsX.CX + 65536)
    ELSE
       Bytes# = CDBL(OutregsX.CX)
    END IF
    Temp# = Sectors# * Clusters# * Bytes#
 CASE "TDRV"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Drive.Number% = CINT(Temp#)
    ELSE
       Drive.Number% = CINT(ASC(UCASE$(Out3))-64)
    END IF
    Last.Token = True
    CALL Get.Token4
    InregsX.AX = &H3600
    InregsX.DX = Drive.Number%
    CALL InterruptX(&H21, InregsX, OutregsX)
    Temp# = DFalse
    IF OutregsX.AX = &HFFFF THEN
       EXIT SUB
    END IF
    ASCIZ = CHR$(Drive.Number% + 64) + ":\" + CHR$(0)
    InregsX.AX = &H7303
    InregsX.DS = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    InregsX.ES = VARSEG(FAT32Struc)
    InregsX.DI = VARPTR(FAT32Struc)
    InregsX.CX = LEN(FAT32Struc)
    CALL InterruptX(&H21, InregsX, OutregsX)
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       IF (OutregsX.AX AND &HFF) <> 0 THEN
          Bytes# = CLNG(ASC(MID$(FAT32Struc.BytesPerSector, 1, 1)))
          Bytes# = Bytes# + CLNG(ASC(MID$(FAT32Struc.BytesPerSector, 2, 1))) * 256#
          Bytes# = Bytes# + CLNG(ASC(MID$(FAT32Struc.BytesPerSector, 3, 1))) * 65536#
          Bytes# = Bytes# + CLNG(ASC(MID$(FAT32Struc.BytesPerSector, 4, 1))) * 16777216#
          Sectors# = CLNG(ASC(MID$(FAT32Struc.TotalSectors, 1, 1)))
          Sectors# = Sectors# + CLNG(ASC(MID$(FAT32Struc.TotalSectors, 2, 1))) * 256#
          Sectors# = Sectors# + CLNG(ASC(MID$(FAT32Struc.TotalSectors, 3, 1))) * 65536#
          Sectors# = Sectors# + CLNG(ASC(MID$(FAT32Struc.TotalSectors, 4, 1))) * 16777216#
          Temp# = Bytes# * Sectors#
          EXIT SUB
       END IF
    END IF
    InregsX.AX = &H3600
    InregsX.DX = Drive.Number%
    CALL InterruptX(&H21, InregsX, OutregsX)
    IF OutregsX.AX < False THEN
       Sectors# = CDBL(OutregsX.AX + 65536)
    ELSE
       Sectors# = CDBL(OutregsX.AX)
    END IF
    IF OutregsX.CX < False THEN
       Clusters# = CDBL(OutregsX.CX + 65536)
    ELSE
       Clusters# = CDBL(OutregsX.CX)
    END IF
    IF OutregsX.DX < False THEN
       Bytes# = CDBL(OutregsX.DX + 65536)
    ELSE
       Bytes# = CDBL(OutregsX.DX)
    END IF
    Temp# = Sectors# * Clusters# * Bytes#
 CASE "FILESIZE"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = DFalse
    IF Last.Token = False THEN
       IF LEN(Out3) THEN
	  Last.Token = True
	  ASCIZ = Out3 + CHR$(0)
	  ' restore directory search dta
	  InregsX.AX = &H1A00
          InregsX.DS = VARSEG(ParseDTA)
          InregsX.DX = VARPTR(ParseDTA)
	  CALL InterruptX(&H21, InregsX, OutregsX)
	  ' find first filename
	  InregsX.AX = &H4E00
	  InregsX.CX = &H27
	  InregsX.DS = VARSEG(ASCIZ)
	  InregsX.DX = VARPTR(ASCIZ)
	  CALL InterruptX(&H21, InregsX, OutregsX)
	  ' check findfirst error
	  IF (OutregsX.Flags AND &H1) = &H0 THEN
	     ' store file size
	     Temp# = DFalse
             Temp# = Temp# + ASC(MID$(ParseDTA.FileSize, 4, 1))
             Temp# = Temp# * &H100 + ASC(MID$(ParseDTA.FileSize, 3, 1))
             Temp# = Temp# * &H100 + ASC(MID$(ParseDTA.FileSize, 2, 1))
             Temp# = Temp# * &H100 + ASC(MID$(ParseDTA.FileSize, 1, 1))
	  END IF
	  ' restore basic dta
	  InregsX.AX = &H1A00
	  InregsX.DS = BASIC.DTA.SEG
	  InregsX.DX = BASIC.DTA.OFF
	  CALL InterruptX(&H21, InregsX, OutregsX)
       END IF
    END IF
    CALL Get.Token4
 CASE "FILEATTR"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = DFalse
    IF Last.Token = False THEN
       IF LEN(Out3) THEN
	  Last.Token = True
	  ASCIZ = Out3 + CHR$(0)
	  ' restore directory search dta
	  InregsX.AX = &H1A00
          InregsX.DS = VARSEG(ParseDTA)
          InregsX.DX = VARPTR(ParseDTA)
	  CALL InterruptX(&H21, InregsX, OutregsX)
	  ' find first filename
	  InregsX.AX = &H4E00
	  InregsX.CX = &H37
	  InregsX.DS = VARSEG(ASCIZ)
	  InregsX.DX = VARPTR(ASCIZ)
	  CALL InterruptX(&H21, InregsX, OutregsX)
	  ' check findfirst error
          IF (OutregsX.Flags AND &H1) = &H0 THEN
             ' store file attribute
             Temp# = ASC(ParseDTA.FileAttr)
	  END IF
	  ' restore basic dta
	  InregsX.AX = &H1A00
	  InregsX.DS = BASIC.DTA.SEG
	  InregsX.DX = BASIC.DTA.OFF
	  CALL InterruptX(&H21, InregsX, OutregsX)
       END IF
    END IF
    CALL Get.Token4
 CASE "FILEDATE"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = DFalse
    IF Last.Token = False THEN
       IF LEN(Out3) THEN
	  ASCIZ = Out3 + CHR$(0)
	  Out3 = Nul
	  ' restore directory search dta
	  InregsX.AX = &H1A00
          InregsX.DS = VARSEG(ParseDTA)
          InregsX.DX = VARPTR(ParseDTA)
	  CALL InterruptX(&H21, InregsX, OutregsX)
	  ' find first filename
	  InregsX.AX = &H4E00
	  InregsX.CX = &H27
	  InregsX.DS = VARSEG(ASCIZ)
	  InregsX.DX = VARPTR(ASCIZ)
	  CALL InterruptX(&H21, InregsX, OutregsX)
	  ' check findfirst error
	  IF (OutregsX.Flags AND &H1) = &H0 THEN
	     ' store file date
             Work! = ASC(MID$(ParseDTA.FileDate, 2, 1))
             Work! = Work! * &H100 + ASC(MID$(ParseDTA.FileDate, 1, 1))
             YearTemp! = INT(Work! / 512)
             MonthTemp! = INT((Work! AND &H1E0) / 32)
             DayTemp! = INT(Work! AND &H1F)
             YearTemp! = YearTemp! + 1980
             Out3 = RIGHT$(STR$(MonthTemp! + 100), 2) + "-" + RIGHT$(STR$(DayTemp! + 100), 2) + "-" + MID$(STR$(YearTemp!), 2)
	  END IF
	  ' restore basic dta
	  InregsX.AX = &H1A00
	  InregsX.DS = BASIC.DTA.SEG
	  InregsX.DX = BASIC.DTA.OFF
	  CALL InterruptX(&H21, InregsX, OutregsX)
       END IF
    END IF
    CALL Get.Token4
 CASE "FILETIME"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = DFalse
    IF Last.Token = False THEN
       IF LEN(Out3) THEN
	  ASCIZ = Out3 + CHR$(0)
	  Out3 = Nul
	  ' restore directory search dta
	  InregsX.AX = &H1A00
          InregsX.DS = VARSEG(ParseDTA)
          InregsX.DX = VARPTR(ParseDTA)
	  CALL InterruptX(&H21, InregsX, OutregsX)
	  ' find first filename
	  InregsX.AX = &H4E00
	  InregsX.CX = &H27
	  InregsX.DS = VARSEG(ASCIZ)
	  InregsX.DX = VARPTR(ASCIZ)
	  CALL InterruptX(&H21, InregsX, OutregsX)
	  ' check findfirst error
	  IF (OutregsX.Flags AND &H1) = &H0 THEN
             Work! = ASC(MID$(ParseDTA.FileTime, 2, 1))
             Work! = Work! * &H100 + ASC(MID$(ParseDTA.FileTime, 1, 1))
             HourTemp! = INT(Work! / 2048)
             MinuteTemp! = INT((Work! AND &H7E0) / 32)
             SecondsTemp! = INT((Work! AND &H1F) / 2)
             Out3 = RIGHT$(STR$(HourTemp! + 100), 2) + ":" + RIGHT$(STR$(MinuteTemp! + 100), 2) + ":" + RIGHT$(STR$(SecondsTemp! + 100), 2)
	  END IF
	  ' restore basic dta
	  InregsX.AX = &H1A00
	  InregsX.DS = BASIC.DTA.SEG
	  InregsX.DX = BASIC.DTA.OFF
	  CALL InterruptX(&H21, InregsX, OutregsX)
       END IF
    END IF
    CALL Get.Token4
 CASE "VLABEL"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Drive.Number% = CINT(Temp#)
    ELSE
       Drive.Number% = CINT(ASC(UCASE$(Out3)) - 64)
    END IF
    Last.Token = False
    ASCIZ = CHR$(Drive.Number% + 64) + ":\*.*" + CHR$(0)
    Out3 = Nul
    ' restore directory search dta
    InregsX.AX = &H1A00
    InregsX.DS = VARSEG(ParseDTA)
    InregsX.DX = VARPTR(ParseDTA)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' find volume label
    InregsX.AX = &H4E00
    InregsX.CX = &H8
    InregsX.DS = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' check findfirst error
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       Out3 = ParseDTA.ASCIZfilename
    END IF
    ' restore basic dta
    InregsX.AX = &H1A00
    InregsX.DS = BASIC.DTA.SEG
    InregsX.DX = BASIC.DTA.OFF
    CALL InterruptX(&H21, InregsX, OutregsX)
    CALL Get.Token4
 CASE "VSERIAL"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Drive.Number% = CINT(Temp#)
    ELSE
       Drive.Number% = CINT(ASC(UCASE$(Out3)) - 64)
    END IF
    Last.Token = False
    Out3 = Nul
    ' get volume info
    InregsX.AX = &H6900
    InregsX.BX = Drive.Number%
    InregsX.DS = VARSEG(BPBfile)
    InregsX.DX = VARPTR(BPBfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' check flag error
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       ' store volume serial number
       FOR Serial.Digit = 4 TO 1 STEP -1
	  IF Serial.Digit = 2 THEN
	     Out3 = Out3 + "-"
	  END IF
          Serial.Value = ASC(MID$(BPBfile.Serial, Serial.Digit, 1))
          Out3 = Out3 + RIGHT$(HEX$(Serial.Value + &H100), 2)
       NEXT
    END IF
    CALL Get.Token4
 ' bubble sort variable array
 CASE "SORT"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token4
    Var = CINT(Temp#)
    IF Var>=1 AND Var<=26 THEN
       FOR Var1=1 TO Max.Arrays
          FOR Var2=Var1+1 TO Max.Arrays
             IF Arrays(Var, Var1)>Arrays(Var, Var2) Then
                SWAP Arrays(Var, Var1), Arrays(Var, Var2)
             END IF
          NEXT
       NEXT
       Last.Token = True
       EXIT SUB
    END IF
    ERROR 2
 ' bubble sort variable array descending
 CASE "ZSORT"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token4
    Var = CINT(Temp#)
    IF Var>=1 AND Var<=26 THEN
       FOR Var1=1 TO Max.Arrays
          FOR Var2=Var1+1 TO Max.Arrays
             IF Arrays(Var, Var1)<Arrays(Var, Var2) Then
                SWAP Arrays(Var, Var1), Arrays(Var, Var2)
             END IF
          NEXT
       NEXT
       Last.Token = True
       EXIT SUB
    END IF
    ERROR 2
 ' bubble sort variables
 CASE "ZSORT2"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token4
    Var = CINT(Temp#)
    IF Var=0 THEN
       FOR Var1=1 TO 26
          FOR Var2=Var1+1 TO 26
             IF Variables(Var1)>Variables(Var2) Then
                SWAP Variables(Var1), Variables(Var2)
             END IF
          NEXT
       NEXT
    ELSE
       FOR Var1=1 TO 26
          FOR Var2=Var1+1 TO 26
             IF Variables(Var1)<Variables(Var2) Then
                SWAP Variables(Var1), Variables(Var2)
             END IF
          NEXT
       NEXT
    END IF
    Temp#=-1
    Last.Token = True
    EXIT SUB
 ' fill array with random values
 CASE "RNDARRAY"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Var = CINT(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    VarX# = Temp#
    CALL Get.Token4
    IF Var>=1 AND Var<=26 THEN
       FOR Var2=1 To Max.Arrays
          Arrays(Var, Var2) = INT(RND*VarX#+1)
       NEXT
       Temp# = Var
       Last.Token = True
       EXIT SUB
    END IF
    ERROR 2
 ' fill variables with random values
 CASE "RNDARRAY2"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token4
    FOR Var1=1 To 26
       Variables(Var1) = INT(RND*Temp#+1)
    NEXT
    Temp# = -1
    Last.Token = True
    EXIT SUB
 ' get array value
 CASE "ARRAY"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Var1 = CINT(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Var2 = CINT(Temp#)
    CALL Get.Token4
    IF Var1>=1 AND Var1<=26 THEN
       IF Var2>=1 AND Var2<=Max.Arrays THEN
          Temp# = Arrays(Var1, Var2)
          Last.Token = True
          EXIT SUB
       END IF
    END IF
    ERROR 2
 ' set array value
 CASE "SETARRAY"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Var1 = CINT(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Var2 = CINT(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    VarX# = Temp#
    CALL Get.Token4
    IF Var1>=1 AND Var1<=26 THEN
       IF Var2>=1 AND Var2<=Max.Arrays THEN
          Arrays(Var1, Var2) = VarX#
          Temp# = Var1
          Last.Token = True
          EXIT SUB
       END IF
    END IF
    ERROR 2
 ' get variable value
 CASE "VARIABLE"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Var1 = CINT(Temp#)
    CALL Get.Token4
    IF Var1>=1 AND Var1<=26 THEN
       Temp# = Variables(Var1)
       Last.Token = True
       EXIT SUB
    END IF
    ERROR 2
 ' set variable value
 CASE "SETVARIABLE"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Var1 = CINT(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    VarX# = Temp#
    CALL Get.Token4
    IF Var1>=1 AND Var1<=26 THEN
       Variables(Var1) = VarX#
       Temp# = Var1
       Last.Token = True
       EXIT SUB
    END IF
    ERROR 2

 REM Remaining nonintrinsic trigonmetric functions..

 'Inverse Cosine
 CASE "ARCCOS"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ATN(-Temp# / SQR(-Temp# * Temp# + 1)) + 2 * ATN(1)
    CALL Get.Token4
    Last.Token = True
 'Inverse Cosecant
 CASE "ARCCOSEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ATN(Temp# / SQR(Temp# * Temp# - 1)) + (SGN(Temp#) - 1) * (2 * ATN(1))
    CALL Get.Token4
    Last.Token = True
 'Inverse Cotangent
 CASE "ARCCOTAN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ATN(Temp#) + 2 * ATN(1)
    CALL Get.Token4
    Last.Token = True
 'Inverse Secant
 CASE "ARCSEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ATN(Temp# / SQR(Temp# * Temp# - 1)) + SGN((Temp#) - 1) * (2 * ATN(1))
    CALL Get.Token4
    Last.Token = True
 'Inverse Sine
 CASE "ARCSIN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ATN(Temp# / SQR(-Temp# * Temp# + 1))
    CALL Get.Token4
    Last.Token = True
 'Cosecant
 CASE "COSEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 1 / SIN(Temp#)
    CALL Get.Token4
    Last.Token = True
 'Cotangent
 CASE "COTAN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 1 / TAN(Temp#)
    CALL Get.Token4
    Last.Token = True
 'Convert Degrees to Radians
 CASE "DEGTORAD"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ((ATN(1) * 4) / 180) * Temp#
    CALL Get.Token4
    Last.Token = True
 'Inverse Hyperbolic Cosine
 CASE "HARCCOS"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LOG(Temp# + SQR(Temp# * Temp# - 1))
    CALL Get.Token4
    Last.Token = True
 'Inverse Hyperbolic Cosecant
 CASE "HARCCOSEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LOG((SGN(Temp#) * SQR(Temp# * Temp# + 1) + 1) / Temp#)
    CALL Get.Token4
    Last.Token = True
 'Inverse Hyperbolic Cotangent
 CASE "HARCCOTAN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LOG((Temp# + 1) / (Temp# - 1)) / 2
    CALL Get.Token4
    Last.Token = True
 'Inverse Hyperbolic Secant
 CASE "HARCSEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LOG((SQR(-Temp# * Temp# + 1) + 1) / Temp#)
    CALL Get.Token4
    Last.Token = True
 'Inverse Hyperbolic Sine
 CASE "HARCSIN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LOG(Temp# + SQR(Temp# * Temp# + 1))
    CALL Get.Token4
    Last.Token = True
 'Inverse Hyperbolic Tangent
 CASE "HARCTAN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LOG((1 + Temp#) / (1 - Temp#)) / 2
    CALL Get.Token4
    Last.Token = True
 'Hyperbolic Cosine
 CASE "HCOS"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = (EXP(Temp#) + EXP(-Temp#)) / 2
    CALL Get.Token4
    Last.Token = True
 'Hyperbolic Cosecant
 CASE "HCOSEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 2 / (EXP(Temp#) - EXP(-Temp#))
    CALL Get.Token4
    Last.Token = True
 'Hyperbolic Cotangent
 CASE "HCOTAN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = (EXP(Temp#) + EXP(-Temp#)) / (EXP(Temp#) - EXP(-Temp#))
    CALL Get.Token4
    Last.Token = True
 'Hyperbolic Secant
 CASE "HSEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 2 / (EXP(Temp#) + EXP(-Temp#))
    CALL Get.Token4
    Last.Token = True
 'Hyperbolic Sine
 CASE "HSIN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = (EXP(Temp#) - EXP(-Temp#)) / 2
    CALL Get.Token4
    Last.Token = True
 'Hyperbolic Tangent
 CASE "HTAN"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = (EXP(Temp#) - EXP(-Temp#)) / (EXP(Temp#) + EXP(-Temp#))
    CALL Get.Token4
    Last.Token = True
 'Convert Radians to Degrees
 CASE "RADTODEG"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = (180 / (ATN(1) * 4)) * Temp#
    CALL Get.Token4
    Last.Token = True
 'Secant
 CASE "SEC"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 1 / COS(Temp#)
    CALL Get.Token4
    Last.Token = True
 ' Hypotenuse
 CASE "HYPOT"
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = SQR(Number# * Number# + Temp# * Temp#)
    CALL Get.Token4
    Last.Token = True
 CASE ELSE
    IF Allow.Alpha THEN
       Out3 = Strng
    ELSE
       Strng = "{" + Strng + "}"
       ERROR 92
    END IF
 END SELECT
END SUB

' process a number
SUB Parse.Numeric (Temp#)
 SELECT CASE RIGHT$(UCASE$(Strng), 1) ' compare character after number
 CASE "P" ' prime number suffix
    FOR Digit = 1 TO LEN(Strng) - 1
       OutX$ = UCASE$(MID$(Strng, Digit, 1))
       SELECT CASE OutX$
       CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
          ' nul
       CASE ELSE
          ERROR 130
       END SELECT
    NEXT
    Temp# = CDBL(VAL(LEFT$(Strng, LEN(Strng) - 1)))
    Prime.Number# = INT(Temp#)
    Prime# = 1
    IF Prime.Number# > False THEN
       Prime.Counter# = False
       DO
	  Prime# = Prime# + 1
	  Prime.Flag = False
          FOR Factor# = 2 TO INT(SQR(Prime#))
             IF Prime# / Factor# = INT(Prime# / Factor#) THEN
		Prime.Flag = True
		EXIT FOR
	     END IF
	  NEXT
	  IF Prime.Flag = False THEN
	     Prime.Counter# = Prime.Counter# + 1
	  END IF
	  IF Prime.Counter# = Prime.Number# THEN
	     EXIT DO
	  END IF
       LOOP
    END IF
    Temp# = Prime#
 CASE "F" ' factorial
    Temp2 = False
    Temp3 = LEN(Strng)
    DO
       IF UCASE$(MID$(Strng, Temp3, 1)) <> "F" THEN
	  EXIT DO
       END IF
       Temp2 = Temp2 + 1
       Temp3 = Temp3 - 1
    LOOP
    FOR Decimal.Digit = 1 TO Temp3
       OutX$ = UCASE$(MID$(Strng, Decimal.Digit, 1))
       SELECT CASE OutX$
       CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
          ' nul
       CASE ELSE
          ERROR 132
       END SELECT
    NEXT
    Temp4# = VAL(LEFT$(Strng, Temp3))
    FOR Number = 1 TO Temp2
       Temp# = 1#
       FOR Factorial# = 2# TO Temp4#
	  Temp# = Temp# * Factorial#
       NEXT
       Temp4# = Temp#
    NEXT
 CASE "H" ' hexidecimal suffix
    Temp# = False
    Hex.Power = False
    FOR Hex.Digit = LEN(Strng) - 1 TO 1 STEP -1
       OutX$ = UCASE$(MID$(Strng, Hex.Digit, 1))
       SELECT CASE OutX$
       CASE "0" TO "9", "A" TO "F"
          Hex.Value = VAL("&H" + OutX$)
          Temp# = Temp# + Hex.Value * 16 ^ Hex.Power
          Hex.Power = Hex.Power + 1
       CASE ELSE
          ERROR 127
       END SELECT
    NEXT
 CASE "O" ' octal suffix
    Temp# = False
    Octal.Power = False
    FOR Octal.Digit = LEN(Strng) - 1 TO 1 STEP -1
       OutX$ = MID$(Strng, Octal.Digit, 1)
       IF OutX$ >= "0" AND OutX$ <= "7" THEN
          Octal.Value = VAL(OutX$)
          Temp# = Temp# + Octal.Value * 8 ^ Octal.Power
          Octal.Power = Octal.Power + 1
       ELSE
          ERROR 128
       END IF
    NEXT
 CASE "B" ' binary suffix
    Temp# = False
    Binary.Power = False
    FOR Binary.Digit = LEN(Strng) - 1 TO 1 STEP -1
       OutX$ = MID$(Strng, Binary.Digit, 1)
       SELECT CASE OutX$
       CASE "0"
          ' nul
       CASE "1"
	  Temp# = Temp# + 2 ^ Binary.Power
       CASE ELSE
          ERROR 129
       END SELECT
       Binary.Power = Binary.Power + 1
    NEXT
 CASE "0" TO "9", "D", "E" ' decimal/exponent suffix
    Decimal = False
    Exponent = False
    Number$ = Strng
 Start.Token:
    FOR Decimal.Digit = 1 TO LEN(Number$)
       OutX$ = UCASE$(MID$(Number$, Decimal.Digit, 1))
       SELECT CASE OutX$
       CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "+"
          ' nul
       CASE "D", "E"
          IF Exponent THEN
             ERROR 140
          END IF
          Exponent = True
          Exponent$ = UCASE$(RIGHT$(Number$, 1))
          IF Exponent$ = "D" OR Exponent$ = "E" THEN
             IF MID$(Out2, Token.Index, 1) = " " THEN
                Token.Index = Token.Index + 1
             END IF
             ' concatenate pre-parsed tokens into exponent
             Unary$ = MID$(Out2, Token.Index, 1)
             IF Unary$ = "+" OR Unary$ = "-" THEN
                Var$ = LEFT$(Out2, Token.Index - 1)
                CALL Get.Token
                Out2 = Var$ + Strng + MID$(Out2, Token.Index)
                CALL Get.Token
                IF Strng = Nul THEN
                   ERROR 141
                END IF
                Number$ = Number$ + Unary$ + Strng
                IF Strng = "-" OR Strng = "+" THEN
                   ERROR 142
                END IF
                IF INSTR(Strng, ".") THEN
                   ERROR 143
                END IF
                ' remove pre-parsed leading unary signs 
                DO
                   IF LEFT$(Number$, 1) = "-" THEN
                      Number$ = MID$(Number$, 2)
                   ELSE
                      IF LEFT$(Number$, 1) = "+" THEN
                         Number$ = MID$(Number$, 2)
                      ELSE
                         EXIT DO
                      END IF
                   END IF
                LOOP
                Decimal = False
                Exponent = False
                GOTO Start.Token
             ELSE
                ERROR 142
             END IF
          END IF
       CASE "."
          IF Exponent THEN
             ERROR 143
          END IF
          IF Decimal THEN
             ERROR 143
          END IF
          Decimal = True
       CASE ELSE
          ERROR 130
       END SELECT
    NEXT
    Temp# = CDBL(VAL(Number$))
 CASE ELSE
    ERROR 131
 END SELECT
 CALL Get.Token
 Last.Token = True
END SUB

' parse string in quotes
SUB Parse.Quoted
 Out3 = Nul
 DO UNTIL MID$(Out2, Token.Index, 1) = CHR$(34)
    Out3 = Out3 + MID$(Out2, Token.Index, 1)
    Token.Index = Token.Index + 1
    IF Token.Index > LEN(Out2) THEN
       ERROR 133
       EXIT DO
    END IF
 LOOP
 CALL Get.Token
 CALL Get.Token
 Last.Token = False
END SUB

' logical parser
SUB Parse1 (Temp#)
 CALL Parse2(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "|", "&", "~", "?", ":", "#", "@", "`"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse2(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

' relational parser
SUB Parse2 (Temp#)
 CALL Parse3(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "<", ">", "=", ">=", "<=", "<>", "=="
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current string
    CALL Get.Token ' read next token
    CALL Parse3(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

' addition/subtraction parser
SUB Parse3 (Temp#)
 CALL Parse4(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "+", "-"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse4(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

' modulo parser
SUB Parse4 (Temp#)
 CALL Parse5(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "%"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse5(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

' integer division parser
SUB Parse5 (Temp#)
 CALL Parse6(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "\"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse6(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

' multiplication/division parser
SUB Parse6 (Temp#)
 CALL Parse7(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "*", "/"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse7(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

' power parser
SUB Parse7 (Temp#)
 CALL Parse8(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "^"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse8(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

' not/unary plus/unary negative parser
SUB Parse8 (Temp#)
 Token.Negate$ = Nul ' reset token storage
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "!", "-", "+"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    CALL Get.Token ' read next token
    Token.Negate$ = Token.Negate$ + Token.Parsed$
    Token.Parsed$ = Strng ' store token
 LOOP
 CALL Parse9(Temp#) ' get next operator
 ' process the combined operators in reverse
 FOR Token.Type = LEN(Token.Negate$) TO 1 STEP -1
    SELECT CASE MID$(Token.Negate$, Token.Type, 1) ' get previous token
    CASE "+"
       ' nul calculation for unary plus
    CASE "-"
       Temp# = -Temp# ' perform negate
    CASE "!" ' not
       Temp# = NOT Temp# ' perform not calculation
    END SELECT
 NEXT
END SUB

' string/numeric expression parser,
' routine returns calculated expression string/value,
' calls Parse1 recursively for values inside parenthesis/functions.
SUB Parse9 (Temp#)
 SELECT CASE Token ' determine token type
 CASE 0 ' no terminating token
    IF Last.Token = 3 THEN
       IF Allow.Extra = False THEN
          Strng = "<extra token>"
          ERROR 92
       END IF
    ELSE
       IF Strng = Nul THEN
          Strng = "<missing token>"
       ELSE
          Strng = "<" + Strng + ">"
       END IF
       ERROR 92
    END IF
    Last.Token = False
 CASE 1 ' token is symbol
    Token.Parsed$ = Strng
    SELECT CASE Token.Parsed$
    CASE ",", ";" ' separaters
       Last.Token = 3
    CASE CHR$(34) ' parse string in quotes
       CALL Parse.Quoted
       Quotes = True
    CASE "(" ' calculate opening parenthesis
       CALL Get.Token ' read next token value inside parenthesis
       IF Strng = ")" THEN
          Strng = "<empty closing token>"
          ERROR 92
       END IF
       IF Strng <> ")" THEN
	  DO ' calculate value
	     CALL Parse1(Temp#) ' recursively call parse entry
	  LOOP UNTIL Strng = ")" OR Token = False ' check closing parenthesis
       END IF
       IF Token = False THEN
          Strng = "<missing closing token>"
          ERROR 92
       END IF
       CALL Get.Token ' read next token after parenthesis
    CASE "["
       CALL Get.Token
       IF Strng = "]" THEN
          Strng = "<empty closing token>"
          ERROR 92
       END IF
       IF Strng <> "]" THEN
	  DO
	     CALL Parse1(Temp#) ' recursively call parse entry
	  LOOP UNTIL Strng = "]" OR Token = False ' check closing parenthesis
       END IF
       IF Token = False THEN
          Strng = "<missing closing token>"
          ERROR 92
       END IF
       CALL Get.Token ' read next token after parenthesis
    CASE "{"
       CALL Get.Token
       IF Strng = "}" THEN
          Strng = "<empty closing token>"
          ERROR 92
       END IF
       IF Strng <> "}" THEN
	  DO
	     CALL Parse1(Temp#) ' recursively call parse entry
	  LOOP UNTIL Strng = "}" OR Token = False ' check closing parenthesis
       END IF
       IF Token = False THEN
          Strng = "<missing closing token>"
          ERROR 92
       END IF
       CALL Get.Token ' read next token after parenthesis
    CASE ")", "]", "}" ' check token is unmatched parenthesis
       IF Allow.Extra <= False THEN
          Strng = "<extra closing token>"
          ERROR 92
       END IF
    END SELECT
 CASE 2 ' token is numeric value
    CALL Parse.Numeric(Temp#)
 CASE 3 ' token type is alphabetic
    SELECT CASE LEN(Strng) ' check token length
    CASE 1
       ' parse the token
       CALL Parse.Alphabetic1(Temp#)
    CASE 2
       SELECT CASE UCASE$(Strng)
       ' special tokens
       CASE "AS"
	  CALL Get.Token
	  EXIT SUB
       CASE "TO"
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  FinishFor = Temp4#
	  EXIT SUB
       END SELECT
       ' parse the token
       CALL Parse.Alphabetic2(Temp#)
    CASE ELSE
       SELECT CASE UCASE$(Strng)
       ' printing tokens
       CASE "SPC"
          IF Printing = False THEN
             ERROR 92
          END IF
          CALL Get.Token3
          CALL Get.Token
          CALL Parse1(Temp#)
          SELECT CASE PrinterLF
          CASE -1
             LPRINT SPACE$(Temp#);
          CASE 1
             PRINT SPC(Temp#);
          END SELECT
          CALL Get.Token
          IF PrinterLF THEN
             CALL Get.Token
             CALL Parse1(Temp#)
          END IF
          EXIT SUB
       CASE "TAB"
          IF Printing = False THEN
             ERROR 92
          END IF
          CALL Get.Token3
          CALL Get.Token
          CALL Parse1(Temp#)
          SELECT CASE PrinterLF
          CASE -1
             LPRINT SPACE$(Temp#);
          CASE 1
             PRINT TAB(Temp#);
          END SELECT
          CALL Get.Token
          IF PrinterLF THEN
             CALL Get.Token
             CALL Parse1(Temp#)
          END IF
          EXIT SUB
       ' special tokens
       CASE "THEN"
          CALL Get.Token
          EXIT SUB
       CASE "STEP"
          CALL Get.Token
          CALL Parse1(Temp4#)
          StepTo = Temp4#
          EXIT SUB
       CASE "EXCEPT"
          CALL Get.Token
          CALL Parse1(Temp4#)
          ExceptStep = Temp4#
          ExceptStepIs = True
          EXIT SUB
       CASE "UNLESS"
          CALL Get.Token
          CALL Parse1(Temp4#)
          Unless.Branch = True
          Unless.Value = Temp4#
          EXIT SUB
       END SELECT
       ' parse the token
       CALL Parse.Alphabetic3(Temp#)
    END SELECT
    ' parse the last token
    ' after any alphabetic token
    ' except the special tokens above.
    CALL Get.Token
 END SELECT
END SUB

' parses data statements.
SUB Read.Data.Element (More.Data)
 More.Data = False
 Stored.Out2$ = Out2
 Stored.Token.Index = Token.Index
 DO
    Out2 = Program(DataLine)
    Out2 = STRIM$(Out2)
    Out2 = UCASE$(Out2)
    IF LEFT$(Out2, 5) <> "DATA " THEN
       GOSUB Read.Next.Data
       DataNumber = False
    END IF
    Out2 = Program(DataLine)
    Out2 = STRIM$(Out2)
    Out2 = MID$(Out2, 5)
    Out2 = STRIM$(Out2)
    Data.Count = False
    Token.Index = 1
    DO
       Last.Token = False
       CALL Get.Token
       CALL Parse1(DataValue)
       IF Data.Count = DataNumber THEN
	  DataNumber = DataNumber + 1
	  Out2 = Stored.Out2$
	  Token.Index = Stored.Token.Index
	  EXIT SUB
       END IF
       IF Token.Index > LEN(Out2) THEN
	  EXIT DO
       END IF
       Data.Count = Data.Count + 1
    LOOP
    DataLine = DataLine + 1
    DataNumber = False
 LOOP
 EXIT SUB

Read.Next.Data:
 DO
    IF DataLine >= Last.Line THEN
       EXIT DO
    END IF
    DataLine = DataLine + 1
    Out2 = Program(DataLine)
    Out2 = STRIM$(Out2)
    Out2 = UCASE$(Out2)
    IF LEFT$(Out2, 5) = "DATA " THEN
       RETURN
    END IF
 LOOP
 More.Data = True
END SUB

' determine operating system
SUB OS
 InregsX.AX=&H2B01
 InregsX.CX=&H4445
 InregsX.DX=&H5351
 CALL InterruptX(&H21,InregsX,OutregsX)
 If (OutregsX.AX AND &HFF)<>&HFF Then
    OperatingSystem = "Desqview"
    Exit Sub
 Endif
 InregsX.AX=&HE400
 CALL InterruptX(&H21,InregsX,OutregsX)
 If (OutregsX.AX AND &HFF)>&H0 Then
    OperatingSystem = "DoubleDos"
    Exit Sub
 Endif
 InregsX.AX=&H160A
 CALL InterruptX(&H2F,InregsX,OutregsX)
 If OutregsX.AX=&H0 Then
    Major=(OutregsX.BX AND &HFF00)/256
    Minor=(OutregsX.BX AND &HFF)
    If Major>=4 Then
       If Minor>10 Then
          OperatingSystem = "Windows ME"
       Else
          If Minor=10 Then
             OperatingSystem = "Windows 98"
          Else
             If Minor=3 Then
                OperatingSystem = "Windows 95B"
             Else
                OperatingSystem = "Windows 95"
             Endif
          Endif
       Endif
    Else
       OperatingSystem = "Windows v"+Ltrim$(Str$(Major))+"."+Ltrim$(Str$(Minor))
    Endif
    Exit Sub
 Endif
 InregsX.AX=&H3001
 CALL InterruptX(&H21,InregsX,OutregsX)
 Major=(OutregsX.AX AND &HFF)
 Minor=(OutregsX.AX AND &HFF00)/256
 If Major=10 Then
    OperatingSystem = "OS/2 v1.0"
 Else
    If Major=20 Then
       If Minor=40 Then
          OperatingSystem = "OS/2 v4.0"
       Else
          If Minor=30 Then
             OperatingSystem = "OS/2 v3.0"
          Else
             OperatingSystem = "OS/2 v2.0"
          Endif
       Endif
    Else
       OperatingSystem = "DOS v"+Ltrim$(Str$(Major))+"."+Ltrim$(Str$(Minor))
    Endif
 Endif
END SUB

' routine to read error string data file,
' searchs current path, environment path, then path statement.
SUB Read.Config
 ' reset init variables
 Program.Resume = True
 Filename = ErrorList
 File.Found = False
 ' find the data file
 Config.Filename$ = Filename
 IF DIR$(Filename) <> Nul THEN
    File.Found = True
 END IF
 ' search environment data file
 IF File.Found = False THEN
    File$ = ENVIRON$("SICCONFIG")
    IF LEN(File$) THEN
       File$ = RTRIM$(File$)
       File$ = LTRIM$(File$)
       IF RIGHT$(File$, 1) <> "\" THEN
          File$ = File$ + "\"
       END IF
       Config.Filename$ = File$ + Filename
       IF DIR$(Config.Filename$) <> Nul THEN
          File.Found = True
       END IF
    END IF
 END IF
 ' search path statement
 IF File.Found = False THEN
    ' store path
    Path$ = ENVIRON$("PATH")
    DO
       ' parse path
       Parse = INSTR(Path$, ";")
       IF Parse THEN
          File$ = LEFT$(Path$, Parse - 1)
          Path$ = MID$(Path$, Parse + 1)
       ELSE
          File$ = Path$
          Path$ = Nul
       END IF
       ' store filename
       File$ = RTRIM$(File$)
       File$ = LTRIM$(File$)
       IF LEN(File$) THEN
          IF RIGHT$(File$, 1) <> "\" THEN
             File$ = File$ + "\"
          END IF
          Config.Filename$ = File$ + Filename
          IF DIR$(Config.Filename$) <> Nul THEN
             File.Found = True
             EXIT DO
          END IF
       ELSE
          EXIT DO
       END IF
    LOOP
 END IF
 ' reset array bounds
 Max.Errors = 0
 Array.Size = 7
 ' initialize error string array
 REDIM Errors(0 tO 7) AS STRING * 64
 ' read in the data file
 IF File.Found THEN
    OPEN Config.Filename$ FOR INPUT AS #1
    DO
       ' check file length
       IF EOF(1) THEN
          EXIT DO
       END IF
       ' check array size
       IF Max.Errors = 255 THEN
          EXIT DO
       END IF
       ' increment array bounds
       Max.Errors = Max.Errors + 1
       IF Max.Errors = Array.Size THEN
          ' resize array
          Array.Size = Array.Size + 8
          REDIM PRESERVE Errors(0 To Array.Size) AS STRING * 64
       END IF
       ' read file line
       LINE INPUT #1, Error.String$
       ' store line
       Error.String$ = LTRIM$(Error.String$)
       Error.String$ = RTRIM$(Error.String$)
       IF LEN(Error.String$) THEN
          Errors(Max.Errors) = Error.String$
       ELSE
          Errors(Max.Errors) = "Error #" + MID$(STR$(Max.Errors), 2)
       END IF
    LOOP
    CLOSE
 END IF
 ' resize the error string array
 IF Max.Errors = 0 THEN
    REDIM Errors(1) AS STRING * 64
    Errors(1) = "Error #1"
 ELSE
    IF Max.Errors < 255 THEN
       REDIM PRESERVE Errors(Max.Errors) AS STRING * 64
    END IF
 END IF
 Program.Resume = False
END SUB
