/*	pgraph.h

	Printer Graphics Package.

	Copyright (c) F van der Hulst 1991
	All Rights Reserved.

	 Revisions:
	 27 March 1991: Initial release (Turbo C v2.0 Large model only)
	 13 April 1991: Ported to MicroSoft C v5.1
	 16 June  1991: Support for all memory models
	 26 June  1991: Added _p_getbyte() and _p_putbyte() for model independence
*/

#if defined(__TURBOC__)
#if defined(TPASCAL)
#define FUNC_TYPE far pascal
#else
#define FUNC_TYPE huge cdecl
#endif
#else
#define FUNC_TYPE far cdecl
#endif

#if     !defined(__P_GRAPHX_DEF_)
#define __P_GRAPHX_DEF_

#if     !defined(__GRAPHX_DEF_)
enum graphics_errors {		/* graphresult error return codes */
	grOk				   =   0,
	grNoInitGraph	   =  -1,
	grNotDetected	   =  -2,
	grFileNotFound	   =  -3,
	grInvalidDriver   =  -4,
	grNoLoadMem	   	=  -5,
	grNoScanMem	   	=  -6,
	grNoFloodMem	   =  -7,
	grFontNotFound	   =  -8,
	grNoFontMem	   	=  -9,
	grInvalidMode	   = -10,
	grError 	   		= -11,   /* generic error */
	grIOerror		   = -12,
	grInvalidFont	   = -13,
	grInvalidFontNum  = -14,
	grInvalidVersion  = -18
};

enum line_styles {		/* Line styles for get/setlinestyle */
	SOLID_LINE   = 0,
	DOTTED_LINE  = 1,
	CENTER_LINE  = 2,
	DASHED_LINE  = 3,
	USERBIT_LINE = 4,	/* User defined line style */
};

enum line_widths {		/* Line widths for get/setlinestyle */
	NORM_WIDTH  = 1,
	THICK_WIDTH = 3,
};

enum font_names {
	DEFAULT_FONT		= 0,	/* 8x8 bit mapped font */
	TRIPLEX_FONT		= 1,	/* "Stroked" fonts */
	SMALL_FONT			= 2,
	SANS_SERIF_FONT 	= 3,
	GOTHIC_FONT			= 4,
	SCRIPT_FONT 		= 5,
	SIMPLEX_FONT		= 6,
	TRI_SCR_FONT		= 7,
	COMPLEX_FONT		= 8,
	EURO_FONT   		= 9,
	BOLD_FONT   		= 10
};

#define HORIZ_DIR	0	/* left to right */
#define VERT_DIR	1	/* bottom to top */

#define USER_CHAR_SIZE	0	/* user-defined char size */

enum fill_patterns {		/* Fill patterns for get/setfillstyle */
		EMPTY_FILL,			/* fills area in background color */
		SOLID_FILL,			/* fills area in solid fill color */
		LINE_FILL,			/* --- fill */
		LTSLASH_FILL,		/* /// fill */
		SLASH_FILL,			/* /// fill with thick lines */
		BKSLASH_FILL,		/* \\\ fill with thick lines */
		LTBKSLASH_FILL, 	/* \\\ fill */
		HATCH_FILL,			/* light hatch fill */
		XHATCH_FILL,		/* heavy cross hatch fill */
		INTERLEAVE_FILL,	/* interleaving line fill */
		WIDE_DOT_FILL,		/* Widely spaced dot fill */
		CLOSE_DOT_FILL, 	/* Closely spaced dot fill */
		USER_FILL			/* user defined fill */
};

enum putimage_ops {		/* BitBlt operators for putimage */
			COPY_PUT,		/* MOV */
			XOR_PUT,			/* XOR */
			OR_PUT, 			/* OR  */
			AND_PUT,			/* AND */
			NOT_PUT	 		/* NOT */
};

enum text_just {		/* Horizontal and vertical justification
				   for settextjustify */
			LEFT_TEXT	= 0,
			CENTER_TEXT	= 1,
			RIGHT_TEXT	= 2,

			BOTTOM_TEXT	= 0,
		/* CENTER_TEXT	= 1,  already defined above */
			TOP_TEXT		= 2
};


struct linesettingstype {
	int linestyle;
	unsigned upattern;
	int thickness;
};

struct textsettingstype {
	int font;
	int direction;
	int charsize;
	int horiz;
	int vert;
};

struct fillsettingstype {
	int pattern;
	int color;
};

struct pointtype {
	int x, y;
};

struct viewporttype {
	int left, top, right, bottom;
	int clip;
};

struct arccoordstype {
	int x, y;
	int xstart, ystart, xend, yend;
};
#endif

enum p_graphics_drivers { 	/* define graphics drivers */
	STAR = 1,
	LASERJET,
	LX400,
	USER1,
	USER2,
};

enum p_graphics_modes {		/* graphics modes for each driver */
	 STAR_60_72 	= 0,  /* Star NX-10   60 dpi *  72 dpi Normal       */
	 STAR_120_216,			/*             120     * 216     Double       */
	 STAR_120_108,			/*             120     * 108     Double       */
	 STAR_120_72,			/*             120     *  72     Double, fast */
	 STAR_240_216,			/*             240     * 216     Quad         */
	 STAR_80_72,			/*              80     *  72     CRT graphics */
	 STAR_72_72,			/*              72     *  72     Plotter      */
	 STAR_90_72,			/*              90     *  72     CRT II		 */
	 LJ_75_75 		= 0,  /* HP LaserJet  75 dpi *  75 dpi */
	 LJ_100_100,			/*				   100     * 100	   */
	 LJ_150_150,			/*				   150     * 150	   */
	 LJ_300_300,			/*		 		   300     * 300	   */
	 LX400_60_72 	= 0,  /* Epson LX-400 60 dpi *  72 dpi Normal       */
	 LX400_120_216,		/*             120     * 216     Double       */
	 LX400_120_108,		/*             120     * 108     Double       */
	 LX400_120_72,			/*             120     *  72     Double, fast */
	 LX400_240_216,		/*             240     * 216     Quad         */
	 LX400_40_72,			/*              40     *  72     CRT graphics */
	 LX400_80_72,			/*              80     *  72     Plotter      */
	 LX400_90_72,			/*              90     *  72     CRT II		 */
};

void           FUNC_TYPE  p_arc(int x, int y, int stangle, int endangle, int radius);
void           FUNC_TYPE  p_circle(int x, int y, int radius);
void           FUNC_TYPE  p_drawpoly(int numpoints, int far *polypoints);
void           FUNC_TYPE  p_ellipse(int x, int y, int stangle, int endangle, int xradius, int yradius);
void           FUNC_TYPE  p_fillellipse( int x, int y, int xradius, int yradius );
void           FUNC_TYPE  p_fillpoly(int numpoints, int far *polypoints);
void           FUNC_TYPE  p_floodfill(int x, int y, int border);
void           FUNC_TYPE  p_getresolution(int far *xres, int far *yres);
void           FUNC_TYPE  p_getaspectratio(int far *xasp, int far *yasp);
void           FUNC_TYPE  p_setaspectratio(int xasp, int yasp);
int            FUNC_TYPE  p_getmaxx(void);
int            FUNC_TYPE  p_getmaxy(void);
int            FUNC_TYPE  p_getx(void);
int            FUNC_TYPE  p_gety(void);
void           FUNC_TYPE  p_line(int x1, int y1, int x2, int y2);
void           FUNC_TYPE  p_linerel(int dx, int dy);
void           FUNC_TYPE  p_lineto(int x, int y);
void           FUNC_TYPE  p_moverel(int dx, int dy);
void           FUNC_TYPE  p_moveto(int x, int y);
void           FUNC_TYPE  p_putpixel(int x, int y, int colour);
void           FUNC_TYPE  p_rectangle(int left, int top, int right, int bottom);
void           FUNC_TYPE  p_closegraph(void);
int            FUNC_TYPE  p_getmaxcolor(void);
void           FUNC_TYPE  p_setlinestyle(int linestyle, unsigned upattern, int thickness);
void           FUNC_TYPE  p_outtext(char far *textstring);
void           FUNC_TYPE  p_outtextxy(int x, int y, char far *textstring);
void           FUNC_TYPE  p_cleardevice(void);
void           FUNC_TYPE  p_setwritemode(int mode);
void           FUNC_TYPE  p_print(int out_dev);
void           FUNC_TYPE  p_view(void);
void           FUNC_TYPE  p_graphdefaults(void);
int            FUNC_TYPE  p_graphresult(void);
unsigned int   FUNC_TYPE  p_getpixel(int x, int y);
void           FUNC_TYPE  p_setcolor(int color);
int            FUNC_TYPE  p_getcolor(void);
void           FUNC_TYPE  p_bar3d(int left, int top, int right, int bottom, int depth, int topflag);
void           FUNC_TYPE  p_bar(int left, int top, int right, int bottom);
void           FUNC_TYPE  p_settextstyle(int font, int direction, int charsize);
void           FUNC_TYPE  p_settextjustify(int horiz, int vert);
void           FUNC_TYPE  p_gettextsettings(struct textsettingstype far *texttypeinfo);
void           FUNC_TYPE  p_setusercharsize(int multx, int divx, int multy, int divy);
int            FUNC_TYPE  p_textwidth(char far *string);
int            FUNC_TYPE  p_textheight(char far *string);
void           FUNC_TYPE  p_getlinesettings(struct linesettingstype far *linetypeinfo);
void           FUNC_TYPE  p_getfillpattern(char far *pattern);
void           FUNC_TYPE  p_getfillsettings(struct fillsettingstype far *fillinfo);
void           FUNC_TYPE  p_setfillpattern(char far *upattern, int colour);
void           FUNC_TYPE  p_setfillstyle(int pattern, int colour);
void           FUNC_TYPE  p_getimage(int left, int top, int right, int bottom, void far *bitmap);
unsigned int 	FUNC_TYPE  p_imagesize(int left, int top, int right, int bottom);
void           FUNC_TYPE  p_putimage(int left, int top, void far *bitmap, int op);
void           FUNC_TYPE  p_pieslice(int x, int y, int stangle, int endangle, int radius);
void           FUNC_TYPE  p_sector( int X, int Y, int StAngle, int EndAngle, int XRadius, int YRadius);
void           FUNC_TYPE  p_clearviewport(void);
int         	FUNC_TYPE  p_getgraphmode(void);
int         	FUNC_TYPE  p_getmaxmode(void);
void           FUNC_TYPE  p_getmoderange(int graphdriver, int far *lomode, int far *himode);
void           FUNC_TYPE  p_initgraph(int far *graphdriver, int far *graphmode, char far *pathtodriver);
void           FUNC_TYPE  p_setgraphmode(int mode);
void           FUNC_TYPE  p_setviewport(int left, int top, int right, int bottom, int clip);
void           FUNC_TYPE  p_getarccoords(struct arccoordstype far *arccoords);
void           FUNC_TYPE  p_dump(void);
int            FUNC_TYPE  p_registerfarbgidriver(void far *driver);
int         	FUNC_TYPE  p_registerfarbgifont(void far *font);

#ifdef TPASCAL
int 				FUNC_TYPE p_registerbgidriver(void (far*driver)(void));
int 				FUNC_TYPE p_registerbgifont(void (far*font)(void));
void				FUNC_TYPE  p_getdrivername(void);
void			   FUNC_TYPE  p_getmodename(int mode_number);
#else
int 				FUNC_TYPE p_registerbgidriver(void (*driver)(void));
int 				FUNC_TYPE p_registerbgifont(void (*font)(void));
char far *     FUNC_TYPE  p_getdrivername(void);
char far *     FUNC_TYPE  p_getmodename(int mode_number);
#endif

#ifdef __TURBOC__
extern void             FUNC_TYPE  (far *_p_putpixel_screen)(int x, int y, int colour);
extern void far *			FUNC_TYPE  (far *_p_graphgetmem)(unsigned long size);
extern void             FUNC_TYPE  (far *_p_graphfreemem)(void far *ptr, unsigned long size);
extern int	 				FUNC_TYPE  (far *_p_graphgetbuff)(unsigned long size);
extern void             FUNC_TYPE  (far *_p_graphfreebuff)(unsigned long size);
extern unsigned char		FUNC_TYPE  (far *_p_getbyte)(unsigned long int offset);
extern void           	FUNC_TYPE  (far *_p_putbyte)(unsigned long int offset, unsigned char byte);
#else
extern void             (*_p_putpixel_screen)(int x, int y, int colour);
extern void far *			(*_p_graphgetmem)(unsigned long size);
extern void             (*_p_graphfreemem)(void far *ptr, unsigned long size);
extern int	 				(*_p_graphgetbuff)(unsigned long size);
extern void             (*_p_graphfreebuff)(unsigned long size);
extern unsigned char		(*_p_getbyte)(unsigned long int offset);
extern void           	(*_p_putbyte)(unsigned long int offset, unsigned char byte);
#endif

#endif
