  /*
   * gettix.c  -- Gets the current timer tick from the BIOS in two ways:
   *
   *          1.) Through the BIOS            - The preferred way
   *          2.) Directly via a far pointer  - The unrecommended way
   *  Copyright Frank D. Greco, 1987
   *  Page 50, Volume 6.1 Programmer's Journal
   */
  
  #include <dos.h>
  
  main()
  {
      unsigned long gettime();
      long far *fp;
  
      FP_SEG(fp) = 0x0040;
      FP_OFF(fp) = 0x006C;
  
      printf("BIOS: %lu   Thru far ptr: %lu\n", gettime(), *fp);
  }
