/* updated Oct. 18, 1988 to work with SDK 4.99 */

#define INCL_PM
#include <os2.h>
#include <stddef.h>
#include <string.h>

#define EXTERN			/* all globals are declared in this module */
#include "spmtpl.h"

/* local function declarations */
void MainWndPaint(HWND hWnd, HPS hPS);
BOOL WindowIsIconic(HWND hWnd);

/* entry point for program */
int cdecl main(int argc, char *argv[])
{

    QMSG qmsg;

  /* call initialization */
    if (!InitProgram(argc, argv))
	return FALSE;

  /* fall into message loop */
    while (WinGetMsg(hAB, (PQMSG)&qmsg, (HWND)NULL, 0, 0))
        WinDispatchMsg( hAB, (PQMSG)&qmsg );

  /* program exit */
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmqMsgQ);
    WinTerminate(hAB);
}

/* main window message loop */
MRESULT FAR PASCAL MainWndProc(HWND hWnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{

    HPS hPS;		/* handle to PM display context */

    switch (msg) {

	case WM_CREATE:		/* called when main window is created */
	    WndCreate(hWnd);
	    break;

	case WM_CLOSE:		/* called when main window is closed */
            WinPostMsg(hWnd, WM_QUIT, 0L, 0L) ;
            break;

   	case WM_PAINT:		/* called when window needs repainting */
	    hPS = WinBeginPaint(hWnd, (HPS)NULL, (PRECTL)NULL);
	    MainWndPaint(hWnd, hPS);
	    WinEndPaint( hPS );
            break;

    	case WM_ERASEBACKGROUND:	/* have PM take care of background */
            return(TRUE);
            break;

    	default:		/* all other messages go here */
            return( WinDefWindowProc( hWnd, msg, mp1, mp2 ) );
            break;
    }
    return(0L);
}

void MainWndPaint(HWND hWnd, HPS hPS)
{

  /* Print a string in the icon area */

/* 
  If Microsoft ever gets WinQueryWindowPos working correctly, then
  replace the line 'if (WindowIsIconic(hWnd))' with the following: 
*/
/*
    SWP swp;

    WinQueryWindowPos(hWnd, &swp);

    if ((swp.fs & SWP_MINIMIZE) && (!(swp.fs & SWP_MAXIMIZE))) {
*/

    if (WindowIsIconic(hWnd)) {
        POINTL pt;
	pt.x = 0;
  	pt.y = 0;
	GpiMove(hPS, (PPOINTL)&pt);
	pt.x = xIconsize-1;
	pt.y = yIconsize-1;
        GpiBox(hPS, 2L, (PPOINTL)&pt, 0L, 0L);
        pt.x = 0;
        pt.y = 2 * (yIconsize - CharHeight) / 3;
        GpiCharStringAt( hPS, (PPOINTL)&pt, (LONG)strlen(szIcon), (PCH)szIcon);
    }
}

/* 
   Return TRUE if main window is iconic.
   This kludge is needed since WinQueryWindowPos is not yet fully implemented.
*/
BOOL WindowIsIconic(HWND hWnd)
{

    RECTL cRect;

  /* get the current window client rectangle */
    WinQueryWindowRect(hWnd, (PRECTL)&cRect);

  /* compare with size when window is iconic */
    if ((cRect.xRight == xIconsize) && (cRect.yTop == yIconsize))
	return TRUE;
 
    return FALSE;
}
