REM Code fragments from "Neural Nets" by Tom Waite and Hal Hardenbergh

REM Here are steps 2 through 4 of the Recall Computations
REM translated into BASIC

for j = 1 to J
    sum = Ibias(j)
    for i = 1 to I
        sum = sum + Input(i)*Iwt(i,j)
    next i
    Iout(j) = 1/(1+exp(-sum))
next j
 
for k = 1 to K
    sum = Cbias(k)
    for j = 1 to J
        sum = sum + Iout(j)*Cwt(j,k)
    next j
    Cout(k) = 1/(1+exp(-sum))
next k
 
for l = 1 to L
    sum = Obias(l)
    for k = 1 to K
        sum = sum + Cout(k)*Owt(k,l)
    next k
    Oout(l) = 1/(1+exp(-sum))
next l

REM The Learning Computations
REM Step 5: Get the output-layer error and error term (Odelta)
REM and update weights and bias while computing a portion of the 
REM center-layer error term:

REM initialize Cdelta()=0   (zero the entire array)
for l=1 to L
    Error(ts,l)=Target(ts,l)-Oout(l)
    Odelta=Oout(l)*(1-Oout(l))*Error(ts,l)
    for k=1 to K
        temp=OwtN(k,l)
        OwtN(k,l)=OwtN(k,l)+Nu*Odelta*Cout(k)+alpha*(OwtN(k,l)-OwtP(k,l))
        OwtP(k,l)=temp
        pCdelta(k)=pCdelta(k)+Odelta*OwtN(k,l)
    next k
    temp=ObiasN(l)
    ObiasN(l)=ObiasN(l)+nu*Odelta+alpha*(ObiasN(l)-ObiasP(l))
    ObiasP(l)=temp
next l

REM Step 6: Get the center-layer error term and update weights and
REM bias while computing a portion of the input-layer error term:

REM initialize Idelta()=0   (zero the entire array)
for k=1 to K
    Cdelta=Cout(k)*(1-Cout(k))*pCdelta(k)
    for j=1 to J
        temp=CwtN(j,k)
        CwtN(j,k)=CwtN(j,k)+Nu*Cdelta*Iout(j)+alpha*(CwtN(j,k)-CwtP(j,k))
        CwtP(j,k)=temp
        pIdelta(j)=pIdelta(j)+Cdelta*CwtN(j,k)
    next j
    temp=CbiasN(k)
    CbiasN(k)=CbiasN(k)+Nu*Cdelta+alpha*(CbiasN(k)-CbiasP(k))
    CbiasP(k)=temp
next k

REM Step 7: Get the input-layer error term and update weights and bias:

for j=1 to J
    Idelta=Iout(j)*(1-Iout(j))*pIdelta(j)
    for i=1 to I
        temp=IwtN(i,j)
        IwtN(i,j)=IwtN(i,j)+Nu*Idelta*Input(ts,i)+alpha*(IwtN(i,j)-IwtP(i,j))
        IwtP(i,j)=temp
    next i
    temp=IbiasN(j)
    IbiasN(j)=IbiasN(j)+Nu*Idelta+alpha*(IbiasN(j)-IbiasP(j))
    IbiasP(j)=temp
next j


