/*
 * PMAUXFN - function support module for PMAUX
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define INCL_PM
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <ttycls.h>
#include "pmaux.h"

/* set the window handle (might be NULL) into OS2.ini */
BOOL SetOS2Ini(HWND hWnd)
{
    char buf[30];
    return(WinWriteProfileString(hAB,szAppName,"hWnd",ltoa((LONG)hWnd,buf,10)));
}

/* respond to menu commands */
void NEAR WndCommand(HWND hWnd, USHORT wParam)
{

    HWND hMenu;

    switch (wParam) {
	case IDM_CLEAR:
	    TTYClear(&MWnd);
	    break;
	    
        case IDM_CRONLF:
	    MWnd.CRonLF = (MWnd.CRonLF ? FALSE : TRUE);	/* toggle parameter */
	    hMenu = WinWindowFromID(hwndFrame, FID_MENU);  /* get menu */
	  /* set or remove check mark on menu */
 	    WinSendMsg(hMenu, MM_SETITEMATTR, MPFROM2SHORT(wParam, TRUE),
		      MPFROM2SHORT(MIA_CHECKED, MWnd.CRonLF ? MIA_CHECKED : 0));
	    break;

	case IDM_ABOUT:		/* display about box */
	    WinDlgBox(HWND_DESKTOP, hWnd, AboutBoxProc, NULL, DT_ABOUT, NULL);
	    break;
    }
}

/* send the received buffer to the display */
void NEAR DispatchString(HWND hWnd, MPARAM mp1, MPARAM mp2)
{

#define LBUFLEN 80

    BYTE buf[LBUFLEN];
    int len, i, count;
    BYTE FAR *bufptr;
    SEL sel;

    len = (int)LOUSHORT(mp1);	/* read the length */
    sel = (SEL)LOUSHORT(mp2);	/* get the selector of the shared buffer */
    bufptr = MAKEP(sel,0);	/* make it into a pointer */

    if (DosGetSeg(sel) == 0) {	/* access the shared buffer */
	while (len > 0) { /* read and dispatch each part of buffer until done */								
	    count = min(len, LBUFLEN);	    
            for (i = 0; i < count; i++)
	        buf[i] = *bufptr++;
            TTYDisplay(&MWnd, (short)count, buf);
	    len -= count;
	}
    }
    else	/* something wrong, ring the bell */
	WinAlarm(HWND_DESKTOP, WA_WARNING);
}

/* repaint the window if needed */
void NEAR MainWndPaint(HWND hWnd, HPS hPS, short top, short bottom)
{

/* 
  If Microsoft ever gets WinQueryWindowPos working correctly, then
  replace the line 'if (WindowIsIconic(hWnd))' with the following: 
*/
/*
    SWP swp;

    WinQueryWindowPos(hWnd, &swp);

    if ((swp.fs & SWP_MINIMIZE) && (!(swp.fs & SWP_MAXIMIZE))) {
*/

    if (WindowIsIconic(hWnd)) {
        POINTL pt;
	pt.x = 0;
  	pt.y = 0;
	GpiMove(hPS, (PPOINTL)&pt);
	pt.x = xIconsize-1;
	pt.y = yIconsize-1;
        GpiBox(hPS, 2L, (PPOINTL)&pt, 0L, 0L);
        pt.x = 0;
        pt.y = 2 * (yIconsize - MWnd.CHeight) / 3;
        GpiCharStringAt( hPS, (PPOINTL)&pt, (LONG)strlen(szIcon), (PCH)szIcon);
    }
    else
	TTYWndPaint(&MWnd, hPS, top, bottom);
}

/* 
 * Return TRUE if main window is iconic.
 * This kludge is needed since WinQueryWindowPos is not yet fully implemented.
 */
BOOL NEAR WindowIsIconic(HWND hWnd)
{

    RECTL cRect;

  /* get the current window client rectangle */
    WinQueryWindowRect(hWnd, (PRECTL)&cRect);

  /* compare with size when window is iconic */
    if ((cRect.xRight == xIconsize) && (cRect.yTop == yIconsize))
	return TRUE;
 
    return FALSE;
}

/* simple procedure to handle the about box */
MRESULT EXPENTRY AboutBoxProc(HWND hDlg, USHORT msg, MPARAM mp1, MPARAM mp2)
{

    switch (msg) {

	case WM_COMMAND:
	    switch(COMMANDMSG(&msg)->cmd) {
		case DID_OK:
		    WinDismissDlg (hDlg, TRUE);
		    break;
		default:
		    break;
	    }
	    break;

	default:
	    return WinDefDlgProc(hDlg, msg, mp1, mp2);
    }
    return FALSE;
}
