/* b_construct.c -- Listing 3. */

#include <stdlib.h>
#include "textbuf.h"

PUBLIC textbuf *b_construct( textbuf *b, int nrows, int ncols )
{
    /* Initialize a textbuf, Return b on success, NULL on failure */

    bufsize asize = nrows * ncols;

    if( asize >= MAXBSIZE )          /* Won't fit in an 8086 segment */
        b = NULL;
    else if( !(b->buf = BMALLOC(asize)) )  /* get the actual buffer */
        b = NULL;
    else
    {
        b->nrows = nrows;
        b->ncols = ncols;
        b->row   = 0;
        b->col   = 0;
        b->p     = b->buf;
        b_clearbuf( b, ' ' );
        b->magic = B_MAGIC;
    }
    return b;
}
