;*******************************************************************************
;|                                                                             |
;|      Module:         Monochrome Screen access from Windows 3.0              |
;|                                                                             |
;|      Description:    This module demonstrates how to access memory mapped   |
;|                      devices within the Windows environment.                |
;|                                                                             |
;|      Author:         Chris Schwartz  (c) 10/25/90                           |
;|                                                                             |
;*******************************************************************************

                .MODEL SMALL  
                .286

                PUBLIC  DllInit                 ;dll entry point
                PUBLIC  WEP                     ;dll exit point

                PUBLIC  VioInit
                PUBLIC  VioWrtStrAttr
                PUBLIC  VioMovePointer
                PUBLIC  VioShowPointer
                PUBLIC  DpmActiveMode
                PUBLIC  DpmSelectorFromSegment

extrn           __B000H:ABS

                .DATA

bogusData       dw      8 DUP(0)        ;just to keep windows from wigging out
wVideoSeg       dw      0
iShowPtrLevel   dw      0               ;initially dont display pointer
iRow            dw      0
iCol            dw      0
iOldAttr        dw      0

                .CODE
;*******************************************************************************
;|                                                                             |
;|      FAR PASCAL Calling Convention                                          |
;|                                                                             |
;|      BOOL DllInit(VOID); - Dll entry point, called by windows during loading|
;|                                                                             |
;|      Entry Values:   DS = Library Data Segment       ES = Command Line Sel  |
;|                      DI = Module Handle              SI = Command Line Off  |
;|                      CX = Local Heap Size                                   |
;|                                                                             |
;|      Return Values:  AX  = 0 Failed, don't load                             |
;|                      AX != 0 Success, load this puppy.                      |
;|                                                                             |
;*******************************************************************************
;------------------------------------------------------------------------------- 
DllInit         PROC    FAR
                mov     ax, 1           ;load this puppy
                ret
DllInit         ENDP

;*******************************************************************************
;|                                                                             |
;|      FAR PASCAL Calling Convention                                          |
;|                                                                             |
;|      BOOL WEP(WORD wExitMode); - Dll exit point                             |
;|                                                                             |
;|      Return Values:  AX  = 0 Failed Cleanup                                 |
;|                      AX != 0 Success                                        |
;|                                                                             |
;*******************************************************************************
;------------------------------------------------------------------------------- 
WEP             PROC    FAR
                mov     ax, 1           ;goodbye
                ret     2
WEP             ENDP

;*******************************************************************************
;|                                                                             |
;|      FAR PASCAL Calling Convention                                          |
;|                                                                             |
;|      BOOL DpmActiveMode(VOID);                                              |
;|                                                                             |
;|      Return Values:  AX  = 0 Protected Mode under DPMI                      |
;|                      AX != 0 Real mode, or not under DPMI                   |
;|                                                                             |
;*******************************************************************************
;------------------------------------------------------------------------------- 
DpmActiveMode   PROC    FAR
                mov     ax, 1686h       ;DPMI Mode Detection Op Code
                int     2Fh             ;only changes the AX register
                ret
DpmActiveMode   ENDP

;*******************************************************************************
;|                                                                             |
;|      FAR PASCAL Calling Convention                                          |
;|                                                                             |
;|      WORD DpmSelectorFromSegment(WORD);                                     |
;|                                                                             |
;|      Return Value:  AX = 0 Then function failed, else we have a selector.   |
;|                                                                             |
;*******************************************************************************
;-------------- Formal Parameters ---------------------------------------------- 
wRealSegment    equ     [bp+06]
;------------------------------------------------------------------------------- 
DpmSelectorFromSegment  PROC    FAR
                push    bp
                mov     bp, sp

                mov     ax, 02h
                mov     bx, wRealSegment
                int     31h
                jnc     DpmSFSExit              ;return protected mode selector

                xor     ax, ax                  ;return error code
DpmSFSExit:
                pop     bp
                ret     2
DpmSelectorFromSegment  ENDP

;*******************************************************************************
;|                                                                             |
;|      FAR PASCAL Calling Convention                                          |
;|                                                                             |
;|      VOID VioInit(VOID);                                                    |
;|                                                                             |
;*******************************************************************************
;------------------------------------------------------------------------------- 
VioInit         PROC    FAR
                push    ds
                mov     ax, DGROUP
                mov     ds, ax                  ;fixup the dll's data segment

                mov     ax, __B000H
                mov     wVideoSeg, ax
VioInitExit:
                pop     ds
                ret
VioInit         ENDP

;*******************************************************************************
;|      AX = row        DX = col    Return: DX:AX                              |
;*******************************************************************************
ScreenOffset    PROC    NEAR
                mov     bx, ax
                mov     cx, 6
                shl     ax, cl
                sub     cx, 2
                shl     bx, cl
                add     ax, bx
                add     ax, dx
                shl     ax, 1
                mov     dx, wVideoSeg
                ret
ScreenOffset    ENDP

;*******************************************************************************
;|                                                                             |
;|      FAR PASCAL Calling Convention                                          |
;|                                                                             |
;|      VioWrtStrAttr(lpData, wLen, wRow, wCol, lpAttr)                        |
;|                                                                             |
;*******************************************************************************
;-------------- Formal Parameters ---------------------------------------------- 
lpData          equ     [bp+16]
wLen            equ     [bp+14]
wRow            equ     [bp+12]
wCol            equ     [bp+10]
lpAttr          equ     [bp+06]
;------------------------------------------------------------------------------- 
VioWrtStrAttr   PROC    FAR
                push    bp
                mov     bp, sp
                push    ds
                mov     ax, DGROUP
                mov     ds, ax                  ;fixup dll's data segment
                push    es
                push    di
                push    si

                mov     ax, wRow
                mov     dx, wCol

                call    ScreenOffset            ;returns proper video address
                or      dx, dx
                je      VioWrtStrAttrExit

                mov     es, dx
                mov     di, ax
                mov     cx, wLen

                lds     si, lpAttr
                lodsb
                mov     ah, al
                lds     si, lpData

VioWrtStrAttrLoop:

                lodsb
                stosw
                loop    VioWrtStrAttrLoop   ;cook those puppies

VioWrtStrAttrExit:
                pop     si
                pop     di
                pop     es
                pop     ds
                pop     bp
                ret     14
VioWrtStrAttr   ENDP

;*******************************************************************************
;|                                                                             |
;|      FAR PASCAL Calling Convention                                          |
;|                                                                             |
;|      VioMovePointer(wRow, wCol)                                             |
;|                                                                             |
;*******************************************************************************
;-------------- Formal Parameters ---------------------------------------------- 
wRow            equ     [bp+08]
wCol            equ     [bp+06]
;------------------------------------------------------------------------------- 
VioMovePointer  PROC    FAR
                push    bp
                mov     bp, sp
                push    ds
                mov     ax, DGROUP
                mov     ds, ax                  ;fixup dll's data segment
                push    es
                push    di
                push    si

                cmp     iShowPtrLevel, 0
                jle     VMPJustUpdate

                ;now we need to restore the old attr and update the new location

                mov     ax, iRow
                mov     dx, iCol
                call    InternalHidePointer

                mov     ax, wRow
                mov     dx, wCol
                xor     si, si
                call    InternalShowPointer
VMPJustUpdate:
                mov     ax, wRow                ;update internal values
                mov     dx, wCol
                mov     iRow, ax
                mov     iCol, dx
VioMovePointerExit:
                pop     si
                pop     di
                pop     es
                pop     ds
                pop     bp
                ret     4
VioMovePointer  ENDP

;*******************************************************************************
;|      AX = row        DX = col                                               |
;*******************************************************************************
InternalShowPointer     PROC    NEAR
                call    ScreenOffset
                mov     es, dx
                inc     ax
                mov     di, ax
                mov     ax, WORD PTR es:[di]
                mov     iOldAttr, ax
                rol     al, 4
                stosb
                ret
InternalShowPointer     ENDP

;*******************************************************************************
;|      AX = row        DX = col                                               |
;*******************************************************************************
InternalHidePointer     PROC    NEAR
                call    ScreenOffset
                mov     es, dx
                inc     ax                      ;move over to attr byte
                mov     di, ax
                mov     ax, iOldAttr
                stosb
                ret
InternalHidePointer     ENDP

;*******************************************************************************
;|                                                                             |
;|      FAR PASCAL Calling Convention                                          |
;|                                                                             |
;|      VioShowPointer(bTrueFalse)                                             |
;|                                                                             |
;*******************************************************************************
;-------------- Formal Parameters ---------------------------------------------- 
bTrueFalse      equ     [bp+06]
;------------------------------------------------------------------------------- 
VioShowPointer  PROC    FAR
                push    bp
                mov     bp, sp
                push    ds
                mov     ax, DGROUP
                mov     ds, ax                  ;fixup dll's data segment
                push    es
                push    di
                push    si

                mov     ax, bTrueFalse
                or      ax, ax
                je      VSPDecLevel

                inc     iShowPtrLevel
                cmp     iShowPtrLevel, 0
                jbe     VioShowPointerExit

                mov     ax, iRow
                mov     dx, iCol
                call    InternalShowPointer
                jmp     SHORT VioShowPointerExit
VSPDecLevel:
                dec     iShowPtrLevel
                cmp     iShowPtrLevel, 0
                jne     VioShowPointerExit

                mov     ax, iRow
                mov     dx, iCol
                call    InternalHidePointer
VioShowPointerExit:
                pop     si
                pop     di
                pop     es
                pop     ds
                pop     bp
                ret     2
VioShowPointer  ENDP
                END     DllInit
