/* PAN-TEST.c --- Display Color Blocks and then pans the display              */

extern void Video_Mode (int Mode);		/* Set video mode using BIOS          */
extern int SetLineLength (int Length);	/* Sets number of bytes per scan line */
extern void SetViewPosition(int HPixel, int LineNum);	/* sets upper left pixel 
                                                         to be seen on the display */
extern void Set_Pixel(int x, int y, int Color);	/* Set a pixel at coordinate x,y 
                                                   to a color */
void main ()
{
	int i,j,k,l;			/* some loop variables */

	/* Step 1 */
	Video_Mode ( 0x0d );	/* Set the video mode to 320x200x16  */

	/* Step 2 */
	SetLineLength( 80 );	/* 80 Bytes wide virtual screen      */
                            /* Sets up 2 wide by 4 high memory   */
	/* Step 3 */
	SetViewPosition( 0,0 ); /* Display upper left page initially */

	/* Step 4 */
 /* Place graphics in video memory -- Make sure whatever routines you use 
  * properly adjust for the new memory layout.                    */

	for (l=0; l<20; l++)			/* Draw a checkerboard of Colors             */
		for (k=0; k<20; k++)        /* Not all of the board is initially visible */
			for (j=0; j<18; j++)    /*  but will be revealed by panning          */
				for (i=0; i<32; i++)
					Set_Pixel( i+j*32, k + l*20, j + l);

	/* Step 5 -- now we pan a little */
	for (i=0; i<320; i++)           /* 320 is first position page 2      */
		SetViewPosition( i,0 );     /* Do a Horizontal Pan (Pixel)       */

	for (i=320; i>0; i--)           /* Diagonal Pan down and to the left */
		SetViewPosition( i,320-i ); /*  to page 3/5 (120 lines down)     */

	for (i=0; i<320; i++)           /* Vertical Pan up to original pos.  */
		SetViewPosition( 0,320-i ); /*  to page 1   (120 lines down)     */

	Video_Mode ( 3 );               /* Restore to text mode before exit  */
};


