/*	
 *	vmheader.h 
 *	by Stephen Kuhn (The Iliad Group)
 *
 *	Example structures for several pieces of information that the 
 *	VM manager needs to maintain for each VM block.  
 *	It is most convenient to organize them into data structures that refer 
 *	to a single VM block.  
 */

struct vmheader {
	int	location;	/* Current block location: 0=disk,1=RAM */
	char *addr;		/* RAM location, if in RAM */
	int	prev;		/* MRU chain previous */
	int	next;		/* MRU chain next */
	int	number;		/* VM Block # contained in this struct */
	int	free;		/* Free chain next ptr */
	int	qfree;		/* Queued free chain head */
	int	allocs;		/* # allocations this block */
	int	dirty;		/* Has block been modified? */
	int	maxfree;	/* Maximum free block size */
	int	memtype;	/* Block type: DOS or EMS */
	int	windnum;	/* If an EMS block, the hardware window */
	int	pagenum;	/* If an EMS block, the software page */
};

struct freeblk	{
	int	next;		/* Offset of the next free chunk of mem */
	int	size;		/* The size of this free chunk */
};

