/*	v_gotorc.c- Move Cursor Within Viewport */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_gotorc( viewport *v, unsigned row, unsigned col )
{
    /* Move the cursor to the indicated viewport-relative row
     * and column. The cursor is not allowed to go past the edge
     * of the viewport. Nonetheless, it will go as far as possible
     * in the required direction. Return true if the cursor ended
     * up where specified, false if it didn't because it bumped
     * up against the side of the viewport.
     */

    if( v->magic != VMAGIC )
        return 0;

    if( v->inactive )
        v_open( v );

    v->cur_row = min( row, v->nrows - 1 ); /* truncate to fit in window */
    v->cur_col = min( col, v->ncols - 1 );

    window( v->col+1, v->row+1, v->col+v->ncols, v->row+v->nrows );
    gotoxy( v->cur_col + 1, v->cur_row + 1 );

    return (v->cur_row == row  &&  v->cur_col == col);
}
