/*
 * Header file for the Windows properly list demo
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

/* This trick insures that globals are declared in only one place */
#if !defined(EXTERN)
#define EXTERN extern
#endif

/* Resource string constants */
#define IDS_APPNAME	100
#define IDS_ICON	101
#define IDS_TITLE	102

/* menu items */
#define IDM_ALLOC	100
#define IDM_PROP	101
#define IDM_ABOUT	102

/* dialogs */
#define DT_ABOUT	1

/* Control window id's */
#define IDD_ALLOC	1
#define IDD_ENUM	2

/* Global variables */
EXTERN HWND hWndMain;		/* main window handle */
EXTERN char szAppName[20];	/* name of the application */
EXTERN HWND hWndList;		/* memory allocations display window */
EXTERN HWND hWndEnum;		/* property list display window */
EXTERN HANDLE hInst;		/* instance handle */

/* Declarations which need to be known in several C source files */
LONG FAR PASCAL MainWndProc(HWND,unsigned,WORD,LONG);
BOOL FAR InitProgram(HANDLE, HANDLE, LPSTR, int);
int FAR PASCAL EnumPropCallBack(HWND hWnd, WORD nDummy, PSTR str, HANDLE hData);
BOOL FAR WndCreate(HWND hWnd);
void FAR _cdecl dbs(const char *fmt, ...);

/* memory allocation and property list functions */
void FAR UpdateList(HWND hWnd);
LPSTR FAR AllocMem(HWND hWnd, int size);
void FAR FreeMem(HWND hWnd);

/* Simple data structure to be stored in each chunk of memory allocated */
typedef struct _MYDATA {
    BYTE data[16];
} MYDATA;
