'DIR.BAS by Dave Cleary
'
'One of the most useful additions to BASIC 7 PDS is the DIR$ function.
'This function allows you to read a directory of filenames. It also
'allows you to check the existence of a file by doing the following:
'
'  IF LEN(DIR$("COMMAND.COM")) THEN
'     PRINT "File Found"
'  ELSE
'     PRINT "File not found"
'  END IF
'
'Now QuickBASIC 4.X users can have this useful function for their
'programs.
'
'Calling DIR$ with a FileSpec$ returns the the name of the FIRST
'matching file name. Subsequent calls with a null FileSpec$ return the
'NEXT matching file name. If a null string is returned, then no more
'matching files were found. FileSpec$ can contain both a drive and a
'path plus DOS wildcards. Special care should be taken when using
'this on floppy drives because there is no check to see if the drive
'is ready.

DEFINT A-Z

DECLARE FUNCTION DIR$ (FileSpec$)

'$INCLUDE: 'QB.BI'

'-----  Some constants that DIR$ uses
CONST DOS = &H21
CONST SetDTA = &H1A00, FindFirst = &H4E00, FindNext = &H4F00

'--------------------------------------------------------------------
'This shows how to call DIR$ to find all matching files

'CLS
'FileSpec$ = "C:\QB\SOURCE\*.BAS"
'Found$ = DIR$(FileSpec$)
'DO WHILE LEN(Found$)
'   PRINT Found$
'   Found$ = DIR$("")
'LOOP

'--------------------------------------------------------------------

FUNCTION DIR$ (FileSpec$) STATIC

   DIM DTA AS STRING * 44, Regs AS RegTypeX
   Null$ = CHR$(0)

'-----  Set up our own DTA so we don't destroy COMMAND$
   Regs.AX = SetDTA                    'Set DTA function
   Regs.DX = VARPTR(DTA)               'DS:DX points to our DTA
   Regs.DS = -1                        'Use current value for DS
   InterruptX DOS, Regs, Regs          'Do the interrupt

'-----  Check to see if this is First or Next
   IF LEN(FileSpec$) THEN              'FileSpec$ isn't null, so
                                       'FindFirst
      FileSpecZ$ = FileSpec$ + Null$   'Make FileSpec$ into an ASCIIZ
                                       'string
      Regs.AX = FindFirst              'Perform a FindFirst
      Regs.CX = 0                      'Only look for normal files
      Regs.DX = SADD(FileSpecZ$)       'DS:DX points to ASCIIZ file
      Regs.DS = -1                     'Use current DS
   ELSE                                'We have a null FileSpec$,
      Regs.AX = FindNext               'so FindNext
   END IF

   InterruptX DOS, Regs, Regs          'Do the interrupt

'-----  Return file name or null
   IF Regs.Flags AND 1 THEN            'No files found
      DIR$ = ""                        'Return null string
   ELSE
      Null = INSTR(31, DTA, Null$)     'Get the filename found
      DIR$ = MID$(DTA, 31, Null - 30)  'It's an ASCIIZ string starting
   END IF                              'at offset 30 of the DTA

END FUNCTION
