;============================================================================
; A selection of Video macros
;Updated 9/26/90
;============================================================================

Wait_CGA_Retrace    Macro
	Local   WAITV, WAITH, FINIS
;;------------------------------------------------------------------
;;Description: Snow prevention on a CGA, about 25% faster
;;than approach that merely uses horizontal retrace.
;;This macro waits for the first of the following to occur:
;; a vertical retrace (max memory move on a PC w/ CGA is 400 words;
;; however this routine is not used that way).
;; a horizontal retrace (max memory move on a CGA is 1 word)
;; Input:
;;  Call with CLI.  Assumes:  03DAh in DX, (CGA status register)
;; Modifies:
;;  DX and AL
;; Logic:
;;  if in the middle of vertical retrace, then end
;;    (and assume routine can move at least one word)
;;  if in the middle of horizontal retrace, wait until a
;;     new horizontal retrace starts, then end
;;    (and assume routine can move at least one word)
;; After write one word, turn on interrupts again STI !!!
;; Faster than just relying on horizontal retrace, because some CGA's
;; appear to turn off horizontal retrace when vertical retrace is on
;;------------------------------------------------------------------
WAITV:
	In	AL,DX	;;Read CRT status register
	Test	AL,8	;;Check if vertical retrace
	Jnz	FINIS	;;if yes, assume that can write at least 1 word
	Rcr	AL,1	;;see if bit 1, Horizontal retrace set
	Jc      WAITV   ;;if it is set start loop again
WAITH:
	In	AL,DX	;;Read CRT status again
	Rcr	AL,1	;;Wait for horizontal retrace so we can start
	Jnc     WAITH   ;;not yet, keep trying
FINIS:			;;rest of routine can now write at least one word
	endm



comment         |*
Set_DI_Offset     macro
	 ;; standard routine for 80 x 25 display
	 ;; Input  : COLL in DL, ROW in DH
	 ;; Returns: Offset within Video Segment in DI
	 ;; Uses & destroys DX,AX,CL
	 ;; Macro is used because inline code speeds routine
			 ;8088 ;80286
	 Xor   AX,AX     ;3    ;2
	 Mov   AL,DH     ;2    ;2  ;;put the current ROW number into AL
	 Mov   CL,160    ;4    ;2  ;;multiply by 160 to get start address of ROW
	 Mul   CL        ;77   ;13 ;;do the multiplication, answer ends up in AX
	 Xor   DH,DH     ;3    ;3  ;;clear DH for the Add below, we only want DL
	 Add   AX,DX     ;3    ;2  ;;add the column once for the character byte
	 Add   AX,DX     ;3    ;2  ;;and once more for the attribute byte
	 Mov   DI,AX     ;2    ;2  ;;now DI holds starting address on the screen
	 endm            ;-------
			 ;97   ;28  clocks
	*|

Set_DI_Offset     macro
	;;This is slightly faster in the abstract
	;;sense on a 80286, though wont see it.
	;;Cannot observe the difference on a 8088 with a CGA,
	;;because of delay waiting for retrace
	;;
	;; Setup for 80 column display because that is all QBASIC supports
	;;
	;; Input:     DH = Row :  DL = Column
	;; Output:    DI = Memory Offset
	;; Destroys:  CX
	;; Macro is used because inline code speeds routine
	;;              ;8086  ;80286
	Xor     CL, CL     ;3   ;2   ;; Clear CL
	Mov     CH, DH     ;2   ;2   ;; CX = Row * 256
	Shr     CX, 1      ;2   ;2   ;; CX = Row * 128
	Mov     DI, CX     ;2   ;2   ;; Store in DI
	Shr     DI, 1      ;2   ;2   ;; DI = Row * 64
	Shr     DI, 1      ;2   ;2   ;; DI = Row * 32
	Add     DI, CX     ;3   ;2   ;; DI = (Row * 128)+(Row * 32)={Row*160}
	Xor     CH, CH     ;3   ;2   ;; Clear CH register
	Mov     CL, DL     ;2   ;2   ;; CX = Columns
	Shl     CX, 1      ;2   ;2   ;; Account for attribute
	Add     DI, CX     ;3   ;2   ;; DI = (Row * 160) + (Col * 2)
			  ;--------
      endm                ;26   ;22  ;; clocks

