








              Quarterdeck Technical Note

              Subject:  Patching QEMM-386 5.00, 5.10, 5.11, and 
              5.12 to resolve problems with programs that resize 
              EMS or XMS handles 

                Background: Starting with QEMM-386 5.00, QEMM-386 
              supports both the EMS (Expanded Memory 
              Specification), which governs access to expanded 
              memory, and the more recent XMS (Extended Memory 
              Specification), which governs access to extended 
              memory.  Requests for EMS and for XMS memory are 
              both filled from the same pool of QEMM-managed 
              memory, and EMS and XMS handles (numbers that the 
              memory manager returns to a program when the 
              program takes a chunk of memory, so that the 
              program can quickly identify the chunk when it next 
              communicates with the memory manager) are managed 
              together by QEMM-386.

                Both EMS and XMS contain a call that programs can 
              make to reallocate blocks of memory; that is, to 
              take a handle that the program has already received 
              and increase or decrease the chunk of memory to 
              which the handle refers.  Users of QEMM-386 
              versions 5.00 through 5.12 may experience system 
              instability under certain circumstances when a 
              program makes an EMS or XMS call to increase the 
              size of a handle.  The symptom is likely to be a 
              system crash or a reboot.  

                Users of versions of QEMM-386 after version 5.12 
              should not experience this problem.  In the 
              meantime, QEMM-386 can be patched to eliminate the 
              problem.  


                The following procedure is intended to prevent 
              system crashes and reboots when Reallocate Memory 
              EMS and XMS functions are used to increase the size 
              of EMS and XMS handles.  This procedure is for use 
              with QEMM-386 versions:

                      5.10 
                      5.11 
                      5.12

              ***************************************************
              
                Do NOT use this patch for QEMM-386 5.0; a 
              separate procedure for QEMM-386 5.0 is later in 
              this technote.  If you are in doubt, go to the 
              directory where the QEMM-386 files are located and 
              check the date on the QEMM386.SYS file by issuing 
              the DOS command:

                        DIR QEMM386.SYS

              If the date on the file is

                        5:10 am 
                        5:11 am 
                        5:12 am

              then use the patch in this section. If there is no 
              QEMM386.SYS file in this directory, then you 
              probably have an earlier version of QEMM-386; go 
              forward to the section that deals with the patch 
              for QEMM-386 5.0. 

              *************************************************** 

                1) Make a copy of the QEMM386.SYS file in your 
              QEMM directory.  We are about to alter your current 
              copy of QEMM386.SYS; the copy you make will serve 
              as a backup in case this operation fails.

                    COPY C:\QEMM\QEMM386.SYS C:\QEMM\QEMM386.OLD

                (If your QEMM386.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                2) Go to the DOS directory on the hard disk and 
              type:

                  DEBUG C:\QEMM\QEMM386.SYS

                (If your QEMM386.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                Hit the Enter key; you should see the DEBUG 
              prompt, which is a hyphen.

                3) At the DEBUG prompt, type:

                  S 100 L F000 75 6 1 0E

                Hit the Enter key; DEBUG should return a segment 
              address and an offset:

                  xxxx:yyyy

                4) At the DEBUG prompt again, use the segment 
              address and offset that was just returned to give 
              the DEBUG command:

                  E xxxx:yyyy EB 
   
                The address that DEBUG returned in step 3 should 
              be used in place of the address xxxx:yyyy, which we 
              use as an example.  Hit the Enter key; the DEBUG 
              prompt should return in a moment.


                5) At the DEBUG prompt, type

                  W

                Hit the Enter key; DEBUG will announce that it is 
              writing a certain number of bytes, then it will 
              return the DEBUG prompt.

                6) At the DEBUG prompt, type

                  Q

                Hit the Enter key to exit DEBUG and return to 
              DOS.  

                7) To double-check your patch, type the following 
              from the DOS prompt in your DOS directory:

                  COMP C:\QEMM\QEMM386.SYS C:\QEMM\QEMM386.OLD

               (If your QEMM386.SYS is not located in the QEMM
              directory of the C: drive, change the path
              accordingly.)

                Hit the Enter key.  COMP should return:


                            C:QEMM386.SYS and C:QEMM386.OLD

                            Compare error at OFFSET xxxx
                            File 1 = EB

                            File 2 = 75

                            Eof mark not found

                            Compare more files (Y/N)?

                The value xxxx after OFFSET will vary from 
              version to version of QEMM 5.1, but the rest of the 
              message should be the same: it tells us that 
              there is exactly one byte difference between the 
              files, and the differing byte is EB in QEMM386.SYS
              and 75 in QEMM386.OLD.  If COMP returns the 
              message:

                            Files compare ok  

              ...then you probably failed to use DEBUG's W 
              command to save your change, or you have compared 
              the wrong files.  If COMP returns more than one 
              compare error, or if the bytes returned by the 
              compare error don't match those in the above 
              example, the procedure has failed.  In this case, 
              use the DOS command:

                  COPY C:\QEMM\QEMM386.OLD C:\QEMM\QEMM386.SYS

              ... to restore the original file, and try again.

              If the patch was successful, you should now reboot 
              the system and test the patched version of QEMM-
              386.  If the patched version of QEMM-386 fails, see 
              the section at the end of the technote on restoring 
              your original copy.  Otherwise, you are finished 
              with the patch.

                            
              ---------------------------------------------------


                The following procedure is intended to prevent 
              system crashes and reboots when Reallocate Memory 
              EMS and XMS functions are used to increase the size 
              of EMS and XMS handles with QEMM 5.00.  
              

              ***********************************************

              This patch is for:

                       QEMM-386 5.00

              A separate procedure for other versions appears 
              earlier in this technote.  If you are in doubt, go 
              to the directory where the QEMM-386 files are 
              located and check the date on the QEMM.SYS file by 
              issuing the DOS command:

                          DIR QEMM.SYS

              If the date on the file is

                           5:00 am

              then this patch is the one to use.  If there is no
              QEMM.SYS file in this directory, then you probably 
              have a later version of QEMM-386; go back to the 
              section that deals with the patch for QEMM-386 5.1.

              ***************************************************

                1) Make a copy of the QEMM.SYS file in your QEMM 
              directory.  We are about to alter your current copy 
              of QEMM.SYS; the copy you make will serve as a 
              backup in case this operation fails.

                    COPY C:\QEMM\QEMM.SYS C:\QEMM\QEMM.OLD

                (If your QEMM.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                2) Go to the DOS directory on the hard disk and 
              type:

                  DEBUG C:\QEMM\QEMM.SYS

                (If your QEMM.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                Hit the Enter key; you should see the DEBUG 
              prompt, which is a hyphen.

                3) At the DEBUG prompt, type:

                  S 100 L F000 75 7 1 0E

                Hit the Enter key; DEBUG should return a segment 
              address and an offset:

                  xxxx:yyyy

                4) At the DEBUG prompt again, use the segment 
              address and the offset that was just returned to 
              give the DEBUG command:

                  E xxxx:yyyy EB 
   
                The address that DEBUG returned in step 3 should 
              be used in place of the address xxxx:yyyy, which we 
              use as an example.  Hit the Enter key; the DEBUG 
              prompt should return in a moment.


                5) At the DEBUG prompt, type

                  W

                Hit the Enter key; DEBUG will announce that it is 
              writing a certain number of bytes, then it will 
              return the DEBUG prompt.

                6) At the DEBUG prompt, type

                  Q

                Hit the Enter key to exit DEBUG and return to 
              DOS.    

                7) To double-check your patch, type the following 
              from the DOS prompt in your DOS directory:

                  COMP C:\QEMM\QEMM.SYS C:\QEMM\QEMM.OLD

               (If your QEMM.SYS is not located in the QEMM
              directory of the C: drive, change the path
              accordingly.)

                Hit the Enter key.  COMP should return:


                            C:QEMM.SYS and C:QEMM.OLD

                            Compare error at OFFSET xxxx
                            File 1 = EB

                            File 2 = 75

                            Eof mark not found

                            Compare more files (Y/N)?

                The value xxxx after OFFSET may vary, but the 
              rest of the message should be the same: it tells us 
              that there is exactly one byte difference between 
              the files, and the differing byte is EB in 
              QEMM.SYS and 75 in QEMM.OLD.  If COMP returns 
              the message:

                            Files compare ok  

              ...then you probably failed to use DEBUG's W 
              command to save your change, or you have compared 
              the wrong files.  If COMP returns more than one 
              compare error, or if the bytes returned by the 
              compare error don't match those in the above 
              example, the procedure has failed.  In this case, 
              use the DOS command:

                  COPY C:\QEMM\QEMM.OLD C:\QEMM\QEMM.SYS

              ... to restore the original file, and try again.

              If the patch was successful, you should now reboot 
              the system and test the patched version of QEMM-
              386.  
              

              --------------------------------------------------

                If the system fails after you perform this patch, 
              you can follow the instructions in the 
              "Installation" section of your QEMM-386 manual to 
              recover without resorting to a boot floppy.  After 
              your system is booted successfully, copy the backup 
              of QEMM-386 that you made back to its original 
              name.  If you are using QEMM-386 5.00, use the 
              following DOS command:

                  COPY C:\QEMM\QEMM.OLD C:\QEMM\QEMM.SYS

                If you have QEMM-386 5.1, use the following DOS 
              command instead:

                  COPY C:\QEMM\QEMM386.OLD C:\QEMM\QEMM386.SYS

                (If your QEMM.SYS or QEMM386.SYS is not located 
              in the QEMM directory of the C: drive, change the 
              path accordingly.)

                You may then wish to try the above procedure 
              again, in case a mistake was made.

             * * *   E N D   O F   F I L E    * * *
