
;Ŀ
;                                                                   
;  
;  ߱ 
;                           
;         ߱ ߱ ߱ ߱    
;                      ۱  
;                   
;         ߱ ߱      ߱ ۱   
;                      
;           ߱      
;                                 
;                                                                   
;           ۲   Versin 2.1   ۲           
;                                                                   
;                                                                   
;     CONTROLADOR DE DISCO VIRTUAL PARA SISTEMAS DOS Y WINDOWS 3    
;                                                                   
;              * * * Programa de Dominio Pblico * * *              
;                                                                   
;              (c) Enero 1993  Ciriaco Garca de Celis.             
;     Grupo Universitario de Informtica. Facultad de Ciencias.     
;                Apartado 6062 - Valladolid (Espaa)                
;                                                                   
;                        Mail (Internet):                           
;                                gui@cpd.uva.es                     
;                                amiga@hp9000.uva.es                
;                        (Subject: "Mensaje para 040")              
;                                                                   
;

   ;   Aviso:   Este programa contiene instrucciones exclusivas de los
   ;          procesadores 386 y superiores.  Debe ser ensamblado como
   ;          fichero  EXE,  de la siguiente manera,  para asegurar la
   ;          compatibilidad con los procesadores 8086 y 286:
   ;
   ;          - Con TASM 2.0:
   ;                            TASM tdsk /m3
   ;                            TLINK tdsk
   ;
   ;          - Con MASM 6.0  (versiones anteriores de MASM generaran
   ;            un disco virtual que requerira  un  386  o  superior,
   ;            adems habra que mover las directivas  que  controlan
   ;            el tipo de procesador y colocarlas con peligro):
   ;
   ;                            ML /Zm tdsk.asm
   ;
   ;                o alternativamente:
   ;
   ;                            ML /c /Zm tdsk.asm
   ;                            TLINK tdsk
   ;
   ;               La ventaja de TLINK frente a LINK es que el fichero
   ;            ejecutable ocupa  2 Kbytes  menos en disco (a la tabla
   ;            ubicada al final del programa  se  le  asigna  memoria
   ;            en la cabecera del fichero EXE y no ocupando disco).
   ;
   ;   IMPORTANTE:  Cualquier cambio realizado en el programa debe ser
   ;                documentado,  indicando claramente en el listado y
   ;                en el fichero DOC quin lo ha realizado.


; ------------ Macros de propsito general

XPUSH          MACRO regmem            ; apilar lista de registros
                 IRP rm, <regmem>
                   PUSH rm
                 ENDM
               ENDM

XPOP           MACRO regmem            ; desapilar lista de registros
                 IRP rm, <regmem>
                   POP rm
                 ENDM
               ENDM

; ------------ Estructuras de datos

cab_PETICION   STRUC                   ; parte inicial comn a todos
tamano         DB    ?                 ; los comandos de la cabecera
unidad         DB    ?                 ; de peticin
orden          DB    ?
estado         DW    ?
dos_info       DB    8 DUP (?)
cab_PETICION   ENDS

cab_INIT_BBPB  STRUC                   ; para comandos INIT/BUILD_BPB
               DB    (TYPE cab_PETICION) DUP (?)
num_discos     DB    ?                 ; nmero de unidades definidas
fin_resid_desp DW    ?                 ; rea que quedar residente
fin_resid_segm DW    ?
bpb_cmd_desp   DW    ?                 ; lnea de rdenes del CONFIG
bpb_cmd_segm   DW    ?                 ; y puntero al BPB
nuevo_disco    DB    ?                 ; (DOS 3+) (0-A:, 1-B:,...)
cab_INIT_BBPB  ENDS

cab_MEDIACHECK STRUC                   ; estructura para MEDIA CHECK
               DB    (TYPE cab_PETICION) DUP (?)
media_descrip  DB    ?                 ; descriptor de medio
cambio         DB    ?                 ; 1: no cambiado, 0FFh:s, 0:?
cab_MEDIACHECK ENDS

cab_READ_WRITE STRUC
               DB    (TYPE cab_PETICION) DUP (?)
               DB    ?                 ; descriptor de medio
transfer_desp  DW    ?                 ; direccin de transferencia
transfer_segm  DW    ?
transfer_sect  DW    ?                 ; n de sectores a transferir
transfer_sini  DW    ?                 ; primer sector a transferir
cab_READ_WRITE ENDS


; ************ Disco virtual: inicio del rea residente.

_PRINCIPAL     SEGMENT
               ASSUME CS:_PRINCIPAL, DS:_PRINCIPAL

               DD    -1           ; encadenamiento con otros drivers
tipo_drive     DW    0800h        ; palabra de atributo:
                                  ; bit 15 a 0: dispositivo de bloques
                                  ; bit 14 a 0: sin control IOCTL
                                  ; bit 13 a 0: formato IBM
                                  ; bit 11 a 1: soportados Open/Close
                                  ;             y Remove (DOS 3.0+)
               DW    estrategia   ; rutina de estrategia
               DW    interrupcion ; rutina de interrupcin
               DB    1            ; nmero de unidades

; ------------ Variables y tablas de datos globales fijas. Estas
;              variables no sern movidas de sitio en otras versiones
;              de TURBODSK, con objeto de facilitar un control externo
;              del disco virtual por parte de otros programas. Todo lo
;              que est dentro del rea a actualizar ser copiado
;              sobre el TURBODSK residente al redefinir el disco, para
;              inicializar todas las variables precisas.

cs_tdsk        DW    ? ; Segmento de TDSK. Con QEMM-386, los drivers
                       ; pueden ser relocalizados en memoria superior
                       ; de tal manera que parte de la cabecera queda
                       ; en memoria convencional, con el dispositivo
                       ; completo en la memoria superior, en la que es
                       ; ejecutado. Tras la instalacin, QEMM copia en
                       ; memoria convencional los primeros 18 bytes de
                       ; la cabecera, entre los que est esta palabra,
                       ; actualizndola. Pese a que la cadena de
                       ; dispositivos del sistema pasa por la memoria
                       ; convencional en este caso, esta variable nos
                       ; permite conocer la direccin REAL en memoria
                       ; superior (o en cualquier otra) de TURBODSK,
                       ; que as es compatible con el LOADHI de QEMM.

id_tdsk        DB    "TDS21" ; esto es TURBODSK 2.1 y no otro
                             ; controlador de dispositivo

num_ordenes    DB    10h     ; n de rdenes soportadas

i_tdsk_ctrl    EQU   $       ; inicio del rea a actualizar

tipo_soporte   DB    0FFh    ; 0: disco no formateado
                             ; 1: se emplea memoria XMS 2.0+
                             ; 2:  "    "     "     EMS 3.2+
                             ; 3:  "    "     " convencional
                             ; 0FFh: an no ejecutada INIT

cambiado       DB    ?       ; al formatear el disco virtual se pone
                             ; a 0FFh (para indicar cambio de disco)

mem_handle     DW    ?       ; para memoria EMS/XMS; si se utiliza
                             ; memoria convencional, apunta al
                             ; segmento donde empieza el disco

tdsk_psp       DW    ?       ; segmento del PSP residente si se
                             ; utiliza memoria convencional

ems_pagina0    DW    ?       ; segmento de pgina EMS (si se emplea)
ems_paginai    DW    ?       ; segmento alternativo
ems_pagni      DB    ?       ; n de pgina fsica alternativa

xms_driver     LABEL DWORD   ; direccin del controlador XMS, en el
xms_desp       DW    ?       ; caso de emplear memoria XMS.
xms_segm       DW    ?

cpu386         DB    OFF     ; a ON si 386  superior

f_tdsk_ctrl    EQU   $       ; final del rea a actualizar

letra_unidad   DB    ?       ; letra ASCII del disco ('C', 'D',...)

bpb_ptr        DW    bpb     ; puntero al BPB del disco

rutina_larga   DB    OFF     ; a ON si reservado espacio en
                             ; memoria para la larga rutina de
                             ; gestin de memoria EMS.

; ------------ Variables internas de TURBODSK; su ubicacin podra
;              cambiar en futuras versiones del programa.

pcab_peticion  LABEL DWORD        ; puntero a la cabecera de peticin
pcab_pet_desp  DW    0
pcab_pet_segm  DW    0

p_rutinas      LABEL WORD         ; tabla de rutinas del controlador
               DW    init
               DW    media_check
               DW    build_bpb
               DW    ioctl_input
               DW    read
               DW    read_nowait
               DW    input_status
               DW    input_flush
               DW    write
               DW    write_verify
               DW    output_status
               DW    output_flush
               DW    ioctl_output
               DW    open              ; DOS 3.0+
               DW    close             ; DOS 3.0+
               DW    remove            ; DOS 3.0+

media          EQU   0FAh    ; byte descriptor de medio utilizado por
                             ; TURBODSK. No es 0F8h como en los discos
                             ; virtuales del sistema ya que TURBODSK
                             ; no es un dispositivo fijo. Este byte no
                             ; es empleado por los discos estndar del
                             ; dos y al ser mayor de 0F7h no provoca
                             ; mensajes extraos con antiguos CHKDSKs.

bpb            LABEL BYTE    ; Estos valores del BPB son arbitrarios:
bytes_sector   DW    512     ; se inicializarn si se define el disco
sect_cluster   DB    1       ; al instalar desde el CONFIG; en caso
sect_reserv    DW    1       ; contrario, como son correctos, el DOS
num_fats       DB    1       ; no tendr problemas para realizar sus
entradas_raiz  DW    128     ; clculos internos iniciales al instalar
num_sect       DW    128     ; el driver. En concreto, el tamao de
media_byte     DB    media   ; sector influye de manera directa en el
sectores_fat   DW    4       ; tamao de los buffers de disco del DOS.
fin_bpb        EQU   $

; ------------ Rutina de estrategia del disco virtual.

estrategia     PROC  FAR
               MOV   CS:pcab_pet_desp,BX
               MOV   CS:pcab_pet_segm,ES
               RET
estrategia     ENDP

; ------------ Rutina de interrupcin del disco virtual. TURBODSK,
;              al igual que RAMDRIVE o VDISK, no define una pila
;              interna. Es responsabilidad del DOS que sta tenga el
;              tamao adecuado (con el disco en memoria XMS, el
;              controlador XMS puede requerir hasta 256 bytes de
;              pila). TURBODSK no consume ms de 64 bytes de pila en
;              ningn momento, y slo alrededor de 48 antes de llamar
;              al controlador XMS cuando se emplea esta memoria.

interrupcion   PROC  FAR
               XPUSH <AX,BX,CX,DX,SI,DI,BP,DS,ES>
               LDS   BX,CS:pcab_peticion
               MOV   AL,[BX].orden     ; AL = orden
               MOV   AH,0              ; AX = orden
               CMP   AL,CS:num_ordenes
               JB    orden_ok          ; orden soportada
               MOV   AL,3              ;   " desconocida (IOCTL INPUT)
orden_ok:      CMP   CS:tipo_soporte,AH
               JNE   no_test_fmt       ; tipo_soporte distinto de 0
               MOV   AX,8102h          ; disco no formateado: error
               JMP   exit_interr
no_test_fmt:   SHL   AX,1              ; orden = orden * 2
               MOV   SI,AX
               XPUSH <BX,DS>
               XOR   BP,BP
               MOV   AX,100h
               CALL  CS:[SI+OFFSET p_rutinas]  ; ejecutar orden
               XPOP  <DS,BX>
               AND   AH,AH
               JNS   exit_interr          ; no hubo error (bit 15 = 0)
               CMP   AL,3
               JE    exit_interr          ; error de orden desconocida
               MOV   [BX].transfer_sect,0 ; otro: movidos 0 sectores
exit_interr:   MOV   [BX].estado,AX
               XPOP  <ES,DS,BP,DI,SI,DX,CX,BX,AX>
               RET
interrupcion   ENDP

; ------------ Las rutinas que controlan el dispositivo devuelven AX
;              con la palabra de estado. Pueden cambiar todos los
;              registros (de 16 bits), includos los de segmento. A la
;              entrada, BP=0 y AX=100h.

media_check:   MOV   AL,CS:cambiado    ; condicin de disco cambiado
               MOV   CS:cambiado,AH    ; de momento ya no cambiar ms
               MOV   [BX].cambio,AL

read_nowait:                           ; conjunto de rdenes con
input_status:                          ; tratamiento idntico
input_flush:
output_status:
output_flush:
ioctl_output:
open:
close:
retorno_ok:    RET                     ; no hay error, ignorar orden

build_bpb:     MOV   [BX].bpb_cmd_desp,OFFSET bpb
               MOV   [BX].bpb_cmd_segm,CS
               JMP   retorno_ok

ioctl_input:   MOV   AX,8103h          ; orden no soportada
               RET

remove:        MOV   AH,3              ; fin de funcin, indicar
               RET                     ; controlador ocupado

nueva_int19    PROC                    ; Interceptar reinicializacin
               .286
               PUSHA
               XPUSH <DS,ES>           ; Esto es una interrupcin
               XOR   AX,AX
               MOV   ES,AX
               CMP   AL,CS:tipo_soporte ; Disco formateado?
               JE    no_lib             ; no
               MOV   CS:tipo_soporte,AL ; s: anularlo
               CALL  procesa_io        ; CF=1: liberar memoria EMS/XMS
no_lib:        LEA   SI,ant19off
               MOV   DI,64h            ; desplazamiento de INT 19h
               PUSH  CS
               POP   DS
               CLI
               MOVSW
               MOVSW
               XPOP  <ES,DS>
               POPA
               DB    0EAh              ; cdigo de JMP FAR SEG:OFF
ant19off       DW    ?
ant19seg       DW    ?
               .8086
nueva_int19    ENDP

read:          INC   BP                ; indicar lectura (BP=1)
write:                                 ; escritura (BP=0)
write_verify:

init_io        PROC                        ; preparar registros E/S
               LES   DI,DWORD PTR [BX].transfer_desp  ; * direc. ES:DI
               LDS   AX,DWORD PTR [BX].transfer_sect  ; n sectores AX
               MOV   BX,DS                 ; 1 sector DS indefinido!
io_proc:       MOV   SI,CS:bytes_sector
               ADD   AX,BX
               JNC   io_ok?                ; ltimo sector < 65536
io_no_ok:      MOV   AX,8108h              ; sector no encontrado
               RET
io_ok?:        CMP   AX,CS:num_sect
               JA    io_no_ok              ; sector final fuera!
               SUB   AX,BX
               MUL   SI                    ; DX(CF):AX = tamao bloque
               RCR   AX,1                  ; CF:AX/2 -> AX = palabras
               MOV   CX,DI
               NEG   CX                    ; 10000h-CX: CF=1 si CX<>0
               CMC                         ; CF:CX bytes hasta fin de
               RCR   CX,1                  ; segmento = (10000h-DI)/2
               CMP   AX,CX
               JAE   io_cx_ok
               MOV   CX,AX                 ; * tamao: CX palabras
io_cx_ok:      JCXZ  io_no_ok              ; CX=0 si DI=0FFFFh (fatal)
               MOV   AX,BX                 ; sector inicial
               MUL   SI                    ; * desplazamiento en DX:AX
               CLC                         ; no reinicializando!
init_io        ENDP

; ------------ Area residente dependiente del tipo de memoria empleada
;              por el disco. La rutina instalada por defecto es la ms
;              larga de todas, para dejar hueco donde copiar encima
;              las otras si se va a utilizar otro tipo de memoria. Si
;              se modifican las rutinas, convendra medirlas por si
;              acaso la de memoria EMS deja de ser la ms larga...

procesa_io     EQU   $

               ; ---- La rutina de gestin de memoria EMS transfiere
               ;      bloques de hasta 16Kb de una vez. Intenta mapear
               ;      en la pgina fsica 0: si no puede, debido a un
               ;      solapamiento con el buffer de transferencia del
               ;      programa principal (si est tambin en memoria
               ;      EMS), utiliza otra pgina alternativa que dista
               ;      al menos 32 Kb absolutos de la 0. Para dilucidar
               ;      si hay solapamiento, se compara la distancia
               ;      entre direcciones origen y destino antes de la
               ;      transferencia: si es mayor de 401h prrafos
               ;      (16400 bytes, 16 para redondeo) no hay problema.
               ;      Ante un solapamiento se procede a restaurar el
               ;      contexto de las pginas mapeadas, antes y
               ;      despus de la transferencia, para poder acceder
               ;      a la memoria expandida donde est el buffer del
               ;      programa principal.

procesa_ems    PROC
               JNC   no_emslib
               MOV   DH,45h            ; sistema reinicializando:
               CALL  llama_EMM         ; liberar memoria EMS
               RET
no_emslib:     MOV   SI,DX             ; preservar DX
               MOV   DH,47h
               CALL  llama_EMM         ; DH=47h -> salvar contexto EMS
               MOV   DX,SI             ; recuperar DX
               MOV   BX,4000h          ; tamao de pgina (16 Kb)
               DIV   BX                ; AX = 1 pgina EMS a mapear
               MOV   SI,DX             ; offset relativo en 1 pgina
procesa_pag:   PUSH  CX                ; **
               MOV   BX,DI
               MOV   CL,4
               SHR   BX,CL             ; bytes del offset -> prrafos
               MOV   CX,ES
               ADD   BX,CX             ; AX = segmento de datos
               MOV   CX,CS:ems_pagina0
               MOV   DS,CX
               XOR   DL,DL             ; intentar emplear pgina 0
               SUB   BX,CX
               JNC   rpos
               NEG   BX                ; valor absoluto
rpos:          CMP   BX,401h           ; distancia respecto pgina EMS
               JAE   no_conflicto      ; ms de 16 Kb: no solapamiento
               CALL  copia_contexto    ; est CX apilado
               MOV   DS,CS:ems_paginai
               MOV   DL,CS:ems_pagni   ; usar pgina alternativa
               OR    BP,8000h          ; indicar su uso
no_conflicto:  POP   CX                ; * pila totalmente equilibrada
               MOV   BX,AX
               MOV   DH,44h            ; DL = 0  2 (pgina fsica)
               CALL  llama_EMM         ; DH = 44h -> mapear pgina EMS
               XPUSH <CX,SI>           ; ++
               SUB   SI,4000h
               NEG   SI                ; SI = 4000h - SI: resto
               SHR   SI,1              ; bytes -> palabras
               CMP   CX,SI
               JB    cx_ok             ; no ocupada toda la pgina
               MOV   CX,SI
cx_ok:         POP   SI                ; + SI=desplazamiento relativo
               CLD
               POP   BX                ; + palabras restantes
               SUB   BX,CX             ; descontar las que se movern
               PUSH  BX                ; * volver a apilar el viejo CX
               CALL  coloca_regs
               CMP   CS:cpu386,ON      ; 386 o superior?
               JNE   trans_16bit
               .386
               PUSHAD
               SHR   CX,1              ; n palabras de 32 bit a mover
               JCXZ  transferido       ; evitar desgracia
               XOR   EAX,EAX           ; asegurar no violacin
               DEC   AX                ; de segmento-64K
               AND   ECX,EAX           ; EAX = 0FFFFh
               AND   ESI,EAX
               AND   EDI,EAX
               REP   MOVSD             ; transferencia ultrarrpida
transferido:   POPAD                   ; POPAD falla en muchos 386
               .8086
               NOP                     ; arreglar fallo de POPAD
               ADD   CX,CX
               ADD   DI,CX             ; simular cambio normal de DI
               ADD   SI,CX             ; y de SI
               JMP   fin_trans
trans_16bit:   REP   MOVSW             ; mover palabras de 16 bit
fin_trans:     CALL  coloca_regs
               AND   BP,BP             ; se us pgina alternativa?
               JNS   ahorra_ms
               CALL  copia_contexto    ; est CX apilado
               AND   BP,1              ; de momento, no se usar ms
ahorra_ms:     POP   CX                ; **
               JCXZ  fin_leer          ; no quedan ms palabras
               INC   AX                ; prxima pgina EMS
               XOR   SI,SI             ; ahora desde inicio pgina EMS
               JMP   procesa_pag
fin_leer:      MOV   DH,48h
               CALL  llama_EMM         ; DH=47h restaurar contexto EMS
               MOV   AX,100h           ; no hubo problemas
               RET
procesa_ems    ENDP

               ; ---- Cuidado!: esta rutina debe ser invocada siempre
               ;      con la pila (SP) tal y como estaba al principio
               ;      del procedimiento procesa_ems, y utilizando
               ;      siempre CALL, para que en el caso de que haya
               ;      errores retorne correctamente al nivel anterior
               ;      (nivel previo a procesa_ems). Se corrompe DX
               ;      y, si hay error, AX tambin (devuelve 810Ch).

llama_EMM      PROC
               XPUSH <AX,BX,CX,BP>
               MOV   AX,DX             ; funcin en AX
llama_denuevo: MOV   DX,CS:mem_handle  ; handle EMS
               XPUSH <AX,BX>
               INT   67h               ; llamar al EMM
               MOV   CL,AH
               XPOP  <BX,AX>
               AND   CL,CL
               JZ    llama_ok          ; adems, ZF = 1
               CMP   CL,82h
               JE    llama_denuevo     ; intentarlo hasta que funcione
llama_ok:      XPOP  <BP,CX,BX,AX>
               JNE   ret_atras
               RET
ret_atras:     POP   AX                ; sacar direccin de retorno
               MOV   AX,810Ch          ; error de anomala general
               RET                     ; retornar dos niveles atrs
llama_EMM      ENDP

               ; ---- Cuidado!: esta rutina debe ser invocada siempre
               ;      con CX (y slo CX) apilado: recarga CX desde la
               ;      pila y corrompe BX dejando an en la pila CX.

copia_contexto PROC
               XPOP  <BX,CX>           ; equilibrar pila a llama_EMM
               MOV   DH,48h
               CALL  llama_EMM         ; restaurar contexto EMS
               MOV   DH,47h
               CALL  llama_EMM         ; preservarlo de nuevo
               PUSH  CX
               JMP   BX                ; ms rpido que PUSH BX/RET
copia_contexto ENDP

coloca_regs    PROC                    ; invertir sentido?
               TEST  BP,1
               JNZ   colocados
               XCHG  SI,DI             ; escritura: invertir sentido
               XPUSH <DS,ES>
               XPOP  <DS,ES>
colocados:     RET
coloca_regs    ENDP

tam_proc_ems   EQU   $-OFFSET procesa_ems   ; tamao de esta rutina

               ; <<< Fin del cdigo residente del disco virtual >>>


; ************ Instalacin (invocada desde CONFIG.SYS).

init           PROC
               MOV   CS:modo,CONFIG         ; ejecutando desde CONFIG
               CALL  obtDosVer              ; obtener versin del DOS
               LEA   AX,retorno_ok
               MOV   CS:p_rutinas,AX        ; anular rutina INIT
               INC   CS:tipo_soporte        ; 0: disco no formateado
               MOV   CS:cs_tdsk,CS          ; inicializar esa variable
               CMP   CS:dosver,300h         ; DOS inferior al 3.0?
               JAE   dos_ok                 ; DOS 3.0+
               AND   CS:tipo_drive,0F7FFh   ; ajustar atributos
               MOV   CS:num_ordenes,0Dh     ; y nmero de rdenes
dos_ok:        MOV   SI,[BX].bpb_cmd_desp
               MOV   ES,[BX].bpb_cmd_segm   ; ES:SI -> parmetros
               MOV   [BX].num_discos,1      ; una unidad de disco
               LEA   AX,bpb_ptr
               MOV   [BX].bpb_cmd_desp,AX
               MOV   [BX].bpb_cmd_segm,CS   ; inicializado puntero BPB
               CALL  desvia_int19           ; controlar INT 19h
               CALL  inic_letra             ; obtener letra de unidad
               MOV   BX,CS
               MOV   DS,BX                  ; DS: -> _PRINCIPAL
               MOV   BX,SI                  ; ES:BX -> parmetros
               CALL  salta_nombre           ; buscar inicio parmetros
               CALL  procesar_param         ; procesar parmetros
               PUSH  DS                     ;
               POP   ES                     ; ES: -> _PRINCIPAL
               CMP   param_h,ON
               JE    fin_instalar           ; piden ayuda
               CALL  max_sector             ; obtener mayor sector
               MOV   BX,param_tsect
               CMP   BX,AX                  ; el nuestro es mayor?
               JBE   sect_def_ok            ; no
               MOV   bytes_sector,BX        ; s: ajustar BPB
sect_def_ok:   CALL  errores_config
               TEST  lista_err,ERROR0+ERROR1
               JNZ   fin_instalar           ; algn error importante
               CMP   param_tdisco,0         ; se define disco ahora?
               JE    fin_instalar           ; no: no hay ms que hacer
               CALL  mem_info               ; evaluar memoria del PC
               CMP   tdisco,0               ; se reservar memoria?
               JE    fin_instalar           ; no: no hay ms que hacer
               CALL  mem_reserva            ; reservar memoria
               JC    fin_instalar           ; fallo al reservarla
               CALL  test_CPU               ; detectar 386  superior
               CALL  adaptar_param          ; adaptar parmetros disco
               CALL  preparar_BPB           ; BPB del nuevo disco
               CALL  prep_driver            ; preparar el driver
               CALL  formatear_tdsk         ; inic. BOOT, FAT y ROOT
fin_instalar:  CALL  info_disco             ; informar sobre el disco
               CMP   tipo_soporte,2
               JE    res_largo              ; se utiliza memoria EMS
               CMP   param_a,ON
               JE    res_largo              ; se indic /A
               CALL  eval_xms
               CALL  eval_ems
               CMP   ems_kb,0
               JE    res_corto              ; no hay memoria EMS
               CMP   xms_kb,0
               JNE   res_corto              ; la hay, pero tambin XMS
res_largo:     MOV   AX,tam_proc_ems
               MOV   rutina_larga,ON        ; dejar sitio a rutina EMS
               JMP   bytes_res_ok
res_corto:     MOV   AX,tam_proc_xms        ; dejar sitio a XMS/conv.
               MOV   BX,tam_proc_con
               CMP   AX,BX
               JAE   bytes_res_ok
               XCHG  AX,BX
bytes_res_ok:  LDS   BX,CS:pcab_peticion
               ADD   AX,OFFSET procesa_io
               MOV   [BX].fin_resid_desp,AX ; reservar memoria para
               MOV   [BX].fin_resid_segm,CS ; las rutinas a usar
               MOV   AX,100h                ; instalacin siempre Ok.
               RET
init           ENDP

; ------------ Redefinicin (invocada desde el AUTOEXEC.BAT o el DOS).

main           PROC  FAR
               MOV   CS:modo,AUTOEXEC       ; ejecutando desde el DOS
               CALL  obtDosVer              ; obtener versin del DOS
               CALL  gestionar_ram          ; gestin de memoria
               MOV   AX,_PRINCIPAL          ; programa de un segmento
               MOV   DS,AX                  ; DS: -> _PRINCIPAL
               MOV   BX,81h                 ; ES:BX lnea de rdenes
               CALL  procesar_param         ; procesar parmetros
               CMP   param_h,ON
               JE    exit_instalar          ; piden ayuda
               PUSH  DS
               POP   ES                     ; ES: --> _PRINCIPAL
               CALL  errores_Dos
               TEST  err_grave,0FFFFh
               JNZ   exit_instalar          ; algn error grave
               MOV   ES,segm_tdsk           ; ES: --> disco residente
               CMP   param_a,ON
               JNE   cabria_ems
               CMP   ES:rutina_larga,ON
               JE    cabria_ems             ; cabe la rutina EMS
               OR    lista_err,ERROR2
cabria_ems:    TEST  lista_err,ERROR0+ERROR2  ; error sintaxis  EMS?
               JNZ   exit_instalar          ; s: no modificar disco
               CMP   param_tdiscof,ON
               JNE   exit_instalar          ; no indicado nuevo tamao
               CMP   ES:tipo_soporte,0
               JE    cont_instalar          ; no estaba formateado an
               CALL  desinstala             ; liberar memoria ocupada
cont_instalar: CALL  mem_info               ; evaluar memoria del PC
               CMP   tdisco,0               ; se reservar memoria?
               JE    exit_instalar          ; no: no hay ms que hacer
               CALL  mem_reserva            ; reservar memoria
               JC    exit_instalar          ; fallo reservando memoria
               CALL  test_CPU               ; detectar 386  superior
               CALL  adaptar_param          ; adaptar parmetros disco
               CALL  preparar_BPB           ; BPB del nuevo disco
               CALL  relocalizar            ; autoreubicacin de TDSK
               CALL  prep_driver            ; preparar el driver
               CALL  formatear_tdsk         ; BOOT, FAT y ROOT
exit_instalar: CALL  info_disco             ; informar sobre el disco
               CMP   tipo_soporte,3         ; memoria convencional?
               JNE   fin_no_res             ; no usada
               CALL  renombrar_mcb          ; cambiar nombre del MCB
               MOV   DX,6                   ; usada: 96 bytes de PSP
               MOV   AX,3100h
               INT   21h                    ; terminar residente
fin_no_res:    CALL  set_errorlevel         ; preparar ERRORLEVEL
               MOV   AH,4Ch
               INT   21h                    ; final normal
main           ENDP

; ------------ Inicializar la variable con la versin del DOS

obtDosVer      PROC
               XPUSH <AX,BX,CX,DX>
               MOV   AH,30h
               INT   21h
               XCHG  AH,AL
               MOV   CS:dosver,AX
               XPOP  <DX,CX,BX,AX>
               RET
obtDosVer      ENDP

; ------------ Determinar segmento del PSP, ltimo segmento de memoria
;              y liberar espacio de entorno. Se modifica tambin el
;              bloque de memoria de TDSK reducindolo a 96 bytes: esto
;              provoca la creacin de un bloque de control de memoria
;              en el offset 96 del PSP, lo cual no es peligroso. El
;              objetivo de esta maniobra es poder asignar memoria al
;              disco despus (slo si hace falta memoria convencional)
;              usando los servicios estndar del DOS.

gestionar_ram  PROC
               MOV   CS:segm_psp,DS         ; indicar segmento del PSP
               MOV   AX,DS:[2]              ; segmento ms alto
               MOV   CS:top_ram,AX          ; indicar tope de memoria
               PUSH  ES
               MOV   ES,DS:[2Ch]            ; segmento del entorno
               MOV   AH,49h
               INT   21h                    ; liberar rea de entorno
               POP   ES                     ; ES: -> PSP
               MOV   BX,6
               MOV   AH,4Ah                 ; hacer creer al DOS que
               INT   21h                    ; TDSK ocupa slo 96 bytes
               RET
gestionar_ram  ENDP

; ------------ Leer los parmetros de la lnea de comandos (ES:BX).
;              Se inicializan las correspondientes variables. En caso
;              de error, se dejan a cero las variables y se acumula en
;              lista_err un ERROR0 (error de sintaxis).

procesar_param PROC
               CALL  busca_param       ; saltar delimitadores
               JC    fin_param         ; no hay ms parmetros
               CALL  param_barra       ; gestionar parmetro tipo "/A"
               JC    procesar_param    ; era parmetro tipo "/A"
               MOV   param_tdisco,AX   ; es numrico: tamao del disco
               MOV   param_tdiscof,ON  ; parmetro de tamao indicado
p_param2:      CALL  busca_param
               JC    fin_param
               CALL  param_barra
               JC    p_param2
               MOV   param_tsect,AX    ; tamao de sector
p_param3:      CALL  busca_param
               JC    fin_param
               CALL  param_barra
               JC    p_param3
               MOV   param_tdir,AX     ; entradas al directorio
p_param4:      CALL  busca_param
               JC    fin_param
               CALL  param_barra
               JC    p_param4
               MOV   param_tcluster,AX ; tamao de cluster
p_param5:      CALL  busca_param
               JC    fin_param
               CALL  param_barra       ; ltimas opciones posibles
               JC    p_param5
fin_param:     CALL  validacion        ; validacin de parmetros
               RET
procesar_param ENDP

param_barra    PROC
               CMP   AX,"e/"           ; indicado /E?
               JNE   p_exp1?
               MOV   param_e,ON
               JMP   p_barra_exit
p_exp1?:       CMP   AX,"a/"           ; indicado /A?
               JNE   p_exp2?
p_exp:         MOV   param_a,ON
               JMP   p_barra_exit
p_exp2?:       CMP   AX,"x/"           ; /A y /X son equivalentes
               JE    p_exp
               CMP   AX,"c/"           ; indicado /C?
               JNE   p_ayuda?
               MOV   param_c,ON
               JMP   p_barra_exit
p_ayuda?:      CMP   AX,"h/"           ; indicado /H?
               JNE   p_exit?
p_ayuda:       MOV   param_h,ON
               JMP   p_barra_exit
p_exit?:       CMP   AX,"?/"           ; /H y /? son equivalentes
               JE    p_ayuda
               CMP   AX,"m/"           ; indicado /M?
               JNE   param_id?
               MOV   param_m,ON
               JMP   p_barra_exit
param_id?:     CMP   AX,"i/"           ; indicado /I= o /I:?
               JNE   param_fats?
               ADD   BX,3
               CMP   BYTE PTR ES:[BX-1],'='
               JE    p_id_ok
               CMP   BYTE PTR ES:[BX-1],':'
               JNE   param_b_mal
p_id_ok:       CALL  obt_num           ; leer cdigo telefnico
               MOV   param_i,AX
               SUB   BX,2
               JMP   p_barra_exit
param_fats?:   CMP   AX,"f/"           ; indicado /F= o /F:?
               JNE   param_unidad?
               ADD   BX,3
               CMP   BYTE PTR ES:[BX-1],'='
               JE    p_f_ok
               CMP   BYTE PTR ES:[BX-1],':'
               JNE   param_b_mal
p_f_ok:        CALL  obt_num           ; leer nmero de FATs
               MOV   param_f,AX
               SUB   BX,2
               JMP   p_barra_exit
param_unidad?: CMP   AH,':'            ; parmetro de unidad?
               JNE   param_num?
               SUB   AL,'a'-1
               MOV   param_unidad,AL
               JMP   p_barra_exit
param_num?:    CMP   AL,'/'
               JNE   param_num         ; puede ser nmero
param_b_mal:   OR    lista_err,ERROR0
param_num:     CALL  obt_num           ; es parmetro numrico: leerlo
               CLC                     ; no es parmetro barrado
               RET
p_barra_exit:  ADD   BX,2              ; saltar este parmetro
               STC                     ; es parmetro barrado
               RET
param_barra    ENDP

validacion     PROC
               MOV   AX,0FFFFh
               CMP   AX,param_tdisco   ; nmeros correctos?
               JE    sintax_err
               CMP   AX,param_tsect
               JE    sintax_err
               CMP   AX,param_tdir
               JE    sintax_err
               CMP   AX,param_tcluster
               JE    sintax_err
               CMP   param_tdisco,0
               JE    valida_tsect      ; no indicado tamao (o 0)
               CMP   param_tdisco,8
               JB    sintax_err
               CMP   param_tdisco,65534
               JA    sintax_err
valida_tsect:  MOV   AX,param_tsect
               CMP   AX,0
               JE    valida_tclus      ; no indicado tamao de sector
               CMP   AX,32
               JE    valida_tclus
               CMP   AX,64
               JE    valida_tclus
               CMP   AX,128
               JE    valida_tclus
               CMP   AX,256
               JE    valida_tclus
               CMP   AX,512
               JE    valida_tclus
               CMP   AX,1024
               JE    valida_tclus
               CMP   AX,2048
               JNE   sintax_err
valida_tclus:  CMP   param_tcluster,256
               JAE   sintax_err        ; debe estar entre 0..255
               CMP   param_f,1
               JB    pf_a1             ; /F=1  /F=2 exclusivamente
               CMP   param_f,2         ; si no, forzarlo y perdonar
               JBE   fin_validar
               MOV   param_f,2
               JMP   fin_validar
pf_a1:         MOV   param_f,1
               JMP   fin_validar
sintax_err:    MOV   param_tdiscof,OFF ; no definir disco ahora
               XOR   AX,AX
               MOV   param_tdisco,AX
               MOV   param_tsect,AX
               MOV   param_tdir,AX
               MOV   param_tcluster,AX
               OR    lista_err,ERROR0  ; aviso de error de sintaxis
fin_validar:   RET
validacion     ENDP

salta_nombre   PROC                    ; saltar nombre del driver en
               MOV   AL,ES:[BX]        ; lnea de rdenes del CONFIG
               INC   BX
               CMP   AL,' '
               JE    fin_nombre
               CMP   AL,9
               JE    fin_nombre
               CMP   AL,0Dh
               JE    fin_nombre
               CMP   AL,0Ah
               JE    fin_nombre
               AND   AL,AL
               JZ    fin_nombre        ; necesario para DOS 2.x
               JMP   salta_nombre
fin_nombre:    RET
salta_nombre   ENDP

busca_param    PROC                    ; saltar delimitadores
               DEC   BX
p_delimit:     INC   BX
               MOV   AX,ES:[BX]
               CMP   AL,' '
               JE    p_delimit         ; espacio en blanco
               CMP   AL,9
               JE    p_delimit         ; tabulador
               CMP   AL,13
               JE    p_final           ; CR  LF indican el final
               CMP   AL,10
               JE    p_final
               OR    AX,"  "           ; poner en minsculas
               CLC
               RET
p_final:       STC                     ; se acabaron los parmetros
               RET
busca_param    ENDP

obt_num        PROC                    ; leer nmero: devolver 65535
               XPUSH <CX,DX,SI>        ; si hay error
               XOR   AX,AX             ; nmero en proceso de creacin
otro_digito:   MOV   CL,ES:[BX]
               CMP   CL,'0'
               JB    no_digito
               CMP   CL,'9'
               JBE   digito_ok
no_digito:     CMP   CL,' '            ; posibles delimitadores...
               JE    fin_num
               CMP   CL,9
               JE    fin_num
               CMP   CL,13
               JE    fin_num
               CMP   CL,10
               JE    fin_num
               CMP   CL,'/'
               JE    fin_num
               JMP   num_incorr
digito_ok:     XOR   DX,DX
               MOV   SI,10
               MUL   SI                ; AX = AX * 10
               JC    num_incorr
               XOR   CH,CH
               SUB   CL,'0'
               ADD   AX,CX             ; AX = AX + dato
               JC    num_incorr
               INC   BX
               JMP   otro_digito
num_incorr:    MOV   AX,65535          ; indicar valor incorrecto
fin_num:       XPOP  <SI,DX,CX>
               RET
obt_num        ENDP

; ------------ Detectar errores que se pueden producir slo en la
;              lnea de comandos.

errores_Dos    PROC
               PUSH  ES
               CMP   dosver,200h       ; necesario DOS 2.x+
               JAE   existe_tdsk?
               OR    err_grave,ERROR0  ; error de DOS incorrecto
               JMP   fin_err_Dos
existe_tdsk?:  CALL  reside_tdsk?      ; instalado TURBODSK?
               CMP   segm_tdsk,0
               JNE   busca_unidad      ; ya instalado
               OR    err_grave,ERROR1  ; error: TURBODSK no instalado
               JMP   fin_err_Dos
busca_unidad:  MOV   ES,segm_tdsk      ; ES: -> disco virtual
               CMP   param_unidad,0
               JE    disco_defecto     ; no se indic letra de unidad
               CALL  obtener_segm      ; segmento del TDSK indicado
               JC    fin_err_Dos       ; fallo (no es unidad TDSK)
disco_defecto: CALL  max_sector        ; obtener mayor sector
               MOV   BX,param_tsect
               CMP   BX,AX
               JBE   fin_err_Dos       ; tamao de sector correcto
               OR    lista_err,ERROR3  ; el tamao no definible ahora
               MOV   param_tsect,0     ; ignorar tamao indicado
fin_err_Dos:   CALL  test32Mb
               CALL  testWin
               POP   ES
               RET
errores_Dos    ENDP

; ------------ Detectar errores que se pueden producir slo desde
;              el CONFIG.SYS

errores_config PROC
               CMP   param_unidad,0
               JE    no_unidad
               OR    lista_err,ERROR1
no_unidad:     CMP   param_c,ON
               JNE   fin_err_con
               OR    lista_err,ERROR1
fin_err_con:   CALL  test32Mb
               RET
errores_config ENDP

; ------------ Preparar valor de ERRORLEVEL para el retorno.

set_errorlevel PROC
               MOV   AL,255
               TEST  err_grave,ERROR1  ; TDSK no instalado?
               JNZ   fin_cod_ok
               DEC   AL
               TEST  err_grave,ERROR2  ; unidad incorrecta?
               JNZ   fin_cod_ok
               DEC   AL
               TEST  err_grave,ERROR3  ; dentro de Windows?
               JNZ   fin_cod_ok
               DEC   AL
               TEST  lista_err,ERROR0  ; error de sintaxis
               JNZ   fin_cod_ok
               MOV   AL,BYTE PTR ES:mem_handle  ; handle XMS/EMS
               CMP   ES:tipo_soporte,0
               JNE   fin_cod_ok
               MOV   AL,0              ; disco no formateado
fin_cod_ok:    RET
set_errorlevel ENDP

; ------------ Obtener mayor tamao de sector definido en el sistema.

max_sector     PROC
               XPUSH <BX,ES>
               MOV   AH,52h
               INT   21h               ; Get List of Lists
               ADD   BX,10h
               CMP   CS:dosver,30Ah
               JAE   psect_ok
               INC   BX                ; DOS anterior al 3.1
psect_ok:      MOV   AX,ES:[BX]        ; mayor tamao de sector
               XPOP  <ES,BX>           ; definido por cualquier disp.
               RET
max_sector     ENDP

; ------------ Si el disco es de ms de 32 Mb, comprobar si el sector
;              es de al menos 1024 bytes.

test32Mb       PROC
               CMP   param_tdisco,32768
               JBE   fin32mb
               CMP   param_tsect,1024
               JAE   fin32mb
               OR    lista_err,ERROR15      ; sector de menos de 1024
               MOV   param_tdisco,32768     ; evitar fallo posterior
fin32mb:       RET
test32Mb       ENDP

; ------------ Desde Windows, no se permite redefinir el disco.

testWin        PROC
               CMP   param_tdiscof,ON
               JNE   fin_testWin       ; no redefinido el disco
               CMP   dosver,300h
               JB    fin_testWin       ; no buscar Windows en DOS 2.x
               MOV   AX,1600h
               INT   2Fh
               AND   AL,AL             ; Windows en modo extendido?
               JZ    noWinEnh
               CMP   AL,80h            ; Windows en modo extendido?
               JE    noWinEnh
siWin:         OR    err_grave,ERROR3  ; estamos dentro de Windows
               JMP   fin_testWin
noWinEnh:      MOV   AX,4680h
               INT   2Fh
               AND   AX,AX
               JZ    siWin             ; Windows en modo real/estndar
fin_testWin:   RET
testWin        ENDP

; ------------ Verificar la presencia en memoria de TURBODSK. Se
;              inicializa segm_tdsk y letra_unidad indicando dnde
;              reside el primer dispositivo TURBODSK de todos los que
;              puede haber instalados. La letra de la unidad se halla
;              contando y no del propio TDSK residente.

reside_tdsk?   PROC
               XPUSH <AX,DX,SI>
               CALL  lista_discos
               LEA   SI,area_trabajo-4
               XOR   DL,DL
busca_final:   ADD   SI,4
               CMP   WORD PTR [SI],0
               JNE   busca_final       ; ir al final de la tabla
busca_tdsk:    SUB   SI,4
               ADD   DL,[SI+2]
               CMP   SI,OFFSET area_trabajo
               JB    fin_busca         ; no reside (segm_tdsk = 0)
               CMP   BYTE PTR [SI+3],1
               JNE   busca_tdsk
               MOV   AX,[SI]           ; encontrada unidad TURBODSK
               MOV   segm_tdsk,AX
               ADD   DL,'A'-1
               MOV   letra_unidad,DL
fin_busca:     XPOP  <SI,DX,AX>
               RET
reside_tdsk?   ENDP

; ------------ Obtener el segmento de la unidad TURBODSK indicada, si
;              existe, accediendo a una tabla de dispositivos que se
;              crea. A la salida, CF=1 si esa unidad no es TURBODSK.

obtener_segm   PROC
               CALL  lista_discos
               LEA   SI,area_trabajo-4
               XOR   AL,AL             ; disco A:
busca_ultimo:  ADD   SI,4
               CMP   WORD PTR [SI],0
               JNE   busca_ultimo      ; realmente, el primero
recorre_dsks:  SUB   SI,4
               ADD   AL,[SI+2]         ; siguiente unidad
               CMP   SI,OFFSET area_trabajo
               JB    tdsk_no_hay
               CMP   BYTE PTR [SI+3],1
               JNE   recorre_dsks
               CMP   AL,param_unidad   ; disco TDSK: es el buscado?
               JNE   recorre_dsks
               ADD   AL,'A'-1
               MOV   letra_unidad,AL   ; inicializar letra de unidad
               MOV   AX,[SI]
               MOV   segm_tdsk,AX      ; inicializar segmento
               MOV   ES,AX
               CLC
               RET
tdsk_no_hay:   OR    err_grave,ERROR2  ; unidad indicada no es TDSK
               STC
               RET
obtener_segm   ENDP

; ------------ Colocar nuevo gestor de INT 19h al instalar TDSK desde
;              el CONFIG.SYS. En algunos entornos multitarea basados
;              en el modo virtual-86 del 386 y superiores, si no se
;              libera la memoria EMS/XMS tras una cancelacin de la
;              tarea virtual, sta queda permanentemente ocupada hasta
;              un reset fro del sistema, sin poder ser aprovechada
;              por los dems procesos. La INT 19h se ejecuta cuando la
;              tarea en curso va a ser inminentemente cancelada por el
;              sistema, y TURBODSK la intercepta para poder liberar la
;              memoria EMS/XMS en el ltimo instante. La rutina que
;              controla INT 19h contiene cdigo de 286, por lo que se
;              chequea la presencia de este procesador.

desvia_int19   PROC
               XPUSH <BX,DS,ES>
               MOV   BX,CS
               MOV   DS,BX
               CALL  test_CPU
               CMP   cpu286,ON
               JNE   fin_desvia19      ; no es 286  superior
               MOV   AX,3519h
               INT   21h               ; ES:BX anterior INT 19h
               MOV   ant19off,BX
               MOV   ant19seg,ES
               LEA   DX,nueva_int19
               MOV   AX,2519h
               INT   21h               ; nueva rutina de control
fin_desvia19:  XPOP  <ES,DS,BX>
               RET
desvia_int19   ENDP

; ------------ Obtener la letra de la unidad de disco definida. Esta
;              rutina se invoca slo desde CONFIG.SYS con DS:BX
;              apuntando a la cabecera de peticin de la orden INIT.

inic_letra     PROC
               XPUSH <AX,BX,SI,DS>
               MOV   AL,[BX].nuevo_disco    ; unidad en DOS 3.0+
               ADD   AL,'A'
               PUSH  CS
               POP   DS                     ; DS -> _PRINCIPAL
               CMP   dosver,300h
               JAE   letra_ok
               CALL  lista_discos           ; hallar unidad en DOS 2.x
               LEA   SI,area_trabajo
               XOR   AL,AL                  ; cuenta de discos
cuenta_discos: ADD   AL,[SI+2]
               ADD   SI,4
               CMP   WORD PTR [SI],0
               JNE   cuenta_discos
               ADD   AL,'A'
letra_ok:      MOV   letra_unidad,AL        ; guardar letra de unidad
               XPOP  <DS,SI,BX,AX>
               RET
inic_letra     ENDP

; ------------ Crear una lista de todos los dispositivos de bloque
;              del sistema. La lista tiene una entrada de 4 bytes
;              para cada dispositivo: los dos primeros indican el
;              segmento en que reside, el siguiente el nmero de
;              unidades que controla y el ltimo vale 1  0 para
;              indicar si es una unidad TDSK o no. El final de la
;              lista lo sealiza un segmento igual a 0.

lista_discos   PROC
               XPUSH <AX,BX,CX,DX,SI,DI,ES>
               MOV   AH,52h            ; "Get list of lists"
               INT   21h               ; obtener puntero en ES:BX
               MOV   CX,17h            ; supuesto DOS 2.x
               CMP   dosver,300h
               JB    pdisp_ok
               MOV   CX,28h            ; supuesto DOS 3.0x
               CMP   dosver,30Ah
               JB    pdisp_ok
               MOV   CX,22h            ; versiones del DOS superiores
pdisp_ok:      ADD   BX,CX
               LEA   DI,area_trabajo-4 ; tabla de dispositivos-4
disp_otro:     ADD   DI,4
disp_skip:     LES   BX,ES:[BX]        ; siguiente dispositivo
               CMP   BX,-1
               JE    disp_fin
               TEST  BYTE PTR ES:[BX+5],80h
               JNZ   disp_skip         ; es dispositivo de caracteres
               MOV   CL,ES:[BX+10]     ; es de bloques
               MOV   [DI],ES           ; anotar direccin
               MOV   [DI+2],CL
               MOV   BYTE PTR [DI+3],0 ; de momento, no es TDSK
               PUSH  DI
               LEA   SI,id_tdsk        ; identificacin de TURBODSK
               MOV   DI,SI
               MOV   CX,5
               CLD
               REP   CMPSB             ; es TURBODSK?
               POP   DI
               JNE   disp_otro         ; es de bloques, pero no TDSK
               MOV   AX,ES:cs_tdsk     ; segmento real de TDSK
               MOV   [DI],AX           ; corregir direccin en tabla
               INC   BYTE PTR [DI+3]   ; indicar dispositivo TDSK
               JMP   disp_otro         ; buscar hasta completar tabla
disp_fin:      MOV   WORD PTR [DI],0   ; final de la lista
               XPOP  <ES,DI,SI,DX,CX,BX,AX>
               RET
lista_discos   ENDP

; ------------ Liberar la memoria ocupada por un TURBODSK residente.

desinstala     PROC
               MOV   DX,ES:mem_handle
               MOV   AL,ES:tipo_soporte
               DEC   AL
               JZ    libera_ext        ; liberar memoria extendida
               DEC   AL
               JZ    libera_exp        ; liberar memoria expandida
               PUSH  ES
               MOV   ES,DX
               MOV   AH,49h            ; liberar memoria convencional:
               INT   21h
               POP   ES
               PUSH  ES
               PUSHF                   ; condicin de error
               MOV   ES,ES:tdsk_psp    ; liberar PSP residente
               MOV   AH,49h
               INT   21h
               PUSHF
               CMP   dosver,31Eh
               JA    mcb_ok            ; DOS 3.31+: el MCB es correcto
               MOV   AX,ES
               DEC   AX
               MOV   ES,AX
               MOV   DI,8
               MOV   CX,DI
               CLD
               MOV   AL,' '
               REP   STOSB             ; hasta DOS 3.30 borrar nombre
mcb_ok:        POPF
               JNC   lib_con_ok?       ; liberado correctamente
               POPF
               POP   ES
               STC                     ; ha habido fallo
               JMP   desinstalado
lib_con_ok?:   POPF                    ; recuperar condicin de error
               POP   ES
               JMP   desinstalado
libera_ext:    MOV   AH,0Ah
               CALL  ES:xms_driver
               CMP   AX,1
               JE    desinstalado      ; xito al liberar memoria XMS
               STC
               JMP   desinstalado      ; fallo
libera_exp:    MOV   AH,45h
               INT   67h
               CMP   AH,0
               JE    desinstalado
               CMP   AH,82h            ; EMM ocupado?
               JE    libera_exp
               STC                     ; fallo al liberar memoria EMS
desinstalado:  MOV   ES:tipo_soporte,0 ; disco no formateado
               JNC   desins_ok
               OR    lista_err,ERROR14 ; fallo al liberar memoria
               STC
desins_ok:     RET
desinstala     ENDP

; ------------ Determinar la configuracin del sistema: tipos de
;              memoria y cantidad de la misma. Se indica en tdisco
;              un valor 0 si no se define ahora el disco, sea cual sea
;              el motivo del fallo, y se actualiza la variable que
;              indica los mensajes de error y advertencia a imprimir.

mem_info       PROC
               MOV   tdisco,0          ; ley de Murphy
               CALL  eval_xms          ; inicializar xms_kb
               CALL  eval_ems          ; inicializar ems_kb
               CALL  eval_con          ; inicializar con_kb
               MOV   AX,param_tdisco   ; cantidad de memoria necesaria
               CMP   param_a,ON
               JNE   no_ems            ; no solicitan memoria EMS
               MOV   BX,ems_kb         ; solicitan memoria EMS...
               AND   BX,BX
               JNZ   usara_ems
               OR    lista_err,ERROR7  ; no hay memoria EMS disponible
               JMP   mem_infoado
usara_ems:     CMP   AX,BX
               JBE   usar_ems          ; piden algo razonable
               MOV   AX,BX
               OR    lista_err,ERROR4  ; rebajado el tamao
usar_ems:      MOV   tdisco,AX
               MOV   tipo_soporte,2    ; indicar memoria expandida
               JMP   mem_infoado
no_ems:        CMP   param_e,ON
               JNE   no_xms            ; no solicitan memoria XMS
               MOV   BX,xms_kb         ; solicitan memoria XMS...
               AND   BX,BX
               JNZ   usara_xms
               OR    lista_err,ERROR6  ; no hay memoria XMS disponible
               JMP   mem_infoado
usara_xms:     CMP   AX,BX
               JBE   usar_xms          ; piden algo razonable
               MOV   AX,BX
               OR    lista_err,ERROR4  ; rebajado el tamao
usar_xms:      MOV   tdisco,AX
               MOV   tipo_soporte,1    ; indicar memoria extendida
               JMP   mem_infoado
no_xms:        CMP   param_c,ON
               JNE   no_con            ; no solicitan memoria conv.
forzar_con:    MOV   BX,con_kb         ; solicitan memoria conv. ...
               AND   BX,BX
               JNZ   usara_con
               OR    lista_err,ERROR10 ; no hay memoria conv. libre
               JMP   mem_infoado
usara_con:     CMP   AX,BX
               JBE   usar_con          ; piden algo razonable
               MOV   AX,BX
               OR    lista_err,ERROR4  ; rebajado el tamao
usar_con:      MOV   tdisco,AX
               MOV   tipo_soporte,3    ; indicar memoria convencional
               JMP   mem_infoado
no_con:        CMP   AX,xms_kb         ; no indicado tipo de memoria
               JBE   usar_xms          ; intentar emplear memoria XMS
               CMP   ES:rutina_larga,ON
               JE    valdria_ems
               MOV   BX,xms_kb
               CMP   BX,0              ; imposible usar EMS
               JNE   usara_xms         ; queda algo de XMS
               JMP   usar_con?
valdria_ems:   MOV   BX,ems_kb
               CMP   AX,BX
               JA    nv_ems
               JMP   usar_ems          ; emplear memoria EMS
nv_ems:        MOV   BX,ems_kb
               OR    BX,xms_kb
               JZ    usar_con?         ; no hay un pice de XMS ni EMS
               OR    lista_err,ERROR4  ; rebajado el tamao solicitado
               MOV   AX,xms_kb
               CMP   AX,ems_kb
               JAE   usar_xms          ; hay ms o igual XMS que EMS
               MOV   AX,ems_kb
               JMP   usar_ems          ; hay algo de EMS (ms que XMS)
usar_con?:     CMP   modo,AUTOEXEC
               JE    forzar_con        ; slo se puede usar mem. conv.
               OR    lista_err,ERROR5  ; ho hay memoria EMS ni XMS
mem_infoado:   RET
mem_info       ENDP

               ; ---- Calcular memoria extendida disponible

eval_xms       PROC
               PUSH  ES
               MOV   AX,352Fh
               INT   21h               ; direccin de INT 2Fh en ES:BX
               MOV   AX,ES
               AND   AX,AX
               JZ    xms_ok            ; apunta a 0000:XXXX (DOS 2.x)
               MOV   AX,4300h
               INT   2Fh
               CMP   AL,80h            ; hay controlador XMS?
               JNE   xms_ok
               MOV   AX,4310h          ; obtener su direccin
               INT   2Fh
               MOV   xms_segm,ES
               MOV   xms_desp,BX
               MOV   AH,8
               CALL  xms_driver        ; preguntar memoria libre
               AND   AX,AX
               JNZ   xms_kb_ok         ; no hubo fallo
               CMP   BL,0A0h
               JE    xms_kb_ok         ; asignada ya toda la memoria
               TEST  BL,80h
               JZ    xms_kb_ok         ; no hay memoria XMS disponible
               OR    lista_err,ERROR8  ; fallo real del controlador
xms_kb_ok:     CMP   AX,8              ; mayor bloque XMS disponible
               JB    xms_ok
               MOV   xms_kb,AX         ; mnimo necesario: 8 Kb
xms_ok:        POP   ES
               RET
eval_xms       ENDP

               ; ---- Calcular memoria expandida disponible. Si la
               ;      versin del EMM es 4.0 o superior, las pginas
               ;      de memoria expandida pueden no ser contiguas:
               ;      buscar una que diste 32 Kb de la pgina 0.

eval_ems       PROC
               PUSH  ES
               MOV   AX,3567h
               INT   21h               ; vector de INT 67h en ES:BX
               MOV   DI,10
               LEA   SI,emm_id
               MOV   CX,8
               CLD
               REP   CMPSB             ; instalado controlador EMS?
               JE    ems_existe
               JMP   ems_ok
ems_existe:    MOV   CX,8000h          ; n de intentos prudente
emm_llama:     MOV   AH,40h
               INT   67h
               AND   AH,AH
               JZ    emm_responde
               CMP   AH,82h
               LOOPE emm_llama
emm_fatal:     OR    lista_err,ERROR9  ; fallo del EMM
               JMP   ems_ok
emm_responde:  MOV   AH,41h
               INT   67h
               AND   AH,AH
               JZ    emm_pag_ok
               CMP   AH,82h
               JE    emm_responde      ; reintentar (EMM ocupado)
               JMP   emm_fatal
emm_pag_ok:    MOV   ems_pagina0,BX    ; inicializar pgina EMS
               ADD   BX,0C00h
               MOV   ems_paginai,BX
               MOV   ems_pagni,3       ; pgina alternativa: la 3
               MOV   AH,46h
               INT   67h               ; obtener versin del EMM
               CMP   AL,40h
               JB    emm_obt_kb        ; versin anterior a la 4.0
               MOV   ems4,ON
emm_obt_pag:   XPUSH <ES,DS>
               POP   ES
               MOV   AX,5800h          ; obtener direccin de pginas
               LEA   DI,area_trabajo
               INT   67h
               POP   ES
               AND   AH,AH
               JZ    emm_pags_ok
               CMP   AH,82h
               JE    emm_obt_pag
               JMP   emm_fatal
emm_pags_ok:   XOR   DX,DX
               CALL  emm_busca_pag     ; buscar pgina 0
               JC    emm_fatal
               MOV   ems_pagina0,BX
ems_busca_i:   INC   DX                ; buscar la siguiente
               CMP   DX,5              ; la 5 y siguientes no valen
               JE    emm_fatal         ;            Ĵ
               CALL  emm_busca_pag     ;                  
               JC    emm_fatal         ;     >   >Ĵ<-- pg i
               MOV   ems_paginai,BX    ;0C00h 32        
               MOV   ems_pagni,DL      ; p   Kb  Ĵ
               SUB   BX,ems_pagina0    ; rra            
               JNC   bxpositivo        ; fos     >Ĵ
               NEG   BX                ;                 
bxpositivo:    CMP   BX,0C00h          ;     >     Ĵ<-- pg 0
               JB    ems_busca_i       ; no distan 32 Kb: buscar otra
emm_obt_kb:    MOV   AH,42h
               INT   67h
               AND   AH,AH
               JZ    emm_kb_ok
               CMP   AH,82h
               JE    emm_obt_kb
               JMP   emm_fatal
emm_kb_ok:     MOV   CL,4
               SHL   BX,CL             ; pginas EMS disponibles
               MOV   ems_kb,BX         ; Kb EMS disponibles (0,16,...)
ems_ok:        POP   ES
               RET
eval_ems       ENDP

emm_busca_pag  PROC                    ; buscar pgina n DX (EMS 4.0)
               LEA   SI,area_trabajo
               PUSH  CX
emm_otra_pag:  LODSW
               MOV   BX,AX             ; BX = segmento de la pgina
               LODSW                   ; AX = n de la pgina
               CMP   AX,DX
               JE    hallada_pag
               LOOP  emm_otra_pag
               STC
hallada_pag:   POP   CX
               RET
emm_busca_pag  ENDP

               ; ---- Calcular el tamao del mayor bloque de memoria
               ;      convencional disponible. Como mnimo se dejarn
               ;      unos 128 Kb libres en l, para que el usuario
               ;      pueda volver a ejecutar TDSK y el DOS tenga algo
               ;      de memoria libre. A la mitad de esos 128Kb (para
               ;      evitar solapamientos) es donde TURBODSK se
               ;      autorelocalizar antes de formatear el disco.

eval_con       PROC
               CMP   modo,AUTOEXEC     ; se ejecuta desde el DOS?
               JNE   conv_ok           ; no, desde el config
               MOV   AH,48h
               MOV   BX,0FFFFh         ; pedir 1 Mb al DOS (fallar)
               INT   21h
               MOV   DX,BX             ; tamao del mayor bloque
               MOV   CL,6
               SHR   BX,CL             ; BX = Kb del mayor bloque
               SUB   BX,128            ; restar 128 Kb
               JC    conv_ok           ; no quedan ni 128 Kb
               CMP   BX,8
               JB    conv_ok           ; no quedan siquiera 8 Kb
               MOV   con_kb,BX
               MOV   BX,DX             ; tamao del mayor bloque
               MOV   AH,48h
               PUSH  BX
               INT   21h               ; localizarlo (AX=segmento)
               POP   BX
               XPUSH <ES,AX>           ; preservar ES y segmento (AX)
               ADD   AX,BX             ; aadir longitud
               SUB   AX,1024/16*64     ; restar 64 Kb
               MOV   segm_reubicar,AX  ; segmento de autoreubicacin
               POP   ES                ; recuperar segmento del bloque
               MOV   AH,49h
               INT   21h               ; liberarlo
               POP   ES                ; recuperar ES
conv_ok:       RET
eval_con       ENDP

; ------------ Reservar la memoria llamando al gestor que la controla.
;              Con memoria XMS y existiendo un controlador EMS 4.0+ se
;              comprueba si el handle XMS provoca la creaccin de otro
;              en EMS (caso de QEMM386 y otros emuladores de EMS) y en
;              ese caso se le renombra, para mejorar la informacin de
;              los programas de diagnstico.

mem_reserva    PROC
               MOV   AL,tipo_soporte   ; tipo de memoria empleada
               DEC   AL
               JZ    mem_r_xms         ; 1: memoria extendida XMS
               DEC   AL
               JZ    mem_r_ems         ; 2: memoria expandida EMS
               MOV   CL,6
               MOV   BX,tdisco         ; 3: memoria convencional
               SHL   BX,CL
               MOV   AH,48h
               INT   21h
               MOV   mem_handle,AX     ; segmento del disco virtual
               MOV   BX,segm_psp
               MOV   tdsk_psp,BX       ; inicializar esta variable
               RET
mem_r_xms:     CMP   ems4,ON
               JNE   skip_lst_hndl
               LEA   BX,area_trabajo
               CALL  lista_handles     ; EMS 4.0+: listado de handles
skip_lst_hndl: MOV   AH,9
               MOV   DX,tdisco
               CALL  xms_driver        ; pedir memoria XMS
               AND   AX,AX
               JNZ   mem_rda_xms
               OR    lista_err,ERROR8  ; fallo del controlador XMS
               STC                     ; indicar error
mem_rda_xms:   MOV   mem_handle,DX
               PUSHF                   ; preservar condicin de error
               CMP   ems4,ON
               JNE   skip_ren_hndl
               CALL  ren_handle        ; en EMS 4.0+ renombrar handle
skip_ren_hndl: POPF
               RET
mem_r_ems:     MOV   BX,tdisco
               ADD   BX,15
               AND   BL,11110000b      ; redondear para arriba
               MOV   tdisco,BX
               MOV   CL,4
               SHR   BX,CL             ; Kb -> n pginas de 16 Kb
               MOV   AH,43h
               INT   67h               ; pedir memoria EMS
               AND   AH,AH
               JZ    mem_rda_ems
               OR    lista_err,ERROR9  ; fallo del controlador EMS
               STC                     ; indicar error
               RET
mem_rda_ems:   MOV   mem_handle,DX
               CMP   ems4,ON
               JNE   nhandle_ok
               CALL  nombrar_hndl      ; en EMS 4.0+ nombrar handle
nhandle_ok:    CLC
               RET
mem_reserva    ENDP

ren_handle     PROC                    ; detectar el handle EMS ligado
               XPUSH <ES,DS>           ; al handle XMS y renombrarlo
               POP   ES
               LEA   BX,area_trabajo[512]
               CALL  lista_handles     ; crear nueva lista de handles
               LEA   SI,area_trabajo
               LEA   DI,area_trabajo[512]
               MOV   CX,256
               CLD
               REP   CMPSW             ; comparar con vieja lista
               JE    ren_hnld_fin
               MOV   DX,[DI-2]         ; handle nuevo
               CALL  nombrar_hndl
ren_hnld_fin:  POP   ES
               RET
ren_handle     ENDP

lista_handles  PROC                    ; crear en DS:BX una lista con
               MOV   CX,256            ; los 256 posibles handles
               XOR   DX,DX             ; activos indicando los usados
listar_h:      MOV   AX,5300h
               LEA   DI,area_trabajo[tam_a_trabajo-8]  ; zona no usada
               XPUSH <BX,CX,DX>
               INT   67h
               XPOP  <DX,CX,BX>
               CMP   AH,0
               JE    handle_usado
               MOV   WORD PTR [BX],0   ; error (handle no usado)
               JMP   lista_h
handle_usado:  MOV   [BX],DX           ; anotar nmero de handle
lista_h:       ADD   BX,2
               INC   DX
               LOOP  listar_h
               RET
lista_handles  ENDP

nombrar_hndl   PROC                    ; nombrar handle (EMS 4.0+)
               MOV   AX,5301h
               LEA   SI,nombre_tdsk
               MOV   BL,letra_unidad
               MOV   [SI+5],BL
               INT   67h               ; dar nombre al handle
               RET
nombrar_hndl   ENDP

; ------------ Detectar 286 y 386 o superior.

test_CPU       PROC
               PUSHF
               POP   AX
               OR    AH,70h        ; intentar activar bit 12, 13  14
               PUSH  AX            ; del registro de estado
               POPF
               PUSHF
               POP   AX
               AND   AH,0F0h
               CMP   AH,0F0h
               JE    fin_test_CPU  ; es 8086 o similar
               MOV   cpu286,ON     ; es 286 o superior
               AND   AH,70h        ; 286 pone bits 12, 13 y 14 a cero
               JZ    fin_test_CPU  ; es 286
               MOV   cpu386,ON     ; 386 o superior
fin_test_CPU:  RET
test_CPU       ENDP

; ------------ Definir valores por defecto y adaptar los parmetros
;              indicados por el usuario a la realidad. Esta rutina
;              inicializa el futuro sector 0 del disco. No se permite
;              que el usuario indique un directorio que ocupe ms de
;              medio disco. Para determinar el tipo de FAT se halla el
;              n de sectores libres del disco (llammoslo nsect),
;              descontanto el sector de arranque y el directorio raiz;
;              y se aplica la siguiente frmula, que devuelve el n de
;              cluster ms alto del disco al considerar tambin la
;              ocupacin de la futura FAT (12 bits = 1,5 bytes):
;
;                 nsect * tamsect          2 * nsect * tamsect
;                ------------------ + 1 = --------------------- + 1
;                 tamcluster + 1,5         2 * tamcluster + 3
;
;                Al resultado se le suma 1, ya que los clusters se
;              numeran a partir de 2, para calcular el cluster de n
;              ms alto del disco. Si ese nmero es 4086 o ms habr
;              de utilizarse una FAT de 16 bits, recalculndose la
;              frmula anterior sustituyendo 1,5 por 2 y 3 por 4. Al
;              final, una vez determinado el tipo de FAT habr de
;              calcularse con exactitud el nmero de cluster ms alto,
;              ya que hay casos crticos en que una FAT12 no sirve
;              pero al aplicar una FAT16 el nmero de clusters baja de
;              nuevo de 4085 (debido al mayor consumo de disco de la
;              FAT16) resultado de ello la asignacin de una FAT12,
;              pese a que se reserva espacio para la de 16. Hay que
;              considerar adems el caso de que el disco tenga 2 FAT.

adaptar_param  PROC
               MOV   AX,tdisco     ; en Kb
               MOV   BX,AX         ; entradas de directorio propuestas
               MOV   CL,1          ; sectores por cluster propuestos
               CMP   AX,128        ; disco de 128 Kb o menos?
               JBE   prop_ok
               MOV   BX,128
               CMP   AX,512        ; disco de 512 Kb o menos?
               JBE   prop_ok
               MOV   BX,256
               CMP   AX,2042       ; disco de casi 2 Mb o menos?
               JBE   prop_ok
               MOV   CL,2          ; evitar FAT16
               CMP   AX,4084       ; disco de casi 4 Mb o menos?
               JBE   prop_ok
               MOV   CL,4          ; evitar FAT16 hasta 8 Mb
               MOV   BX,384
               CMP   AX,16384      ; disco de menos de 16 Mb?
               JB    prop_ok
               MOV   BX,512
prop_ok:       CMP   dosver,300h
               JAE   prop_valido
               CMP   AX,4084*2     ; en DOS 2.xx evitar FAT16
               JB    prop_valido
               MOV   CL,8
               CMP   AX,4084*4
               JB    prop_valido
               MOV   CL,16
               CMP   AX,4084*8
               JB    prop_valido
               MOV   CL,32
prop_valido:   MOV   tdir,BX
               MOV   tcluster,CL   ; inicializar valores recomendados
               MOV   DX,1024       ; AX = tamao del disco en Kb
               MUL   DX            ; DX:AX = bytes totales del disco
               MOV   CX,param_tsect
               AND   CX,CX
               JNZ   tsect_def     ; se ha definido tamao de sector
tsect_rec:     MOV   CX,tsect      ; tamao por defecto
tsect_def:     CALL  divCX
               JNC   nsect_ok      ; menos de 65536 sectores: correcto
               OR    lista_err,ERROR11
               JMP   tsect_rec     ; asumir por defecto y recalcular
nsect_ok:      MOV   tsect,CX
               MOV   numsect,AX
               MOV   BX,AX
               SHR   BX,1          ; BX = 1/2 del n total de sectores
               MOV   CX,param_tdir
               AND   CX,CX
               JNZ   tdir_def      ; se ha definido n entradas
tdir_rec:      MOV   CX,tdir       ; n por defecto
tdir_def:      MOV   AX,tsect
               XOR   DX,DX
               MOV   SI,32         ; 32 bytes = tamao entrada direct.
               DIV   SI            ; AX n entradas direct. por sector
               XCHG  AX,CX
               XOR   DX,DX         ; DX:AX = n de entradas
               DIV   CX            ; CX = entradas en cada sector
               AND   DX,DX         ; AX = n sectores del ROOT
               JZ    dir_ok?
               INC   AX            ; redondear tamao de ROOT
dir_ok?:       CMP   AX,BX         ; BX = 1/2 n sectores del disco
               JB    dir_ok
               OR    lista_err,ERROR12  ; directorio excesivo
               JMP   tdir_rec      ; directorio por defecto
dir_ok:        MOV   sdir,AX
               MUL   tsect
               MOV   CX,32
               CALL  divCX
               MOV   tdir,AX       ; optimizar tamao de directorio
               MOV   AX,512
               XOR   DX,DX
               DIV   tsect         ; 512 / tamao de sector
               MOV   BL,tcluster
               XOR   BH,BH
               MUL   BX            ; ajustar tamao de cluster
               AND   AL,AL
               JZ    propclus_ok
               MOV   tcluster,AL
propclus_ok:   MOV   BX,param_tcluster
               AND   BX,BX
               JNZ   tcluster_def  ; se ha definido tamao de cluster
tcluster_rec:  MOV   BL,tcluster   ; tamao por defecto
               XOR   BH,BH
tcluster_def:  SHL   BX,1
               CMP   BX,numsect    ; cabe seguro un cluster?
               JB    tcluster_ok
tcluster_mal:  OR    lista_err,ERROR13 ; tamao de cluster incorrecto
               JMP   tcluster_rec
tcluster_ok:   SHR   BX,1
               MOV   AX,tsect
               MUL   BX            ; DX:AX = tamao de cluster
               JC    tcluster_mal
               CMP   AX,31*1024
               JA    tcluster_mal  ; cluster de ms de 31 Kb
               MOV   tcluster,BL   ; sectores por cluster
               MOV   tamcluster,AX ; tamao de cluster
               MOV   CX,param_f    ; considerar nmero de FATs
               MOV   nfats,CL
               MOV   SI,3
               MOV   CX,param_f
               SHL   SI,CL
               SHR   SI,1
               CALL  eval_clust    ; obtener n ms alto de cluster
               CMP   AX,4086
               JAE   fat16         ; el n ms alto supera 4085
               MOV   CX,3
               MUL   CX            ; clusters * 3
               SHR   DX,1
               RCR   AX,1          ; clusters * 3 / 2 = clusters * 1,5
               JMP   calc_sfat
fat16:         MOV   SI,4
               MOV   CX,param_f    ; considerar nmero de FATs
               SHL   SI,CL
               SHR   SI,1
               CALL  eval_clust
               SHL   AX,1
               RCL   DX,1          ; clusters * 2
calc_sfat:     DIV   tsect         ; AX = n sectores de FAT aprox.
               AND   DX,DX
               JZ    fat_ok
               INC   AX            ; redondeo
fat_ok:        MOV   sfat,AX
               MOV   AX,numsect    ; n total de sectores
               DEC   AX            ; descontar BOOT
               SUB   AX,sdir       ; descontar ROOT
               SUB   AX,sfat       ; descontar FAT
               MOV   CL,tcluster
               XOR   CH,CH
               XOR   DX,DX
               DIV   CX            ; AX = nmero real de clusters
               INC   AX            ; se numeran desde 2
               MOV   ultclus,AX
               RET
adaptar_param  ENDP

eval_clust     PROC                ; obtener el n ms alto de cluster
               MOV   AX,numsect
               DEC   AX            ; restar BOOT
               SUB   AX,sdir       ; restar ROOT
               MUL   tsect         ; DX:AX = nsect * tamsect
               SHL   AX,1
               RCL   DX,1          ; DX:AX = nsect * tamsect * 2
               MOV   CX,tamcluster
               SHL   CX,1
               ADD   CX,SI         ; CX = 2 * tamcluster + SI
               DIV   CX
               INC   AX            ; los clusters se numeran desde 2
               AND   DX,DX         ; sobra un cacho de cluster?
               JZ    clust_eval    ; redondear: es preferible que
               INC   AX            ; sobre un poco de FAT a que falte!
clust_eval:    XOR   DX,DX         ; resultado en DX:AX
               RET
eval_clust     ENDP

; ------------ Preparar el BPB del disco virtual segn los parmetros
;              y forzar que el DOS lo lea indicando cambio de disco.

preparar_BPB   PROC
               MOV   AX,tsect
               MOV   bytes_sector,AX
               MOV   AL,tcluster
               MOV   sect_cluster,AL
               MOV   AX,tdir
               MOV   entradas_raiz,AX
               MOV   AX,numsect
               MOV   num_sect,AX
               MOV   AL,nfats
               MOV   num_fats,AL
               MOV   AX,sfat
               MOV   sectores_fat,AX
               MOV   cambiado,0FFh     ; ha habido cambio de disco
               RET
preparar_BPB   ENDP

; ------------ Preparar el disco para operar. ES apunta al disco al
;              entrar. Se proceder a copiar la rutina necesaria en
;              funcin del tipo de memoria que gestiona el disco.
;              Despus, se copiarn las variables que gestionan TDSK
;              sobre la copia residente, as como el nuevo BPB.

prep_driver    PROC
               MOV   AL,tipo_soporte
               LEA   SI,procesa_xms
               MOV   CX,tam_proc_xms
               DEC   AL
               JZ    prep_mem          ; instalar rutina XMS
               LEA   SI,procesa_ems
               MOV   CX,tam_proc_ems
               DEC   AL
               JZ    prep_mem          ; instalar rutina EMS
               LEA   SI,procesa_con
               MOV   CX,tam_proc_con   ; instalar rutina memoria conv.
prep_mem:      LEA   DI,procesa_io
               CLD
               XPUSH <SI,DI,CX>
               REP   MOVSB             ; instalar rutina en el disco
               XPOP  <CX,DI,SI>
               XPUSH <ES,DS>
               POP   ES
               REP   MOVSB             ; y en el propio TDSK.EXE (para
               POP   ES                ; usarla despus al formatear)
               LEA   CX,f_tdsk_ctrl
               LEA   SI,i_tdsk_ctrl
               SUB   CX,SI
               MOV   DI,SI
               REP   MOVSB             ; actualizar variables
               LEA   CX,fin_bpb
               LEA   SI,bpb
               SUB   CX,SI
               MOV   DI,SI
               REP   MOVSB             ; actualizar BPB
               RET
prep_driver    ENDP

; ------------ Autorelocalizacin de TDSK.EXE
;              Es necesario si se reserva memoria convencional para el
;              disco virtual. El motivo es evitar que al inicializar
;              la BOOT, la FAT y el ROOT al inicio del disco, si ste
;              est justo encima de TDSK, TDSK se autodestruya. Por
;              ello, TDSK se autocopiar en la mitad de los 128 Kb del
;              mayor bloque de memoria libre, nunca utilizados por el
;              disco (aunque este bloque no haya sido reservado, como
;              est libre!). Finalmente pasar a correr en ese nuevo
;              destino. Se copia TODO, pila incluida. La copia se hace
;              en segm_reubicar que apunta a la mitad de esos 128 Kb
;              con objeto de evitar solapamientos origen/destino (TDSK
;              ocupa slo alrededor de 16 Kb en memoria).

relocalizar    PROC
               CMP   tipo_soporte,3
               JE    procede_reloc     ; usada memoria convencional
               RET
procede_reloc: PUSH  ES                ; * preservar ES
               MOV   ES,segm_reubicar  ; segmento de reubicacin
               XOR   SI,SI
               XOR   DI,DI
               MOV   BX,SS             ; final de TURBODSK (pila)
               MOV   CX,DS             ; inicio de _PRINCIPAL
               SUB   BX,CX             ; tamao de TDSK en prrafos
               MOV   CL,4
               SHL   BX,CL             ; ahora en bytes
               ADD   BX,tam_pila+16    ; 16 por si acaso
               MOV   CX,BX             ; CX = bytes a relocalizar
               CLD
               REP   MOVSB             ; auto-copiaje arriba
               MOV   AX,ES
               MOV   DS,AX             ; nuevo segmento de datos
               POP   ES                ; * restaurar ES
               MOV   BX,CS
               SUB   AX,BX             ; ES - CS --> cuanta del salto
               MOV   BX,SS
               ADD   BX,AX
               MOV   SS,BX             ; actualizar segmento de pila
               POP   AX                ; direccin de retorno cercano
               PUSH  DS                ; segmento de retorno
               PUSH  AX                ; offset
               RETF                    ; retorno cargando CS:
relocalizar    ENDP

; ------------ Inicializar la BOOT, FAT y ROOT del disco virtual.
;              En versiones del DOS anteriores a la 3.3, el sistema
;              inexplicablemente hace caso omiso del cambio de disco
;              (?), por lo que hay que avisarle dos veces!, con el
;              correspondiente doble cambio del byte descriptor de
;              medio, para que se tome en serio el cambio de disco.
;              Por fortuna desde el DOS 3.3 ya no es preciso hacer
;              esta extraa maniobra. Para que el DOS acceda al disco,
;              se le pregunta simplemente el espacio libre del mismo.

formatear_tdsk PROC
               PUSH  ES                ; *
               PUSH  DS
               POP   ES
               LEA   SI,sector_cero
               LEA   DI,area_trabajo
               MOV   CX,128
               CLD
               REP   MOVSB             ; primeros 128 bytes del BOOT
               XOR   AX,AX
               MOV   CX,tam_a_trabajo-128
               REP   STOSB             ; a 0 resto del rea de trabajo
               LEA   DI,area_trabajo
               ADD   DI,tsect
               MOV   [DI-2],0AA55h     ; marca de sector vlido
               CALL  escribe_sectAX    ; escribir sector BOOT (AX=0)
               LEA   DI,area_trabajo
               MOV   CX,tsect
               REP   STOSB             ; borrar area de trabajo
               MOV   AX,sfat
               MOV   CX,param_f        ; considerar nmero de FATs
               SHL   AX,CL
               SHR   AX,1
               ADD   AX,sdir           ; AX = sectores fat + dir. raiz
ini_fat:       CMP   AX,1
               JE    pfat
               CALL  escribe_sectAX    ; inicializar directorio raiz
               DEC   AX                ; y ltimos sectores de la FAT
               JMP   ini_fat
pfat:          LEA   DI,area_trabajo
               MOV   BYTE PTR [DI],media
               MOV   AX,0FFFFh         ; inicializar 3 bytes FAT...
               MOV   DS:[DI+1],AX
               CMP   ultclus,4086      ; menos de 4085 clusters?
               JB    pfat_ok
               MOV   DS:[DI+3],AL      ; inicializar 4 byte FAT
pfat_ok:       MOV   AX,1
               CALL  escribe_sectAX    ; primer sector FAT preparado
               CALL  fecha_hora
               LEA   SI,dir_raiz
               MOV   [SI+22],AX        ; hora actual
               MOV   [SI+24],DX        ; fecha actual
               LEA   DI,area_trabajo
               MOV   CX,32
               REP   MOVSB
               MOV   AX,sfat
               MOV   CX,param_f        ; considerar nmero de FATs
               SHL   AX,CL
               SHR   AX,1
               INC   AX
               CALL  escribe_sectAX    ; primer sector raiz preparado
               POP   ES                ; *
               CMP   dosver,31Eh
               JAE   formateado        ; DOS 3.3+
               NOT   ES:media_byte     ; cambiar descriptor de medio
               MOV   AH,36h            ; obtener espacio libre
               MOV   DL,ES:letra_unidad
               SUB   DL,'A'-1          ; unidad de disco virtual
               PUSH  DX
               INT   21h               ; primer acceso al disco
               POP   DX
               NOT   ES:media_byte     ; restaurar descriptor de medio
               MOV   ES:cambiado,0FFh  ; nuevo cambio de disco
               MOV   AH,36h
               INT   21h               ; acceder otra vez al disco
formateado:    RET
formatear_tdsk ENDP

               ; ---- Escribir el sector n AX del disco virtual. No
               ;      se utiliza INT 26h (imposible desde el CONFIG).

escribe_sectAX PROC
               PUSHF                   ; preservar bit DF
               XPUSH <AX,BX,CX,DX,SI,DI,BP,DS,ES>
               XOR   BP,BP             ; indicar escritura
               LEA   DI,area_trabajo   ; ES:DI buffer
               MOV   BX,AX             ; nmero de sector
               MOV   AX,1              ; 1 sector
               CALL  io_proc           ; acceder al disco directamente
               XPOP  <ES,DS,BP,DI,SI,DX,CX,BX,AX>
               POPF
               RET
escribe_sectAX ENDP

               ; ---- Obtener fecha y hora del sistema en DX y AX

fecha_hora     PROC
               MOV   AH,2Ah
               INT   21h               ; obtener fecha del sistema
               MOV   AL,32
               MUL   DH                ; AX = mes * 32
               SUB   CX,1980
               SHL   CL,1              ; (ao-1980)*2
               ADD   AH,CL             ; sumar (ao-1980)*512
               MOV   CL,DL             ; CX = dia (CH=0)
               ADD   AX,CX
               PUSH  AX                ; * guardar fecha
               MOV   AH,2Ch
               INT   21h               ; obtener hora del sistema
               MOV   AL,32
               MUL   CL                ; AX = minutos*32
               MOV   CL,3
               SHL   CH,CL
               XOR   CL,CL             ; CX = hora*2048
               ADD   AX,CX
               SHR   DH,1              ; segundos/2
               ADD   AL,DH
               ADC   AH,0
               POP   DX                ; * recuperar fecha
               RET
fecha_hora     ENDP

; ------------ Cambiar el nombre al bloque de control de memoria para
;              mejorar la informacin del comando MEM del sistema si
;              el disco se define en memoria convencional/superior.

renombrar_mcb  PROC
               PUSH  ES
               MOV   AL,letra_unidad
               MOV   BYTE PTR nombre_tdsk+5,AL
               MOV   BYTE PTR nombre_tdsk+4,'('
               MOV   BYTE PTR nombre_tdsk+6,')'
               MOV   AX,segm_psp
               DEC   AX
               MOV   ES,AX
               LEA   SI,nombre_tdsk
               MOV   DI,8
               MOV   CX,DI
               CLD
               REP   MOVSB
               POP   ES
               RET
renombrar_mcb  ENDP

; ------------ Informar sobre el disco virtual instalado.

info_disco     PROC
               CALL  InitMultiPrint
               CALL  habla_hispana?
               LEA   DX,ayuda_txt      ; ayuda en espaol
               CMP   idioma_sp,ON
               JE    info_ayuda_ok
               LEA   DX,ayuda_ex_txt   ; ayuda en ingls
info_ayuda_ok: CMP   param_h,ON        ; solicitud de ayuda?
               JNE   cont_info         ; no
               JMP   info_exit
cont_info:     TEST  err_grave,0FFFFh
               JZ    info_no_fatal
               LEA   DX,err_grave_gen  ; texto de encabezamiento
               CALL  imprimir          ; imprimir errores graves:
               LEA   DX,e0             ; en espaol
               CMP   idioma_sp,ON
               JE    e0_ok
               LEA   DX,e0_ex          ; en ingls
e0_ok:         TEST  err_grave,ERROR0
               JZ    otro_fallo        ; no es error de DOS incorrecto
               CALL  imprimir
               MOV   SP,tam_pila
               PUSH  segm_psp          ; en DOS 1.x hay que terminar
               XOR   AX,AX             ; con CS = PSP
               PUSH  AX
               RETF                    ; ejecutar INT 20h de PSP:0
otro_fallo:    LEA   AX,e1
               LEA   BX,e1_ex
               TEST  err_grave,ERROR1
               JNZ   info_g
               LEA   AX,e2
               LEA   BX,e2_ex
               TEST  err_grave,ERROR2
               JNZ   info_g
               LEA   AX,e3
               LEA   BX,e3_ex
info_g:        MOV   DX,AX             ; mensaje en espaol
               CMP   idioma_sp,ON
               JE    info_g_ok
               MOV   DX,BX             ; mensaje en ingls
info_g_ok:     JMP   info_exit
info_no_fatal: MOV   AL,letra_unidad   ; error no fatal
               MOV   inf_unidad1,AL
               MOV   inf_unidad1_,AL
               MOV   inf_unidad2,AL
               MOV   inf_unidad2_,AL   ; actualizadas letras de unidad
               CMP   ES:tipo_soporte,0
               JNE   info_reporte
               LEA   DX,info_ins       ; disco no formateado (espaol)
               CMP   idioma_sp,ON
               JE    info_ins_ok
               LEA   DX,info_ins_ex    ; disco no formateado (ingls)
info_ins_ok:   CMP   lista_err,0
               JE    info_exit         ; sin mensajes de advertencia
               CALL  imprimir          ; ... o con ellos
               JMP   info_err
info_reporte:  CALL  haz_info          ; disco formateado
               LEA   DX,info_txt       ; cuadro informativo en espaol
               CMP   idioma_sp,ON
               JE    info_txt_ok
               LEA   DX,info_txt_ex    ; cuadro informativo en ingls
info_txt_ok:   CMP   lista_err,0
               JE    info_exit         ; sin mensajes de advertencia
               CALL  imprimir          ; ... o con ellos
               LEA   DX,cab_adv_txt    ; cabecera en espaol
               CMP   idioma_sp,ON
               JE    cab_ok
               LEA   DX,cab_adv_ex_txt ; cabecera en ingls
cab_ok:        CALL  imprimir          ; cabecera de advertencias
info_err:      MOV   AX,lista_err
               LEA   BX,tabla_mens-2   ; tabla de mensajes en espaol
               CMP   idioma_sp,ON
               JE    tmens_ok
               LEA   BX,tabla_mens_ex-2  ; tabla de mensajes en ingls
tmens_ok:      MOV   CX,16             ; 16 posibles mensajes
busca_err:     ADD   BX,2
               SHR   AX,1
               JC    informa
mas_mens:      LOOP  busca_err         ; no se produce ese error
               JMP   info_ret
informa:       LEA   DX,mens_cabec     ; inicio comn a los mensajes
               CALL  imprimir
               MOV   DX,[BX]           ; direccin de ese mensaje
               CALL  imprimir
               JMP   mas_mens          ; acabar con todos
info_exit:     CALL  imprimir
info_ret:      RET
info_disco     ENDP

haz_info       PROC
               MOV   AL,ES:tipo_soporte
               LEA   BX,inf_mem_xms
               LEA   CX,inf_mem_xms_ex
               DEC   AL
               JZ    mem_ifdo          ; memoria XMS
               LEA   BX,inf_mem_ems
               LEA   CX,inf_mem_ems_ex
               DEC   AL
               JZ    mem_ifdo          ; memoria EMS
               CMP   ES:mem_handle,0A000h
               JB    info_tsect        ; memoria convencional
               LEA   BX,inf_mem_sup    ; memoria superior
               LEA   CX,inf_mem_sup_ex
mem_ifdo:      MOV   SI,BX             ; mensaje en espaol
               LEA   DI,inf_mem
               CMP   idioma_sp,ON
               JE    mem_ifdo_ok
               MOV   SI,CX             ; mensaje en ingls
               LEA   DI,inf_mem_
mem_ifdo_ok:   MOV   CX,inf_mem_lon
               XPUSH <ES,DS>
               POP   ES
               CLD
               REP   MOVSB             ; indicar tipo de memoria
               POP   ES
info_tsect:    LEA   DI,inf_tsect
               LEA   SI,inf_tsect_
               MOV   AX,ES:bytes_sector
               CALL  haz_numero        ; indicar tamao de sector
               LEA   DI,inf_tdir
               LEA   SI,inf_tdir_
               MOV   AX,ES:entradas_raiz
               CALL  haz_numero        ; indicar n entradas direct.
               LEA   DI,inf_tdisco
               LEA   SI,inf_tdisco_
               MOV   AX,ES:num_sect
               MUL   ES:bytes_sector
               MOV   BX,1024
               DIV   BX
               CALL  haz_numero        ; indicar tamao del disco
               LEA   DI,inf_tcluster
               LEA   SI,inf_tcluster_
               MOV   AL,ES:sect_cluster
               XOR   AH,AH
               CALL  haz_numero        ; indicar sectores por cluster
               MOV   AX,ES:entradas_raiz
               MOV   BX,32
               MUL   BX                ; bytes ocupados por directorio
               DIV   ES:bytes_sector   ; AX = sectores del directorio
               ADD   AX,ES:sect_reserv
               ADD   AX,ES:sectores_fat
               SUB   AX,ES:num_sect
               NEG   AX                ; AX = sectores libres
               XOR   DX,DX
               MOV   BL,ES:sect_cluster
               XOR   BH,BH
               DIV   BX                ; AX = n de clusters
               CMP   AX,4085           ; FAT12?
               JB    ifat_ok
               MOV   WORD PTR inf_tfat,"61"
               MOV   WORD PTR inf_tfat_,"61"
ifat_ok:       LEA   DI,inf_nclusters
               LEA   SI,inf_nclusters_
               CALL  haz_numero        ; indicar n de clusters
               RET
haz_info       ENDP

haz_numero     PROC
               CMP   idioma_sp,ON
               JE    haz_idm_ok
               MOV   DI,SI             ; mensaje ingls y no espaol
haz_idm_ok:    MOV   BX,10000          ; empezar por decenas de millar
               MOV   CX,5              ; cinco dgitos
otro_dig:      PUSH  CX
               MOV   CL,-1
gen_digito:    INC   CL
               SUB   AX,BX
               JNC   gen_digito        ; se puede restar an ms
               ADD   AX,BX             ; deshacer desbordamiento
               ADD   CL,'0'            ; pasar a ASCII
               CMP   CL,'0'
               JNE   no_cero
               CMP   BYTE PTR [DI-1],' '  ; anterior byte a cero?
               JNE   no_cero
               MOV   CL,' '            ; pues convertirlo en blanco
no_cero:       MOV   [DI],CL           ; dgito generado
               INC   DI                ; apuntar al siguiente
               XCHG  AX,BX
               MOV   CX,10
               XOR   DX,DX
               DIV   CX                ; pasar a otra potencia de 10
               XCHG  AX,BX
               POP   CX
               LOOP  otro_dig          ; acabar los dgitos
               RET
haz_numero     ENDP

; ------------ Dividir DX:AX / CX sin desbordamientos (cociente: AX,
;              resto: DX). Si el cociente excede los 16 bits, CF = 1
;              y todos los registros intactos.

divCX          PROC
               XPUSH <BX,SI,CX,AX,DX>
               MOV   SI,32
               XOR   BX,BX
divmas:        SHL   AX,1
               RCL   DX,1
               RCL   BX,1
               CMP   BX,CX
               JB    dividido          ; "no cabe"
               SUB   BX,CX
               INC   AL                ; 1 al cociente
dividido:      DEC   SI
               JNZ   divmas
               AND   DX,DX
               JZ    div_ok
               XPOP  <DX,AX>           ; error
               STC
               JMP   div_fin
div_ok:        MOV   DX,BX             ; resto en DX y cociente en AX
               ADD   SP,4              ; sacar sin sacar DX y AX
               CLC
div_fin:       XPOP  <CX,SI,BX>        ; recuperar CX, SI y BX
               RET
divCX          ENDP

; ------------ Inicializar variable idioma_sp segn la lengua del pas

habla_hispana? PROC
               MOV   idioma_sp,OFF     ; supuesto de habla no hispana
               MOV   AX,param_i
               AND   AX,AX
               JNZ   habla_ax          ; parmetro /I indicado
               CMP   dosver,200h
               JB    habla_ok
               LEA   DX,area_trabajo
               MOV   AX,3800h
               INT   21h               ; obtener informacin del pais
               CMP   dosver,20Bh
               JE    habla_ax          ; DOS 2.11: AX cd. telefnico
               CMP   dosver,300h
               JB    habla_ok          ; 2.x excepto 2.11: mala suerte
               MOV   AX,BX
habla_ax:      LEA   BX,paises_sp-2
               MOV   CX,numpaises_sp
habla_sp?:     ADD   BX,2
               CMP   AX,[BX]
               JE    habla_hispana
               LOOP  habla_sp?
habla_ok:      RET
habla_hispana: MOV    idioma_sp,ON     ; pas de habla hispana
               RET
habla_hispana? ENDP

; ------------ Impresin en color o monocroma (esta ltima
;              redireccionable). Desde el CONFIG.SYS se imprime en
;              monocromo para no llamar la atencin, a menos que
;              indiquen /M, al contrario que desde el DOS.

imprimir       PROC
               PUSH  AX
               MOV   AL,param_m
               CMP   modo,CONFIG       ; en CONFIG.SYS?
               JNE   m_ok              ; no
               XOR   AL,ON             ; s: /M opera al revs
m_ok:          MOV   pr_mono,AL
               CALL  MultiPrint
               POP   AX
               RET
imprimir       ENDP

; ------------ Impresin en pantalla, en color o monocromo, usando el
;              BIOS o el DOS respectivamente. Antes deber ejecutarse
;              InitMultiPrint para inicializar.   Al  hacer scroll se
;              intenta respetar el posible  color  global  de  fondo.
;              Con pr_mono en ON se solicita imprimir en monocromo.
;
;              - El texto a imprimir es apuntado por DS:DX.
;              - Cdigos de control soportados:
;
;                 0 -> final de cadena
;                 1 -> el siguiente carcter indica el color (BIOS)
;                 2 -> el siguiente carcter indica el n de veces que
;                      se imprimir el que viene detrs
;                 3 -> avanzar cursor a la derecha
;                10 -> retorno de carro y salto de lnea estilo UNIX

MultiPrint     PROC
               XPUSH <AX,BX,CX,DX,SI,DI,BP,DS,ES>
               PUSH  DS
               POP   ES
               PUSH  CS
               POP   DS
               LEA   AX,pr_AL_dos
               CMP   pr_mono,ON
               JE    pr_rut_ok
               LEA   AX,pr_AL_bios
pr_rut_ok:     MOV   pr_rut,AX         ; instalar rutina de impresin
               MOV   BX,DX
pr_otro:       MOV   AL,ES:[BX]
               PUSH  BX
               CMP   AL,' '
               JAE   pr_ASCII          ; no es un cdigo de control
               AND   AL,AL
               JZ    pr_exit           ; cdigo de control 0: final
               CMP   AL,1
               JE    pr_setcolor       ; cdigo de control 1: color
               CMP   AL,2
               JE    pr_setveces       ; cdigo de control 2: repetir
pr_ASCII:      CALL  pr_rut
               POP   BX
               INC   BX
               JMP   pr_otro
pr_setcolor:   MOV   AL,ES:[BX+1]
               MOV   pr_color,AL       ; actualizar color
               POP   BX
               ADD   BX,2
               JMP   pr_otro
pr_setveces:   MOV   AL,ES:[BX+1]
               MOV   pr_veces,AL       ; actualizar repeticiones
               POP   BX
               ADD   BX,2
               JMP   pr_otro
pr_exit:       XPOP  <BX,ES,DS,BP,DI,SI,DX,CX,BX,AX>
               RET
MultiPrint     ENDP

pr_AL_bios     PROC                    ; imprimir en color usando BIOS
               PUSH  AX
               MOV   AH,3
               MOV   BH,pr_pagina
               INT   10h               ; DX = coordenadas del cursor
               POP   AX
               CMP   AL,3
               JE    pr_derecha        ; cdigo de control 3: avanzar
               CMP   AL,10
               JE    pr_crlf           ; cdigo de control 10: CR & LF
               MOV   AH,9
               MOV   BH,pr_pagina
               MOV   BL,pr_color
               MOV   CL,pr_veces
               XOR   CH,CH
               PUSH  DX
               INT   10h               ; imprimir carcter
               POP   DX
pr_derecha:    ADD   DL,pr_veces
               MOV   pr_veces,1
               CMP   DL,pr_maxX
               JBE   pr_av
pr_crlf:       XOR   DL,DL             ; volver al inicio de lnea
               INC   DH                ; salto a la siguiente
               CMP   DH,pr_maxY
               JBE   pr_av
               DEC   DH
               PUSH  DX                ; es preciso hacer scroll
               MOV   AX,601h
               MOV   BH,pr_colorb      ; color por defecto
               XOR   CX,CX
               MOV   DL,pr_maxX
               MOV   DH,pr_maxY
               INT   10h               ; hacer scroll usando BIOS
               POP   DX
pr_av:         MOV   BH,pr_pagina
               MOV   AH,2
               INT   10h               ; posicionar cursor
               RET                     ; retorno del procedimiento
pr_AL_bios     ENDP

pr_AL_dos      PROC                    ; imprimir usando DOS
               CMP   AL,3
               JNE   pr_no_der
               MOV   AL,' '            ; cdigo de control 3: avanzar
pr_no_der:     CMP   AL,10
               JNE   pr_dos
               MOV   AL,13             ; cdigo de control 10: CR & LF
               CALL  pr_dos            ; llamada "recursiva"
               MOV   AL,10
pr_dos:        MOV   CL,pr_veces
               XOR   CH,CH
               MOV   pr_veces,1
               MOV   DL,AL
pr_chr:        XPUSH <DX,CX>
               MOV   AH,2
               INT   21h               ; imprimir carcter
               XPOP  <CX,DX>
               LOOP  pr_chr
               RET
pr_AL_dos      ENDP

InitMultiPrint PROC
               XPUSH <AX,BX,CX,DX,BP,DS,ES>
               PUSH  CS
               POP   DS
               MOV   pr_veces,1
               MOV   pr_color,15       ; valores por defecto
               MOV   pr_mono,OFF
pr_i_80?:      MOV   AH,0Fh
               INT   10h
               CMP   AH,80             ; 80  ms columnas?
               JAE   pr_i_video_ok     ; as es
               MOV   AX,3
               INT   10h               ; forzar modo de 80 columnas
               JMP   pr_i_80?
pr_i_video_ok: MOV   pr_maxX,AH        ; inicializar mxima coord. X
               MOV   pr_pagina,BH      ; inicializar pgina activa
               MOV   AX,40h
               MOV   ES,AX             ; ES: -> variables del BIOS
               MOV   AL,ES:[84h]       ; variable de n lneas - 1
               CMP   AL,24             ; el BIOS define la variable?
               JB    pr_i_maxy_ok      ; no
               MOV   pr_maxY,AL        ; inicializar mxima coord. Y
pr_i_maxy_ok:  MOV   AH,8              ; (BH = pgina)
               INT   10h               ; obtener color por defecto
               MOV   pr_colorb,AH
               XPOP  <ES,DS,BP,DX,CX,BX,AX>
               RET
InitMultiPrint ENDP

pr_pagina      DB    0       ; pgina de visualizacin activa
pr_veces       DB    1       ; veces que se imprime cada carcter
pr_color       DB    15      ; color BIOS para imprimir
pr_colorb      DB    ?       ; color por defecto en pantalla
pr_maxX        DB    80      ; mxima coordenada X en pantalla
pr_maxY        DB    24      ; mxima coordenada Y en pantalla
pr_mono        DB    OFF     ; a ON si imprimir en monocromo
pr_rut         DW    ?       ; apunta a pr_AL_bios / pr_AL_dos

; ------------ Rutina de gestin de memoria XMS. Se copiar sobre
;              la de memoria EMS si se utiliza memoria XMS.
;              En esta rutina se emplea la pila para pasar los
;              parmetros al controlador XMS.

procesa_xms    PROC
               MOV   DS,CS:mem_handle
               JNC   no_xmslib
               .286                    ; rutina ejecutada desde 286+
               PUSHA                   ; sistema reinicializando:
               MOV   AH,0Dh
               CALL  llama_XMS         ; desbloquear EMB (prudente)
               MOV   AH,0Ah
               CALL  llama_XMS         ; liberar EMB
               POPA
               .8086
               RET
no_xmslib:     DEC   BP                ; leer/escribir en el disco
               JNZ   xms_escribe
               PUSH  ES
               PUSH  DI                ; segmento:offset destino
               PUSH  BP                ; handle destino (BP=0)
xms_escribe:   PUSH  DX
               PUSH  AX                ; desplazamiento DX:AX
               PUSH  DS                ; handle fuente/destino
               JZ    xms_general
               INC   BP                ; hacer BP = 0
               PUSH  ES
               PUSH  DI                ; segmento:offset fuente
               PUSH  BP                ; handle fuente (BP=0)
xms_general:   SHL   CX,1              ; palabras -> bytes
               RCL   BP,1              ; BP era 0
               PUSH  BP                ; tamao bloque (parte alta)
               PUSH  CX                ; tamao bloque (parte baja)
               MOV   SI,SP
               PUSH  SS
               POP   DS                ; DS:SI apuntando a la pila
               MOV   AH,0Bh            ; funcin para mover EMB
               CALL  llama_XMS         ; mover EMB (DS no importa)
               ADD   SP,16             ; equilibrar pila
               CMP   AL,1              ; fall el controlador?
               JE    xms_proc_ok
               MOV   AX,0C81h          ; anomala general
xms_proc_ok:   XCHG  AH,AL             ; colocar resultado
               RET
procesa_xms    ENDP

llama_XMS      PROC
               MOV   DX,DS             ; handle en DS (si utilizado)
               CALL  CS:xms_driver     ; ejecutar funcin XMS
               RET
llama_XMS      ENDP

tam_proc_xms   EQU   $-OFFSET procesa_xms   ; tamao de esta rutina

; ------------ Rutina de gestin de memoria convencional. Se copiar
;              sobre la de memoria EMS si se utiliza memoria conv.

procesa_con    PROC
               JC    con_exit          ; sistema inicializndose
               MOV   BX,16             ; bytes por prrafo
               DIV   BX                ; AX = segmento, DX = offset
               ADD   AX,CS:mem_handle  ; segmento de inicio datos
               MOV   DS,AX
               MOV   SI,DX             ; DS:SI inicio de datos
               DEC   BP                ; y ES:DI destino del buffer
               JZ    con_general       ; es lectura
               XCHG  SI,DI             ; escritura: intercambiar
               XPUSH <DS,ES>
               XPOP  <DS,ES>
con_general:   CLD
               CMP   CS:cpu386,ON
               JE    con_tr32bit
               REP   MOVSW
               JMP   con_tr_fin
con_tr32bit:   SHR   CX,1              ; n palabras de 32 bit a mover
               JCXZ  con_trdo          ; evitar desgracia
               .386
               PUSHAD
               XOR   EAX,EAX           ; asegurar no violacin
               DEC   AX                ; de segmento-64K
               AND   ECX,EAX           ; EAX = 0FFFFh
               AND   ESI,EAX
               AND   EDI,EAX
               REP   MOVSD             ; transferencia ultrarrpida
con_trdo:      POPAD                   ; POPAD falla en muchos 386
               NOP                     ; arreglar fallo de POPAD
               .8086
con_tr_fin:    MOV   AX,100h           ; todo fue bien, por supuesto
con_exit:      RET
procesa_con    ENDP

tam_proc_con   EQU   $-OFFSET procesa_con   ; tamao de esta rutina


; ************ Datos no residentes para la instalacin

ON             EQU   1            ; constantes booleanas
OFF            EQU   0

CONFIG         EQU   1            ; TURBODSK ejecutado desde el CONFIG
AUTOEXEC       EQU   2            ; TURBODSK se ejecuta desde el DOS

emm_id         DB    "EMMXXXX0"   ; identificacin del controlador EMS

nombre_tdsk    DB    "TDSK U: "   ; para nombrar handle EMS y el MCB

modo           DB    ?            ; CONFIG/AUTOEXEC
dosver         DW    ?            ; versin del DOS
top_ram        DW    0            ; segmento ms alto de la RAM
segm_psp       DW    0            ; segmento del PSP
segm_tdsk      DW    0            ; segmento donde reside TURBODSK
segm_reubicar  DW    0            ; segmento donde reubicar TURBODSK
ems4           DB    OFF          ; a ON si EMS versin 4.0+
cpu286         DB    OFF          ; a ON si 286  superior
idioma_sp      DB    OFF          ; a ON si mensajes en espaol

param_unidad   DB    0            ; nmero de disco si indicada unidad
param_tdiscof  DB    OFF          ; a ON si se define tamao de disco
param_tdisco   DW    0            ; tamao de disco (si se define)
param_tsect    DW    0            ; tamao de sector (si se define)
param_tdir     DW    0            ; nmero de entradas (si se define)
param_tcluster DW    0            ; tamao de cluster (si se define)
param_a        DB    OFF          ; a ON si indicado parmetro /A o /X
param_e        DB    OFF          ; a ON si indicado parmetro /E
param_c        DB    OFF          ; a ON si indicado parmetro /C
param_h        DB    OFF          ; a ON si indicado parmetro /? o /H
param_m        DB    OFF          ; a ON si indicado parmetro /M
param_i        DW    0            ; <> 0 si indicado parmetro /I=
param_f        DW    1            ; n de FATs (1-2): parmetro /F=

tdisco         DW    ?            ; tamao de disco (Kb)
ultclus        DW    ?            ; nmero ms alto de cluster
tamcluster     DW    ?            ; tamao de cluster (bytes)
sdir           DW    ?            ; sectores para directorio raiz
xms_kb         DW    0            ; Kb de memoria XMS libres
ems_kb         DW    0            ; Kb de memoria EMS libres
con_kb         DW    0            ; Kb de memoria convencional libres

sector_cero    LABEL BYTE
               JMP   SHORT botar
               NOP
               DB    "TDSK 2.1"   ; identificacin del sistema
tsect          DW    512          ; tamao de sector por defecto
tcluster       DB    ?            ; sectores por cluster
               DW    1            ; sectores reservados
nfats          DB    ?            ; nmero de FAT's
tdir           DW    ?            ; nmero de entradas al dir. raiz
numsect        DW    ?            ; n sectores del disco (<=32Mb)
               DB    media        ; descriptor de medio
sfat           DW    ?            ; sectores por FAT
               DW    1, 1         ; sectores por pista / cabezas
               DD    0            ; sectores ocultos
               DD    0            ; n total de sectores (si > 32Mb)
               DB    7 DUP (0)    ; 7 bytes reservados
botar:         DB    0EAh         ; cdigo de JMP FAR...
               DW    0,0FFFFh     ; ...FFFF:0000 (programa BOOT)
               DB    "(c)1993 CiriSOFT"; resto de primeros 64 bytes
               DB    ". Grupo Universi"
               DB    "tario de Inform"
               DB    "tica (GUI) - Val"
               DB    "ladolid (Espaa)"; resto de primeros 128 bytes

dir_raiz       DB    "TURBODSK   "; Directorio raiz: primera entrada
               DB    8            ; etiqueta de volmen
               DB    10 DUP (0)   ; reservado
               DW    ?            ; hora (inicializado al formatear)
               DW    ?            ; fecha
               DW    0,0,0        ; ltimos bytes (hasta 32)

; ------------ Areas de datos para informacin del disco virtual

               ; --- Cdigo telefnico de pases de habla
               ;     hispana (mucha o poca).

paises_sp      DW    54                ; Argentina
               DW    591               ; Bolivia
               DW    57                ; Colombia
               DW    506               ; Costa Rica
               DW    56                ; Chile
               DW    593               ; Ecuador
               DW    503               ; El Salvador
               DW    34                ; Espaa
               DW    63                ; Filipinas
               DW    502               ; Guatemala
               DW    504               ; Honduras
               DW    212               ; Marruecos
               DW    52                ; Mxico
               DW    505               ; Nicaragua
               DW    507               ; Panam
               DW    595               ; Paraguay
               DW    51                ; Per
               DW    80                ; Puerto Rico
               DW    508               ; Repblica Dominicana
               DW    598               ; Uruguay
               DW    58                ; Venezuela
               DW    3         ; cdigo genrico COUNTRY.SYS para toda
                               ; latinoamrica (hasta el DOS 5.0)
numpaises_sp   EQU   ($-OFFSET paises_sp)/2

; ------------ Mensaje de no formateado

               ; --- en espaol

info_ins       DB 10,1,10,"TURBODSK 2.1 - Unidad "
inf_unidad1    LABEL BYTE
               DB    "D: sin formatear.",10,1,14,0

               ; --- en ingls

info_ins_ex    DB 10,1,10,"TURBODSK 2.1 - Drive "
inf_unidad1_   LABEL BYTE
               DB    "D: unformatted.",10,1,14,0

; ------------ Cuadro de informacin

colA EQU 11+1*16  ; color del recuadro y los mensajes
colB EQU 15+1*16  ; color de los parmetros de operacin del disco
colC EQU 15+0*16  ; color de lo que rodea a la ventana
colD EQU 10+1*16  ; color de TURBODSK

               ; --- en espaol

info_txt LABEL BYTE
DB 10,2,12,3,1,colA,"",2,26,"",2,26,"Ŀ",1,colC
DB 10,2,12,3,1,colA," ",1,colD,"TURBODSK 2.1",1,colA
DB " - Unidad ",1,colB
inf_unidad2 LABEL BYTE
DB "D:",1,colA,"  Tamao de sector:",1,colB," "
inf_tsect EQU $
DB "00000  ",1,colA,"",1,colC,10,2,12,3
DB 1,colA,"",2,26,"Ĵ N entradas raiz:",1,colB," "
inf_tdir EQU $
DB "00000  ",1,colA,"",1,colC,10
DB 2,12,3,1,colA," Tamao:  ",1,colB," "
inf_tdisco EQU $
DB "00000 Kbytes   ",1,colA," Sectores/cluster:",1,colB," "
inf_tcluster EQU $
DB "00000  ",1,colA,"",1,colC,10
DB 2,12,3,1,colA," Memoria:  ",1,colB
inf_mem EQU $
DB "Convencional   ",1,colA,"",1,colB," "
inf_nclusters EQU $
DB "00000",1,colA," clusters (",1,colB,"FAT"
inf_tfat EQU $
DB "12",1,colA,")   ",1,colA,"",1,colC,10,2,12,3
DB 1,colA,"",2,26,"",2,26,"",1,colC,10,0

inf_mem_xms DB "Extendida XMS"
inf_mem_ems DB "Expandida EMS"
inf_mem_sup DB "   Superior  "
inf_mem_lon EQU $-OFFSET inf_mem_sup

               ; --- en ingls

info_txt_ex LABEL BYTE
DB 10,2,12,3,1,colA,"",2,26,"",2,26,"Ŀ",1,colC
DB 10,2,12,3,1,colA," ",1,colD,"TURBODSK 2.1",1,colA
DB " - Drive ",1,colB
inf_unidad2_ LABEL BYTE
DB "D:",1,colA,"   Sector size:",2,5," ",1,colB," "
inf_tsect_ EQU $
DB "00000  ",1,colA,"",1,colC,10,2,12,3
DB 1,colA,"",2,26,"Ĵ Root entries:",2,4," ",1,colB," "
inf_tdir_ EQU $
DB "00000  ",1,colA,"",1,colC,10
DB 2,12,3,1,colA," Size:",2,4," ",1,colB," "
inf_tdisco_ EQU $
DB "00000 Kbytes   ",1,colA," Sectors/cluster: ",1,colB," "
inf_tcluster_ EQU $
DB "00000  ",1,colA,"",1,colC,10
DB 2,12,3,1,colA," Memory:   ",1,colB
inf_mem_ EQU $
DB "Conventional   ",1,colA,"",1,colB," "
inf_nclusters_ EQU $
DB "00000",1,colA," clusters (",1,colB,"FAT"
inf_tfat_ EQU $
DB "12",1,colA,")   ",1,colA,"",1,colC,10,2,12,3
DB 1,colA,"",2,26,"",2,26,"",1,colC,10,0

inf_mem_xms_ex DB "Extended XMS "
inf_mem_ems_ex DB "Expanded EMS "
inf_mem_sup_ex DB "    Upper    "

; ------------ Errores leves

ERROR0         EQU   1
ERROR1         EQU   2
ERROR2         EQU   4
ERROR3         EQU   8         ; TURBODSK es muy flexible y se instala
ERROR4         EQU   16        ; casi de cualquier forma, aunque a
ERROR5         EQU   32        ; veces no se reserve memoria y sea
ERROR6         EQU   64        ; necesario volver a ejecutarlo despus
ERROR7         EQU   128       ; desde el DOS para formatearlo.
ERROR8         EQU   256
ERROR9         EQU   512
ERROR10        EQU   1024
ERROR11        EQU   2048
ERROR12        EQU   4096
ERROR13        EQU   8192
ERROR14        EQU   16384
ERROR15        EQU   32768

lista_err      DW    0    ; palabra que indica los mensajes a imprimir

mens_cabec     DB    2,8,3,0

tabla_mens     DW    m0,m1,m2,m3,m4,m5,m6,m7
               DW    m8,m9,m10,m11,m12,m13,m14,m15

tabla_mens_ex  DW    m0_ex,m1_ex,m2_ex,m3_ex,m4_ex,m5_ex,m6_ex,m7_ex
               DW    m8_ex,m9_ex,m10_ex,m11_ex,m12_ex,m13_ex,m14_ex
               DW    m15_ex

cab_adv_txt    DB    10,2,8,3,1,12
               DB    "Advertencias y/o errores de TURBODSK:",2,27," "
               DB    10,1,10,0

cab_adv_ex_txt DB    10,2,8,3,1,12,"Warnings and errors of TURBODSK:"
               DB    2,32," ",10,1,10,0

               ; --- Mensajes en espaol

m0 LABEL BYTE
DB "- Error de sintaxis o parmetro fuera de rango.  No se define el"
DB 10,2,8,3
DB "  disco virtual ahora o no se modifica el que estaba definido.  "
DB 10,0

m1 LABEL BYTE
DB "- El parmetro /C o la letra de unidad slo han de emplearse"
DB 2,4," ",10,2,8,3
DB "  desde la lnea de comandos o el AUTOEXEC (les ignorar)."
DB 2,6," ",10,0

m2 LABEL BYTE
DB "- Para poder emplear memoria expandida hay que incluir la opcin"
DB 10,2,8,3
DB "  /A en CONFIG.SYS, con objeto de dejar espacio para las rutinas"
DB 10,2,8,3
DB "  de control EMS: la memoria ocupada crecer de 432 a 608 bytes."
DB 10,0

m3 LABEL BYTE
DB "- El tamao de sector es mayor que el definido en cualquier otro"
DB 10,2,8,3
DB "  controlador de dispositivo: indquese ese tamao en CONFIG.SYS"
DB 10,2,8,3
DB "  para que el DOS ajuste sus buffers (ms consumo de memoria!)."
DB 10,0

m4 LABEL BYTE
DB "- La cantidad de memoria solicitada no existe, se ha rebajado.  "
DB 10,0

m5 LABEL BYTE
DB "- No hay memoria XMS/EMS disponible: no la reservo; ejecute TDSK"
DB 10,2,8,3
DB "  de nuevo desde el DOS para utilizar memoria convencional."
DB 2,5," ",10,0

m6 LABEL BYTE
DB "- No existe memoria XMS: pruebe a indicar EMS en su lugar (/A)  "
DB 10,0

m7 LABEL BYTE
DB "- No existe memoria EMS: pruebe a indicar XMS en su lugar (/E)  "
DB 10,0

m8 LABEL BYTE
DB "- Fallo del controlador XMS: imposible usar memoria extendida.  "
DB 10,0

m9 LABEL BYTE
DB "- Fallo del controlador EMS: imposible usar memoria expandida.  "
DB 10,0

m10 LABEL BYTE
DB "- No existe suficiente memoria convencional para TURBODSK."
DB 2,6," ",10,0

m11 LABEL BYTE
DB "- Tamao de sector incorrecto: lo establezco por defecto."
DB 2,7," ",10,0

m12 LABEL BYTE
DB "- Nmero de entradas incorrecto: lo establezco por defecto."
DB 2,5," ",10,0

m13 LABEL BYTE
DB "- Tamao de cluster incorrecto: lo establezco por defecto."
DB 2,6," ",10,0

m14 LABEL BYTE
DB "- FATAL: fallo al liberar la memoria que ocupaba el disco."
DB 2,6," ",10,0

m15 LABEL BYTE
DB "- Para discos de ms de 32 Mb, hace falta un tamao de sector de"
DB 10,2,8,3,"  al menos 1024 bytes.",2,42," ",10,0

               ; --- Mensajes en ingls

m0_ex LABEL BYTE
DB "- Syntax error and/or parameter out of range. The Ramdisk is not"
DB 10,2,8,3
DB "  defined now or the previous one is not modified.",2,14," ",10,0

m1_ex LABEL BYTE
DB "- The /C parameter and the driver letter only can be used when  "
DB 10,2,8,3
DB "  executing TURBODSK in command line or AUTOEXEC (now, ignored)."
DB 10,0

m2_ex LABEL BYTE
DB "- In order to use expanded memory you must include the /A option"
DB 10,2,8,3
DB "  in CONFIG.SYS, needed to reserve too space for the EMS support"
DB 10,2,8,3
DB "  routines: the memory used will increase from 432 to 608 bytes."
DB 10,0

m3_ex LABEL BYTE
DB "- Sector size is greater than any other defined  by  any  device"
DB 10,2,8,3
DB "  driver loaded: you must indicate the sector size in CONFIG.SYS"
DB 10,2,8,3
DB "  because DOS need adjust buffers length (more memory spent!).  "
DB 10,0

m4_ex LABEL BYTE
DB "- The amount of memory requested does not exist: size reduced.  "
DB 10,0

m5_ex LABEL BYTE
DB "- There is not XMS/EMS memory available: execute TDSK again from"
DB 10,2,8,3
DB "  DOS command line or AUTOEXEC and use conventional memory."
DB 2,5," ",10,0

m6_ex LABEL BYTE
DB "- There is not XMS memory available: try to request EMS (/A).   "
DB 10,0

m7_ex LABEL BYTE
DB "- There is not EMS memory available: try to request XMS (/E).   "
DB 10,0

m8_ex LABEL BYTE
DB "- XMS controller failure: imposible to use extended memory."
DB 2,5," ",10,0

m9_ex LABEL BYTE
DB "- EMS controller failure: imposible to use expanded memory."
DB 2,5," ",10,0

m10_ex LABEL BYTE
DB "- There is not sufficient conventional memory for TURBODSK."
DB 2,5," ",10,0

m11_ex LABEL BYTE
DB "- Incorrect sector size indicated: default values assumed."
DB 2,6," ",10,0

m12_ex LABEL BYTE
DB "- Incorrect number of root entries: default value assumed."
DB 2,6," ",10,0

m13_ex LABEL BYTE
DB "- Incorrect cluster size indicated: default value assumed."
DB 2,6," ",10,0

m14_ex LABEL BYTE
DB "- FATAL: imposible to free memory alocated by TURBODSK."
DB 2,9," ",10,0

m15_ex LABEL BYTE
DB "- In drives over 32 Mb, sector size must be at least 1024 bytes."
DB 10,0

; ------------ Errores graves (se imprime slo el ms importante)

err_grave      DW    0   ; tipo de error grave a imprimir

err_grave_gen  DB    10,1,10,"TURBODSK 2.1",10,1,12,0

               ; --- En espaol

e0  DB "  - Este disco virtual requiere DOS 2.0 o superior.",10,0

e1  DB "  - Instale primero TURBODSK desde CONFIG.SYS (con DEVICE)."
    DB 10,"  - Puede solicitar ayuda con TDSK /?",10,0

e2  DB "  - La unidad indicada no es un dispositivo TURBODSK 2.1",10,0

e3  DB "  - No pueden modificarse las caractersticas de operacin de"
    DB 10
    DB "    TURBODSK dentro de WINDOWS. Configrelo con anterioridad."
    DB 10,0
               ; --- En ingls

e0_ex  DB "  - This Ram Disk needs at least DOS 2.0 or above.",10,0

e1_ex  DB "  - You must install before TURBODSK from CONFIG.SYS "
       DB "(using DEVICE).",10
       DB "  - Help is available with TDSK /?",10,0

e2_ex  DB "  - Drive letter indicated does not is a TURBODSK 2.1 "
       DB "device.",10,0

e3_ex  DB "  - Operational characteristics of disk can not be "
       DB "altered inside",10,2,4," a WINDOWS session. You must "
       DB "configure TURBODSK before.",10,0

; ------------ Ayuda

colorA   EQU 15+4*16+128  ; color de TURBODSK
colorAm  EQU 14+1*16      ; color del marco de fondo de TURBODSK
colorB   EQU 13+1*16      ; color de la fecha
colorC   EQU 10+1*16      ; color de sintaxis y parmetros
colorD   EQU 15+1*16      ; color principal del texto
colorDm  EQU 11+1*16      ; color del marco de fondo
colorDmx EQU 11+0*16      ; color de la esquina del marco
colorE   EQU 11+1*16      ; color del nombre del autor
colorF   EQU 14+1*16      ; color para llamar la atencin
colorG   EQU 12+1*16      ; color para la direccin de mail
colorH   EQU  9+1*16      ; color para mensaje de dominio pblico

               ; --- En espaol

ayuda_txt LABEL BYTE
DB 10,3,1,colorDm,"  ",1,colorA," TURBODSK 2.1 ",1,colorAm,""
DB    1,colorB,2,52," 31/1/93 ",1,colorDmx,"",10
DB 3,1,colorE,"   ",1,colorAm,2,14,"",1,colorE
DB    "  (c) 1993 Ciriaco Garca de Celis. ",1,colorG
DB    "(Mail: gui@cpd.uva.es). ",1,colorDm,"",10
DB 3,1,colorE," (c) Grupo Universitario de Informtica. "
DB    "Apartado 6062, Valladolid (Espaa). ",1,colorDm,"",10
DB 3,1,colorH,2,18," ","* * *  Programa de Dominio Pblico  * * *"
DB    2,18," ",1,colorDm,"",10
DB 3,1,colorD,"   Bienvenido al disco virtual ",1,colorF,"ms rpido"
DB    1,colorD,", con soporte de memoria EMS, XMS y ",1,colorDm,"",10
DB 3,1,colorD," convencional; redimensionable, fcil de usar. En DOS "
DB    "5 ocupa 432-608 bytes. ",1,colorDm,"",10
DB 3,1,colorC,2,77," ",1,colorDm,"",10
DB 3,1,colorC," DEVICE=TDSK.EXE [tamao [tsector "
DB    "[nfich [scluster]]]] [/E] [/A|X] [/C] [/M] ",1,colorDm,"",10
DB 3,1,colorC,2,77," ",1,colorDm,"",10
DB 3,1,colorD," ",1,colorF,"",1,colorD," El tamao debe de estar en "
DB    "el rango 8 - 65534 Kb; son vlidos sectores de ",1,colorDm
DB    "",10
DB 3,1,colorD," 32 a 2048 bytes (en potencias de dos, aunque algn "
DB    "sistema slo los soporta ",1,colorDm,"",10
DB 3,1,colorD," de 128 a 512). El nmero de ficheros del directorio "
DB    "raiz debe estar entre 1 ",1,colorDm,"",10
DB 3,1,colorD," y 65534 y el de sectores por cluster entre 1 y 255 ("
DB    "en algn sistema han de ",1,colorDm,"",10
DB 3,1,colorD," ser potencia de dos). Segn el tamao se ajustar "
DB    "lo dems automticamente. ",1,colorDm,"",10
DB 3,1,colorD," ",1,colorF,"",1,colorD," Se puede indicar ",1,colorC
DB    "/E",1,colorD," para emplear memoria extendida XMS, y ",1,colorC
DB    "/A",1,colorD," o ",1,colorC,"/X",1,colorD," para la ",1,colorDm
DB    "",10
DB 3,1,colorD," expandida EMS; aunque por defecto, TURBODSK utilizar"
DB    " automticamente estas ",1,colorDm,"",10
DB 3,1,colorD," memorias si puede. Con la opcin ",1,colorC,"/C"
DB    1,colorD," se pide el uso de memoria convencional. ",1,colorDm
DB    "",10
DB 3,1,colorD,32,1,colorF,"",1,colorD," Tras ser instalado, se puede"
DB    " ejecutar desde el DOS para cambiar el tamao ",1,colorDm
DB    "",10
DB 3,1,colorD," del disco (perdindose los datos almacenados):  con "
DB    "un tamao 0 se anula el ",1,colorDm,"",10
DB 3,1,colorD," disco por completo, liberndose la memoria. "
DB    "Utilizando memoria convencional ",1,colorDm,"",10
DB 3,1,colorD," es ",1,colorF,"MUY",1,colorD," conveniente anular el "
DB    "disco previo antes de modificar su tamao. Con ",1,colorDm
DB    "",10
DB 3,1,colorD," ms de un disco presente se pueden distinguir "
DB    "indicando la letra de unidad. ",1,colorDm,"",10
DB 3,1,1*16,"",1,colorDm,2,76,"",10,0

               ; --- En ingls

ayuda_ex_txt LABEL BYTE
DB 10,3,1,colorDm,"  ",1,colorA," TURBODSK 2.1 ",1,colorAm,""
DB    1,colorB,2,52," 1/31/93 ",1,colorDmx,"",10
DB 3,1,colorE,"   ",1,colorAm,2,14,"",1,colorE
DB    "  (c) 1993 Ciriaco Garcia de Celis. ",1,colorG
DB    "(Mail: gui@cpd.uva.es). ",1,colorDm,"",10
DB 3,1,colorE,"  (c) Grupo Universitario de Informtica. "
DB    "Apartado 6062, Valladolid (Spain). ",1,colorDm,"",10
DB 3,1,colorC,2,77," ",1,colorDm,"",10
DB 3,1,colorD,"   Welcome to the ",1,colorF,"faster",1,colorD
DB    " RAM disk!,  which includes support of both EMS, XMS "
DB    1,colorDm,"",10
DB 3,1,colorD," and conventional memory.  Full resizeable,  easy to "
DB    "use like DOS RAM disks, ",1,colorDm,"",10
DB 3,1,colorD," in DOS 5.0 it takes only about 432-608 bytes. "
DB    1,colorH,"This program is freeware!.",2,4," ",1,colorDm,"",10
DB 3,1,colorC,2,77," ",1,colorDm,"",10
DB 3,1,colorC," DEVICE=TDSK.EXE [size [s_sector [files [s_cluster]]]]"
DB    " [/E] [/A|X] [/C] [/M] ",1,colorDm,"",10
DB 3,1,colorC,2,77," ",1,colorDm,"",10
DB 3,1,colorD," ",1,colorF,"",1,colorD," Size must be in the range "
DB    "8 - 65534 Kb; are valid sectors from 32 to 2048 ",1,colorDm
DB    "",10
DB 3,1,colorD," bytes (in power of 2), though some DOS versions only "
DB    "support 128, 256 & 512 ",1,colorDm,"",10
DB 3,1,colorD," bytes. Files of root may be 1 to 65534 and sectors "
DB    "by cluster can vary from ",1,colorDm,"",10
DB 3,1,colorD," 1 to 255 (some systems need a power of 2). Only the "
DB    "size is necessary.",2,6," ",1,colorDm,"",10
DB 3,1,colorD," ",1,colorF,"",1,colorC," /E",1,colorD," force the "
DB    "use of XMS memory, ",1,colorC,"/A",1,colorD," and ",1,colorC
DB    "/X",1,colorD," indicates the use of EMS memory ",1,colorDm
DB    "",10
DB 3,1,colorD," and ",1,colorC,"/C",1,colorD," the conventional. By "
DB    "default, TURBODSK try to use XMS or EMS memory. ",1,colorDm
DB    "",10
DB 3,1,colorD," ",1,colorF,"",1,colorD," After been installed in "
DB    "CONFIG.SYS, TURBODSK must be executed in AUTOEXEC ",1,colorDm
DB    "",10
DB 3,1,colorD," or command line in order to vary the disk size (the "
DB    "amount of memory used); ",1,colorDm,"",10
DB 3,1,colorD," this operation erase the disk contents.  A size 0 "
DB    "can be used to complitely ",1,colorDm,"",10
DB 3,1,colorD," anulation of the disk freezen the memory: when using "
DB    "conventional memory it ",1,colorDm,"",10
DB 3,1,colorD," is useful to annulate the disk ",1,colorF,"BEFORE"
DB    1,colorD," resizing. When more than one TURBODSK ",1,colorDm
DB    "",10
DB 3,1,colorD," is installed, they can be identified using in "
DB    "adition the drive letter.",2,5," ",1,colorDm,"",10
DB 3,1,1*16,"",1,colorDm,2,76,"",10,0

tam_a_trabajo  EQU   2048              ; tamao del mayor sector
                                       ; soportado por TURBODSK
area_trabajo   EQU   $
               DB    tam_a_trabajo DUP (?)

_PRINCIPAL     ENDS

tam_pila       EQU   1024              ; 1 Kb de pila es suficiente

_PILA          SEGMENT STACK 'STACK'
               DB    tam_pila DUP (?)
_PILA          ENDS

               END   main
