; Blee-dip Bel (^G) for 600 MHz Duron under DOS (AH=0Eh, AL=7)
; You can change tones at ToneSpex, but in Win 95B the blee-dip is just a click
; Releases its Environment to use less RAM; TSR listers won't show its name.

;This one also initializes the Mono card for the crappy AMI BIOS.

cr		EQU	0Dh
lf		EQU	0Ah
bel		EQU	7

CSEG	segment	byte public
	assume	CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

	ORG	100h

Start:		JMP	Install

INT10hOffset	DW	0
INT10hSeg	DW	0

ToneSpex	DW	0A00h		;low tone period
		DW	03000h		;low tone on time
		DW	02000h		;off time
		DW	0400h		;hi tone period
		DW	04000h		;hi tone on time
		DW	0
		DW	0		;mark end of tones
MHzCount	DW	0280h

NewInt10h:
	CMP	AH,0Eh		;Display char in AL in TTY mode
	JNZ	NotUs
	CMP	AL,bel
	JZ	BleeDip
NotUs:	JMP	DWORD PTR CS:INT10hOffset

BleeDip:PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	PUSH	CS
	POP	DS
	STI
	XOR	BX,BX
NextTone:
	CMP	WORD PTR [BX+OFFSET ToneSpex],0
	JNZ	MakeTone
	POP	DS
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET

MakeTone:
	MOV	AL,10110110b			;timer 2, read lo then hi byte,
						; sq wave generator, not BCD
	OUT	43h,AL				;8253/4 timer control word
	MOV	AX,WORD PTR [BX+OFFSET ToneSpex]
	OUT	42h,AL				;lo byte, count
	MOV	AL,AH
	OUT	42h,AL				;hi byte, count
	IN	AL,61h				;8255 PPI speaker on-off port
	OR	AL,00000011b			;turn speaker on
	OUT	61h,AL
	MOV	CX,WORD PTR [BX+OFFSET ToneSpex+2]  ;delay time
	CALL	BeepWait
	IN	AL,61h
	AND	AL,11111100b			;turn speaker off
	OUT	61h,AL
	MOV	CX,WORD PTR [BX+OFFSET ToneSpex+4]  ;delay time
	CALL	BeepWait
	ADD	BX,6
	JMP	SHORT NextTone

BeepWait:
	JCXZ	JustRet
	PUSH	BX
	PUSH	CX
BeepLoop:
	XOR	BX,BX
AddOne:	INC	BX
	CMP	MHzCount,BX
	JNB	AddOne
	LOOP	BeepLoop

	POP	CX
	POP	BX
JustRet:RET
;
Install:
; Initialize the old Monochrome Display Adaptor card
	Mov	DX,03B8h
	Xor	AX,AX		;reset the 6845 chip
	Out	DX,AL
;set up the registers
	Mov	DX,03B4h	;Index register - determines which reg is dest
	Mov	BP,Offset SetupString
	Mov	CX,16		;do it 16d times
NxtReg:	Mov	BL,CS:[BP]
	Push	AX
	Mov	AH,BL
	Out	DX,AX
	Pop	AX
	Inc	BP
	Inc	AL
	Loop	NxtReg
;set the mode
	Mov	DX,03B8h
	Mov	AL,28h
	Out	DX,AL
; -------------------------------
;install the Blee-Dip beep
	XOR	AX,AX
	MOV	ES,AX
	CLI
	MOV	AX,WORD PTR ES:40h	;INT 10h offset
	MOV	INT10hOffset,AX
	MOV	AX,WORD PTR ES:42h
	MOV	INT10hSeg,AX
	MOV	WORD PTR ES:40h,OFFSET NewINT10h
	MOV	WORD PTR ES:42h,CS
	STI
;De-allocate the Environment Block, we don't need it.
; This sometimes leaves a uselessly small unused Block
	push	es
	xor	ax,ax
	xchg	ax,word ptr CS:2Ch	;Environment Block addr in the PSP
	or	ax,ax
	jz	GoRes			;skip it if there is no Env
	mov	es,ax
	mov	ah,49h			;free allocated RAM
	int	21h
GoRes:
;demonstrate the blee-dip
	MOV	AL,bel
	MOV	AH,0Eh			;Write char in AL, Bel is executed
	INT	10h
;show our banner
	MOV	DX,OFFSET InstMsg
	MOV	AH,9
	INT	21h
	pop	es
;go resident
	mov	dx,offset Install	;bytes to stay resident
	add	dx,15			;allow for fractional para
	mov	cl,4
	shr	dx,cl			;paras to stay resident
	mov	ax,3100h		;go TSR
	int	21h
	
InstMsg	DB	cr,lf,'MDA card initialized and blee-dip beep installed','$'
SetupString	DB	61h,50h,52h,0Fh,19h,6,19h,19h,2,0Dh,0Bh,0Ch,0,0,0,0

CSEG	ends
	END	Start
