unit pax_u;
interface
  uses acrcy,dlgama_u,ppchi2_u,ppnd_u,xinbta_u;

  function pax(indic:integer;var ifault:integer;prb,df1,df2:double):double;

implementation

function pax(indic:integer;var ifault:integer;prb,df1,df2:double):double;
{
c    this function produces the deviate corresponding to a provided
c    probability for the chi, f, t, and normal distribution.
c    in all cases the probability if taken from minus infinity
c    to the deviate provided.
c
c         indic = 1   chi squared.
c         indic = 2   f distribution.
c         indic = 3   t distribution.
c         indic = 4   normal distribution.
c
c    the output information is stored in 'ifault':
c         ifault = 0    function had no errors.
c         ifault = 1    degrees of freedom are += zero.
c         ifault = 2    probability supplied is less than 1.0e-5 or
c                                   greater than 1.0 - 1.0e-5.
c         ifault = 3    value of indic is not  1, 2, 3, or 4.
c         ifault = 4    an internal subprogram has had an error.
c
c    the degrees of freedom are entered as double variables, but only as
c         required.  none are necessary for normal calculations, df1 is
c         only used for t and chi squared calculations, and both are
c         needed for the f density.  they need not be whole numbers,
c         e.g.  df1 = 1.345 should work.
}
var
   lnbeta,
   g,
   prbx,aprb,
   p,q,x,
   tdjm
    : double;
const
  tol = 1.0e-7;
  ptest = 1.0e-5;
label
  label25;
begin
      pax := 0.0;
      acu := 1.0e-7;
      ifault := 3;
      if(indic<1) or (indic>4) then
        exit;
      if(indic>=3) then
      begin
        ifault := 2;
        if (prb>1.0-ptest) then
          exit;
        if (prb<ptest) then
          exit;
      end;
{    5 continue }
      ifault := 1;
      case indic of
{   10 }
      1: begin
  {
  c     chi squared section
  }
        if(df1<=tol) then
          exit;
        ifault := 0;
        g := dlgama(0.5*df1);
        pax := ppchi2(prb,df1,g,ifault);
        if(ifault<>0) then
          ifault := 4;
        exit;
      end;

      2: begin
   {20}
{
c     f distribution section.
}
        if(df1<=tol) or (df2<=tol) then
          exit;
        ifault := 0;
        prbx := prb;
        p := 0.5*df1;
        q := 0.5*df2;
     label25:
        lnbeta := dlgama(p) + dlgama(q) - dlgama(p+q);
        x := xinbta(p,q,lnbeta,prbx,ifault);
        if (ifault<>0)  then
          ifault := 4;
        tdjm := (q/p)*x/(1.0-x);
        pax := tdjm;
        if(indic = 2) then
          exit;
  {
  c     subsection for t distribution.
  }
        ifault := 0;
        if(x<=0.0) then
          exit;
        if prb < 0.5 then
          pax := -sqrt(tdjm)
        else
          pax := sqrt(tdjm);
        exit;
      end;

      3: begin
   {30}
{
c     t density section
}
        if(df1<=tol) then
          exit;
        pax := 0.0;
        aprb := abs(prb-0.5);
        if(aprb<tol) then
          exit;
        prbx := 1.0 - 2.0*prb;
        if(prb>0.5) then
         prbx := 1.0 - 2.0*(1.0-prb);
        p := 0.5;
        q := 0.5*df1;
        goto label25;
      end;
      4: begin
  { 40}
{
c     normal density
}
        ifault := 0;
        pax := ppnd(prb,ifault);
        if(ifault <> 0) then
          ifault := 4;
        exit;
      end;
    end;
end;

end.

