unit ppnd_u;

interface
  function ppnd(p:double; var ifault:integer):double;

implementation
  function ppnd(p:double;var ifault:integer):double;
{
c
c   algorithm as 111 applied stats (1977) 26:1 pp 118-121
c
c   produces normal deviate corresponding to lower tail area of p
c   double version for eps = 2 **(-31)
c   hash sums are the sums of the abs vals of coefficients...
c     included only to check transcriptions
c
}
var
  q, r, tdjm :double;

const
  zero = 0.0;
  half = 0.5;
  one =  1.0;
  split =0.42;

  a0 =  2.50662823884;
  a1 =-18.61500062529;
  a2 = 41.39119773534;
  a3 =-25.44106049637;

  b1 = -8.47351093090;
  b2 = 23.08336743743;
  b3 =-21.06224101826;
  b4 =  3.13082909833;
{sum =143.70383558076 }

  c0 = -2.78718931138;
  c1 = -2.29796479134;
  c2 =  4.85014127135;
  c3 =  2.32121276858;

  d1 =  3.54388924762;
  d2 =  1.63706781897;

{sum = 17.43746520924 }
begin
  ifault := 0;
  q := p - half;
  if ( abs(q)<=split) then
  begin
    r := q*q;
    ppnd := q * (((a3*r + a2)*r + a1)*r + a0) /
     ((((b4*r + b3)*r + b2)*r + b1)*r + one);
    exit;
  end
  else
  begin
{  1} r := p;
   if ( q>zero) then
     r := one - p;
   if ( r>zero) then
   begin
    r := sqrt( - ln(r) );
    tdjm := (((c3*r + c2)*r + c1)*r + c0) /
     ((d2*r + d1)*r + one);
    if (q<zero) then
      ppnd := -tdjm
    else
      ppnd := tdjm;
   end
   else
   begin
 { 2} ifault := 1;
    ppnd := zero;
   end;
 end;
end;

end.

